/*
 * ACP_2_2 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef ACP_2_2_D_H
#define ACP_2_2_D_H

#define mmACP_DMA_CNTL_0                                                        0x5000
#define mmACP_DMA_CNTL_1                                                        0x5001
#define mmACP_DMA_CNTL_2                                                        0x5002
#define mmACP_DMA_CNTL_3                                                        0x5003
#define mmACP_DMA_CNTL_4                                                        0x5004
#define mmACP_DMA_CNTL_5                                                        0x5005
#define mmACP_DMA_CNTL_6                                                        0x5006
#define mmACP_DMA_CNTL_7                                                        0x5007
#define mmACP_DMA_CNTL_8                                                        0x5008
#define mmACP_DMA_CNTL_9                                                        0x5009
#define mmACP_DMA_CNTL_10                                                       0x500a
#define mmACP_DMA_CNTL_11                                                       0x500b
#define mmACP_DMA_CNTL_12                                                       0x500c
#define mmACP_DMA_CNTL_13                                                       0x500d
#define mmACP_DMA_CNTL_14                                                       0x500e
#define mmACP_DMA_CNTL_15                                                       0x500f
#define mmACP_DMA_DSCR_STRT_IDX_0                                               0x5010
#define mmACP_DMA_DSCR_STRT_IDX_1                                               0x5011
#define mmACP_DMA_DSCR_STRT_IDX_2                                               0x5012
#define mmACP_DMA_DSCR_STRT_IDX_3                                               0x5013
#define mmACP_DMA_DSCR_STRT_IDX_4                                               0x5014
#define mmACP_DMA_DSCR_STRT_IDX_5                                               0x5015
#define mmACP_DMA_DSCR_STRT_IDX_6                                               0x5016
#define mmACP_DMA_DSCR_STRT_IDX_7                                               0x5017
#define mmACP_DMA_DSCR_STRT_IDX_8                                               0x5018
#define mmACP_DMA_DSCR_STRT_IDX_9                                               0x5019
#define mmACP_DMA_DSCR_STRT_IDX_10                                              0x501a
#define mmACP_DMA_DSCR_STRT_IDX_11                                              0x501b
#define mmACP_DMA_DSCR_STRT_IDX_12                                              0x501c
#define mmACP_DMA_DSCR_STRT_IDX_13                                              0x501d
#define mmACP_DMA_DSCR_STRT_IDX_14                                              0x501e
#define mmACP_DMA_DSCR_STRT_IDX_15                                              0x501f
#define mmACP_DMA_DSCR_CNT_0                                                    0x5020
#define mmACP_DMA_DSCR_CNT_1                                                    0x5021
#define mmACP_DMA_DSCR_CNT_2                                                    0x5022
#define mmACP_DMA_DSCR_CNT_3                                                    0x5023
#define mmACP_DMA_DSCR_CNT_4                                                    0x5024
#define mmACP_DMA_DSCR_CNT_5                                                    0x5025
#define mmACP_DMA_DSCR_CNT_6                                                    0x5026
#define mmACP_DMA_DSCR_CNT_7                                                    0x5027
#define mmACP_DMA_DSCR_CNT_8                                                    0x5028
#define mmACP_DMA_DSCR_CNT_9                                                    0x5029
#define mmACP_DMA_DSCR_CNT_10                                                   0x502a
#define mmACP_DMA_DSCR_CNT_11                                                   0x502b
#define mmACP_DMA_DSCR_CNT_12                                                   0x502c
#define mmACP_DMA_DSCR_CNT_13                                                   0x502d
#define mmACP_DMA_DSCR_CNT_14                                                   0x502e
#define mmACP_DMA_DSCR_CNT_15                                                   0x502f
#define mmACP_DMA_PRIO_0                                                        0x5030
#define mmACP_DMA_PRIO_1                                                        0x5031
#define mmACP_DMA_PRIO_2                                                        0x5032
#define mmACP_DMA_PRIO_3                                                        0x5033
#define mmACP_DMA_PRIO_4                                                        0x5034
#define mmACP_DMA_PRIO_5                                                        0x5035
#define mmACP_DMA_PRIO_6                                                        0x5036
#define mmACP_DMA_PRIO_7                                                        0x5037
#define mmACP_DMA_PRIO_8                                                        0x5038
#define mmACP_DMA_PRIO_9                                                        0x5039
#define mmACP_DMA_PRIO_10                                                       0x503a
#define mmACP_DMA_PRIO_11                                                       0x503b
#define mmACP_DMA_PRIO_12                                                       0x503c
#define mmACP_DMA_PRIO_13                                                       0x503d
#define mmACP_DMA_PRIO_14                                                       0x503e
#define mmACP_DMA_PRIO_15                                                       0x503f
#define mmACP_DMA_CUR_DSCR_0                                                    0x5040
#define mmACP_DMA_CUR_DSCR_1                                                    0x5041
#define mmACP_DMA_CUR_DSCR_2                                                    0x5042
#define mmACP_DMA_CUR_DSCR_3                                                    0x5043
#define mmACP_DMA_CUR_DSCR_4                                                    0x5044
#define mmACP_DMA_CUR_DSCR_5                                                    0x5045
#define mmACP_DMA_CUR_DSCR_6                                                    0x5046
#define mmACP_DMA_CUR_DSCR_7                                                    0x5047
#define mmACP_DMA_CUR_DSCR_8                                                    0x5048
#define mmACP_DMA_CUR_DSCR_9                                                    0x5049
#define mmACP_DMA_CUR_DSCR_10                                                   0x504a
#define mmACP_DMA_CUR_DSCR_11                                                   0x504b
#define mmACP_DMA_CUR_DSCR_12                                                   0x504c
#define mmACP_DMA_CUR_DSCR_13                                                   0x504d
#define mmACP_DMA_CUR_DSCR_14                                                   0x504e
#define mmACP_DMA_CUR_DSCR_15                                                   0x504f
#define mmACP_DMA_CUR_TRANS_CNT_0                                               0x5050
#define mmACP_DMA_CUR_TRANS_CNT_1                                               0x5051
#define mmACP_DMA_CUR_TRANS_CNT_2                                               0x5052
#define mmACP_DMA_CUR_TRANS_CNT_3                                               0x5053
#define mmACP_DMA_CUR_TRANS_CNT_4                                               0x5054
#define mmACP_DMA_CUR_TRANS_CNT_5                                               0x5055
#define mmACP_DMA_CUR_TRANS_CNT_6                                               0x5056
#define mmACP_DMA_CUR_TRANS_CNT_7                                               0x5057
#define mmACP_DMA_CUR_TRANS_CNT_8                                               0x5058
#define mmACP_DMA_CUR_TRANS_CNT_9                                               0x5059
#define mmACP_DMA_CUR_TRANS_CNT_10                                              0x505a
#define mmACP_DMA_CUR_TRANS_CNT_11                                              0x505b
#define mmACP_DMA_CUR_TRANS_CNT_12                                              0x505c
#define mmACP_DMA_CUR_TRANS_CNT_13                                              0x505d
#define mmACP_DMA_CUR_TRANS_CNT_14                                              0x505e
#define mmACP_DMA_CUR_TRANS_CNT_15                                              0x505f
#define mmACP_DMA_ERR_STS_0                                                     0x5060
#define mmACP_DMA_ERR_STS_1                                                     0x5061
#define mmACP_DMA_ERR_STS_2                                                     0x5062
#define mmACP_DMA_ERR_STS_3                                                     0x5063
#define mmACP_DMA_ERR_STS_4                                                     0x5064
#define mmACP_DMA_ERR_STS_5                                                     0x5065
#define mmACP_DMA_ERR_STS_6                                                     0x5066
#define mmACP_DMA_ERR_STS_7                                                     0x5067
#define mmACP_DMA_ERR_STS_8                                                     0x5068
#define mmACP_DMA_ERR_STS_9                                                     0x5069
#define mmACP_DMA_ERR_STS_10                                                    0x506a
#define mmACP_DMA_ERR_STS_11                                                    0x506b
#define mmACP_DMA_ERR_STS_12                                                    0x506c
#define mmACP_DMA_ERR_STS_13                                                    0x506d
#define mmACP_DMA_ERR_STS_14                                                    0x506e
#define mmACP_DMA_ERR_STS_15                                                    0x506f
#define mmACP_DMA_DESC_BASE_ADDR                                                0x5070
#define mmACP_DMA_DESC_MAX_NUM_DSCR                                             0x5071
#define mmACP_DMA_CH_STS                                                        0x5072
#define mmACP_DMA_CH_GROUP                                                      0x5073
#define mmACP_DSP0_CACHE_OFFSET0                                                0x5078
#define mmACP_DSP0_CACHE_SIZE0                                                  0x5079
#define mmACP_DSP0_CACHE_OFFSET1                                                0x507a
#define mmACP_DSP0_CACHE_SIZE1                                                  0x507b
#define mmACP_DSP0_CACHE_OFFSET2                                                0x507c
#define mmACP_DSP0_CACHE_SIZE2                                                  0x507d
#define mmACP_DSP0_CACHE_OFFSET3                                                0x507e
#define mmACP_DSP0_CACHE_SIZE3                                                  0x507f
#define mmACP_DSP0_CACHE_OFFSET4                                                0x5080
#define mmACP_DSP0_CACHE_SIZE4                                                  0x5081
#define mmACP_DSP0_CACHE_OFFSET5                                                0x5082
#define mmACP_DSP0_CACHE_SIZE5                                                  0x5083
#define mmACP_DSP0_CACHE_OFFSET6                                                0x5084
#define mmACP_DSP0_CACHE_SIZE6                                                  0x5085
#define mmACP_DSP0_CACHE_OFFSET7                                                0x5086
#define mmACP_DSP0_CACHE_SIZE7                                                  0x5087
#define mmACP_DSP0_CACHE_OFFSET8                                                0x5088
#define mmACP_DSP0_CACHE_SIZE8                                                  0x5089
#define mmACP_DSP0_NONCACHE_OFFSET0                                             0x508a
#define mmACP_DSP0_NONCACHE_SIZE0                                               0x508b
#define mmACP_DSP0_NONCACHE_OFFSET1                                             0x508c
#define mmACP_DSP0_NONCACHE_SIZE1                                               0x508d
#define mmACP_DSP0_DEBUG_PC                                                     0x508e
#define mmACP_DSP0_NMI_SEL                                                      0x508f
#define mmACP_DSP0_CLKRST_CNTL                                                  0x5090
#define mmACP_DSP0_RUNSTALL                                                     0x5091
#define mmACP_DSP0_OCD_HALT_ON_RST                                              0x5092
#define mmACP_DSP0_WAIT_MODE                                                    0x5093
#define mmACP_DSP0_VECT_SEL                                                     0x5094
#define mmACP_DSP0_DEBUG_REG1                                                   0x5095
#define mmACP_DSP0_DEBUG_REG2                                                   0x5096
#define mmACP_DSP0_DEBUG_REG3                                                   0x5097
#define mmACP_DSP1_CACHE_OFFSET0                                                0x509d
#define mmACP_DSP1_CACHE_SIZE0                                                  0x509e
#define mmACP_DSP1_CACHE_OFFSET1                                                0x509f
#define mmACP_DSP1_CACHE_SIZE1                                                  0x50a0
#define mmACP_DSP1_CACHE_OFFSET2                                                0x50a1
#define mmACP_DSP1_CACHE_SIZE2                                                  0x50a2
#define mmACP_DSP1_CACHE_OFFSET3                                                0x50a3
#define mmACP_DSP1_CACHE_SIZE3                                                  0x50a4
#define mmACP_DSP1_CACHE_OFFSET4                                                0x50a5
#define mmACP_DSP1_CACHE_SIZE4                                                  0x50a6
#define mmACP_DSP1_CACHE_OFFSET5                                                0x50a7
#define mmACP_DSP1_CACHE_SIZE5                                                  0x50a8
#define mmACP_DSP1_CACHE_OFFSET6                                                0x50a9
#define mmACP_DSP1_CACHE_SIZE6                                                  0x50aa
#define mmACP_DSP1_CACHE_OFFSET7                                                0x50ab
#define mmACP_DSP1_CACHE_SIZE7                                                  0x50ac
#define mmACP_DSP1_CACHE_OFFSET8                                                0x50ad
#define mmACP_DSP1_CACHE_SIZE8                                                  0x50ae
#define mmACP_DSP1_NONCACHE_OFFSET0                                             0x50af
#define mmACP_DSP1_NONCACHE_SIZE0                                               0x50b0
#define mmACP_DSP1_NONCACHE_OFFSET1                                             0x50b1
#define mmACP_DSP1_NONCACHE_SIZE1                                               0x50b2
#define mmACP_DSP1_DEBUG_PC                                                     0x50b3
#define mmACP_DSP1_NMI_SEL                                                      0x50b4
#define mmACP_DSP1_CLKRST_CNTL                                                  0x50b5
#define mmACP_DSP1_RUNSTALL                                                     0x50b6
#define mmACP_DSP1_OCD_HALT_ON_RST                                              0x50b7
#define mmACP_DSP1_WAIT_MODE                                                    0x50b8
#define mmACP_DSP1_VECT_SEL                                                     0x50b9
#define mmACP_DSP1_DEBUG_REG1                                                   0x50ba
#define mmACP_DSP1_DEBUG_REG2                                                   0x50bb
#define mmACP_DSP1_DEBUG_REG3                                                   0x50bc
#define mmACP_DSP2_CACHE_OFFSET0                                                0x50c2
#define mmACP_DSP2_CACHE_SIZE0                                                  0x50c3
#define mmACP_DSP2_CACHE_OFFSET1                                                0x50c4
#define mmACP_DSP2_CACHE_SIZE1                                                  0x50c5
#define mmACP_DSP2_CACHE_OFFSET2                                                0x50c6
#define mmACP_DSP2_CACHE_SIZE2                                                  0x50c7
#define mmACP_DSP2_CACHE_OFFSET3                                                0x50c8
#define mmACP_DSP2_CACHE_SIZE3                                                  0x50c9
#define mmACP_DSP2_CACHE_OFFSET4                                                0x50ca
#define mmACP_DSP2_CACHE_SIZE4                                                  0x50cb
#define mmACP_DSP2_CACHE_OFFSET5                                                0x50cc
#define mmACP_DSP2_CACHE_SIZE5                                                  0x50cd
#define mmACP_DSP2_CACHE_OFFSET6                                                0x50ce
#define mmACP_DSP2_CACHE_SIZE6                                                  0x50cf
#define mmACP_DSP2_CACHE_OFFSET7                                                0x50d0
#define mmACP_DSP2_CACHE_SIZE7                                                  0x50d1
#define mmACP_DSP2_CACHE_OFFSET8                                                0x50d2
#define mmACP_DSP2_CACHE_SIZE8                                                  0x50d3
#define mmACP_DSP2_NONCACHE_OFFSET0                                             0x50d4
#define mmACP_DSP2_NONCACHE_SIZE0                                               0x50d5
#define mmACP_DSP2_NONCACHE_OFFSET1                                             0x50d6
#define mmACP_DSP2_NONCACHE_SIZE1                                               0x50d7
#define mmACP_DSP2_DEBUG_PC                                                     0x50d8
#define mmACP_DSP2_NMI_SEL                                                      0x50d9
#define mmACP_DSP2_CLKRST_CNTL                                                  0x50da
#define mmACP_DSP2_RUNSTALL                                                     0x50db
#define mmACP_DSP2_OCD_HALT_ON_RST                                              0x50dc
#define mmACP_DSP2_WAIT_MODE                                                    0x50dd
#define mmACP_DSP2_VECT_SEL                                                     0x50de
#define mmACP_DSP2_DEBUG_REG1                                                   0x50df
#define mmACP_DSP2_DEBUG_REG2                                                   0x50e0
#define mmACP_DSP2_DEBUG_REG3                                                   0x50e1
#define mmACP_AXI2DAGB_ONION_CNTL                                               0x50e7
#define mmACP_AXI2DAGB_ONION_ERR_STATUS_WR                                      0x50e8
#define mmACP_AXI2DAGB_ONION_ERR_STATUS_RD                                      0x50e9
#define mmACP_DAGB_Onion_TransPerf_Counter_Control                              0x50ea
#define mmACP_DAGB_Onion_Wr_TransPerf_Counter_Current                           0x50eb
#define mmACP_DAGB_Onion_Wr_TransPerf_Counter_Peak                              0x50ec
#define mmACP_DAGB_Onion_Rd_TransPerf_Counter_Current                           0x50ed
#define mmACP_DAGB_Onion_Rd_TransPerf_Counter_Peak                              0x50ee
#define mmACP_AXI2DAGB_GARLIC_CNTL                                              0x50f3
#define mmACP_AXI2DAGB_GARLIC_ERR_STATUS_WR                                     0x50f4
#define mmACP_AXI2DAGB_GARLIC_ERR_STATUS_RD                                     0x50f5
#define mmACP_DAGB_Garlic_TransPerf_Counter_Control                             0x50f6
#define mmACP_DAGB_Garlic_Wr_TransPerf_Counter_Current                          0x50f7
#define mmACP_DAGB_Garlic_Wr_TransPerf_Counter_Peak                             0x50f8
#define mmACP_DAGB_Garlic_Rd_TransPerf_Counter_Current                          0x50f9
#define mmACP_DAGB_Garlic_Rd_TransPerf_Counter_Peak                             0x50fa
#define mmACP_DAGB_PAGE_SIZE_GRP_1                                              0x50ff
#define mmACP_DAGB_BASE_ADDR_GRP_1                                              0x5100
#define mmACP_DAGB_PAGE_SIZE_GRP_2                                              0x5101
#define mmACP_DAGB_BASE_ADDR_GRP_2                                              0x5102
#define mmACP_DAGB_PAGE_SIZE_GRP_3                                              0x5103
#define mmACP_DAGB_BASE_ADDR_GRP_3                                              0x5104
#define mmACP_DAGB_PAGE_SIZE_GRP_4                                              0x5105
#define mmACP_DAGB_BASE_ADDR_GRP_4                                              0x5106
#define mmACP_DAGB_PAGE_SIZE_GRP_5                                              0x5107
#define mmACP_DAGB_BASE_ADDR_GRP_5                                              0x5108
#define mmACP_DAGB_PAGE_SIZE_GRP_6                                              0x5109
#define mmACP_DAGB_BASE_ADDR_GRP_6                                              0x510a
#define mmACP_DAGB_PAGE_SIZE_GRP_7                                              0x510b
#define mmACP_DAGB_BASE_ADDR_GRP_7                                              0x510c
#define mmACP_DAGB_PAGE_SIZE_GRP_8                                              0x510d
#define mmACP_DAGB_BASE_ADDR_GRP_8                                              0x510e
#define mmACP_DAGB_ATU_CTRL                                                     0x510f
#define mmACP_CONTROL                                                           0x5131
#define mmACP_STATUS                                                            0x5133
#define mmACP_SOFT_RESET                                                        0x5134
#define mmACP_PwrMgmt_CNTL                                                      0x5135
#define mmACP_CAC_INDICATOR_CONTROL                                             0x5136
#define mmACP_SMU_MAILBOX                                                       0x5137
#define mmACP_FUTURE_REG_SCLK_0                                                 0x5138
#define mmACP_FUTURE_REG_SCLK_1                                                 0x5139
#define mmACP_FUTURE_REG_SCLK_2                                                 0x513a
#define mmACP_FUTURE_REG_SCLK_3                                                 0x513b
#define mmACP_FUTURE_REG_SCLK_4                                                 0x513c
#define mmACP_DAGB_DEBUG_CNT_ENABLE                                             0x513d
#define mmACP_DAGBG_WR_ASK_CNT                                                  0x513e
#define mmACP_DAGBG_WR_GO_CNT                                                   0x513f
#define mmACP_DAGBG_WR_EXP_RESP_CNT                                             0x5140
#define mmACP_DAGBG_WR_ACTUAL_RESP_CNT                                          0x5141
#define mmACP_DAGBG_RD_ASK_CNT                                                  0x5142
#define mmACP_DAGBG_RD_GO_CNT                                                   0x5143
#define mmACP_DAGBG_RD_EXP_RESP_CNT                                             0x5144
#define mmACP_DAGBG_RD_ACTUAL_RESP_CNT                                          0x5145
#define mmACP_DAGBO_WR_ASK_CNT                                                  0x5146
#define mmACP_DAGBO_WR_GO_CNT                                                   0x5147
#define mmACP_DAGBO_WR_EXP_RESP_CNT                                             0x5148
#define mmACP_DAGBO_WR_ACTUAL_RESP_CNT                                          0x5149
#define mmACP_DAGBO_RD_ASK_CNT                                                  0x514a
#define mmACP_DAGBO_RD_GO_CNT                                                   0x514b
#define mmACP_DAGBO_RD_EXP_RESP_CNT                                             0x514c
#define mmACP_DAGBO_RD_ACTUAL_RESP_CNT                                          0x514d
#define mmACP_BRB_CONTROL                                                       0x5156
#define mmACP_EXTERNAL_INTR_ENB                                                 0x5157
#define mmACP_EXTERNAL_INTR_CNTL                                                0x5158
#define mmACP_ERROR_SOURCE_STS                                                  0x5159
#define mmACP_DSP_SW_INTR_TRIG                                                  0x515a
#define mmACP_DSP_SW_INTR_CNTL                                                  0x515b
#define mmACP_DAGBG_TIMEOUT_CNTL                                                0x515c
#define mmACP_DAGBO_TIMEOUT_CNTL                                                0x515d
#define mmACP_EXTERNAL_INTR_STAT                                                0x515e
#define mmACP_DSP_SW_INTR_STAT                                                  0x515f
#define mmACP_DSP0_INTR_CNTL                                                    0x5160
#define mmACP_DSP0_INTR_STAT                                                    0x5161
#define mmACP_DSP0_TIMEOUT_CNTL                                                 0x5162
#define mmACP_DSP1_INTR_CNTL                                                    0x5163
#define mmACP_DSP1_INTR_STAT                                                    0x5164
#define mmACP_DSP1_TIMEOUT_CNTL                                                 0x5165
#define mmACP_DSP2_INTR_CNTL                                                    0x5166
#define mmACP_DSP2_INTR_STAT                                                    0x5167
#define mmACP_DSP2_TIMEOUT_CNTL                                                 0x5168
#define mmACP_DSP0_EXT_TIMER_CNTL                                               0x5169
#define mmACP_DSP1_EXT_TIMER_CNTL                                               0x516a
#define mmACP_DSP2_EXT_TIMER_CNTL                                               0x516b
#define mmACP_AXI2DAGB_SEM_0                                                    0x516c
#define mmACP_AXI2DAGB_SEM_1                                                    0x516d
#define mmACP_AXI2DAGB_SEM_2                                                    0x516e
#define mmACP_AXI2DAGB_SEM_3                                                    0x516f
#define mmACP_AXI2DAGB_SEM_4                                                    0x5170
#define mmACP_AXI2DAGB_SEM_5                                                    0x5171
#define mmACP_AXI2DAGB_SEM_6                                                    0x5172
#define mmACP_AXI2DAGB_SEM_7                                                    0x5173
#define mmACP_AXI2DAGB_SEM_8                                                    0x5174
#define mmACP_AXI2DAGB_SEM_9                                                    0x5175
#define mmACP_AXI2DAGB_SEM_10                                                   0x5176
#define mmACP_AXI2DAGB_SEM_11                                                   0x5177
#define mmACP_AXI2DAGB_SEM_12                                                   0x5178
#define mmACP_AXI2DAGB_SEM_13                                                   0x5179
#define mmACP_AXI2DAGB_SEM_14                                                   0x517a
#define mmACP_AXI2DAGB_SEM_15                                                   0x517b
#define mmACP_AXI2DAGB_SEM_16                                                   0x517c
#define mmACP_AXI2DAGB_SEM_17                                                   0x517d
#define mmACP_AXI2DAGB_SEM_18                                                   0x517e
#define mmACP_AXI2DAGB_SEM_19                                                   0x517f
#define mmACP_AXI2DAGB_SEM_20                                                   0x5180
#define mmACP_AXI2DAGB_SEM_21                                                   0x5181
#define mmACP_AXI2DAGB_SEM_22                                                   0x5182
#define mmACP_AXI2DAGB_SEM_23                                                   0x5183
#define mmACP_AXI2DAGB_SEM_24                                                   0x5184
#define mmACP_AXI2DAGB_SEM_25                                                   0x5185
#define mmACP_AXI2DAGB_SEM_26                                                   0x5186
#define mmACP_AXI2DAGB_SEM_27                                                   0x5187
#define mmACP_AXI2DAGB_SEM_28                                                   0x5188
#define mmACP_AXI2DAGB_SEM_29                                                   0x5189
#define mmACP_AXI2DAGB_SEM_30                                                   0x518a
#define mmACP_AXI2DAGB_SEM_31                                                   0x518b
#define mmACP_AXI2DAGB_SEM_32                                                   0x518c
#define mmACP_AXI2DAGB_SEM_33                                                   0x518d
#define mmACP_AXI2DAGB_SEM_34                                                   0x518e
#define mmACP_AXI2DAGB_SEM_35                                                   0x518f
#define mmACP_AXI2DAGB_SEM_36                                                   0x5190
#define mmACP_AXI2DAGB_SEM_37                                                   0x5191
#define mmACP_AXI2DAGB_SEM_38                                                   0x5192
#define mmACP_AXI2DAGB_SEM_39                                                   0x5193
#define mmACP_AXI2DAGB_SEM_40                                                   0x5194
#define mmACP_AXI2DAGB_SEM_41                                                   0x5195
#define mmACP_AXI2DAGB_SEM_42                                                   0x5196
#define mmACP_AXI2DAGB_SEM_43                                                   0x5197
#define mmACP_AXI2DAGB_SEM_44                                                   0x5198
#define mmACP_AXI2DAGB_SEM_45                                                   0x5199
#define mmACP_AXI2DAGB_SEM_46                                                   0x519a
#define mmACP_AXI2DAGB_SEM_47                                                   0x519b
#define mmACP_SRBM_Client_Base_Addr                                             0x519c
#define mmACP_SRBM_Client_RDDATA                                                0x519d
#define mmACP_SRBM_Cycle_Sts                                                    0x519e
#define mmACP_SRBM_Targ_Idx_Addr                                                0x519f
#define mmACP_SRBM_Targ_Idx_Data                                                0x51a0
#define mmACP_SEMA_ADDR_LOW                                                     0x51a1
#define mmACP_SEMA_ADDR_HIGH                                                    0x51a2
#define mmACP_SEMA_CMD                                                          0x51a3
#define mmACP_SEMA_STS                                                          0x51a4
#define mmACP_SEMA_REQ                                                          0x51a5
#define mmACP_FW_STATUS                                                         0x51a6
#define mmACP_FUTURE_REG_ACLK_0                                                 0x51a7
#define mmACP_FUTURE_REG_ACLK_1                                                 0x51a8
#define mmACP_FUTURE_REG_ACLK_2                                                 0x51a9
#define mmACP_FUTURE_REG_ACLK_3                                                 0x51aa
#define mmACP_FUTURE_REG_ACLK_4                                                 0x51ab
#define mmACP_TIMER                                                             0x51ac
#define mmACP_TIMER_CNTL                                                        0x51ad
#define mmACP_DSP0_TIMER                                                        0x51ae
#define mmACP_DSP1_TIMER                                                        0x51af
#define mmACP_DSP2_TIMER                                                        0x51b0
#define mmACP_I2S_TRANSMIT_BYTE_CNT_HIGH                                        0x51b1
#define mmACP_I2S_TRANSMIT_BYTE_CNT_LOW                                         0x51b2
#define mmACP_I2S_BT_TRANSMIT_BYTE_CNT_HIGH                                     0x51b3
#define mmACP_I2S_BT_TRANSMIT_BYTE_CNT_LOW                                      0x51b4
#define mmACP_I2S_BT_RECEIVE_BYTE_CNT_HIGH                                      0x51b5
#define mmACP_I2S_BT_RECEIVE_BYTE_CNT_LOW                                       0x51b6
#define mmACP_DSP0_CS_STATE                                                     0x51b7
#define mmACP_DSP1_CS_STATE                                                     0x51b8
#define mmACP_DSP2_CS_STATE                                                     0x51b9
#define mmACP_SCRATCH_REG_BASE_ADDR                                             0x51ba
#define mmCC_ACP_EFUSE                                                          0x51c8
#define mmACP_PGFSM_RETAIN_REG                                                  0x51c9
#define mmACP_PGFSM_CONFIG_REG                                                  0x51ca
#define mmACP_PGFSM_WRITE_REG                                                   0x51cb
#define mmACP_PGFSM_READ_REG_0                                                  0x51cc
#define mmACP_PGFSM_READ_REG_1                                                  0x51cd
#define mmACP_PGFSM_READ_REG_2                                                  0x51ce
#define mmACP_PGFSM_READ_REG_3                                                  0x51cf
#define mmACP_PGFSM_READ_REG_4                                                  0x51d0
#define mmACP_PGFSM_READ_REG_5                                                  0x51d1
#define mmACP_IP_PGFSM_ENABLE                                                   0x51d2
#define mmACP_I2S_PIN_CONFIG                                                    0x51d3
#define mmACP_AZALIA_I2S_SELECT                                                 0x51d4
#define mmACP_CHIP_PKG_FOR_PAD_ISOLATION                                        0x51d5
#define mmACP_AUDIO_PAD_PULLUP_PULLDOWN_CTRL                                    0x51d6
#define mmACP_BT_UART_PAD_SEL                                                   0x51d7
#define mmACP_SCRATCH_REG_0                                                     0x52c0
#define mmACP_SCRATCH_REG_1                                                     0x52c1
#define mmACP_SCRATCH_REG_2                                                     0x52c2
#define mmACP_SCRATCH_REG_3                                                     0x52c3
#define mmACP_SCRATCH_REG_4                                                     0x52c4
#define mmACP_SCRATCH_REG_5                                                     0x52c5
#define mmACP_SCRATCH_REG_6                                                     0x52c6
#define mmACP_SCRATCH_REG_7                                                     0x52c7
#define mmACP_SCRATCH_REG_8                                                     0x52c8
#define mmACP_SCRATCH_REG_9                                                     0x52c9
#define mmACP_SCRATCH_REG_10                                                    0x52ca
#define mmACP_SCRATCH_REG_11                                                    0x52cb
#define mmACP_SCRATCH_REG_12                                                    0x52cc
#define mmACP_SCRATCH_REG_13                                                    0x52cd
#define mmACP_SCRATCH_REG_14                                                    0x52ce
#define mmACP_SCRATCH_REG_15                                                    0x52cf
#define mmACP_SCRATCH_REG_16                                                    0x52d0
#define mmACP_SCRATCH_REG_17                                                    0x52d1
#define mmACP_SCRATCH_REG_18                                                    0x52d2
#define mmACP_SCRATCH_REG_19                                                    0x52d3
#define mmACP_SCRATCH_REG_20                                                    0x52d4
#define mmACP_SCRATCH_REG_21                                                    0x52d5
#define mmACP_SCRATCH_REG_22                                                    0x52d6
#define mmACP_SCRATCH_REG_23                                                    0x52d7
#define mmACP_SCRATCH_REG_24                                                    0x52d8
#define mmACP_SCRATCH_REG_25                                                    0x52d9
#define mmACP_SCRATCH_REG_26                                                    0x52da
#define mmACP_SCRATCH_REG_27                                                    0x52db
#define mmACP_SCRATCH_REG_28                                                    0x52dc
#define mmACP_SCRATCH_REG_29                                                    0x52dd
#define mmACP_SCRATCH_REG_30                                                    0x52de
#define mmACP_SCRATCH_REG_31                                                    0x52df
#define mmACP_SCRATCH_REG_32                                                    0x52e0
#define mmACP_SCRATCH_REG_33                                                    0x52e1
#define mmACP_SCRATCH_REG_34                                                    0x52e2
#define mmACP_SCRATCH_REG_35                                                    0x52e3
#define mmACP_SCRATCH_REG_36                                                    0x52e4
#define mmACP_SCRATCH_REG_37                                                    0x52e5
#define mmACP_SCRATCH_REG_38                                                    0x52e6
#define mmACP_SCRATCH_REG_39                                                    0x52e7
#define mmACP_SCRATCH_REG_40                                                    0x52e8
#define mmACP_SCRATCH_REG_41                                                    0x52e9
#define mmACP_SCRATCH_REG_42                                                    0x52ea
#define mmACP_SCRATCH_REG_43                                                    0x52eb
#define mmACP_SCRATCH_REG_44                                                    0x52ec
#define mmACP_SCRATCH_REG_45                                                    0x52ed
#define mmACP_SCRATCH_REG_46                                                    0x52ee
#define mmACP_SCRATCH_REG_47                                                    0x52ef
#define mmACP_VOICE_WAKEUP_ENABLE                                               0x51e8
#define mmACP_VOICE_WAKEUP_STATUS                                               0x51e9
#define mmI2S_VOICE_WAKEUP_LOWER_THRESHOLD                                      0x51ea
#define mmI2S_VOICE_WAKEUP_HIGHER_THRESHOLD                                     0x51eb
#define mmI2S_VOICE_WAKEUP_NO_OF_SAMPLES                                        0x51ec
#define mmI2S_VOICE_WAKEUP_NO_OF_PEAKS                                          0x51ed
#define mmI2S_VOICE_WAKEUP_DURATION_OF_N_PEAKS                                  0x51ee
#define mmI2S_VOICE_WAKEUP_BITCLK_TOGGLE_DETECTION                              0x51ef
#define mmI2S_VOICE_WAKEUP_DATA_PATH_SWITCH                                     0x51f0
#define mmI2S_VOICE_WAKEUP_DATA_POINTER                                         0x51f1
#define mmI2S_VOICE_WAKEUP_AUTH_MATCH                                           0x51f2
#define mmI2S_VOICE_WAKEUP_8KB_WRAP                                             0x51f3
#define mmACP_I2S_RECEIVED_BYTE_CNT_HIGH                                        0x51f4
#define mmACP_I2S_RECEIVED_BYTE_CNT_LOW                                         0x51f5
#define mmACP_I2S_MICSP_TRANSMIT_BYTE_CNT_HIGH                                  0x51f6
#define mmACP_I2S_MICSP_TRANSMIT_BYTE_CNT_LOW                                   0x51f7
#define mmACP_MEM_SHUT_DOWN_REQ_LO                                              0x51f8
#define mmACP_MEM_SHUT_DOWN_REQ_HI                                              0x51f9
#define mmACP_MEM_SHUT_DOWN_STS_LO                                              0x51fa
#define mmACP_MEM_SHUT_DOWN_STS_HI                                              0x51fb
#define mmACP_MEM_DEEP_SLEEP_REQ_LO                                             0x51fc
#define mmACP_MEM_DEEP_SLEEP_REQ_HI                                             0x51fd
#define mmACP_MEM_DEEP_SLEEP_STS_LO                                             0x51fe
#define mmACP_MEM_DEEP_SLEEP_STS_HI                                             0x51ff
#define mmACP_MEM_WAKEUP_FROM_SHUT_DOWN_LO                                      0x5200
#define mmACP_MEM_WAKEUP_FROM_SHUT_DOWN_HI                                      0x5201
#define mmACP_MEM_WAKEUP_FROM_SLEEP_LO                                          0x5202
#define mmACP_MEM_WAKEUP_FROM_SLEEP_HI                                          0x5203
#define mmACP_I2SSP_IER                                                         0x5210
#define mmACP_I2SSP_IRER                                                        0x5211
#define mmACP_I2SSP_ITER                                                        0x5212
#define mmACP_I2SSP_CER                                                         0x5213
#define mmACP_I2SSP_CCR                                                         0x5214
#define mmACP_I2SSP_RXFFR                                                       0x5215
#define mmACP_I2SSP_TXFFR                                                       0x5216
#define mmACP_I2SSP_LRBR0                                                       0x5218
#define mmACP_I2SSP_RRBR0                                                       0x5219
#define mmACP_I2SSP_RER0                                                        0x521a
#define mmACP_I2SSP_TER0                                                        0x521b
#define mmACP_I2SSP_RCR0                                                        0x521c
#define mmACP_I2SSP_TCR0                                                        0x521d
#define mmACP_I2SSP_ISR0                                                        0x521e
#define mmACP_I2SSP_IMR0                                                        0x521f
#define mmACP_I2SSP_ROR0                                                        0x5220
#define mmACP_I2SSP_TOR0                                                        0x5221
#define mmACP_I2SSP_RFCR0                                                       0x5222
#define mmACP_I2SSP_TFCR0                                                       0x5223
#define mmACP_I2SSP_RFF0                                                        0x5224
#define mmACP_I2SSP_TFF0                                                        0x5225
#define mmACP_I2SSP_RXDMA                                                       0x5226
#define mmACP_I2SSP_RRXDMA                                                      0x5227
#define mmACP_I2SSP_TXDMA                                                       0x5228
#define mmACP_I2SSP_RTXDMA                                                      0x5229
#define mmACP_I2SSP_COMP_PARAM_2                                                0x522a
#define mmACP_I2SSP_COMP_PARAM_1                                                0x522b
#define mmACP_I2SSP_COMP_VERSION                                                0x522c
#define mmACP_I2SSP_COMP_TYPE                                                   0x522d
#define mmACP_I2SMICSP_IER                                                      0x522e
#define mmACP_I2SMICSP_IRER                                                     0x522f
#define mmACP_I2SMICSP_ITER                                                     0x5230
#define mmACP_I2SMICSP_CER                                                      0x5231
#define mmACP_I2SMICSP_CCR                                                      0x5232
#define mmACP_I2SMICSP_RXFFR                                                    0x5233
#define mmACP_I2SMICSP_TXFFR                                                    0x5234
#define mmACP_I2SMICSP_LRBR0                                                    0x5236
#define mmACP_I2SMICSP_RRBR0                                                    0x5237
#define mmACP_I2SMICSP_RER0                                                     0x5238
#define mmACP_I2SMICSP_TER0                                                     0x5239
#define mmACP_I2SMICSP_RCR0                                                     0x523a
#define mmACP_I2SMICSP_TCR0                                                     0x523b
#define mmACP_I2SMICSP_ISR0                                                     0x523c
#define mmACP_I2SMICSP_IMR0                                                     0x523d
#define mmACP_I2SMICSP_ROR0                                                     0x523e
#define mmACP_I2SMICSP_TOR0                                                     0x523f
#define mmACP_I2SMICSP_RFCR0                                                    0x5240
#define mmACP_I2SMICSP_TFCR0                                                    0x5241
#define mmACP_I2SMICSP_RFF0                                                     0x5242
#define mmACP_I2SMICSP_TFF0                                                     0x5243
#define mmACP_I2SMICSP_LRBR1                                                    0x5246
#define mmACP_I2SMICSP_RRBR1                                                    0x5247
#define mmACP_I2SMICSP_RER1                                                     0x5248
#define mmACP_I2SMICSP_TER1                                                     0x5249
#define mmACP_I2SMICSP_RCR1                                                     0x524a
#define mmACP_I2SMICSP_TCR1                                                     0x524b
#define mmACP_I2SMICSP_ISR1                                                     0x524c
#define mmACP_I2SMICSP_IMR1                                                     0x524d
#define mmACP_I2SMICSP_ROR1                                                     0x524e
#define mmACP_I2SMICSP_TOR1                                                     0x524f
#define mmACP_I2SMICSP_RFCR1                                                    0x5250
#define mmACP_I2SMICSP_TFCR1                                                    0x5251
#define mmACP_I2SMICSP_RFF1                                                     0x5252
#define mmACP_I2SMICSP_TFF1                                                     0x5253
#define mmACP_I2SMICSP_RXDMA                                                    0x5254
#define mmACP_I2SMICSP_RRXDMA                                                   0x5255
#define mmACP_I2SMICSP_TXDMA                                                    0x5256
#define mmACP_I2SMICSP_RTXDMA                                                   0x5257
#define mmACP_I2SMICSP_COMP_PARAM_2                                             0x5258
#define mmACP_I2SMICSP_COMP_PARAM_1                                             0x5259
#define mmACP_I2SMICSP_COMP_VERSION                                             0x525a
#define mmACP_I2SMICSP_COMP_TYPE                                                0x525b
#define mmACP_I2SBT_IER                                                         0x525c
#define mmACP_I2SBT_IRER                                                        0x525d
#define mmACP_I2SBT_ITER                                                        0x525e
#define mmACP_I2SBT_CER                                                         0x525f
#define mmACP_I2SBT_CCR                                                         0x5260
#define mmACP_I2SBT_RXFFR                                                       0x5261
#define mmACP_I2SBT_TXFFR                                                       0x5262
#define mmACP_I2SBT_LRBR0                                                       0x5264
#define mmACP_I2SBT_RRBR0                                                       0x5265
#define mmACP_I2SBT_RER0                                                        0x5266
#define mmACP_I2SBT_TER0                                                        0x5267
#define mmACP_I2SBT_RCR0                                                        0x5268
#define mmACP_I2SBT_TCR0                                                        0x5269
#define mmACP_I2SBT_ISR0                                                        0x526a
#define mmACP_I2SBT_IMR0                                                        0x526b
#define mmACP_I2SBT_ROR0                                                        0x526c
#define mmACP_I2SBT_TOR0                                                        0x526d
#define mmACP_I2SBT_RFCR0                                                       0x526e
#define mmACP_I2SBT_TFCR0                                                       0x526f
#define mmACP_I2SBT_RFF0                                                        0x5270
#define mmACP_I2SBT_TFF0                                                        0x5271
#define mmACP_I2SBT_LRBR1                                                       0x5274
#define mmACP_I2SBT_RRBR1                                                       0x5275
#define mmACP_I2SBT_RER1                                                        0x5276
#define mmACP_I2SBT_TER1                                                        0x5277
#define mmACP_I2SBT_RCR1                                                        0x5278
#define mmACP_I2SBT_TCR1                                                        0x5279
#define mmACP_I2SBT_ISR1                                                        0x527a
#define mmACP_I2SBT_IMR1                                                        0x527b
#define mmACP_I2SBT_ROR1                                                        0x527c
#define mmACP_I2SBT_TOR1                                                        0x527d
#define mmACP_I2SBT_RFCR1                                                       0x527e
#define mmACP_I2SBT_TFCR1                                                       0x527f
#define mmACP_I2SBT_RFF1                                                        0x5280
#define mmACP_I2SBT_TFF1                                                        0x5281
#define mmACP_I2SBT_RXDMA                                                       0x5282
#define mmACP_I2SBT_RRXDMA                                                      0x5283
#define mmACP_I2SBT_TXDMA                                                       0x5284
#define mmACP_I2SBT_RTXDMA                                                      0x5285
#define mmACP_I2SBT_COMP_PARAM_2                                                0x5286
#define mmACP_I2SBT_COMP_PARAM_1                                                0x5287
#define mmACP_I2SBT_COMP_VERSION                                                0x5288
#define mmACP_I2SBT_COMP_TYPE                                                   0x5289

#endif /* ACP_2_2_D_H */
