set(PACKAGE_VERSION "1.3.5")

if (PACKAGE_FIND_VERSION_RANGE)
  # Check for a version range
  if (PACKAGE_VERSION VERSION_LESS PACKAGE_FIND_VERSION_RANGE_MIN)
    set(PACKAGE_VERSION_COMPATIBLE FALSE)
  else ()
    if (PACKAGE_FIND_VERSION_RANGE_MAX)
      if (PACKAGE_VERSION VERSION_GREATER PACKAGE_FIND_VERSION_RANGE_MAX)
        set(PACKAGE_VERSION_COMPATIBLE FALSE)
      else ()
        set(PACKAGE_VERSION_COMPATIBLE TRUE)
      endif ()
    else ()
      set(PACKAGE_VERSION_COMPATIBLE TRUE)
    endif ()
  endif ()

elseif (PACKAGE_FIND_VERSION)
  # Check for a specific version or minimum version
  if (PACKAGE_VERSION VERSION_LESS PACKAGE_FIND_VERSION)
    set(PACKAGE_VERSION_COMPATIBLE FALSE)
  else ()
    set(PACKAGE_VERSION_COMPATIBLE TRUE)
    if (PACKAGE_VERSION VERSION_EQUAL PACKAGE_FIND_VERSION)
      set(PACKAGE_VERSION_EXACT TRUE)
    endif ()
  endif ()
endif ()
