/* SPDX-License-Identifier: GPL-2.0-only */

#include <mainboard/gpio.h>
#include <soc/gpio.h>

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group V ------- */

	/* GPP_V00 - BATLOW# */
	PAD_CFG_NF(GPP_V00, UP_20K, DEEP, NF1),
	/* GPP_V01 - ACPRESENT */
	PAD_CFG_NF(GPP_V01, NATIVE, DEEP, NF1),
	/* GPP_V02 - SOC_WAKE# */
	PAD_CFG_NF(GPP_V02, NATIVE, DEEP, NF1),
	/* GPP_V03 - PWRBTN# */
	PAD_CFG_NF(GPP_V03, UP_20K, DEEP, NF1),
	/* GPP_V04 - SLP_S3# */
	PAD_CFG_NF(GPP_V04, NONE, DEEP, NF1),
	/* GPP_V05 - SLP_S4# */
	PAD_CFG_NF(GPP_V05, NONE, DEEP, NF1),
	/* GPP_V06 - SLP_A# */
	PAD_CFG_NF(GPP_V06, NONE, DEEP, NF1),
	/* GPP_V07 - GPIO */
	PAD_CFG_GPO(GPP_V07, 0, DEEP),
	/* GPP_V08 - SUSCLK */
	PAD_CFG_NF(GPP_V08, NONE, DEEP, NF1),
	/* GPP_V09 - SLP_WLAN# */
	PAD_CFG_NF(GPP_V09, NONE, DEEP, NF1),
	/* GPP_V10 - SLP_S5# */
	PAD_CFG_NF(GPP_V10, NONE, DEEP, NF1),
	/* GPP_V11 - LANPHYPC */
	PAD_CFG_NF(GPP_V11, NONE, DEEP, NF1),
	/* GPP_V12 - SLP_LAN# */
	PAD_CFG_NF(GPP_V12, NONE, DEEP, NF1),
	/* GPP_V13 - GPIO */
	PAD_CFG_GPO(GPP_V13, 0, DEEP),
	/* GPP_V14 - WAKE# */
	PAD_CFG_NF(GPP_V14, NONE, DEEP, NF1),
	/* GPP_V15 - GPIO */
	PAD_CFG_GPO(GPP_V15, 0, DEEP),
	/* GPP_V16 - GPIO */
	PAD_CFG_GPO(GPP_V16, 0, DEEP),
	/* GPP_V17 - GPIO */
	PAD_CFG_GPO(GPP_V17, 0, DEEP),
	/* GPP_V18 - GPIO */
	PAD_CFG_GPO(GPP_V18, 0, DEEP),
	/* GPP_V19 - n/a */
	PAD_CFG_NF(GPP_V19, NONE, DEEP, NF1),
	/* GPP_V20 - n/a */
	PAD_CFG_NF(GPP_V20, NONE, DEEP, NF1),
	/* GPP_V21 - n/a */
	PAD_CFG_NF(GPP_V21, NONE, DEEP, NF1),
	/* GPP_V22 - GPIO */
	PAD_CFG_GPO(GPP_V22, 0, DEEP),
	/* GPP_V23 - GPIO */
	PAD_CFG_GPO(GPP_V23, 0, DEEP),

	/* ------- GPIO Group GPP_C ------- */

	/* GPP_C00 - SMBCLK */
	PAD_CFG_NF(GPP_C00, UP_20K, DEEP, NF1),
	/* GPP_C01 - SMBDATA */
	PAD_CFG_NF(GPP_C01, UP_20K, DEEP, NF1),
	/* GPP_C02 - GPIO */
	PAD_CFG_GPO(GPP_C02, 0, DEEP),
	/* GPP_C03 - SML0CLK */
	PAD_CFG_NF(GPP_C03, NONE, DEEP, NF1),
	/* GPP_C04 - SML0DATA */
	PAD_CFG_NF(GPP_C04, NONE, DEEP, NF1),
	/* GPP_C05 - GPIO */
	PAD_CFG_GPO(GPP_C05, 0, DEEP),
	/* GPP_C06 - SML1CLK */
	PAD_CFG_NF(GPP_C06, NONE, RSMRST, NF1),
	/* GPP_C07 - SML1DATA */
	PAD_CFG_NF(GPP_C07, NONE, RSMRST, NF1),
	/* GPP_C08 - GPIO */
	PAD_CFG_GPO(GPP_C08, 0, DEEP),
	/* GPP_C09 - GPIO */
	PAD_CFG_GPO(GPP_C09, 0, DEEP),
	/* GPP_C10 - GPIO */
	PAD_CFG_GPO(GPP_C10, 0, DEEP),
	/* GPP_C11 - SRCCLKREQ2# */
	PAD_CFG_NF(GPP_C11, NONE, DEEP, NF1),
	/* GPP_C12 - SRCCLKREQ3# */
	PAD_CFG_NF(GPP_C12, NONE, DEEP, NF1),
	/* GPP_C13 - GPIO */
	PAD_CFG_GPO(GPP_C13, 0, DEEP),
	/* GPP_C14 - GPIO */
	PAD_CFG_GPO(GPP_C14, 0, DEEP),
	/* GPP_C15 - GPIO */
	PAD_CFG_GPO(GPP_C15, 0, DEEP),
	/* GPP_C16 - TBT_LSX0_TXD */
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),
	/* GPP_C17 - TBT_LSX0_RXD */
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),
	/* GPP_C18 - GPIO */
	PAD_CFG_GPO(GPP_C18, 0, DEEP),
	/* GPP_C19 - GPIO */
	PAD_CFG_GPO(GPP_C19, 0, DEEP),
	/* GPP_C20 - DDP2_CTRLCLK */
	PAD_CFG_NF(GPP_C20, NONE, DEEP, NF2),
	/* GPP_C21 - DDP2_CTRLDATA */
	PAD_CFG_NF(GPP_C21, NONE, DEEP, NF2),
	/* GPP_C22 - GPIO */
	PAD_CFG_GPO(GPP_C22, 0, DEEP),
	/* GPP_C23 - GPIO */
	PAD_CFG_GPO(GPP_C23, 0, DEEP),

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_A ------- */

	/* GPP_A00 - ESPI_IO0 */
	PAD_CFG_NF(GPP_A00, UP_20K, DEEP, NF1),
	/* GPP_A01 - ESPI_IO1 */
	PAD_CFG_NF(GPP_A01, UP_20K, DEEP, NF1),
	/* GPP_A02 - ESPI_IO2 */
	PAD_CFG_NF(GPP_A02, UP_20K, DEEP, NF1),
	/* GPP_A03 - ESPI_IO3 */
	PAD_CFG_NF(GPP_A03, UP_20K, DEEP, NF1),
	/* GPP_A04 - ESPI_CS0# */
	PAD_CFG_NF(GPP_A04, UP_20K, DEEP, NF1),
	/* GPP_A05 - ESPI_CLK */
	PAD_CFG_NF(GPP_A05, UP_20K, DEEP, NF1),
	/* GPP_A06 - ESPI_RESET# */
	PAD_CFG_NF(GPP_A06, NONE, DEEP, NF1),
	/* GPP_A07 - GPIO */
	PAD_CFG_GPO(GPP_A07, 0, DEEP),
	/* GPP_A08 - GPIO */
	PAD_CFG_GPO(GPP_A08, 0, DEEP),
	/* GPP_A09 - GPIO */
	PAD_CFG_GPO(GPP_A09, 0, DEEP),
	/* GPP_A10 - GPIO */
	PAD_CFG_GPO(GPP_A10, 0, DEEP),
	/* GPP_A11 - GPIO */
	PAD_CFG_GPO(GPP_A11, 0, DEEP),
	/* GPP_A12 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A12, NONE, DEEP, OFF, ACPI),
	/* GPP_A13 - GPIO */
	PAD_CFG_TERM_GPO(GPP_A13, 1, UP_20K, PLTRST),
	/* GPP_A14 - GPIO */
	PAD_CFG_GPO(GPP_A14, 0, DEEP),
	/* GPP_A15 - GPIO */
	PAD_CFG_GPO(GPP_A15, 0, DEEP),
	/* GPP_A16 - RSVD */
	PAD_CFG_NF(GPP_A16, UP_20K, DEEP, NF1),
	/* GPP_A17 - GPIO */
	PAD_CFG_GPO(GPP_A17, 0, DEEP),
	/* GPP_A18 - GPIO */
	PAD_CFG_GPO(GPP_A18, 0, DEEP),
	/* GPP_A19 - GPIO */
	PAD_CFG_GPO(GPP_A19, 0, DEEP),
	/* GPP_A20 - GPIO */
	PAD_CFG_GPO(GPP_A20, 0, DEEP),
	/* GPP_A21 - PMCALERT# */
	PAD_CFG_NF(GPP_A21, NATIVE, DEEP, NF1),
	/* GPP_A22 - GPIO */
	PAD_NC(GPP_A22, NATIVE),
	/* GPP_A23 - GPIO */
	PAD_NC(GPP_A23, NATIVE),
	/* GPP_ESPI_CLK_LPBK - n/a */
	PAD_CFG_NF(GPP_ESPI_CLK_LPBK, NONE, DEEP, NF1),

	/* ------- GPIO Group GPP_E ------- */

	/* GPP_E00 - GPIO */
	PAD_CFG_GPO(GPP_E00, 0, DEEP),
	/* GPP_E01 - GPIO */
	PAD_CFG_GPI_APIC(GPP_E01, UP_20K, DEEP, LEVEL, NONE),
	/* GPP_E02 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E02, NONE, DEEP, OFF, ACPI),
	/* GPP_E03 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E03, NONE, DEEP, OFF, ACPI),
	/* GPP_E04 - GPIO */
	PAD_CFG_GPO(GPP_E04, 0, DEEP),
	/* GPP_E05 - GPIO */
	PAD_CFG_GPO(GPP_E05, 0, DEEP),
	/* GPP_E06 - GPIO */
	PAD_CFG_GPO(GPP_E06, 0, DEEP),
	/* GPP_E07 - GPIO */
	PAD_CFG_GPO(GPP_E07, 0, DEEP),
	/* GPP_E08 - GPIO */
	PAD_CFG_GPO(GPP_E08, 0, DEEP),
	/* GPP_E09 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E09, NONE, DEEP, OFF, ACPI),
	/* GPP_E10 - GPIO */
	PAD_CFG_GPO(GPP_E10, 0, DEEP),
	/* GPP_E11 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E11, NONE, DEEP, OFF, ACPI),
	/* GPP_E12 - GPIO */
	PAD_CFG_GPO(GPP_E12, 0, DEEP),
	/* GPP_E13 - GPIO */
	PAD_CFG_GPO(GPP_E13, 0, DEEP),
	/* GPP_E14 - DDSP_HPDA */
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),
	/* GPP_E15 - GPIO */
	PAD_CFG_GPO(GPP_E15, 0, DEEP),
	/* GPP_E16 - VRALERT# */
	PAD_CFG_NF(GPP_E16, NONE, DEEP, NF2),
	/* GPP_E17 - GPIO */
	PAD_CFG_GPO(GPP_E17, 0, DEEP),
	/* GPP_E18 - GPIO */
	PAD_CFG_GPO(GPP_E18, 0, DEEP),
	/* GPP_E19 - GPIO */
	PAD_CFG_GPO(GPP_E19, 0, DEEP),
	/* GPP_E20 - GPIO */
	PAD_CFG_GPO(GPP_E20, 0, DEEP),
	/* GPP_E21 - GPIO */
	PAD_CFG_GPO(GPP_E21, 0, DEEP),
	/* GPP_E22 - GPIO */
	PAD_CFG_GPO(GPP_E22, 0, DEEP),
	/* GPP_E23 - GPIO */
	PAD_NC(GPP_E23, NONE),
	/* GPP_THC0_GSPI_CLK_LPBK - GPIO */
	PAD_NC(GPP_THC0_GSPI_CLK_LPBK, NONE),

	/* ------- GPIO Community 3 ------- */

	/* ------- GPIO Group GPP_H ------- */

	/* GPP_H00 - GPIO */
	PAD_CFG_GPO(GPP_H00, 0, DEEP),
	/* GPP_H01 - GPIO */
	PAD_CFG_GPO(GPP_H01, 0, DEEP),
	/* GPP_H02 - GPIO */
	PAD_CFG_GPO(GPP_H02, 0, DEEP),
	/* GPP_H03 - GPIO */
	PAD_CFG_GPO(GPP_H03, 0, DEEP),
	/* GPP_H04 - GPIO */
	PAD_CFG_GPO(GPP_H04, 0, DEEP),
	/* GPP_H05 - GPIO */
	PAD_CFG_GPO(GPP_H05, 0, DEEP),
	/* GPP_H06 - I2C3_SDA */
	PAD_CFG_NF(GPP_H06, NONE, DEEP, NF1),
	/* GPP_H07 - I2C3_SCL */
	PAD_CFG_NF(GPP_H07, NONE, DEEP, NF1),
	/* GPP_H08 - GPIO */
	PAD_CFG_GPO(GPP_H08, 0, DEEP),
	/* GPP_H09 - GPIO */
	PAD_CFG_GPO(GPP_H09, 0, DEEP),
	/* GPP_H10 - GPIO */
	PAD_CFG_GPO(GPP_H10, 0, DEEP),
	/* GPP_H11 - GPIO */
	PAD_CFG_GPO(GPP_H11, 0, DEEP),
	/* GPP_H12 - GPIO */
	PAD_CFG_GPO(GPP_H12, 0, DEEP),
	/* GPP_H13 - PROC_C10_GATE# */
	PAD_CFG_NF(GPP_H13, NONE, DEEP, NF1),
	/* GPP_H14 - GPIO */
	PAD_CFG_GPO(GPP_H14, 0, DEEP),
	/* GPP_H15 - GPIO */
	PAD_CFG_GPO(GPP_H15, 0, DEEP),
	/* GPP_H16 - GPIO */
	PAD_CFG_GPO(GPP_H16, 0, DEEP),
	/* GPP_H17 - GPIO */
	PAD_CFG_GPO(GPP_H17, 0, DEEP),
	/* GPP_H18 - GPIO */
	PAD_CFG_GPO(GPP_H18, 0, DEEP),
	/* GPP_H19 - I2C0_SDA */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF1),
	/* GPP_H20 - I2C0_SCL */
	PAD_CFG_NF(GPP_H20, NONE, DEEP, NF1),
	/* GPP_H21 - I2C1_SDA */
	PAD_CFG_NF(GPP_H21, NONE, DEEP, NF1),
	/* GPP_H22 - I2C1_SCL */
	PAD_CFG_NF(GPP_H22, NONE, DEEP, NF1),
	/* GPP_H23 - GPIO */
	PAD_NC(GPP_H23, NONE),
	/* GPP_LPI3C1_CLK_LPBK - GPIO */
	PAD_NC(GPP_LPI3C1_CLK_LPBK, NATIVE),
	/* GPP_LPI3C0_CLK_LPBK - n/a */
	PAD_CFG_NF(GPP_LPI3C0_CLK_LPBK, NATIVE, DEEP, NF2),

	/* ------- GPIO Group GPP_F ------- */

	/* GPP_F00 - CNV_BRI_DT */
	PAD_CFG_NF(GPP_F00, NONE, DEEP, NF1),
	/* GPP_F01 - CNV_BRI_RSP */
	PAD_CFG_NF(GPP_F01, UP_20K, DEEP, NF1),
	/* GPP_F02 - CNV_RGI_DT */
	PAD_CFG_NF(GPP_F02, NONE, DEEP, NF1),
	/* GPP_F03 - CNV_RGI_RSP */
	PAD_CFG_NF(GPP_F03, UP_20K, DEEP, NF1),
	/* GPP_F04 - CNV_RF_RESET# */
	PAD_CFG_NF(GPP_F04, NONE, DEEP, NF1),
	/* GPP_F05 - MODEM_CLKREQ */
	PAD_CFG_NF(GPP_F05, NONE, DEEP, NF3),
	/* GPP_F06 - GPIO */
	PAD_CFG_GPO(GPP_F06, 0, DEEP),
	/* GPP_F07 - GPIO */
	PAD_CFG_GPO(GPP_F07, 0, DEEP),
	/* GPP_F08 - GPIO */
	PAD_CFG_GPO(GPP_F08, 0, DEEP),
	/* GPP_F09 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F09, NONE, DEEP, OFF, ACPI),
	/* GPP_F10 - GPIO */
	PAD_CFG_GPO(GPP_F10, 0, DEEP),
	/* GPP_F11 - GPIO */
	PAD_CFG_GPO(GPP_F11, 0, DEEP),
	/* GPP_F12 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F12, NONE, DEEP, OFF, ACPI),
	/* GPP_F13 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F13, NONE, DEEP, OFF, ACPI),
	/* GPP_F14 - GPIO */
	PAD_CFG_GPO(GPP_F14, 0, DEEP),
	/* GPP_F15 - GPIO */
	PAD_CFG_GPO(GPP_F15, 0, DEEP),
	/* GPP_F16 - GPIO */
	PAD_CFG_GPO(GPP_F16, 0, DEEP),
	/* GPP_F17 - GPIO */
	PAD_CFG_GPO(GPP_F17, 0, DEEP),
	/* GPP_F18 - GPIO */
	PAD_CFG_GPO(GPP_F18, 0, DEEP),
	/* GPP_F19 - GPIO */
	PAD_CFG_GPO(GPP_F19, 0, DEEP),
	/* GPP_F20 - GPIO */
	PAD_CFG_GPO(GPP_F20, 0, DEEP),
	/* GPP_F21 - GPIO */
	PAD_CFG_GPO(GPP_F21, 0, DEEP),
	/* GPP_F22 - GPIO */
	PAD_CFG_GPO(GPP_F22, 0, DEEP),
	/* GPP_F23 - GPIO */
	PAD_CFG_GPO(GPP_F23, 0, DEEP),
	/* GPP_THC1_GSPI1_CLK_LPBK - GPIO */
	PAD_NC(GPP_THC1_GSPI1_CLK_LPBK, NONE),
	/* GPP_GSPI0A_CLK_LOOPBK - GPIO */
	PAD_NC(GPP_GSPI0A_CLK_LOOPBK, NONE),

	/* ------- GPIO Group SPI ------- */

	/* ------- GPIO Group VGPIO3 ------- */

	/* GPP_VGPIO3_USB0 - GPP_VGPIO3_USB0 */
	PAD_CFG_NF(GPP_VGPIO3_USB0, NONE, DEEP, NF1),
	/* GPP_VGPIO3_USB1 - GPP_VGPIO3_USB1 */
	PAD_CFG_NF(GPP_VGPIO3_USB1, NONE, DEEP, NF1),
	/* GPP_VGPIO3_USB2 - GPP_VGPIO3_USB2 */
	PAD_CFG_NF(GPP_VGPIO3_USB2, NONE, DEEP, NF1),
	/* GPP_VGPIO3_USB3 - GPP_VGPIO3_USB3 */
	PAD_CFG_NF(GPP_VGPIO3_USB3, NONE, DEEP, NF1),
	/* GPP_VGPIO3_USB4 - GPP_VGPIO3_USB4 */
	PAD_CFG_NF(GPP_VGPIO3_USB4, NONE, DEEP, NF1),
	/* GPP_VGPIO3_USB5 - GPP_VGPIO3_USB5 */
	PAD_CFG_NF(GPP_VGPIO3_USB5, NONE, DEEP, NF1),
	/* GPP_VGPIO3_USB6 - GPP_VGPIO3_USB6 */
	PAD_CFG_NF(GPP_VGPIO3_USB6, NONE, DEEP, NF1),
	/* GPP_VGPIO3_USB7 - GPP_VGPIO3_USB7 */
	PAD_CFG_NF(GPP_VGPIO3_USB7, NONE, DEEP, NF1),
	/* GPP_VGPIO3_TS0 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_VGPIO3_TS0, NONE, DEEP, OFF, ACPI),
	/* GPP_VGPIO3_TS1 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_VGPIO3_TS1, NONE, DEEP, OFF, ACPI),
	/* GPP_VGPIO3_THC0 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_VGPIO3_THC0, NONE, DEEP, OFF, ACPI),
	/* GPP_VGPIO3_THC1 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_VGPIO3_THC1, NONE, DEEP, OFF, ACPI),
	/* GPP_VGPIO3_THC2 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_VGPIO3_THC2, NONE, DEEP, OFF, ACPI),
	/* GPP_VGPIO3_THC3 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_VGPIO3_THC3, NONE, DEEP, OFF, ACPI),

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPP_S ------- */

	/* GPP_S00 - GPIO */
	PAD_CFG_GPO(GPP_S00, 0, DEEP),
	/* GPP_S01 - GPIO */
	PAD_CFG_GPO(GPP_S01, 0, DEEP),
	/* GPP_S02 - GPIO */
	PAD_CFG_GPO(GPP_S02, 0, DEEP),
	/* GPP_S03 - GPIO */
	PAD_CFG_GPO(GPP_S03, 0, DEEP),
	/* GPP_S04 - GPIO */
	PAD_CFG_GPO(GPP_S04, 0, DEEP),
	/* GPP_S05 - GPIO */
	PAD_CFG_GPO(GPP_S05, 0, DEEP),
	/* GPP_S06 - GPIO */
	PAD_CFG_GPO(GPP_S06, 0, DEEP),
	/* GPP_S07 - GPIO */
	PAD_CFG_GPO(GPP_S07, 0, DEEP),

	/* ------- GPIO Group JTAG ------- */

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_B ------- */

	/* GPP_B00 - GPIO */
	PAD_CFG_GPI_INT(GPP_B00, NONE, PLTRST, LEVEL),
	/* GPP_B01 - GPIO */
	PAD_CFG_GPO(GPP_B01, 0, DEEP),
	/* GPP_B02 - GPIO */
	PAD_CFG_GPO(GPP_B02, 0, DEEP),
	/* GPP_B03 - GPIO */
	PAD_CFG_GPO(GPP_B03, 0, DEEP),
	/* GPP_B04 - GPIO */
	PAD_CFG_GPO(GPP_B04, 0, DEEP),
	/* GPP_B05 - GPIO */
	PAD_CFG_GPO(GPP_B05, 0, DEEP),
	/* GPP_B06 - GPIO */
	PAD_CFG_GPO(GPP_B06, 0, DEEP),
	/* GPP_B07 - GPIO */
	PAD_CFG_GPO(GPP_B07, 0, DEEP),
	/* GPP_B08 - GPIO */
	PAD_CFG_GPO(GPP_B08, 0, DEEP),
	/* GPP_B09 - GPIO */
	PAD_CFG_GPO(GPP_B09, 0, DEEP),
	/* GPP_B10 - GPIO */
	PAD_CFG_GPO(GPP_B10, 0, DEEP),
	/* GPP_B11 - DDSP_HPD2 */
	PAD_CFG_NF(GPP_B11, NONE, DEEP, NF2),
	/* GPP_B12 - SLP_S0# */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	/* GPP_B13 - PLTRST# */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),
	/* GPP_B14 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B14, NONE, DEEP, OFF, ACPI),
	/* GPP_B15 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B15, NONE, DEEP, OFF, ACPI),
	/* GPP_B16 - GPIO */
	PAD_CFG_GPO(GPP_B16, 0, DEEP),
	/* GPP_B17 - GPIO */
	PAD_CFG_GPO(GPP_B17, 0, DEEP),
	/* GPP_B18 - GPIO */
	PAD_CFG_GPO(GPP_B18, 1, DEEP),
	/* GPP_B19 - GPIO */
	PAD_CFG_GPO(GPP_B19, 1, DEEP),
	/* GPP_B20 - GPIO */
	PAD_CFG_GPO(GPP_B20, 0, DEEP),
	/* GPP_B21 - GPIO */
	PAD_CFG_GPO(GPP_B21, 0, PLTRST),
	/* GPP_B22 - GPIO */
	PAD_CFG_GPO(GPP_B22, 0, DEEP),
	/* GPP_B23 - GPIO */
	PAD_CFG_GPO(GPP_B23, 0, DEEP),
	/* GPP_ACI3C0_CLK_LPBK - n/a */
	PAD_CFG_NF(GPP_ACI3C0_CLK_LPBK, NATIVE, DEEP, NF4),

	/* ------- GPIO Group GPP_D ------- */

	/* GPP_D00 - GPIO */
	PAD_CFG_GPO(GPP_D00, 1, DEEP),
	/* GPP_D01 - GPIO */
	PAD_CFG_GPO(GPP_D01, 1, DEEP),
	/* GPP_D02 - GPIO */
	PAD_CFG_GPO(GPP_D02, 1, DEEP),
	/* GPP_D03 - GPIO */
	PAD_CFG_GPO(GPP_D03, 0, DEEP),
	/* GPP_D04 - GPIO */
	PAD_CFG_GPO(GPP_D04, 0, DEEP),
	/* GPP_D05 - GPIO */
	PAD_CFG_GPO(GPP_D05, 1, DEEP),
	/* GPP_D06 - GPIO */
	PAD_CFG_GPO(GPP_D06, 0, DEEP),
	/* GPP_D07 - GPIO */
	PAD_CFG_GPO(GPP_D07, 0, DEEP),
	/* GPP_D08 - GPIO */
	PAD_CFG_GPO(GPP_D08, 0, DEEP),
	/* GPP_D09 - GPIO */
	PAD_CFG_GPO(GPP_D09, 0, DEEP),
	/* GPP_D10 - HDA_BCLK */
	PAD_CFG_NF(GPP_D10, NONE, DEEP, NF1),
	/* GPP_D11 - HDA_SYNC */
	PAD_CFG_NF(GPP_D11, NATIVE, DEEP, NF1),
	/* GPP_D12 - HDA_SDO */
	PAD_CFG_NF(GPP_D12, NATIVE, DEEP, NF1),
	/* GPP_D13 - HDA_SDI0 */
	PAD_CFG_NF(GPP_D13, NATIVE, DEEP, NF1),
	/* GPP_D14 - GPIO */
	PAD_CFG_GPO(GPP_D14, 0, DEEP),
	/* GPP_D15 - GPIO */
	PAD_CFG_GPO(GPP_D15, 0, DEEP),
	/* GPP_D16 - GPIO */
	PAD_CFG_GPO(GPP_D16, 0, DEEP),
	/* GPP_D17 - HDA_RST# */
	PAD_CFG_NF(GPP_D17, NONE, DEEP, NF1),
	/* GPP_D18 - SRCCLKREQ6# */
	PAD_CFG_NF(GPP_D18, NONE, DEEP, NF1),
	/* GPP_D19 - SRCCLKREQ7# */
	PAD_CFG_NF(GPP_D19, NONE, DEEP, NF1),
	/* GPP_D20 - SRCCLKREQ8# */
	PAD_CFG_NF(GPP_D20, NONE, DEEP, NF1),
	/* GPP_D21 - SRCCLKREQ5# */
	PAD_CFG_NF(GPP_D21, NONE, DEEP, NF2),
	/* GPP_D22 - n/a */
	PAD_CFG_NF(GPP_D22, NATIVE, DEEP, NF1),
	/* GPP_D23 - n/a */
	PAD_CFG_NF(GPP_D23, NATIVE, DEEP, NF1),
	/* GPP_BOOTHALT_B - n/a */
	PAD_CFG_NF(GPP_BOOTHALT_B, UP_20K, DEEP, NF1),

	/* ------- GPIO Group VGPIO ------- */

	/* VGPIO00 - GPIO */
	PAD_CFG_GPO(GPP_VGPIO00, 1, DEEP),
	/* VGPIO04 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_VGPIO04, NONE, DEEP, OFF, ACPI),
	/* VGPIO05 - GPIO */
	PAD_CFG_GPO(GPP_VGPIO05, 1, DEEP),
	/* VGPIO06 - GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO06, 0, NONE, DEEP, LEVEL, ACPI),
	/* VGPIO07 - GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO07, 0, NONE, DEEP, LEVEL, ACPI),
	/* VGPIO08 - GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO08, 0, NONE, DEEP, LEVEL, ACPI),
	/* VGPIO09 - GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO09, 0, NONE, DEEP, LEVEL, ACPI),
	/* VGPIO10 - VGPIO10 */
	PAD_CFG_NF(GPP_VGPIO10, NONE, DEEP, NF1),
	/* VGPIO11 - VGPIO11 */
	PAD_CFG_NF(GPP_VGPIO11, NONE, DEEP, NF1),
	/* VGPIO12 - VGPIO12 */
	PAD_CFG_NF(GPP_VGPIO12, NONE, DEEP, NF1),
	/* VGPIO13 - VGPIO13 */
	PAD_CFG_NF(GPP_VGPIO13, NONE, DEEP, NF1),
	/* VGPIO18 - GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO18, 0, NONE, DEEP, LEVEL, ACPI),
	/* VGPIO19 - GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO19, 0, NONE, DEEP, LEVEL, ACPI),
	/* VGPIO20 - GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO20, 0, NONE, DEEP, LEVEL, ACPI),
	/* VGPIO21 - GPIO */
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO21, 0, NONE, DEEP, LEVEL, ACPI),
	/* VGPIO22 - VGPIO22 */
	PAD_CFG_NF(GPP_VGPIO22, NONE, DEEP, NF1),
	/* VGPIO23 - VGPIO23 */
	PAD_CFG_NF(GPP_VGPIO23, NONE, DEEP, NF1),
	/* VGPIO24 - VGPIO24 */
	PAD_CFG_NF(GPP_VGPIO24, NONE, DEEP, NF1),
	/* VGPIO25 - VGPIO25 */
	PAD_CFG_NF(GPP_VGPIO25, NONE, DEEP, NF1),
	/* VGPIO30 - RESERVED */
	PAD_CFG_NF(GPP_VGPIO30, NONE, DEEP, NF3),
	/* VGPIO31 - RESERVED */
	PAD_CFG_NF(GPP_VGPIO31, NONE, DEEP, NF3),
	/* VGPIO32 - RESERVED */
	PAD_CFG_NF(GPP_VGPIO32, NONE, DEEP, NF3),
	/* VGPIO33 - RESERVED */
	PAD_CFG_NF(GPP_VGPIO33, NONE, DEEP, NF3),
	/* VGPIO34 - VGPIO34 */
	PAD_CFG_NF(GPP_VGPIO34, NONE, DEEP, NF1),
	/* VGPIO35 - VGPIO35 */
	PAD_CFG_NF(GPP_VGPIO35, NONE, DEEP, NF1),
	/* VGPIO36 - VGPIO36 */
	PAD_CFG_NF(GPP_VGPIO36, NONE, DEEP, NF1),
	/* VGPIO37 - VGPIO37 */
	PAD_CFG_NF(GPP_VGPIO37, NONE, DEEP, NF1),
	/* VGPIO40 - RESERVED */
	PAD_CFG_NF(GPP_VGPIO40, NONE, DEEP, NF2),
	/* VGPIO41 - RESERVED */
	PAD_CFG_NF(GPP_VGPIO41, NONE, DEEP, NF2),
	/* VGPIO42 - RESERVED */
	PAD_CFG_NF(GPP_VGPIO42, NONE, DEEP, NF2),
	/* VGPIO43 - RESERVED */
	PAD_CFG_NF(GPP_VGPIO43, NONE, DEEP, NF2),
	/* VGPIO44 - VGPIO44 */
	PAD_CFG_NF(GPP_VGPIO44, NONE, DEEP, NF1),
	/* VGPIO45 - VGPIO45 */
	PAD_CFG_NF(GPP_VGPIO45, NONE, DEEP, NF1),
	/* VGPIO46 - VGPIO46 */
	PAD_CFG_NF(GPP_VGPIO46, NONE, DEEP, NF1),
	/* VGPIO47 - VGPIO47 */
	PAD_CFG_NF(GPP_VGPIO47, NONE, DEEP, NF1),
};

void variant_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
