#ifndef ANV_VP9_TABLES_H
#define ANV_VP9_TABLES_H

/* Taken from ffmpeg */
static const int16_t vp9_dc_qlookup[3][256] = {
   {
      4,     8,     8,     9,    10,    11,    12,    12,
      13,    14,    15,    16,    17,    18,    19,    19,
      20,    21,    22,    23,    24,    25,    26,    26,
      27,    28,    29,    30,    31,    32,    32,    33,
      34,    35,    36,    37,    38,    38,    39,    40,
      41,    42,    43,    43,    44,    45,    46,    47,
      48,    48,    49,    50,    51,    52,    53,    53,
      54,    55,    56,    57,    57,    58,    59,    60,
      61,    62,    62,    63,    64,    65,    66,    66,
      67,    68,    69,    70,    70,    71,    72,    73,
      74,    74,    75,    76,    77,    78,    78,    79,
      80,    81,    81,    82,    83,    84,    85,    85,
      87,    88,    90,    92,    93,    95,    96,    98,
      99,   101,   102,   104,   105,   107,   108,   110,
      111,   113,   114,   116,   117,   118,   120,   121,
      123,   125,   127,   129,   131,   134,   136,   138,
      140,   142,   144,   146,   148,   150,   152,   154,
      156,   158,   161,   164,   166,   169,   172,   174,
      177,   180,   182,   185,   187,   190,   192,   195,
      199,   202,   205,   208,   211,   214,   217,   220,
      223,   226,   230,   233,   237,   240,   243,   247,
      250,   253,   257,   261,   265,   269,   272,   276,
      280,   284,   288,   292,   296,   300,   304,   309,
      313,   317,   322,   326,   330,   335,   340,   344,
      349,   354,   359,   364,   369,   374,   379,   384,
      389,   395,   400,   406,   411,   417,   423,   429,
      435,   441,   447,   454,   461,   467,   475,   482,
      489,   497,   505,   513,   522,   530,   539,   549,
      559,   569,   579,   590,   602,   614,   626,   640,
      654,   668,   684,   700,   717,   736,   755,   775,
      796,   819,   843,   869,   896,   925,   955,   988,
      1022,  1058,  1098,  1139,  1184,  1232,  1282,  1336,
   },
   {
      4,     9,    10,    13,    15,    17,    20,    22,
      25,    28,    31,    34,    37,    40,    43,    47,
      50,    53,    57,    60,    64,    68,    71,    75,
      78,    82,    86,    90,    93,    97,   101,   105,
      109,   113,   116,   120,   124,   128,   132,   136,
      140,   143,   147,   151,   155,   159,   163,   166,
      170,   174,   178,   182,   185,   189,   193,   197,
      200,   204,   208,   212,   215,   219,   223,   226,
      230,   233,   237,   241,   244,   248,   251,   255,
      259,   262,   266,   269,   273,   276,   280,   283,
      287,   290,   293,   297,   300,   304,   307,   310,
      314,   317,   321,   324,   327,   331,   334,   337,
      343,   350,   356,   362,   369,   375,   381,   387,
      394,   400,   406,   412,   418,   424,   430,   436,
      442,   448,   454,   460,   466,   472,   478,   484,
      490,   499,   507,   516,   525,   533,   542,   550,
      559,   567,   576,   584,   592,   601,   609,   617,
      625,   634,   644,   655,   666,   676,   687,   698,
      708,   718,   729,   739,   749,   759,   770,   782,
      795,   807,   819,   831,   844,   856,   868,   880,
      891,   906,   920,   933,   947,   961,   975,   988,
      1001,  1015,  1030,  1045,  1061,  1076,  1090,  1105,
      1120,  1137,  1153,  1170,  1186,  1202,  1218,  1236,
      1253,  1271,  1288,  1306,  1323,  1342,  1361,  1379,
      1398,  1416,  1436,  1456,  1476,  1496,  1516,  1537,
      1559,  1580,  1601,  1624,  1647,  1670,  1692,  1717,
      1741,  1766,  1791,  1817,  1844,  1871,  1900,  1929,
      1958,  1990,  2021,  2054,  2088,  2123,  2159,  2197,
      2236,  2276,  2319,  2363,  2410,  2458,  2508,  2561,
      2616,  2675,  2737,  2802,  2871,  2944,  3020,  3102,
      3188,  3280,  3375,  3478,  3586,  3702,  3823,  3953,
      4089,  4236,  4394,  4559,  4737,  4929,  5130,  5347,
   },
   {
      4,    12,    18,    25,    33,    41,    50,    60,
      70,    80,    91,   103,   115,   127,   140,   153,
      166,   180,   194,   208,   222,   237,   251,   266,
      281,   296,   312,   327,   343,   358,   374,   390,
      405,   421,   437,   453,   469,   484,   500,   516,
      532,   548,   564,   580,   596,   611,   627,   643,
      659,   674,   690,   706,   721,   737,   752,   768,
      783,   798,   814,   829,   844,   859,   874,   889,
      904,   919,   934,   949,   964,   978,   993,  1008,
      1022,  1037,  1051,  1065,  1080,  1094,  1108,  1122,
      1136,  1151,  1165,  1179,  1192,  1206,  1220,  1234,
      1248,  1261,  1275,  1288,  1302,  1315,  1329,  1342,
      1368,  1393,  1419,  1444,  1469,  1494,  1519,  1544,
      1569,  1594,  1618,  1643,  1668,  1692,  1717,  1741,
      1765,  1789,  1814,  1838,  1862,  1885,  1909,  1933,
      1957,  1992,  2027,  2061,  2096,  2130,  2165,  2199,
      2233,  2267,  2300,  2334,  2367,  2400,  2434,  2467,
      2499,  2532,  2575,  2618,  2661,  2704,  2746,  2788,
      2830,  2872,  2913,  2954,  2995,  3036,  3076,  3127,
      3177,  3226,  3275,  3324,  3373,  3421,  3469,  3517,
      3565,  3621,  3677,  3733,  3788,  3843,  3897,  3951,
      4005,  4058,  4119,  4181,  4241,  4301,  4361,  4420,
      4479,  4546,  4612,  4677,  4742,  4807,  4871,  4942,
      5013,  5083,  5153,  5222,  5291,  5367,  5442,  5517,
      5591,  5665,  5745,  5825,  5905,  5984,  6063,  6149,
      6234,  6319,  6404,  6495,  6587,  6678,  6769,  6867,
      6966,  7064,  7163,  7269,  7376,  7483,  7599,  7715,
      7832,  7958,  8085,  8214,  8352,  8492,  8635,  8788,
      8945,  9104,  9275,  9450,  9639,  9832, 10031, 10245,
      10465, 10702, 10946, 11210, 11482, 11776, 12081, 12409,
      12750, 13118, 13501, 13913, 14343, 14807, 15290, 15812,
      16356, 16943, 17575, 18237, 18949, 19718, 20521, 21387,
   }
};

static const int16_t vp9_ac_qlookup[3][256] = {
   {
      4,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,
      104,   106,   108,   110,   112,   114,   116,   118,
      120,   122,   124,   126,   128,   130,   132,   134,
      136,   138,   140,   142,   144,   146,   148,   150,
      152,   155,   158,   161,   164,   167,   170,   173,
      176,   179,   182,   185,   188,   191,   194,   197,
      200,   203,   207,   211,   215,   219,   223,   227,
      231,   235,   239,   243,   247,   251,   255,   260,
      265,   270,   275,   280,   285,   290,   295,   300,
      305,   311,   317,   323,   329,   335,   341,   347,
      353,   359,   366,   373,   380,   387,   394,   401,
      408,   416,   424,   432,   440,   448,   456,   465,
      474,   483,   492,   501,   510,   520,   530,   540,
      550,   560,   571,   582,   593,   604,   615,   627,
      639,   651,   663,   676,   689,   702,   715,   729,
      743,   757,   771,   786,   801,   816,   832,   848,
      864,   881,   898,   915,   933,   951,   969,   988,
      1007,  1026,  1046,  1066,  1087,  1108,  1129,  1151,
      1173,  1196,  1219,  1243,  1267,  1292,  1317,  1343,
      1369,  1396,  1423,  1451,  1479,  1508,  1537,  1567,
      1597,  1628,  1660,  1692,  1725,  1759,  1793,  1828,
   },
   {
      4,     9,    11,    13,    16,    18,    21,    24,
      27,    30,    33,    37,    40,    44,    48,    51,
      55,    59,    63,    67,    71,    75,    79,    83,
      88,    92,    96,   100,   105,   109,   114,   118,
      122,   127,   131,   136,   140,   145,   149,   154,
      158,   163,   168,   172,   177,   181,   186,   190,
      195,   199,   204,   208,   213,   217,   222,   226,
      231,   235,   240,   244,   249,   253,   258,   262,
      267,   271,   275,   280,   284,   289,   293,   297,
      302,   306,   311,   315,   319,   324,   328,   332,
      337,   341,   345,   349,   354,   358,   362,   367,
      371,   375,   379,   384,   388,   392,   396,   401,
      409,   417,   425,   433,   441,   449,   458,   466,
      474,   482,   490,   498,   506,   514,   523,   531,
      539,   547,   555,   563,   571,   579,   588,   596,
      604,   616,   628,   640,   652,   664,   676,   688,
      700,   713,   725,   737,   749,   761,   773,   785,
      797,   809,   825,   841,   857,   873,   889,   905,
      922,   938,   954,   970,   986,  1002,  1018,  1038,
      1058,  1078,  1098,  1118,  1138,  1158,  1178,  1198,
      1218,  1242,  1266,  1290,  1314,  1338,  1362,  1386,
      1411,  1435,  1463,  1491,  1519,  1547,  1575,  1603,
      1631,  1663,  1695,  1727,  1759,  1791,  1823,  1859,
      1895,  1931,  1967,  2003,  2039,  2079,  2119,  2159,
      2199,  2239,  2283,  2327,  2371,  2415,  2459,  2507,
      2555,  2603,  2651,  2703,  2755,  2807,  2859,  2915,
      2971,  3027,  3083,  3143,  3203,  3263,  3327,  3391,
      3455,  3523,  3591,  3659,  3731,  3803,  3876,  3952,
      4028,  4104,  4184,  4264,  4348,  4432,  4516,  4604,
      4692,  4784,  4876,  4972,  5068,  5168,  5268,  5372,
      5476,  5584,  5692,  5804,  5916,  6032,  6148,  6268,
      6388,  6512,  6640,  6768,  6900,  7036,  7172,  7312,
   },
   {
      4,    13,    19,    27,    35,    44,    54,    64,
      75,    87,    99,   112,   126,   139,   154,   168,
      183,   199,   214,   230,   247,   263,   280,   297,
      314,   331,   349,   366,   384,   402,   420,   438,
      456,   475,   493,   511,   530,   548,   567,   586,
      604,   623,   642,   660,   679,   698,   716,   735,
      753,   772,   791,   809,   828,   846,   865,   884,
      902,   920,   939,   957,   976,   994,  1012,  1030,
      1049,  1067,  1085,  1103,  1121,  1139,  1157,  1175,
      1193,  1211,  1229,  1246,  1264,  1282,  1299,  1317,
      1335,  1352,  1370,  1387,  1405,  1422,  1440,  1457,
      1474,  1491,  1509,  1526,  1543,  1560,  1577,  1595,
      1627,  1660,  1693,  1725,  1758,  1791,  1824,  1856,
      1889,  1922,  1954,  1987,  2020,  2052,  2085,  2118,
      2150,  2183,  2216,  2248,  2281,  2313,  2346,  2378,
      2411,  2459,  2508,  2556,  2605,  2653,  2701,  2750,
      2798,  2847,  2895,  2943,  2992,  3040,  3088,  3137,
      3185,  3234,  3298,  3362,  3426,  3491,  3555,  3619,
      3684,  3748,  3812,  3876,  3941,  4005,  4069,  4149,
      4230,  4310,  4390,  4470,  4550,  4631,  4711,  4791,
      4871,  4967,  5064,  5160,  5256,  5352,  5448,  5544,
      5641,  5737,  5849,  5961,  6073,  6185,  6297,  6410,
      6522,  6650,  6778,  6906,  7034,  7162,  7290,  7435,
      7579,  7723,  7867,  8011,  8155,  8315,  8475,  8635,
      8795,  8956,  9132,  9308,  9484,  9660,  9836, 10028,
      10220, 10412, 10604, 10812, 11020, 11228, 11437, 11661,
      11885, 12109, 12333, 12573, 12813, 13053, 13309, 13565,
      13821, 14093, 14365, 14637, 14925, 15213, 15502, 15806,
      16110, 16414, 16734, 17054, 17390, 17726, 18062, 18414,
      18766, 19134, 19502, 19886, 20270, 20670, 21070, 21486,
      21902, 22334, 22766, 23214, 23662, 24126, 24590, 25070,
      25551, 26047, 26559, 27071, 27599, 28143, 28687, 29247,
   }
};

/* Taken from intel-vaapi-driver */
#define TX_SIZE_CONTEXTS 2
#define TX_SIZES 4
#define SKIP_CONTEXTS 3
#define INTER_MODE_CONTEXTS 7
#define INTER_MODES 4
#define SWITCHABLE_FILTERS 3
#define SWITCHABLE_FILTER_CONTEXTS (SWITCHABLE_FILTERS + 1)
#define MAX_SEGMENTS 8
#define PREDICTION_PROBS 3
#define SEG_TREE_PROBS (MAX_SEGMENTS-1)
#define MV_JOINTS 4
#define INTRA_INTER_CONTEXTS 4
#define COMP_INTER_CONTEXTS 5
#define REF_CONTEXTS 5
#define BLOCK_SIZE_GROUPS 4
#define INTRA_MODES 10
/* number of probability models per block size */
#define PARTITION_PLOFFSET 4
#define PARTITION_CONTEXTS (4 * PARTITION_PLOFFSET)
#define PARTITION_TYPES 4
#define MV_CLASSES 11
/* bits at integer precision for class 0 */
#define CLASS0_BITS    1
#define CLASS0_SIZE    (1 << CLASS0_BITS)
#define MV_OFFSET_BITS (MV_CLASSES + CLASS0_BITS - 2)
#define MV_MAX_BITS    (MV_CLASSES + CLASS0_BITS + 2)
#define MV_FP_SIZE 4

#define COEFF_PROB_SIZE 132
#define COEFF_PROB_NUM 3

#define INTER_MODE_PROBS_OFFSET 1667
#define INTER_MODE_PROBS_SIZE 343
#define SEG_PROBS_OFFSET 2010

struct tx_probs {
    uint8_t p8x8[TX_SIZE_CONTEXTS][TX_SIZES - 3];
    uint8_t p16x16[TX_SIZE_CONTEXTS][TX_SIZES - 2];
    uint8_t p32x32[TX_SIZE_CONTEXTS][TX_SIZES - 1];
};

struct tx_counts {
    unsigned int p32x32[TX_SIZE_CONTEXTS][TX_SIZES];
    unsigned int p16x16[TX_SIZE_CONTEXTS][TX_SIZES - 1];
    unsigned int p8x8[TX_SIZE_CONTEXTS][TX_SIZES - 2];
    unsigned int tx_totals[TX_SIZES];
};

typedef struct {
    uint8_t sign;
    uint8_t classes[MV_CLASSES - 1];
    uint8_t class0[CLASS0_SIZE - 1];
    uint8_t bits[MV_OFFSET_BITS];
} nmv_component;

typedef struct {
    uint8_t joints[MV_JOINTS - 1];
    nmv_component comps[2];
    uint8_t class0_fp0[CLASS0_SIZE][MV_FP_SIZE - 1];
    uint8_t fp0[MV_FP_SIZE - 1];
    uint8_t class0_fp1[CLASS0_SIZE][MV_FP_SIZE - 1];
    uint8_t fp1[MV_FP_SIZE - 1];
    uint8_t class0_hp[2];
    uint8_t hp[2];
} nmv_context;

typedef struct frame_contexts {
    struct tx_probs tx_probs;
    uint8_t dummy1[52];
    uint8_t coef_probs_4x4[COEFF_PROB_SIZE][COEFF_PROB_NUM];
    uint8_t coef_probs_8x8[COEFF_PROB_SIZE][COEFF_PROB_NUM];
    uint8_t coef_probs_16x16[COEFF_PROB_SIZE][COEFF_PROB_NUM];
    uint8_t coef_probs_32x32[COEFF_PROB_SIZE][COEFF_PROB_NUM];
    uint8_t dummy2[16];
    uint8_t skip_probs[SKIP_CONTEXTS];
    uint8_t inter_mode_probs[INTER_MODE_CONTEXTS][INTER_MODES - 1];
    uint8_t switchable_interp_prob[SWITCHABLE_FILTER_CONTEXTS]
                                  [SWITCHABLE_FILTERS - 1];
    uint8_t intra_inter_prob[INTRA_INTER_CONTEXTS];
    uint8_t comp_inter_prob[COMP_INTER_CONTEXTS];
    uint8_t single_ref_prob[REF_CONTEXTS][2];
    uint8_t comp_ref_prob[REF_CONTEXTS];
    uint8_t y_mode_prob[BLOCK_SIZE_GROUPS][INTRA_MODES - 1];
    uint8_t partition_probs[PARTITION_CONTEXTS][PARTITION_TYPES - 1];
    nmv_context nmvc;
    uint8_t dummy3[47];
    uint8_t uv_mode_probs[INTRA_MODES][INTRA_MODES - 1];
    uint8_t seg_tree_probs[SEG_TREE_PROBS];
    uint8_t seg_pred_probs[PREDICTION_PROBS];
    uint8_t dummy4[28];
} vp9_frame_context;


static struct tx_probs default_tx_probs = {
   {   { 100 },
       { 66  }
   },

   {   { 20, 152 },
       { 15, 101 }
   },

   {   { 3, 136, 37 },
       { 5, 52,  13 }
   },
};

static uint8_t default_skip_probs[SKIP_CONTEXTS] = {
   192, 128, 64
};

static uint8_t default_inter_mode_probs[INTER_MODE_CONTEXTS]
                                       [INTER_MODES - 1] = {
   { 2,       173,   34 },  // 0 = both zero mv
   { 7,       145,   85 },  // 1 = one zero mv + one a predicted mv
   { 7,       166,   63 },  // 2 = two predicted mvs
   { 7,       94,    66 },  // 3 = one predicted/zero and one new mv
   { 8,       64,    46 },  // 4 = two new mvs
   { 17,      81,    31 },  // 5 = one intra neighbour + x
   { 25,      29,    30 },  // 6 = two intra neighbours
};

static uint8_t default_switchable_interp_prob[SWITCHABLE_FILTER_CONTEXTS]
                                             [SWITCHABLE_FILTERS - 1] = {
   { 235, 162, },
   { 36, 255, },
   { 34, 3, },
   { 149, 144, },
};

static uint8_t default_intra_inter_prob[INTRA_INTER_CONTEXTS] = {
   9, 102, 187, 225
};

static uint8_t default_comp_inter_prob[COMP_INTER_CONTEXTS] = {
   239, 183, 119,  96,  41
};

static uint8_t default_single_ref_prob[REF_CONTEXTS][2] = {
   {  33,  16 },
   {  77,  74 },
   { 142, 142 },
   { 172, 170 },
   { 238, 247 }
};

static uint8_t default_comp_ref_prob[REF_CONTEXTS] = {
   50, 126, 123, 221, 226
};

static uint8_t vp9_kf_uv_mode_probs[INTRA_MODES][INTRA_MODES - 1] = {
   { 144,  11,  54, 157, 195, 130,  46,  58, 108 },  // y = dc
   { 118,  15, 123, 148, 131, 101,  44,  93, 131 },  // y = v
   { 113,  12,  23, 188, 226, 142,  26,  32, 125 },  // y = h
   { 120,  11,  50, 123, 163, 135,  64,  77, 103 },  // y = d45
   { 113,   9,  36, 155, 111, 157,  32,  44, 161 },  // y = d135
   { 116,   9,  55, 176,  76,  96,  37,  61, 149 },  // y = d117
   { 115,   9,  28, 141, 161, 167,  21,  25, 193 },  // y = d153
   { 120,  12,  32, 145, 195, 142,  32,  38,  86 },  // y = d207
   { 116,  12,  64, 120, 140, 125,  49, 115, 121 },  // y = d63
   { 102,  19,  66, 162, 182, 122,  35,  59, 128 }   // y = tm
};

static uint8_t default_y_mode_prob[BLOCK_SIZE_GROUPS][INTRA_MODES - 1] = {
   {  65,  32,  18, 144, 162, 194,  41,  51,  98 },  // block_size < 8x8
   { 132,  68,  18, 165, 217, 196,  45,  40,  78 },  // block_size < 16x16
   { 173,  80,  19, 176, 240, 193,  64,  35,  46 },  // block_size < 32x32
   { 221, 135,  38, 194, 248, 121,  96,  85,  29 }   // block_size >= 32x32
};

static uint8_t default_uv_mode_probs[INTRA_MODES][INTRA_MODES - 1] = {
   { 120,   7,  76, 176, 208, 126,  28,  54, 103 },  // y = dc
   {  48,  12, 154, 155, 139,  90,  34, 117, 119 },  // y = v
   {  67,   6,  25, 204, 243, 158,  13,  21,  96 },  // y = h
   {  97,   5,  44, 131, 176, 139,  48,  68,  97 },  // y = d45
   {  83,   5,  42, 156, 111, 152,  26,  49, 152 },  // y = d135
   {  80,   5,  58, 178,  74,  83,  33,  62, 145 },  // y = d117
   {  86,   5,  32, 154, 192, 168,  14,  22, 163 },  // y = d153
   {  85,   5,  32, 156, 216, 148,  19,  29,  73 },  // y = d207
   {  77,   7,  64, 116, 132, 122,  37, 126, 120 },  // y = d63
   { 101,  21, 107, 181, 192, 103,  19,  67, 125 }   // y = tm
};

static uint8_t default_seg_tree_probs[SEG_TREE_PROBS] = {
   255, 255, 255, 255, 255, 255, 255
};

static uint8_t default_seg_pred_probs[PREDICTION_PROBS] = {
   255, 255, 255
};

static uint8_t vp9_kf_partition_probs[PARTITION_CONTEXTS]
                                     [PARTITION_TYPES - 1] = {
   // 8x8 -> 4x4
   { 158,  97,  94 },  // a/l both not split
   {  93,  24,  99 },  // a split, l not split
   {  85, 119,  44 },  // l split, a not split
   {  62,  59,  67 },  // a/l both split
   // 16x16 -> 8x8
   { 149,  53,  53 },  // a/l both not split
   {  94,  20,  48 },  // a split, l not split
   {  83,  53,  24 },  // l split, a not split
   {  52,  18,  18 },  // a/l both split
   // 32x32 -> 16x16
   { 150,  40,  39 },  // a/l both not split
   {  78,  12,  26 },  // a split, l not split
   {  67,  33,  11 },  // l split, a not split
   {  24,   7,   5 },  // a/l both split
   // 64x64 -> 32x32
   { 174,  35,  49 },  // a/l both not split
   {  68,  11,  27 },  // a split, l not split
   {  57,  15,   9 },  // l split, a not split
   {  12,   3,   3 },  // a/l both split
};

static uint8_t default_partition_probs[PARTITION_CONTEXTS]
                                      [PARTITION_TYPES - 1] = {
   // 8x8 -> 4x4
   { 199, 122, 141 },  // a/l both not split
   { 147,  63, 159 },  // a split, l not split
   { 148, 133, 118 },  // l split, a not split
   { 121, 104, 114 },  // a/l both split
   // 16x16 -> 8x8
   { 174,  73,  87 },  // a/l both not split
   {  92,  41,  83 },  // a split, l not split
   {  82,  99,  50 },  // l split, a not split
   {  53,  39,  39 },  // a/l both split
   // 32x32 -> 16x16
   { 177,  58,  59 },  // a/l both not split
   {  68,  26,  63 },  // a split, l not split
   {  52,  79,  25 },  // l split, a not split
   {  17,  14,  12 },  // a/l both split
   // 64x64 -> 32x32
   { 222,  34,  30 },  // a/l both not split
   {  72,  16,  44 },  // a split, l not split
   {  58,  32,  12 },  // l split, a not split
   {  10,   7,   6 },  // a/l both split
};

static nmv_context default_nmv_context = {
   { 32, 64, 96 },
   {
      {
         // Vertical component
         128,                                                  // sign
         { 224, 144, 192, 168, 192, 176, 192, 198, 198, 245 },   // class
         { 216 },                                                // class0
         { 136, 140, 148, 160, 176, 192, 224, 234, 234, 240 },   // bits
      },
      {
         // Horizontal component
         128,                                                  // sign
         { 216, 128, 176, 160, 176, 176, 192, 198, 198, 208 },   // class
         { 208 },                                                // class0
         { 136, 140, 148, 160, 176, 192, 224, 234, 234, 240 },   // bits
      }
   },
   { { 128, 128, 64 }, { 96, 112, 64 } },                      // class0_fp0
   { 64, 96, 64 },                                         // fp0
   { {128, 128, 64 }, { 96, 112, 64 } },                      // class0_fp1
   { 64, 96, 64 },                                         // fp1
   { 160, 128 },                                           // class0_hp bit
   { 160, 128 }                                            // hp
};

static uint8_t default_coef_probs_4x4[COEFF_PROB_SIZE][COEFF_PROB_NUM] = {
   // Y plane - Intra
   // Band 0
   { 195,  29, 183 }, {  84,  49, 136 }, {   8,  42,  71 },
   // Band 1
   {  31, 107, 169 }, {  35,  99, 159 }, {  17,  82, 140 },
   {   8,  66, 114 }, {   2,  44,  76 }, {   1,  19,  32 },
   // Band 2
   {  40, 132, 201 }, {  29, 114, 187 }, {  13,  91, 157 },
   {   7,  75, 127 }, {   3,  58,  95 }, {   1,  28,  47 },
   // Band 3
   {  69, 142, 221 }, {  42, 122, 201 }, {  15,  91, 159 },
   {   6,  67, 121 }, {   1,  42,  77 }, {   1,  17,  31 },
   // Band 4
   { 102, 148, 228 }, {  67, 117, 204 }, {  17,  82, 154 },
   {   6,  59, 114 }, {   2,  39,  75 }, {   1,  15,  29 },
   // Band 5
   { 156,  57, 233 }, { 119,  57, 212 }, {  58,  48, 163 },
   {  29,  40, 124 }, {  12,  30,  81 }, {   3,  12,  31 },

   // Y plane - Inter
   // Band 0
   { 191, 107, 226 }, { 124, 117, 204 }, {  25,  99, 155 },
   // Band 1
   {  29, 148, 210 }, {  37, 126, 194 }, {   8,  93, 157 },
   {   2,  68, 118 }, {   1,  39,  69 }, {   1,  17,  33 },
   // Band 2
   {  41, 151, 213 }, {  27, 123, 193 }, {   3,  82, 144 },
   {   1,  58, 105 }, {   1,  32,  60 }, {   1,  13,  26 },
   // Band 3
   {  59, 159, 220 }, {  23, 126, 198 }, {   4,  88, 151 },
   {   1,  66, 114 }, {   1,  38,  71 }, {   1,  18,  34 },
   // Band 4
   { 114, 136, 232 }, {  51, 114, 207 }, {  11,  83, 155 },
   {   3,  56, 105 }, {   1,  33,  65 }, {   1,  17,  34 },
   // Band 5
   { 149,  65, 234 }, { 121,  57, 215 }, {  61,  49, 166 },
   {  28,  36, 114 }, {  12,  25,  76 }, {   3,  16,  42 },

   // UV plane - Intra
   // Band 0
   { 214,  49, 220 }, { 132,  63, 188 }, {  42,  65, 137 },
   // Band 1
   {  85, 137, 221 }, { 104, 131, 216 }, {  49, 111, 192 },
   {  21,  87, 155 }, {   2,  49,  87 }, {   1,  16,  28 },
   // Band 2
   {  89, 163, 230 }, {  90, 137, 220 }, {  29, 100, 183 },
   {  10,  70, 135 }, {   2,  42,  81 }, {   1,  17,  33 },
   // Band 3
   { 108, 167, 237 }, {  55, 133, 222 }, {  15,  97, 179 },
   {   4,  72, 135 }, {   1,  45,  85 }, {   1,  19,  38 },
   // Band 4
   { 124, 146, 240 }, {  66, 124, 224 }, {  17,  88, 175 },
   {   4,  58, 122 }, {   1,  36,  75 }, {   1,  18,  37 },
   //  Band 5
   { 141,  79, 241 }, { 126,  70, 227 }, {  66,  58, 182 },
   {  30,  44, 136 }, {  12,  34,  96 }, {   2,  20,  47 },

   // UV plane - Inter
   // Band 0
   { 229,  99, 249 }, { 143, 111, 235 }, {  46, 109, 192 },
   // Band 1
   {  82, 158, 236 }, {  94, 146, 224 }, {  25, 117, 191 },
   {   9,  87, 149 }, {   3,  56,  99 }, {   1,  33,  57 },
   // Band 2
   {  83, 167, 237 }, {  68, 145, 222 }, {  10, 103, 177 },
   {   2,  72, 131 }, {   1,  41,  79 }, {   1,  20,  39 },
   // Band 3
   {  99, 167, 239 }, {  47, 141, 224 }, {  10, 104, 178 },
   {   2,  73, 133 }, {   1,  44,  85 }, {   1,  22,  47 },
   // Band 4
   { 127, 145, 243 }, {  71, 129, 228 }, {  17,  93, 177 },
   {   3,  61, 124 }, {   1,  41,  84 }, {   1,  21,  52 },
   // Band 5
   { 157,  78, 244 }, { 140,  72, 231 }, {  69,  58, 184 },
   {  31,  44, 137 }, {  14,  38, 105 }, {   8,  23,  61 }
};

static uint8_t default_coef_probs_8x8[COEFF_PROB_SIZE][COEFF_PROB_NUM] = {
   // Y plane - Intra
   // Band 0
   { 125,  34, 187 }, {  52,  41, 133 }, {   6,  31,  56 },
   // Band 1
   {  37, 109, 153 }, {  51, 102, 147 }, {  23,  87, 128 },
   {   8,  67, 101 }, {   1,  41,  63 }, {   1,  19,  29 },
   // Band 2
   {  31, 154, 185 }, {  17, 127, 175 }, {   6,  96, 145 },
   {   2,  73, 114 }, {   1,  51,  82 }, {   1,  28,  45 },
   // Band 3
   {  23, 163, 200 }, {  10, 131, 185 }, {   2,  93, 148 },
   {   1,  67, 111 }, {   1,  41,  69 }, {   1,  14,  24 },
   // Band 4
   {  29, 176, 217 }, {  12, 145, 201 }, {   3, 101, 156 },
   {   1,  69, 111 }, {   1,  39,  63 }, {   1,  14,  23 },
   // Band 5
   {  57, 192, 233 }, {  25, 154, 215 }, {   6, 109, 167 },
   {   3,  78, 118 }, {   1,  48,  69 }, {   1,  21,  29 },

   // Y plane - Inter
   // Band 0
   { 202, 105, 245 }, { 108, 106, 216 }, {  18,  90, 144 },
   // Band 1
   {  33, 172, 219 }, {  64, 149, 206 }, {  14, 117, 177 },
   {   5,  90, 141 }, {   2,  61,  95 }, {   1,  37,  57 },
   // Band 2
   {  33, 179, 220 }, {  11, 140, 198 }, {   1,  89, 148 },
   {   1,  60, 104 }, {   1,  33,  57 }, {   1,  12,  21 },
   // Band 3
   {  30, 181, 221 }, {   8, 141, 198 }, {   1,  87, 145 },
   {   1,  58, 100 }, {   1,  31,  55 }, {   1,  12,  20 },
   // Band 4
   {  32, 186, 224 }, {   7, 142, 198 }, {   1,  86, 143 },
   {   1,  58, 100 }, {   1,  31,  55 }, {   1,  12,  22 },
   // Band 5
   {  57, 192, 227 }, {  20, 143, 204 }, {   3,  96, 154 },
   {   1,  68, 112 }, {   1,  42,  69 }, {   1,  19,  32 },

   // UV plane - Intra
   // Band 0
   { 212,  35, 215 }, { 113,  47, 169 }, {  29,  48, 105 },
   // Band 1
   {  74, 129, 203 }, { 106, 120, 203 }, {  49, 107, 178 },
   {  19,  84, 144 }, {   4,  50,  84 }, {   1,  15,  25 },
   // Band 2
   {  71, 172, 217 }, {  44, 141, 209 }, {  15, 102, 173 },
   {   6,  76, 133 }, {   2,  51,  89 }, {   1,  24,  42 },
   // Band 3
   {  64, 185, 231 }, {  31, 148, 216 }, {   8, 103, 175 },
   {   3,  74, 131 }, {   1,  46,  81 }, {   1,  18,  30 },
   // Band 4
   {  65, 196, 235 }, {  25, 157, 221 }, {   5, 105, 174 },
   {   1,  67, 120 }, {   1,  38,  69 }, {   1,  15,  30 },
   // Band 5
   {  65, 204, 238 }, {  30, 156, 224 }, {   7, 107, 177 },
   {   2,  70, 124 }, {   1,  42,  73 }, {   1,  18,  34 },

   // UV Plane - Inter
   // Band 0
   { 225,  86, 251 }, { 144, 104, 235 }, {  42,  99, 181 },
   // Band 1
   {  85, 175, 239 }, { 112, 165, 229 }, {  29, 136, 200 },
   {  12, 103, 162 }, {   6,  77, 123 }, {   2,  53,  84 },
   // Band 2
   {  75, 183, 239 }, {  30, 155, 221 }, {   3, 106, 171 },
   {   1,  74, 128 }, {   1,  44,  76 }, {   1,  17,  28 },
   // Band 3
   {  73, 185, 240 }, {  27, 159, 222 }, {   2, 107, 172 },
   {   1,  75, 127 }, {   1,  42,  73 }, {   1,  17,  29 },
   // Band 4
   {  62, 190, 238 }, {  21, 159, 222 }, {   2, 107, 172 },
   {   1,  72, 122 }, {   1,  40,  71 }, {   1,  18,  32 },
   // Band 5
   {  61, 199, 240 }, {  27, 161, 226 }, {   4, 113, 180 },
   {   1,  76, 129 }, {   1,  46,  80 }, {   1,  23,  41 }
};

static uint8_t default_coef_probs_16x16[COEFF_PROB_SIZE][COEFF_PROB_NUM] = {
   // Y plane - Intra
   // Band 0
   {   7,  27, 153 }, {   5,  30,  95 }, {   1,  16,  30 },
   // Band 1
   {  50,  75, 127 }, {  57,  75, 124 }, {  27,  67, 108 },
   {  10,  54,  86 }, {   1,  33,  52 }, {   1,  12,  18 },
   // Band 2
   {  43, 125, 151 }, {  26, 108, 148 }, {   7,  83, 122 },
   {   2,  59,  89 }, {   1,  38,  60 }, {   1,  17,  27 },
   // Band 3
   {  23, 144, 163 }, {  13, 112, 154 }, {   2,  75, 117 },
   {   1,  50,  81 }, {   1,  31,  51 }, {   1,  14,  23 },
   // Band 4
   {  18, 162, 185 }, {   6, 123, 171 }, {   1,  78, 125 },
   {   1,  51,  86 }, {   1,  31,  54 }, {   1,  14,  23 },
   // Band 5
   {  15, 199, 227 }, {   3, 150, 204 }, {   1,  91, 146 },
   {   1,  55,  95 }, {   1,  30,  53 }, {   1,  11,  20 },

   // Y plane - Inter
   // Band 0
   {  19,  55, 240 }, {  19,  59, 196 }, {   3,  52, 105 },
   // Band 1
   {  41, 166, 207 }, { 104, 153, 199 }, {  31, 123, 181 },
   {  14, 101, 152 }, {   5,  72, 106 }, {   1,  36,  52 },
   // Band 2
   {  35, 176, 211 }, {  12, 131, 190 }, {   2,  88, 144 },
   {   1,  60, 101 }, {   1,  36,  60 }, {   1,  16,  28 },
   // Band 3
   {  28, 183, 213 }, {   8, 134, 191 }, {   1,  86, 142 },
   {   1,  56,  96 }, {   1,  30,  53 }, {   1,  12,  20 },
   // Band 4
   {  20, 190, 215 }, {   4, 135, 192 }, {   1,  84, 139 },
   {   1,  53,  91 }, {   1,  28,  49 }, {   1,  11,  20 },
   // Band 5
   {  13, 196, 216 }, {   2, 137, 192 }, {   1,  86, 143 },
   {   1,  57,  99 }, {   1,  32,  56 }, {   1,  13,  24 },

   // UV plane - Intra
   // Band 0
   { 211,  29, 217 }, {  96,  47, 156 }, {  22,  43,  87 },
   // Band 1
   {  78, 120, 193 }, { 111, 116, 186 }, {  46, 102, 164 },
   {  15,  80, 128 }, {   2,  49,  76 }, {   1,  18,  28 },
   // Band 2
   {  71, 161, 203 }, {  42, 132, 192 }, {  10,  98, 150 },
   {   3,  69, 109 }, {   1,  44,  70 }, {   1,  18,  29 },
   // Band 3
   {  57, 186, 211 }, {  30, 140, 196 }, {   4,  93, 146 },
   {   1,  62, 102 }, {   1,  38,  65 }, {   1,  16,  27 },
   // Band 4
   {  47, 199, 217 }, {  14, 145, 196 }, {   1,  88, 142 },
   {   1,  57,  98 }, {   1,  36,  62 }, {   1,  15,  26 },
   // Band 5
   {  26, 219, 229 }, {   5, 155, 207 }, {   1,  94, 151 },
   {   1,  60, 104 }, {   1,  36,  62 }, {   1,  16,  28 },

   // UV plane - Inter
   // Band 0
   { 233,  29, 248 }, { 146,  47, 220 }, {  43,  52, 140 },
   // Band 1
   { 100, 163, 232 }, { 179, 161, 222 }, {  63, 142, 204 },
   {  37, 113, 174 }, {  26,  89, 137 }, {  18,  68,  97 },
   // Band 2
   {  85, 181, 230 }, {  32, 146, 209 }, {   7, 100, 164 },
   {   3,  71, 121 }, {   1,  45,  77 }, {   1,  18,  30 },
   // Band 3
   {  65, 187, 230 }, {  20, 148, 207 }, {   2,  97, 159 },
   {   1,  68, 116 }, {   1,  40,  70 }, {   1,  14,  29 },
   // Band 4
   {  40, 194, 227 }, {   8, 147, 204 }, {   1,  94, 155 },
   {   1,  65, 112 }, {   1,  39,  66 }, {   1,  14,  26 },
   // Band 5
   {  16, 208, 228 }, {   3, 151, 207 }, {   1,  98, 160 },
   {   1,  67, 117 }, {   1,  41,  74 }, {   1,  17,  31 }
};

static uint8_t default_coef_probs_32x32[COEFF_PROB_SIZE][COEFF_PROB_NUM] = {
   // Y plane - Intra
   // Band 0
   {  17,  38, 140 }, {   7,  34,  80 }, {   1,  17,  29 },
   // Band 1
   {  37,  75, 128 }, {  41,  76, 128 }, {  26,  66, 116 },
   {  12,  52,  94 }, {   2,  32,  55 }, {   1,  10,  16 },
   // Band 2
   {  50, 127, 154 }, {  37, 109, 152 }, {  16,  82, 121 },
   {   5,  59,  85 }, {   1,  35,  54 }, {   1,  13,  20 },
   //Band 3
   {  40, 142, 167 }, {  17, 110, 157 }, {   2,  71, 112 },
   {   1,  44,  72 }, {   1,  27,  45 }, {   1,  11,  17 },
   // Band 4
   {  30, 175, 188 }, {   9, 124, 169 }, {   1,  74, 116 },
   {   1,  48,  78 }, {   1,  30,  49 }, {   1,  11,  18 },
   // Band 5
   {  10, 222, 223 }, {   2, 150, 194 }, {   1,  83, 128 },
   {   1,  48,  79 }, {   1,  27,  45 }, {   1,  11,  17 },

   // Y plane - Inter
   // Band 0
   {  36,  41, 235 }, {  29,  36, 193 }, {  10,  27, 111 },
   // Band 1
   {  85, 165, 222 }, { 177, 162, 215 }, { 110, 135, 195 },
   {  57, 113, 168 }, {  23,  83, 120 }, {  10,  49,  61 },
   // Band 2
   {  85, 190, 223 }, {  36, 139, 200 }, {   5,  90, 146 },
   {   1,  60, 103 }, {   1,  38,  65 }, {   1,  18,  30 },
   // Band 3
   {  72, 202, 223 }, {  23, 141, 199 }, {   2,  86, 140 },
   {   1,  56,  97 }, {   1,  36,  61 }, {   1,  16,  27 },
   // Band 4
   {  55, 218, 225 }, {  13, 145, 200 }, {   1,  86, 141 },
   {   1,  57,  99 }, {   1,  35,  61 }, {   1,  13,  22 },
   // Band 5
   {  15, 235, 212 }, {   1, 132, 184 }, {   1,  84, 139 },
   {   1,  57,  97 }, {   1,  34,  56 }, {   1,  14,  23 },

   // UV plane - Intra
   // Band 0
   { 181,  21, 201 }, {  61,  37, 123 }, {  10,  38,  71 },
   // Band 1
   {  47, 106, 172 }, {  95, 104, 173 }, {  42,  93, 159 },
   {  18,  77, 131 }, {   4,  50,  81 }, {   1,  17,  23 },
   // Band 2
   {  62, 147, 199 }, {  44, 130, 189 }, {  28, 102, 154 },
   {  18,  75, 115 }, {   2,  44,  65 }, {   1,  12,  19 },
   // Band 3
   {  55, 153, 210 }, {  24, 130, 194 }, {   3,  93, 146 },
   {   1,  61,  97 }, {   1,  31,  50 }, {   1,  10,  16 },
   // Band 4
   {  49, 186, 223 }, {  17, 148, 204 }, {   1,  96, 142 },
   {   1,  53,  83 }, {   1,  26,  44 }, {   1,  11,  17 },
   // Band 5
   {  13, 217, 212 }, {   2, 136, 180 }, {   1,  78, 124 },
   {   1,  50,  83 }, {   1,  29,  49 }, {   1,  14,  23 },

   // UV plane - Inter
   // Band 0
   { 197,  13, 247 }, {  82,  17, 222 }, {  25,  17, 162 },
   // Band 1
   { 126, 186, 247 }, { 234, 191, 243 }, { 176, 177, 234 },
   { 104, 158, 220 }, {  66, 128, 186 }, {  55,  90, 137 },
   // Band 2
   { 111, 197, 242 }, {  46, 158, 219 }, {   9, 104, 171 },
   {   2,  65, 125 }, {   1,  44,  80 }, {   1,  17,  91 },
   // Band 3
   { 104, 208, 245 }, {  39, 168, 224 }, {   3, 109, 162 },
   {   1,  79, 124 }, {   1,  50, 102 }, {   1,  43, 102 },
   // Band 4
   {  84, 220, 246 }, {  31, 177, 231 }, {   2, 115, 180 },
   {   1,  79, 134 }, {   1,  55,  77 }, {   1,  60,  79 },
   // Band 5
   {  43, 243, 240 }, {   8, 180, 217 }, {   1, 115, 166 },
   {   1,  84, 121 }, {   1,  51,  67 }, {   1,  16,   6 }
};

#endif
