# ----------------------------------------------------------------------------
#  Update the library version header file
#    FILE_TO_PARSE="SRC/include/mrpt/MRPT_version.h.in"
#    TARGET_FILE  ="MRPT_version.h"
# ----------------------------------------------------------------------------
set(CMAKE_MRPT_COMPLETE_NAME "MRPT ${CMAKE_MRPT_VERSION_NUMBER_MAJOR}.${CMAKE_MRPT_VERSION_NUMBER_MINOR}.${CMAKE_MRPT_VERSION_NUMBER_PATCH}")

# Build a six digits hex version code, eg. 1.2.0 -> 0x010200
VERSION_TO_HEXADECIMAL(CMAKE_MRPT_VERSION_CODE ${CMAKE_MRPT_COMPLETE_NAME})

# SOURCE_DATE_EPOCH: See Specs in https://reproducible-builds.org/specs/source-date-epoch/
# Take its value from:
# 1) The file SRC/SOURCE_DATE_EPOCH  (generated by scripts creating Windows/Debian packages)
# 2) The env var "SOURCE_DATE_EPOCH"
# 3) The output from "git log -1 --pretty=%ct"
# 4) As a last resort, leave it blank, so the C++ source code will use current time.

set(CMAKE_SOURCE_DATE_EPOCH "")
# 1: SRC/SOURCE_DATE_EPOCH
if(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/SOURCE_DATE_EPOCH")
  file(STRINGS "${CMAKE_CURRENT_SOURCE_DIR}/SOURCE_DATE_EPOCH" CMAKE_SOURCE_DATE_EPOCH LIMIT_COUNT 1) # Read only the first line
endif()
if ("" STREQUAL "${CMAKE_SOURCE_DATE_EPOCH}")
  # If empty:
  # 2) The env var "SOURCE_DATE_EPOCH"
  if (DEFINED ENV{SOURCE_DATE_EPOCH})
    set(CMAKE_SOURCE_DATE_EPOCH "$ENV{SOURCE_DATE_EPOCH}")
  else()
    # 3) The output from "git log -1 --pretty=%ct"
    find_package(Git QUIET)
    if(GIT_FOUND)
      execute_process(
        COMMAND "${GIT_EXECUTABLE}" "log" "-1" "--pretty=%ct"
		WORKING_DIRECTORY  "${CMAKE_CURRENT_SOURCE_DIR}"
        OUTPUT_VARIABLE CMAKE_SOURCE_DATE_EPOCH
        OUTPUT_STRIP_TRAILING_WHITESPACE)
        if ($ENV{VERBOSE})
         message(STATUS "SOURCE_DATE_EPOCH from git log: ${CMAKE_SOURCE_DATE_EPOCH}")
        endif()
    else() # fallback if no git is found: use "%s" from CMake, if available
			  string(TIMESTAMP CMAKE_SOURCE_DATE_EPOCH "%s")
				if ("${CMAKE_SOURCE_DATE_EPOCH}" STREQUAL "%s")
					set(CMAKE_SOURCE_DATE_EPOCH "0") # worst case
				endif()
    endif()
  endif()
endif()


configure_file("${MRPT_SOURCE_DIR}/parse-files/version.h.in" "${MRPT_CONFIG_FILE_INCLUDE_DIR}/mrpt/version.h")


# Prepare version.rc for Windows apps:
if (WIN32)
	configure_file(
		${MRPT_SOURCE_DIR}/parse-files/version.rc.in
		${MRPT_BINARY_DIR}/version.rc
		@ONLY)
	set(MRPT_VERSION_RC_FILE "${MRPT_BINARY_DIR}/version.rc")
else()
	set(MRPT_VERSION_RC_FILE "")
endif()
