from typing import Any, ClassVar, Dict, Tuple

from . import Lie

from typing import overload
import mrpt.pymrpt.mrpt
import mrpt.pymrpt.mrpt.bayes
import mrpt.pymrpt.mrpt.containers
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization
import mrpt.pymrpt.std.chrono
LKUP_EXTRAPOLATION_ERROR: FrameLookUpStatus
LKUP_GOOD: FrameLookUpStatus
LKUP_NO_CONNECTIVITY: FrameLookUpStatus
LKUP_UNKNOWN_FRAME: FrameLookUpStatus
UNINITIALIZED_POSE: TConstructorFlags_Poses
imLinear2Neig: TInterpolatorMethod
imLinear4Neig: TInterpolatorMethod
imLinearSlerp: TInterpolatorMethod
imSSLLLL: TInterpolatorMethod
imSSLSLL: TInterpolatorMethod
imSpline: TInterpolatorMethod
imSplineSlerp: TInterpolatorMethod

class CPoint2D(CPoint_mrpt_poses_CPoint2D_2UL_t, mrpt.pymrpt.mrpt.serialization.CSerializable):
    m_coords: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_2UL_1UL_t
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float) -> None: ...
    @overload
    def __init__(self, o) -> None: ...
    @overload
    def __init__(self, o) -> None: ...
    @overload
    def __init__(self, arg0: CPoint2D) -> None: ...
    @overload
    def __init__(self, arg0: CPoint2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asTPoint(self, *args, **kwargs) -> Any: ...
    def asVector(self, v: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_2UL_1UL_t) -> None: ...
    def assign(self) -> CPoint2D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def empty(self, *args, **kwargs) -> Any: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...
    def max_size(self, *args, **kwargs) -> Any: ...
    def resize(self, *args, **kwargs) -> Any: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    def size(self, *args, **kwargs) -> Any: ...
    def __sub__(self, other) -> Any: ...

class CPoint2DPDF(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.math.CProbabilityDensityFunction_mrpt_poses_CPoint2D_2UL_t):
    def __init__(self) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPoint2DPDF: ...
    @overload
    def bayesianFusion(self, p1: CPoint2DPDF, p2: CPoint2DPDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPoint2DPDF, p2: CPoint2DPDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPoint2DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...

class CPoint2DPDFGaussian(CPoint2DPDF):
    cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_2UL_2UL_t
    mean: CPoint2D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, init_Mean: CPoint2D) -> None: ...
    @overload
    def __init__(self, init_Mean: CPoint2D, init_Cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_2UL_2UL_t) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPoint2DPDFGaussian: ...
    @overload
    def bayesianFusion(self, p1: CPoint2DPDFGaussian, p2: CPoint2DPDFGaussian) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPoint2DPDF, p2: CPoint2DPDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPoint2DPDF, p2: CPoint2DPDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPoint2DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outSample: CPoint2D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_2UL_2UL_t,CPoint2D]: ...
    @overload
    def getMean(self, p: CPoint2D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    @overload
    def mahalanobisDistanceTo(self, other: CPoint2DPDFGaussian) -> float: ...
    @overload
    def mahalanobisDistanceTo(constclassmrpt) -> double: ...
    def mahalanobisDistanceToPoint(self, x: float, y: float) -> float: ...
    @overload
    def productIntegralNormalizedWith(self, p: CPoint2DPDFGaussian) -> float: ...
    @overload
    def productIntegralNormalizedWith(constclassmrpt) -> double: ...
    @overload
    def productIntegralWith(self, p: CPoint2DPDFGaussian) -> float: ...
    @overload
    def productIntegralWith(constclassmrpt) -> double: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...

class CPoint3D(CPoint_mrpt_poses_CPoint3D_3UL_t, mrpt.pymrpt.mrpt.serialization.CSerializable):
    m_coords: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_1UL_t
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float) -> None: ...
    @overload
    def __init__(self, xyz: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_1UL_t) -> None: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, p: CPose3D) -> None: ...
    @overload
    def __init__(self, p: CPose2D) -> None: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, arg0: CPoint3D) -> None: ...
    @overload
    def __init__(self, arg0: CPoint3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asTPoint(self, *args, **kwargs) -> Any: ...
    def asVector(self, v: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_1UL_t) -> None: ...
    def assign(self) -> CPoint3D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def empty(self, *args, **kwargs) -> Any: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...
    def max_size(self, *args, **kwargs) -> Any: ...
    def resize(self, *args, **kwargs) -> Any: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    def size(self, *args, **kwargs) -> Any: ...
    @overload
    def __add__(self, b: CPoint3D) -> CPoint3D: ...
    @overload
    def __add__(self, b: CPose3D) -> CPose3D: ...
    @overload
    def __sub__(self, b: CPose3D) -> CPoint3D: ...
    @overload
    def __sub__(self, b: CPoint3D) -> CPoint3D: ...

class CPointPDF(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.math.CProbabilityDensityFunction_mrpt_poses_CPoint3D_3UL_t):
    @overload
    def __init__(self, arg0: CPointPDF) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPointPDF: ...
    @overload
    def bayesianFusion(self, p1: CPointPDF, p2: CPointPDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPointPDF, p2: CPointPDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPointPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...

class CPointPDFGaussian(CPointPDF):
    cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t
    mean: CPoint3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, init_Mean: CPoint3D) -> None: ...
    @overload
    def __init__(self, init_Mean: CPoint3D, init_Cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def __init__(self, arg0: CPointPDFGaussian) -> None: ...
    @overload
    def __init__(self, arg0: CPointPDFGaussian) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPointPDFGaussian: ...
    @overload
    def bayesianFusion(self, p1: CPointPDFGaussian, p2: CPointPDFGaussian) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPointPDF, p2: CPointPDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPointPDF, p2: CPointPDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPointPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outSample: CPoint3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t,CPoint3D]: ...
    @overload
    def getMean(self, p: CPoint3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    @overload
    def mahalanobisDistanceTo(self, other: CPointPDFGaussian) -> float: ...
    @overload
    def mahalanobisDistanceTo(self, other: CPointPDFGaussian, only_2D: bool) -> float: ...
    @overload
    def mahalanobisDistanceTo(constclassmrpt, bool) -> double: ...
    @overload
    def productIntegralNormalizedWith(self, p: CPointPDFGaussian) -> float: ...
    @overload
    def productIntegralNormalizedWith(constclassmrpt) -> double: ...
    @overload
    def productIntegralNormalizedWith2D(self, p: CPointPDFGaussian) -> float: ...
    @overload
    def productIntegralNormalizedWith2D(constclassmrpt) -> double: ...
    @overload
    def productIntegralWith(self, p: CPointPDFGaussian) -> float: ...
    @overload
    def productIntegralWith(constclassmrpt) -> double: ...
    @overload
    def productIntegralWith2D(self, p: CPointPDFGaussian) -> float: ...
    @overload
    def productIntegralWith2D(constclassmrpt) -> double: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...

class CPointPDFParticles(CPointPDF, mrpt.pymrpt.mrpt.bayes.CParticleFilterData_mrpt_math_TPoint3D_float_mrpt_bayes_particle_storage_mode_POINTER_t, mrpt.pymrpt.mrpt.bayes.CParticleFilterDataImpl_mrpt_poses_CPointPDFParticles_std_deque_mrpt_bayes_CProbabilityParticle_mrpt_math_TPoint3D_float_mrpt_bayes_particle_storage_mode_POINTER_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, numParticles: int) -> None: ...
    @overload
    def __init__(self, arg0: CPointPDFParticles) -> None: ...
    @overload
    def __init__(self, arg0: CPointPDFParticles) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPointPDFParticles: ...
    @overload
    def bayesianFusion(self, p1: CPointPDF, p2: CPointPDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPointPDF, p2: CPointPDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def computeKurtosis(self) -> float: ...
    @overload
    def computeKurtosis() -> double: ...
    @overload
    def copyFrom(self, o: CPointPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outSample: CPoint3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t,CPoint3D]: ...
    @overload
    def getMean(self, mean_point: CPoint3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    @overload
    def setSize(self, numberParticles: int) -> None: ...
    @overload
    def setSize(self, numberParticles: int, defaultValue) -> None: ...
    @overload
    def setSize(size_t, conststructmrpt) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CPointPDFSOG(CPointPDF):
    class TGaussianMode:
        log_w: float
        val: CPointPDFGaussian
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPointPDFSOG.TGaussianMode) -> None: ...
        def assign(self) -> CPointPDFSOG.TGaussianMode: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, nModes: int) -> None: ...
    @overload
    def __init__(self, arg0: CPointPDFSOG) -> None: ...
    @overload
    def __init__(self, arg0: CPointPDFSOG) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def ESS(self) -> float: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPointPDFSOG: ...
    @overload
    def bayesianFusion(self, p1: CPointPDF, p2: CPointPDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPointPDF, p2: CPointPDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPointPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outSample: CPoint3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def evaluatePDF(self, x: CPoint3D, sumOverAllZs: bool) -> float: ...
    @overload
    def evaluatePDF(constclassmrpt, bool) -> double: ...
    @overload
    def evaluatePDFInArea(self, x_min: float, x_max: float, y_min: float, y_max: float, resolutionXY: float, z: float, outMatrix: mrpt.pymrpt.mrpt.math.CMatrixD) -> None: ...
    @overload
    def evaluatePDFInArea(self, x_min: float, x_max: float, y_min: float, y_max: float, resolutionXY: float, z: float, outMatrix: mrpt.pymrpt.mrpt.math.CMatrixD, sumOverAllZs: bool) -> None: ...
    def get(self, *args, **kwargs) -> Any: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t,CPoint3D]: ...
    @overload
    def getMean(self, mean_point: CPoint3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    @overload
    def getMostLikelyMode(self, outVal: CPointPDFGaussian) -> None: ...
    @overload
    def getMostLikelyMode(classmrpt) -> void: ...
    @overload
    def normalizeWeights(self) -> None: ...
    @overload
    def normalizeWeights() -> void: ...
    @overload
    def push_back(self, m) -> None: ...
    @overload
    def push_back(conststructmrpt) -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def saveToTextFile(self, *args, **kwargs) -> Any: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def __getitem__(self, index) -> Any: ...

class CPoint_mrpt_poses_CPoint2D_2UL_t(CPoseOrPoint_mrpt_poses_CPoint2D_2UL_t, mrpt.pymrpt.mrpt.Stringifyable):
    @overload
    def __init__(self, arg0: CPoint_mrpt_poses_CPoint2D_2UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def asString(self) -> str: ...
    @overload
    def asString(self) -> str: ...
    def asVectorVal(self) -> mrpt.pymrpt.mrpt.math.CMatrixFixed_double_2UL_1UL_t: ...
    @overload
    def assign(self) -> CPoint_mrpt_poses_CPoint2D_2UL_t: ...
    @overload
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPoint2D_2UL_t: ...
    @overload
    def assign(self) -> mrpt.pymrpt.mrpt.Stringifyable: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...
    def __getitem__(self, i: int) -> float: ...
    def __imul__(self, s: float) -> None: ...

class CPoint_mrpt_poses_CPoint3D_3UL_t(CPoseOrPoint_mrpt_poses_CPoint3D_3UL_t, mrpt.pymrpt.mrpt.Stringifyable):
    @overload
    def __init__(self, arg0: CPoint_mrpt_poses_CPoint3D_3UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def asString(self) -> str: ...
    @overload
    def asString(self) -> str: ...
    def asVectorVal(self) -> mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_1UL_t: ...
    @overload
    def assign(self) -> CPoint_mrpt_poses_CPoint3D_3UL_t: ...
    @overload
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPoint3D_3UL_t: ...
    @overload
    def assign(self) -> mrpt.pymrpt.mrpt.Stringifyable: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...
    def __getitem__(self, i: int) -> float: ...
    def __imul__(self, s: float) -> None: ...

class CPose2D(CPose_mrpt_poses_CPose2D_3UL_t, mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.Stringifyable):
    m_coords: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, phi: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPose2D) -> None: ...
    @overload
    def __init__(self, arg0: CPose2D) -> None: ...
    def AddComponents(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def asTPose(self, *args, **kwargs) -> Any: ...
    def asVector(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose2D: ...
    @overload
    def changeCoordinatesReference(self, p: CPose2D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def composeFrom(self, A: CPose2D, B: CPose2D) -> None: ...
    @overload
    def composePoint(self, lx: float, ly: float, gx: float, gy: float) -> None: ...
    @overload
    def composePoint(self, l, g) -> None: ...
    @overload
    def composePoint(conststructmrpt, structmrpt) -> void: ...
    @overload
    def composePoint(self, l, g) -> None: ...
    @overload
    def composePoint(conststructmrpt, structmrpt) -> void: ...
    @overload
    def composePoint(self, lx: float, ly: float, lz: float, gx: float, gy: float, gz: float) -> None: ...
    @overload
    def distance2DFrobeniusTo(self, p: CPose2D) -> float: ...
    @overload
    def distance2DFrobeniusTo(constclassmrpt) -> double: ...
    def empty(self, *args, **kwargs) -> Any: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def fromStringRaw(self, s: str) -> None: ...
    @overload
    def fromStringRaw(conststd) -> void: ...
    def getHomogeneousMatrix(self, *args, **kwargs) -> Any: ...
    def getOppositeScalar(self) -> CPose2D: ...
    def getPoseMean(self) -> CPose2D: ...
    def getRotationMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def inverse(self) -> None: ...
    @overload
    def inverse() -> void: ...
    def inverseComposeFrom(self, A: CPose2D, B: CPose2D) -> None: ...
    @overload
    def inverseComposePoint(self, gx: float, gy: float, lx: float, ly: float) -> None: ...
    @overload
    def inverseComposePoint(self, g, l) -> None: ...
    @overload
    def inverseComposePoint(conststructmrpt, structmrpt) -> void: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...
    def max_size(self, *args, **kwargs) -> Any: ...
    @overload
    def normalizePhi(self) -> None: ...
    @overload
    def normalizePhi() -> void: ...
    @overload
    def phi(self) -> float: ...
    @overload
    def phi(self, angle: float) -> None: ...
    @overload
    def phi(double) -> void: ...
    @overload
    def phi_cos(self) -> float: ...
    @overload
    def phi_cos() -> double: ...
    @overload
    def phi_incr(self, Aphi: float) -> None: ...
    @overload
    def phi_incr(constdouble) -> void: ...
    @overload
    def phi_sin(self) -> float: ...
    @overload
    def phi_sin() -> double: ...
    def resize(self, *args, **kwargs) -> Any: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    def size(self, *args, **kwargs) -> Any: ...
    def translation(self, *args, **kwargs) -> Any: ...
    def __add__(self, D: CPose2D) -> CPose2D: ...
    def __getitem__(self, i: int) -> float: ...
    def __iadd__(self, b: CPose2D) -> CPose2D: ...
    def __imul__(self, s: float) -> None: ...
    def __sub__(self, b: CPose2D) -> CPose2D: ...

class CPose2DGridTemplate_double_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xMin: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, yMin: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, yMin: float, yMax: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, yMin: float, yMax: float, resolutionXY: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, yMin: float, yMax: float, resolutionXY: float, resolutionPhi: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, yMin: float, yMax: float, resolutionXY: float, resolutionPhi: float, phiMin: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, yMin: float, yMax: float, resolutionXY: float, resolutionPhi: float, phiMin: float, phiMax: float) -> None: ...
    @overload
    def __init__(self, arg0: CPose2DGridTemplate_double_t) -> None: ...
    def absidx2idx(self, absIdx: int) -> Tuple[int,int,int]: ...
    def assign(self) -> CPose2DGridTemplate_double_t: ...
    def getByIndex(self, x: int, y: int, phi: int) -> float: ...
    def getByPos(self, x: float, y: float, phi: float) -> float: ...
    @overload
    def getPhiMax(self) -> float: ...
    @overload
    def getPhiMax() -> double: ...
    @overload
    def getPhiMin(self) -> float: ...
    @overload
    def getPhiMin() -> double: ...
    @overload
    def getResolutionPhi(self) -> float: ...
    @overload
    def getResolutionPhi() -> double: ...
    @overload
    def getResolutionXY(self) -> float: ...
    @overload
    def getResolutionXY() -> double: ...
    @overload
    def getSizePhi(self) -> int: ...
    @overload
    def getSizePhi() -> size_t: ...
    @overload
    def getSizeX(self) -> int: ...
    @overload
    def getSizeX() -> size_t: ...
    @overload
    def getSizeY(self) -> int: ...
    @overload
    def getSizeY() -> size_t: ...
    @overload
    def getXMax(self) -> float: ...
    @overload
    def getXMax() -> double: ...
    @overload
    def getXMin(self) -> float: ...
    @overload
    def getXMin() -> double: ...
    @overload
    def getYMax(self) -> float: ...
    @overload
    def getYMax() -> double: ...
    @overload
    def getYMin(self) -> float: ...
    @overload
    def getYMin() -> double: ...
    def idx2absidx(self, cx: int, cy: int, cPhi: int) -> int: ...
    @overload
    def idx2phi(self, phi: int) -> float: ...
    @overload
    def idx2phi(size_t) -> double: ...
    @overload
    def idx2x(self, x: int) -> float: ...
    @overload
    def idx2x(size_t) -> double: ...
    @overload
    def idx2y(self, y: int) -> float: ...
    @overload
    def idx2y(size_t) -> double: ...
    @overload
    def phi2idx(self, phi: float) -> int: ...
    @overload
    def phi2idx(double) -> size_t: ...
    @overload
    def setSize(self, xMin: float, xMax: float, yMin: float, yMax: float, resolutionXY: float, resolutionPhi: float) -> None: ...
    @overload
    def setSize(self, xMin: float, xMax: float, yMin: float, yMax: float, resolutionXY: float, resolutionPhi: float, phiMin: float) -> None: ...
    @overload
    def setSize(self, xMin: float, xMax: float, yMin: float, yMax: float, resolutionXY: float, resolutionPhi: float, phiMin: float, phiMax: float) -> None: ...
    @overload
    def x2idx(self, x: float) -> int: ...
    @overload
    def x2idx(double) -> size_t: ...
    @overload
    def y2idx(self, y: float) -> int: ...
    @overload
    def y2idx(double) -> size_t: ...

class CPose2DInterpolator(mrpt.pymrpt.mrpt.serialization.CSerializable, CPoseInterpolatorBase_2_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPose2DInterpolator) -> None: ...
    @overload
    def __init__(self, arg0: CPose2DInterpolator) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose2DInterpolator: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CPose3D(CPose_mrpt_poses_CPose3D_6UL_t, mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.Stringifyable):
    m_coords: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, yaw: float, pitch: float, roll: float) -> None: ...
    @overload
    def __init__(self, m) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, q, x: float, y: float, z: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPose3D) -> None: ...
    @overload
    def __init__(self, arg0: CPose3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def FromQuaternion(self, *args, **kwargs) -> Any: ...
    def FromQuaternionAndTranslation(self, *args, **kwargs) -> Any: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    def FromTranslation(self, *args, **kwargs) -> Any: ...
    def FromXYZYawPitchRoll(self, *args, **kwargs) -> Any: ...
    def FromYawPitchRoll(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    @overload
    def addComponents(self, p: CPose3D) -> None: ...
    @overload
    def addComponents(constclassmrpt) -> void: ...
    def asString(self) -> str: ...
    def asTPose(self, *args, **kwargs) -> Any: ...
    def asVector(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose3D: ...
    @overload
    def changeCoordinatesReference(self, p: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def composeFrom(self, A: CPose3D, B: CPose3D) -> None: ...
    @overload
    def composePoint(self, local_point, global_point) -> None: ...
    @overload
    def composePoint(conststructmrpt, structmrpt) -> void: ...
    @overload
    def composePoint(self, local_point, global_point) -> None: ...
    @overload
    def composePoint(conststructmrpt, structmrpt) -> void: ...
    @overload
    def composePoint(self, lx: float, ly: float, lz: float, gx: float, gy: float, gz: float) -> None: ...
    @overload
    def distanceEuclidean6D(self, o: CPose3D) -> float: ...
    @overload
    def distanceEuclidean6D(constclassmrpt) -> double: ...
    def empty(self, *args, **kwargs) -> Any: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def fromStringRaw(self, s: str) -> None: ...
    @overload
    def fromStringRaw(conststd) -> void: ...
    def getHomogeneousMatrix(self, *args, **kwargs) -> Any: ...
    def getOppositeScalar(self) -> CPose3D: ...
    def getPoseMean(self) -> CPose3D: ...
    def getRotationMatrix(self, *args, **kwargs) -> Any: ...
    def getYawPitchRoll(self, yaw: float, pitch: float, roll: float) -> None: ...
    @overload
    def inverse(self) -> None: ...
    @overload
    def inverse() -> void: ...
    def inverseComposeFrom(self, A: CPose3D, B: CPose3D) -> None: ...
    @overload
    def inverseComposePoint(self, g, l) -> None: ...
    @overload
    def inverseComposePoint(conststructmrpt, structmrpt) -> void: ...
    @overload
    def inverseComposePoint(self, g, l) -> None: ...
    @overload
    def inverseComposePoint(self, g, l, eps: float) -> None: ...
    @overload
    def inverseComposePoint(conststructmrpt, structmrpt, constdouble) -> void: ...
    def inverseRotateVector(self, *args, **kwargs) -> Any: ...
    @overload
    def isHorizontal(self) -> bool: ...
    @overload
    def isHorizontal(self, tolerance: float) -> bool: ...
    @overload
    def isHorizontal(constdouble) -> bool: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...
    def jacobian_pose_rodrigues_from_YPR(self, *args, **kwargs) -> Any: ...
    def jacobian_rodrigues_from_YPR(self, *args, **kwargs) -> Any: ...
    def max_size(self, *args, **kwargs) -> Any: ...
    @overload
    def normalizeAngles(self) -> None: ...
    @overload
    def normalizeAngles() -> void: ...
    @overload
    def pitch(self) -> float: ...
    @overload
    def pitch() -> double: ...
    def resize(self, *args, **kwargs) -> Any: ...
    @overload
    def roll(self) -> float: ...
    @overload
    def roll() -> double: ...
    def rotateVector(self, *args, **kwargs) -> Any: ...
    def setFrom12Vector(self, *args, **kwargs) -> Any: ...
    @overload
    def setFromValues(self, x0: float, y0: float, z0: float) -> None: ...
    @overload
    def setFromValues(self, x0: float, y0: float, z0: float, yaw: float) -> None: ...
    @overload
    def setFromValues(self, x0: float, y0: float, z0: float, yaw: float, pitch: float) -> None: ...
    @overload
    def setFromValues(self, x0: float, y0: float, z0: float, yaw: float, pitch: float, roll: float) -> None: ...
    def setRotationMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    def setYawPitchRoll(self, yaw_: float, pitch_: float, roll_: float) -> None: ...
    def size(self, *args, **kwargs) -> Any: ...
    def sphericalCoordinates(self, point, out_range: float, out_yaw: float, out_pitch: float) -> None: ...
    def translation(self, *args, **kwargs) -> Any: ...
    @overload
    def yaw(self) -> float: ...
    @overload
    def yaw() -> double: ...
    def __add__(self, b: CPose3D) -> CPose3D: ...
    def __getitem__(self, i: int) -> float: ...
    def __iadd__(self, b: CPose3D) -> CPose3D: ...
    def __imul__(self, s: float) -> None: ...
    def __sub__(self, b: CPose3D) -> CPose3D: ...

class CPose3DGridTemplate_double_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, bb_min: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def __init__(self, bb_min: mrpt.pymrpt.mrpt.math.TPose3D, bb_max: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def __init__(self, bb_min: mrpt.pymrpt.mrpt.math.TPose3D, bb_max: mrpt.pymrpt.mrpt.math.TPose3D, resolution_XYZ: float) -> None: ...
    @overload
    def __init__(self, bb_min: mrpt.pymrpt.mrpt.math.TPose3D, bb_max: mrpt.pymrpt.mrpt.math.TPose3D, resolution_XYZ: float, resolution_YPR: float) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DGridTemplate_double_t) -> None: ...
    def absidx2idx(self, absIdx: int) -> Tuple[int,int,int,int,int,int]: ...
    def assign(self) -> CPose3DGridTemplate_double_t: ...
    def fill(self, val: float) -> None: ...
    def getByIndex(self, cx: int, cy: int, cz: int, cY: int, cP: int, cR: int) -> float: ...
    @overload
    def getByPos(self, x: float, y: float, z: float, yaw: float, pitch: float, roll: float) -> float: ...
    @overload
    def getByPos(self, p: mrpt.pymrpt.mrpt.math.TPose3D) -> float: ...
    def getMaxBoundingBox(self) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    def getMinBoundingBox(self) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    @overload
    def getResolutionAngles(self) -> float: ...
    @overload
    def getResolutionAngles() -> double: ...
    @overload
    def getResolutionXYZ(self) -> float: ...
    @overload
    def getResolutionXYZ() -> double: ...
    @overload
    def getSizePitch(self) -> int: ...
    @overload
    def getSizePitch() -> uint32_t: ...
    @overload
    def getSizeRoll(self) -> int: ...
    @overload
    def getSizeRoll() -> uint32_t: ...
    @overload
    def getSizeX(self) -> int: ...
    @overload
    def getSizeX() -> uint32_t: ...
    @overload
    def getSizeY(self) -> int: ...
    @overload
    def getSizeY() -> uint32_t: ...
    @overload
    def getSizeYaw(self) -> int: ...
    @overload
    def getSizeYaw() -> uint32_t: ...
    @overload
    def getSizeZ(self) -> int: ...
    @overload
    def getSizeZ() -> uint32_t: ...
    @overload
    def getTotalVoxelCount(self) -> int: ...
    @overload
    def getTotalVoxelCount() -> uint32_t: ...
    def idx2absidx(self, cx: int, cy: int, cz: int, cYaw: int, cPitch: int, cRoll: int) -> int: ...
    @overload
    def idx2pitch(self, cP: int) -> float: ...
    @overload
    def idx2pitch(uint32_t) -> double: ...
    @overload
    def idx2roll(self, cR: int) -> float: ...
    @overload
    def idx2roll(uint32_t) -> double: ...
    @overload
    def idx2x(self, cx: int) -> float: ...
    @overload
    def idx2x(uint32_t) -> double: ...
    @overload
    def idx2y(self, cy: int) -> float: ...
    @overload
    def idx2y(uint32_t) -> double: ...
    @overload
    def idx2yaw(self, cY: int) -> float: ...
    @overload
    def idx2yaw(uint32_t) -> double: ...
    @overload
    def idx2z(self, cz: int) -> float: ...
    @overload
    def idx2z(uint32_t) -> double: ...
    @overload
    def pitch2idx(self, pitch: float) -> int: ...
    @overload
    def pitch2idx(double) -> int: ...
    @overload
    def roll2idx(self, roll: float) -> int: ...
    @overload
    def roll2idx(double) -> int: ...
    def setSize(self, bb_min: mrpt.pymrpt.mrpt.math.TPose3D, bb_max: mrpt.pymrpt.mrpt.math.TPose3D, resolution_XYZ: float, resolution_YPR: float) -> None: ...
    @overload
    def x2idx(self, x: float) -> int: ...
    @overload
    def x2idx(double) -> int: ...
    @overload
    def y2idx(self, y: float) -> int: ...
    @overload
    def y2idx(double) -> int: ...
    @overload
    def yaw2idx(self, yaw: float) -> int: ...
    @overload
    def yaw2idx(double) -> int: ...
    @overload
    def z2idx(self, z: float) -> int: ...
    @overload
    def z2idx(double) -> int: ...

class CPose3DInterpolator(mrpt.pymrpt.mrpt.serialization.CSerializable, CPoseInterpolatorBase_3_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DInterpolator) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DInterpolator) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose3DInterpolator: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CPose3DPDF(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.math.CProbabilityDensityFunction_mrpt_poses_CPose3D_6UL_t):
    @overload
    def __init__(self, arg0: CPose3DPDF) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose3DPDF: ...
    def bayesianFusion(self, p1: CPose3DPDF, p2: CPose3DPDF) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPose3DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    def createFrom2D(self, *args, **kwargs) -> Any: ...
    @overload
    def inverse(self, o: CPose3DPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...
    def jacobiansPoseComposition(self, *args, **kwargs) -> Any: ...

class CPose3DPDFGaussian(CPose3DPDF, mrpt.pymrpt.mrpt.Stringifyable):
    cov: Any
    mean: CPose3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose3D) -> None: ...
    @overload
    def __init__(self, constructor_dummy_param: TConstructorFlags_Poses) -> None: ...
    @overload
    def __init__(self, o) -> None: ...
    @overload
    def __init__(self, o) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFGaussian) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFGaussian) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> CPose3DPDFGaussian: ...
    def bayesianFusion(self, p1: CPose3DPDF, p2: CPose3DPDF) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPose3DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def evaluateNormalizedPDF(self, x: CPose3D) -> float: ...
    @overload
    def evaluateNormalizedPDF(constclassmrpt) -> double: ...
    @overload
    def evaluatePDF(self, x: CPose3D) -> float: ...
    @overload
    def evaluatePDF(constclassmrpt) -> double: ...
    @overload
    def getCovSubmatrix2D(self, out_cov) -> None: ...
    @overload
    def getCovSubmatrix2D(classmrpt) -> void: ...
    def getCovarianceAndMean(self, *args, **kwargs) -> Any: ...
    @overload
    def getMean(self, mean_pose: CPose3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getPoseMean(self) -> CPose3D: ...
    @overload
    def inverse(self, o: CPose3DPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    def mahalanobisDistanceTo(self, *args, **kwargs) -> Any: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    def __add__(self, arg0: CPose3DPDFGaussian) -> CPose3DPDFGaussian: ...
    @overload
    def __iadd__(self, Ap: CPose3D) -> None: ...
    @overload
    def __iadd__(self, Ap: CPose3DPDFGaussian) -> None: ...
    def __isub__(self, Ap: CPose3DPDFGaussian) -> None: ...
    def __neg__(self) -> CPose3DPDFGaussian: ...
    def __sub__(self, arg0: CPose3DPDFGaussian) -> CPose3DPDFGaussian: ...

class CPose3DPDFGaussianInf(CPose3DPDF):
    cov_inv: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_6UL_6UL_t
    mean: CPose3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose3D) -> None: ...
    @overload
    def __init__(self, constructor_dummy_param: TConstructorFlags_Poses) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose3D, init_CovInv: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_6UL_6UL_t) -> None: ...
    @overload
    def __init__(self, o) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFGaussianInf) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFGaussianInf) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose3DPDFGaussianInf: ...
    def bayesianFusion(self, p1: CPose3DPDF, p2: CPose3DPDF) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPose3DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def evaluateNormalizedPDF(self, x: CPose3D) -> float: ...
    @overload
    def evaluateNormalizedPDF(constclassmrpt) -> double: ...
    @overload
    def evaluatePDF(self, x: CPose3D) -> float: ...
    @overload
    def evaluatePDF(constclassmrpt) -> double: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_6UL_6UL_t,CPose3D]: ...
    def getInformationMatrix(self, inf: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_6UL_6UL_t) -> None: ...
    @overload
    def getInvCovSubmatrix2D(self, out_cov: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t) -> None: ...
    @overload
    def getInvCovSubmatrix2D(classmrpt) -> void: ...
    @overload
    def getMean(self, mean_pose: CPose3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getPoseMean(self) -> CPose3D: ...
    @overload
    def inverse(self, o: CPose3DPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def isInfType(self) -> bool: ...
    @overload
    def isInfType() -> bool: ...
    def mahalanobisDistanceTo(self, *args, **kwargs) -> Any: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    def __add__(self, arg0: CPose3DPDFGaussianInf) -> CPose3DPDFGaussianInf: ...
    @overload
    def __iadd__(self, Ap: CPose3D) -> None: ...
    @overload
    def __iadd__(self, Ap: CPose3DPDFGaussianInf) -> None: ...
    def __isub__(self, Ap: CPose3DPDFGaussianInf) -> None: ...
    def __neg__(self) -> CPose3DPDFGaussianInf: ...
    def __sub__(self, arg0: CPose3DPDFGaussianInf) -> CPose3DPDFGaussianInf: ...

class CPose3DPDFGrid(CPose3DPDF, CPose3DGridTemplate_double_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.math.TPose3D, arg1: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.math.TPose3D, arg1: mrpt.pymrpt.mrpt.math.TPose3D, arg2: float) -> None: ...
    @overload
    def __init__(self, bb_min: mrpt.pymrpt.mrpt.math.TPose3D, bb_max: mrpt.pymrpt.mrpt.math.TPose3D, resolution_XYZ: float, resolution_YPR: float) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFGrid) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFGrid) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose3DPDFGrid: ...
    def bayesianFusion(self, p1: CPose3DPDF, p2: CPose3DPDF) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPose3DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_6UL_6UL_t,CPose3D]: ...
    @overload
    def getMean(self, mean_pose: CPose3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    @overload
    def inverse(self, o: CPose3DPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def normalize(self) -> None: ...
    @overload
    def normalize() -> void: ...
    @overload
    def saveToTextFile(self, dataFile: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    @overload
    def uniformDistribution(self) -> None: ...
    @overload
    def uniformDistribution() -> void: ...

class CPose3DPDFParticles(CPose3DPDF, mrpt.pymrpt.mrpt.bayes.CParticleFilterData_mrpt_math_TPose3D_mrpt_bayes_particle_storage_mode_VALUE_t, mrpt.pymrpt.mrpt.bayes.CParticleFilterDataImpl_mrpt_poses_CPose3DPDFParticles_std_deque_mrpt_bayes_CProbabilityParticle_mrpt_math_TPose3D_mrpt_bayes_particle_storage_mode_VALUE_t, mrpt.pymrpt.mrpt.Stringifyable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, M: int) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFParticles) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFParticles) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def append(self, o: CPose3DPDFParticles) -> None: ...
    @overload
    def append(classmrpt) -> void: ...
    def asString(self) -> str: ...
    def assign(self) -> CPose3DPDFParticles: ...
    def bayesianFusion(self, p1: CPose3DPDF, p2: CPose3DPDF) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPose3DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    def getCovarianceAndMean(self, *args, **kwargs) -> Any: ...
    @overload
    def getMean(self, mean_pose: CPose3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getMostLikelyParticle(self) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    def getParticlePose(self, i: int) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    @overload
    def inverse(self, o: CPose3DPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def resetDeterministic(self, location: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def resetDeterministic(self, location: mrpt.pymrpt.mrpt.math.TPose3D, particlesCount: int) -> None: ...
    @overload
    def resetDeterministic(conststructmrpt, size_t) -> void: ...
    @overload
    def resetUniform(self, corner_min: mrpt.pymrpt.mrpt.math.TPose3D, corner_max: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def resetUniform(self, corner_min: mrpt.pymrpt.mrpt.math.TPose3D, corner_max: mrpt.pymrpt.mrpt.math.TPose3D, particlesCount: int) -> None: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def __iadd__(self, Ap: CPose3D) -> None: ...

class CPose3DPDFSOG(CPose3DPDF):
    class TGaussianMode:
        log_w: float
        val: CPose3DPDFGaussian
        def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, nModes: int) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFSOG) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DPDFSOG) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def appendFrom(self, o: CPose3DPDFSOG) -> None: ...
    @overload
    def appendFrom(constclassmrpt) -> void: ...
    def assign(self) -> CPose3DPDFSOG: ...
    def bayesianFusion(self, p1: CPose3DPDF, p2: CPose3DPDF) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPose3DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_6UL_6UL_t,CPose3D]: ...
    @overload
    def getMean(self, mean_pose: CPose3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    @overload
    def getMostLikelyMode(self, outVal: CPose3DPDFGaussian) -> None: ...
    @overload
    def getMostLikelyMode(classmrpt) -> void: ...
    @overload
    def inverse(self, o: CPose3DPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def normalizeWeights(self) -> None: ...
    @overload
    def normalizeWeights() -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def saveToTextFile(self, *args, **kwargs) -> Any: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CPose3DQuat(CPose_mrpt_poses_CPose3DQuat_7UL_t, mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.Stringifyable):
    class const_iterator:
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, obj: CPose3DQuat, start_idx: int) -> None: ...
        def dereference(self) -> float: ...
        def __getitem__(self, off: int) -> float: ...

    class iterator:
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, obj: CPose3DQuat, start_idx: int) -> None: ...
        def dereference(self) -> float: ...
        def __getitem__(self, off: int) -> float: ...
    m_coords: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_1UL_t
    m_quat: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, q) -> None: ...
    @overload
    def __init__(self, p: CPose3D) -> None: ...
    @overload
    def __init__(self, p: mrpt.pymrpt.mrpt.math.TPose3DQuat) -> None: ...
    @overload
    def __init__(self, M: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_4UL_4UL_t) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DQuat) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DQuat) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self, *args, **kwargs) -> Any: ...
    def asTPose(self) -> mrpt.pymrpt.mrpt.math.TPose3DQuat: ...
    def asVector(self, v: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_1UL_t) -> None: ...
    @overload
    def assign(self, N: int, val: float) -> None: ...
    @overload
    def assign(size_t, constdouble) -> void: ...
    @overload
    def assign(self) -> CPose3DQuat: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def composeFrom(self, *args, **kwargs) -> Any: ...
    def empty(self, *args, **kwargs) -> Any: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def fromStringRaw(self, s: str) -> None: ...
    @overload
    def fromStringRaw(conststd) -> void: ...
    def getHomogeneousMatrix(self, out_HM: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_4UL_4UL_t) -> None: ...
    def getPoseMean(self) -> CPose3DQuat: ...
    @overload
    def inverse(self) -> None: ...
    @overload
    def inverse() -> void: ...
    def inverseComposeFrom(self, A: CPose3DQuat, B: CPose3DQuat) -> None: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...
    def max_size(self, *args, **kwargs) -> Any: ...
    def quat(self, *args, **kwargs) -> Any: ...
    def resize(self, *args, **kwargs) -> Any: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    def size(self, *args, **kwargs) -> Any: ...
    @overload
    def swap(self, o: CPose3DQuat) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    def xyz(self) -> mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_1UL_t: ...
    @overload
    def __add__(self, L: CPoint3D) -> CPoint3D: ...
    @overload
    def __add__(self, p: CPose3DQuat) -> CPose3DQuat: ...
    def __getitem__(self, i: int) -> float: ...
    def __iadd__(self, b: CPose3DQuat) -> CPose3DQuat: ...
    def __imul__(self, s: float) -> None: ...
    def __isub__(self, b: CPose3DQuat) -> CPose3DQuat: ...
    def __sub__(self, p: CPose3DQuat) -> CPose3DQuat: ...

class CPose3DQuatPDF(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.math.CProbabilityDensityFunction_mrpt_poses_CPose3DQuat_7UL_t):
    @overload
    def __init__(self, arg0: CPose3DQuatPDF) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose3DQuatPDF: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPose3DQuatPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    def createFrom2D(self, *args, **kwargs) -> Any: ...
    @overload
    def inverse(self, o: CPose3DQuatPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    def jacobiansPoseComposition(self, *args, **kwargs) -> Any: ...

class CPose3DQuatPDFGaussian(CPose3DQuatPDF):
    cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_7UL_t
    mean: CPose3DQuat
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, constructor_dummy_param: mrpt.pymrpt.mrpt.math.TConstructorFlags_Quaternions) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose3DQuat) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose3DQuat, init_Cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_7UL_t) -> None: ...
    @overload
    def __init__(self, o: CPosePDFGaussian) -> None: ...
    @overload
    def __init__(self, o: CPose3DPDFGaussian) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DQuatPDFGaussian) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DQuatPDFGaussian) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose3DQuatPDFGaussian: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3DQuat) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPose3DQuatPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPose3DPDFGaussian) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose3DQuat) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def evaluateNormalizedPDF(self, x: CPose3DQuat) -> float: ...
    @overload
    def evaluateNormalizedPDF(constclassmrpt) -> double: ...
    @overload
    def evaluatePDF(self, x: CPose3DQuat) -> float: ...
    @overload
    def evaluatePDF(constclassmrpt) -> double: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_7UL_t,CPose3DQuat]: ...
    @overload
    def getMean(self, mean_pose: CPose3DQuat) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getPoseMean(self) -> CPose3DQuat: ...
    @overload
    def inverse(self, o: CPose3DQuatPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    def inverseCompositionCrossCorrelation(self, pose_to: CPose3DQuatPDFGaussian) -> CPose3DQuatPDFGaussian: ...
    def inverseJacobian(self) -> mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_7UL_t: ...
    def mahalanobisDistanceTo(self, *args, **kwargs) -> Any: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    @overload
    def __iadd__(self, Ap: CPose3DQuat) -> None: ...
    @overload
    def __iadd__(self, Ap: CPose3DQuatPDFGaussian) -> None: ...
    def __isub__(self, Ap: CPose3DQuatPDFGaussian) -> None: ...
    def __neg__(self) -> CPose3DQuatPDFGaussian: ...

class CPose3DQuatPDFGaussianInf(CPose3DQuatPDF):
    cov_inv: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_7UL_t
    mean: CPose3DQuat
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, constructor_dummy_param: mrpt.pymrpt.mrpt.math.TConstructorFlags_Quaternions) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose3DQuat) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose3DQuat, init_CovInv: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_7UL_t) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DQuatPDFGaussianInf) -> None: ...
    @overload
    def __init__(self, arg0: CPose3DQuatPDFGaussianInf) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPose3DQuatPDFGaussianInf: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3DQuat) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPose3DQuatPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose3DQuat) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def evaluateNormalizedPDF(self, x: CPose3DQuat) -> float: ...
    @overload
    def evaluateNormalizedPDF(constclassmrpt) -> double: ...
    @overload
    def evaluatePDF(self, x: CPose3DQuat) -> float: ...
    @overload
    def evaluatePDF(constclassmrpt) -> double: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_7UL_t,CPose3DQuat]: ...
    def getInformationMatrix(self, inf: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_7UL_7UL_t) -> None: ...
    @overload
    def getMean(self, mean_pose: CPose3DQuat) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getPoseMean(self) -> CPose3DQuat: ...
    @overload
    def inverse(self, o: CPose3DQuatPDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def isInfType(self) -> bool: ...
    @overload
    def isInfType() -> bool: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    def __add__(self, arg0: CPose3DQuatPDFGaussianInf) -> CPose3DQuatPDFGaussianInf: ...
    @overload
    def __iadd__(self, Ap: CPose3DQuat) -> None: ...
    @overload
    def __iadd__(self, Ap: CPose3DQuatPDFGaussianInf) -> None: ...
    def __isub__(self, Ap: CPose3DQuatPDFGaussianInf) -> None: ...
    def __neg__(self) -> CPose3DQuatPDFGaussianInf: ...
    def __sub__(self, arg0: CPose3DQuatPDFGaussianInf) -> CPose3DQuatPDFGaussianInf: ...

class CPoseInterpolatorBase_2_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPoseInterpolatorBase_2_t) -> None: ...
    def assign(self) -> CPoseInterpolatorBase_2_t: ...
    def at(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    def filter(self, component: int, samples: int) -> None: ...
    def getBoundingBox(self, minCorner, maxCorner) -> None: ...
    def getInterpolationMethod(self) -> TInterpolatorMethod: ...
    def getMaxTimeInterpolation(self) -> mrpt.pymrpt.std.chrono.duration_long_std_ratio_1_10000000_t: ...
    @overload
    def getPreviousPoseWithMinDistance(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, distance: float, out_pose: mrpt.pymrpt.mrpt.math.TPose2D) -> bool: ...
    @overload
    def getPreviousPoseWithMinDistance(constmrpt, double, structmrpt) -> bool: ...
    @overload
    def getPreviousPoseWithMinDistance(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, distance: float, out_pose: CPose2D) -> bool: ...
    @overload
    def getPreviousPoseWithMinDistance(constmrpt, double, classmrpt) -> bool: ...
    @overload
    def insert(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, p: mrpt.pymrpt.mrpt.math.TPose2D) -> None: ...
    @overload
    def insert(constmrpt, conststructmrpt) -> void: ...
    @overload
    def insert(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, p: CPose2D) -> None: ...
    @overload
    def insert(constmrpt, constclassmrpt) -> void: ...
    @overload
    def interpolate(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, out_interp: mrpt.pymrpt.mrpt.math.TPose2D, out_valid_interp: bool) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    @overload
    def interpolate(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, out_interp: CPose2D, out_valid_interp: bool) -> CPose2D: ...
    @overload
    def loadFromTextFile(self, s: str) -> bool: ...
    @overload
    def loadFromTextFile(conststd) -> bool: ...
    @overload
    def loadFromTextFile_TUM(self, s: str) -> bool: ...
    @overload
    def loadFromTextFile_TUM(conststd) -> bool: ...
    def saveInterpolatedToTextFile(self, s: str, period: mrpt.pymrpt.std.chrono.duration_long_std_ratio_1_10000000_t) -> bool: ...
    @overload
    def saveToTextFile(self, s: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    @overload
    def saveToTextFile_TUM(self, s: str) -> bool: ...
    @overload
    def saveToTextFile_TUM(conststd) -> bool: ...
    @overload
    def setInterpolationMethod(self, method: TInterpolatorMethod) -> None: ...
    @overload
    def setInterpolationMethod(enummrpt) -> void: ...
    def setMaxTimeInterpolation(self, time: mrpt.pymrpt.std.chrono.duration_long_std_ratio_1_10000000_t) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CPoseInterpolatorBase_3_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPoseInterpolatorBase_3_t) -> None: ...
    def assign(self) -> CPoseInterpolatorBase_3_t: ...
    def at(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    def filter(self, component: int, samples: int) -> None: ...
    def getBoundingBox(self, minCorner, maxCorner) -> None: ...
    def getInterpolationMethod(self) -> TInterpolatorMethod: ...
    def getMaxTimeInterpolation(self) -> mrpt.pymrpt.std.chrono.duration_long_std_ratio_1_10000000_t: ...
    @overload
    def getPreviousPoseWithMinDistance(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, distance: float, out_pose: mrpt.pymrpt.mrpt.math.TPose3D) -> bool: ...
    @overload
    def getPreviousPoseWithMinDistance(constmrpt, double, structmrpt) -> bool: ...
    @overload
    def getPreviousPoseWithMinDistance(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, distance: float, out_pose: CPose3D) -> bool: ...
    @overload
    def getPreviousPoseWithMinDistance(constmrpt, double, classmrpt) -> bool: ...
    @overload
    def insert(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, p: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def insert(constmrpt, conststructmrpt) -> void: ...
    @overload
    def insert(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, p: CPose3D) -> None: ...
    @overload
    def insert(constmrpt, constclassmrpt) -> void: ...
    @overload
    def interpolate(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, out_interp: mrpt.pymrpt.mrpt.math.TPose3D, out_valid_interp: bool) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    @overload
    def interpolate(self, t: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, out_interp: CPose3D, out_valid_interp: bool) -> CPose3D: ...
    @overload
    def loadFromTextFile(self, s: str) -> bool: ...
    @overload
    def loadFromTextFile(conststd) -> bool: ...
    @overload
    def loadFromTextFile_TUM(self, s: str) -> bool: ...
    @overload
    def loadFromTextFile_TUM(conststd) -> bool: ...
    def saveInterpolatedToTextFile(self, s: str, period: mrpt.pymrpt.std.chrono.duration_long_std_ratio_1_10000000_t) -> bool: ...
    @overload
    def saveToTextFile(self, s: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    @overload
    def saveToTextFile_TUM(self, s: str) -> bool: ...
    @overload
    def saveToTextFile_TUM(conststd) -> bool: ...
    @overload
    def setInterpolationMethod(self, method: TInterpolatorMethod) -> None: ...
    @overload
    def setInterpolationMethod(enummrpt) -> void: ...
    def setMaxTimeInterpolation(self, time: mrpt.pymrpt.std.chrono.duration_long_std_ratio_1_10000000_t) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CPoseOrPoint_mrpt_poses_CPoint2D_2UL_t:
    @overload
    def __init__(self, arg0: CPoseOrPoint_mrpt_poses_CPoint2D_2UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def asVectorVal(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPoint2D_2UL_t: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...

class CPoseOrPoint_mrpt_poses_CPoint3D_3UL_t:
    @overload
    def __init__(self, arg0: CPoseOrPoint_mrpt_poses_CPoint3D_3UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def asVectorVal(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPoint3D_3UL_t: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...

class CPoseOrPoint_mrpt_poses_CPose2D_3UL_t:
    @overload
    def __init__(self, arg0: CPoseOrPoint_mrpt_poses_CPose2D_3UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def asVectorVal(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPose2D_3UL_t: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...

class CPoseOrPoint_mrpt_poses_CPose3DQuat_7UL_t:
    @overload
    def __init__(self, arg0: CPoseOrPoint_mrpt_poses_CPose3DQuat_7UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def asVectorVal(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPose3DQuat_7UL_t: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...

class CPoseOrPoint_mrpt_poses_CPose3D_6UL_t:
    @overload
    def __init__(self, arg0: CPoseOrPoint_mrpt_poses_CPose3D_6UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def asVectorVal(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPose3D_6UL_t: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    def getHomogeneousMatrixVal(self, *args, **kwargs) -> Any: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...

class CPosePDF(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.math.CProbabilityDensityFunction_mrpt_poses_CPose2D_3UL_t):
    @overload
    def __init__(self, arg0: CPosePDF) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPosePDF: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def inverse(self, o: CPosePDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    def is_3D(self, *args, **kwargs) -> Any: ...
    def is_PDF(self, *args, **kwargs) -> Any: ...
    def jacobiansPoseComposition(self, *args, **kwargs) -> Any: ...

class CPosePDFGaussian(CPosePDF):
    cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t
    mean: CPose2D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose2D) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose2D, init_Cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def __init__(self, o: CPosePDF) -> None: ...
    @overload
    def __init__(self, o: CPose3DPDF) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFGaussian) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFGaussian) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPosePDFGaussian: ...
    def assureMinCovariance(self, minStdXY: float, minStdPhi: float) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose2D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def composePoint(self, l, g) -> None: ...
    @overload
    def composePoint(conststructmrpt, classmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPose3DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose2D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def evaluateNormalizedPDF(self, x: CPose2D) -> float: ...
    @overload
    def evaluateNormalizedPDF(constclassmrpt) -> double: ...
    @overload
    def evaluatePDF(self, x: CPose2D) -> float: ...
    @overload
    def evaluatePDF(constclassmrpt) -> double: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t,CPose2D]: ...
    @overload
    def getMean(self, mean_pose: CPose2D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getPoseMean(self) -> CPose2D: ...
    @overload
    def inverse(self, o: CPosePDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def inverseComposition(self, x: CPosePDFGaussian, ref: CPosePDFGaussian) -> None: ...
    @overload
    def inverseComposition(self, x1: CPosePDFGaussian, x0: CPosePDFGaussian, COV_01: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def mahalanobisDistanceTo(self, theOther: CPosePDFGaussian) -> float: ...
    @overload
    def mahalanobisDistanceTo(constclassmrpt) -> double: ...
    @overload
    def rotateCov(self, ang: float) -> None: ...
    @overload
    def rotateCov(constdouble) -> void: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    def __add__(self, arg0: CPosePDFGaussian) -> CPosePDFGaussian: ...
    @overload
    def __iadd__(self, Ap: CPose2D) -> None: ...
    @overload
    def __iadd__(self, Ap: CPosePDFGaussian) -> None: ...
    def __isub__(self, ref: CPosePDFGaussian) -> None: ...
    def __sub__(self, arg0: CPosePDFGaussian) -> CPosePDFGaussian: ...

class CPosePDFGaussianInf(CPosePDF):
    cov_inv: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t
    mean: CPose2D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose2D) -> None: ...
    @overload
    def __init__(self, init_Mean: CPose2D, init_CovInv: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def __init__(self, o: CPosePDF) -> None: ...
    @overload
    def __init__(self, o: CPose3DPDF) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFGaussianInf) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFGaussianInf) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPosePDFGaussianInf: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose2D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def copyFrom(self, o: CPose3DPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose2D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def evaluateNormalizedPDF(self, x: CPose2D) -> float: ...
    @overload
    def evaluateNormalizedPDF(constclassmrpt) -> double: ...
    @overload
    def evaluatePDF(self, x: CPose2D) -> float: ...
    @overload
    def evaluatePDF(constclassmrpt) -> double: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t,CPose2D]: ...
    def getInformationMatrix(self, inf: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def getMean(self, mean_pose: CPose2D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getPoseMean(self) -> CPose2D: ...
    @overload
    def inverse(self, o: CPosePDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def inverseComposition(self, x: CPosePDFGaussianInf, ref: CPosePDFGaussianInf) -> None: ...
    @overload
    def inverseComposition(self, x1: CPosePDFGaussianInf, x0: CPosePDFGaussianInf, COV_01: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def isInfType(self) -> bool: ...
    @overload
    def isInfType() -> bool: ...
    @overload
    def mahalanobisDistanceTo(self, theOther: CPosePDFGaussianInf) -> float: ...
    @overload
    def mahalanobisDistanceTo(constclassmrpt) -> double: ...
    @overload
    def rotateCov(self, ang: float) -> None: ...
    @overload
    def rotateCov(constdouble) -> void: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    def __add__(self, arg0: CPosePDFGaussianInf) -> CPosePDFGaussianInf: ...
    @overload
    def __iadd__(self, Ap: CPose2D) -> None: ...
    @overload
    def __iadd__(self, Ap: CPosePDFGaussianInf) -> None: ...
    def __isub__(self, ref: CPosePDFGaussianInf) -> None: ...
    def __sub__(self, arg0: CPosePDFGaussianInf) -> CPosePDFGaussianInf: ...

class CPosePDFGrid(CPosePDF, CPose2DGridTemplate_double_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, yMin: float, yMax: float, resolutionXY: float, resolutionPhi: float, phiMin: float, phiMax: float) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFGrid) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFGrid) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPosePDFGrid: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose2D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t,CPose2D]: ...
    @overload
    def getMean(self, mean_pose: CPose2D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    @overload
    def inverse(self, o: CPosePDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def normalize(self) -> None: ...
    @overload
    def normalize() -> void: ...
    @overload
    def saveToTextFile(self, dataFile: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    @overload
    def uniformDistribution(self) -> None: ...
    @overload
    def uniformDistribution() -> void: ...

class CPosePDFParticles(CPosePDF, mrpt.pymrpt.mrpt.bayes.CParticleFilterData_mrpt_math_TPose2D_mrpt_bayes_particle_storage_mode_VALUE_t, mrpt.pymrpt.mrpt.bayes.CParticleFilterDataImpl_mrpt_poses_CPosePDFParticles_std_deque_mrpt_bayes_CProbabilityParticle_mrpt_math_TPose2D_mrpt_bayes_particle_storage_mode_VALUE_t, mrpt.pymrpt.mrpt.Stringifyable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, M: int) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFParticles) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFParticles) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def append(self, o: CPosePDFParticles) -> None: ...
    @overload
    def append(classmrpt) -> void: ...
    def asString(self) -> str: ...
    def assign(self) -> CPosePDFParticles: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose2D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    def evaluatePDF_parzen(self, x: float, y: float, phi: float, stdXY: float, stdPhi: float) -> float: ...
    def getCovarianceAndMean(self, *args, **kwargs) -> Any: ...
    @overload
    def getMean(self, mean_pose: CPose2D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getMostLikelyParticle(self) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    def getParticlePose(self, i: int) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    @overload
    def inverse(self, o: CPosePDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def resetDeterministic(self, location: mrpt.pymrpt.mrpt.math.TPose2D) -> None: ...
    @overload
    def resetDeterministic(self, location: mrpt.pymrpt.mrpt.math.TPose2D, particlesCount: int) -> None: ...
    @overload
    def resetDeterministic(conststructmrpt, size_t) -> void: ...
    @overload
    def resetUniform(self, x_min: float, x_max: float, y_min: float, y_max: float) -> None: ...
    @overload
    def resetUniform(self, x_min: float, x_max: float, y_min: float, y_max: float, phi_min: float) -> None: ...
    @overload
    def resetUniform(self, x_min: float, x_max: float, y_min: float, y_max: float, phi_min: float, phi_max: float) -> None: ...
    @overload
    def resetUniform(self, x_min: float, x_max: float, y_min: float, y_max: float, phi_min: float, phi_max: float, particlesCount: int) -> None: ...
    def saveParzenPDFToTextFile(self, fileName: str, x_min: float, x_max: float, y_min: float, y_max: float, phi: float, stepSizeXY: float, stdXY: float, stdPhi: float) -> None: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def __iadd__(self, Ap: mrpt.pymrpt.mrpt.math.TPose2D) -> None: ...

class CPosePDFSOG(CPosePDF):
    class TGaussianMode:
        cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t
        log_w: float
        mean: CPose2D
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPosePDFSOG.TGaussianMode) -> None: ...
        def assign(self) -> CPosePDFSOG.TGaussianMode: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, nModes: int) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFSOG) -> None: ...
    @overload
    def __init__(self, arg0: CPosePDFSOG) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPosePDFSOG: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: CPosePDF, p2: CPosePDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: CPosePDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outPart: CPose2D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def evaluateNormalizedPDF(self, x: CPose2D) -> float: ...
    @overload
    def evaluateNormalizedPDF(constclassmrpt) -> double: ...
    @overload
    def evaluatePDF(self, x: CPose2D) -> float: ...
    @overload
    def evaluatePDF(self, x: CPose2D, sumOverAllPhis: bool) -> float: ...
    @overload
    def evaluatePDF(constclassmrpt, bool) -> double: ...
    @overload
    def evaluatePDFInArea(self, x_min: float, x_max: float, y_min: float, y_max: float, resolutionXY: float, phi: float, outMatrix: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t) -> None: ...
    @overload
    def evaluatePDFInArea(self, x_min: float, x_max: float, y_min: float, y_max: float, resolutionXY: float, phi: float, outMatrix: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t, sumOverAllPhis: bool) -> None: ...
    def get(self, *args, **kwargs) -> Any: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t,CPose2D]: ...
    @overload
    def getMean(self, mean_pose: CPose2D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getMostLikelyCovarianceAndMean(self, cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t, mean_point: CPose2D) -> None: ...
    @overload
    def inverse(self, o: CPosePDF) -> None: ...
    @overload
    def inverse(classmrpt) -> void: ...
    @overload
    def mergeModes(self) -> None: ...
    @overload
    def mergeModes(self, max_KLd: float) -> None: ...
    @overload
    def mergeModes(self, max_KLd: float, verbose: bool) -> None: ...
    @overload
    def mergeModes(double, bool) -> void: ...
    @overload
    def normalizeWeights(self) -> None: ...
    @overload
    def normalizeWeights() -> void: ...
    @overload
    def push_back(self, m) -> None: ...
    @overload
    def push_back(conststructmrpt) -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def rotateAllCovariances(self, ang: float) -> None: ...
    @overload
    def rotateAllCovariances(double) -> void: ...
    def saveToTextFile(self, *args, **kwargs) -> Any: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def __getitem__(self, index) -> Any: ...
    def __iadd__(self, Ap: CPose2D) -> None: ...

class CPoseRandomSampler:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPoseRandomSampler) -> None: ...
    def assign(self, o: CPoseRandomSampler) -> CPoseRandomSampler: ...
    @overload
    def drawSample(self, p: CPose2D) -> CPose2D: ...
    @overload
    def drawSample(self, p: CPose3D) -> CPose3D: ...
    @overload
    def getOriginalPDFCov2D(self, cov3x3) -> None: ...
    @overload
    def getOriginalPDFCov2D(classmrpt) -> void: ...
    @overload
    def getOriginalPDFCov3D(self, cov6x6) -> None: ...
    @overload
    def getOriginalPDFCov3D(classmrpt) -> void: ...
    def getSamplingMean2D(self, out_mean: CPose2D) -> CPose2D: ...
    def getSamplingMean3D(self, out_mean: CPose3D) -> CPose3D: ...
    @overload
    def isPrepared(self) -> bool: ...
    @overload
    def isPrepared() -> bool: ...
    @overload
    def setPosePDF(self, pdf: CPosePDF) -> None: ...
    @overload
    def setPosePDF(constclassmrpt) -> void: ...
    @overload
    def setPosePDF(self, pdf: CPose3DPDF) -> None: ...
    @overload
    def setPosePDF(constclassmrpt) -> void: ...

class CPose_mrpt_poses_CPose2D_3UL_t(CPoseOrPoint_mrpt_poses_CPose2D_3UL_t):
    @overload
    def __init__(self, arg0: CPose_mrpt_poses_CPose2D_3UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def asVectorVal(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self) -> CPose_mrpt_poses_CPose2D_3UL_t: ...
    @overload
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPose2D_3UL_t: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...

class CPose_mrpt_poses_CPose3DQuat_7UL_t(CPoseOrPoint_mrpt_poses_CPose3DQuat_7UL_t):
    @overload
    def __init__(self, arg0: CPose_mrpt_poses_CPose3DQuat_7UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def asVectorVal(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self) -> CPose_mrpt_poses_CPose3DQuat_7UL_t: ...
    @overload
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPose3DQuat_7UL_t: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...

class CPose_mrpt_poses_CPose3D_6UL_t(CPoseOrPoint_mrpt_poses_CPose3D_6UL_t):
    @overload
    def __init__(self, arg0: CPose_mrpt_poses_CPose3D_6UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def asVectorVal(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self) -> CPose_mrpt_poses_CPose3D_6UL_t: ...
    @overload
    def assign(self) -> CPoseOrPoint_mrpt_poses_CPose3D_6UL_t: ...
    def derived(self, *args, **kwargs) -> Any: ...
    def distance2DTo(self, ax: float, ay: float) -> float: ...
    def distance2DToSquare(self, ax: float, ay: float) -> float: ...
    def distance3DTo(self, ax: float, ay: float, az: float) -> float: ...
    def distance3DToSquare(self, ax: float, ay: float, az: float) -> float: ...
    @overload
    def distanceTo(self, b) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    def getHomogeneousMatrixVal(self, *args, **kwargs) -> Any: ...
    def is3DPoseOrPoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def setToNaN(self) -> None: ...
    @overload
    def setToNaN() -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def x(self, v: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x_incr(self, v: float) -> None: ...
    @overload
    def x_incr(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def y(self, v: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y_incr(self, v: float) -> None: ...
    @overload
    def y_incr(constdouble) -> void: ...

class CPoses2DSequence(mrpt.pymrpt.mrpt.serialization.CSerializable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPoses2DSequence) -> None: ...
    @overload
    def __init__(self, arg0: CPoses2DSequence) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def absolutePoseAfterAll(self) -> CPose2D: ...
    def absolutePoseOf(self, n: int) -> CPose2D: ...
    @overload
    def appendPose(self, newPose: CPose2D) -> None: ...
    @overload
    def appendPose(classmrpt) -> void: ...
    def assign(self) -> CPoses2DSequence: ...
    @overload
    def changePose(self, ind: int, inPose: CPose2D) -> None: ...
    @overload
    def changePose(unsignedint, classmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def computeTraveledDistanceAfter(self, n: int) -> float: ...
    @overload
    def computeTraveledDistanceAfter(size_t) -> double: ...
    def computeTraveledDistanceAfterAll(self, *args, **kwargs) -> Any: ...
    @overload
    def getPose(self, ind: int, outPose: CPose2D) -> None: ...
    @overload
    def getPose(unsignedint, classmrpt) -> void: ...
    @overload
    def posesCount(self) -> int: ...
    @overload
    def posesCount() -> size_t: ...

class CPoses3DSequence(mrpt.pymrpt.mrpt.serialization.CSerializable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPoses3DSequence) -> None: ...
    @overload
    def __init__(self, arg0: CPoses3DSequence) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def absolutePoseAfterAll(self) -> CPose3D: ...
    def absolutePoseOf(self, n: int) -> CPose3D: ...
    @overload
    def appendPose(self, newPose: CPose3D) -> None: ...
    @overload
    def appendPose(classmrpt) -> void: ...
    def assign(self) -> CPoses3DSequence: ...
    @overload
    def changePose(self, ind: int, inPose: CPose3D) -> None: ...
    @overload
    def changePose(unsignedint, classmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def computeTraveledDistanceAfter(self, n: int) -> float: ...
    @overload
    def computeTraveledDistanceAfter(size_t) -> double: ...
    def computeTraveledDistanceAfterAll(self, *args, **kwargs) -> Any: ...
    @overload
    def getPose(self, ind: int, outPose: CPose3D) -> None: ...
    @overload
    def getPose(unsignedint, classmrpt) -> void: ...
    @overload
    def posesCount(self) -> int: ...
    @overload
    def posesCount() -> size_t: ...

class CRobot2DPoseEstimator:
    class TOptions:
        max_localiz_age: float
        max_odometry_age: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CRobot2DPoseEstimator.TOptions) -> None: ...
        def assign(self) -> CRobot2DPoseEstimator.TOptions: ...
    params: Any
    def __init__(self) -> None: ...
    def extrapolateRobotPose(self, *args, **kwargs) -> Any: ...
    @overload
    def getCurrentEstimate(self, pose: mrpt.pymrpt.mrpt.math.TPose2D, velLocal, velGlobal) -> bool: ...
    @overload
    def getCurrentEstimate(self, pose: mrpt.pymrpt.mrpt.math.TPose2D, velLocal, velGlobal, tim_query: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> bool: ...
    def getLatestRobotPose(self, *args, **kwargs) -> Any: ...
    @overload
    def processUpdateNewOdometry(self, newGlobalOdometry: mrpt.pymrpt.mrpt.math.TPose2D, cur_tim: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> None: ...
    @overload
    def processUpdateNewOdometry(self, newGlobalOdometry: mrpt.pymrpt.mrpt.math.TPose2D, cur_tim: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, hasVelocities: bool) -> None: ...
    @overload
    def processUpdateNewOdometry(self, newGlobalOdometry: mrpt.pymrpt.mrpt.math.TPose2D, cur_tim: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, hasVelocities: bool, newRobotVelLocal) -> None: ...
    @overload
    def processUpdateNewPoseLocalization(self, newPose: mrpt.pymrpt.mrpt.math.TPose2D, tim: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> None: ...
    @overload
    def processUpdateNewPoseLocalization(conststructmrpt, mrpt) -> void: ...
    @overload
    def reset(self) -> None: ...
    @overload
    def reset() -> void: ...

class FrameLookUpStatus:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    LKUP_EXTRAPOLATION_ERROR: ClassVar[FrameLookUpStatus] = ...
    LKUP_GOOD: ClassVar[FrameLookUpStatus] = ...
    LKUP_NO_CONNECTIVITY: ClassVar[FrameLookUpStatus] = ...
    LKUP_UNKNOWN_FRAME: ClassVar[FrameLookUpStatus] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SE_average_2UL_t:
    enable_exception_on_undeterminate: bool
    def __init__(self) -> None: ...
    @overload
    def append(self, p: CPose2D) -> None: ...
    @overload
    def append(constclassmrpt) -> void: ...
    @overload
    def append(self, p: CPose2D, weight: float) -> None: ...
    @overload
    def append(constclassmrpt, constdouble) -> void: ...
    @overload
    def append(self, p: mrpt.pymrpt.mrpt.math.TPose2D, weight: float) -> None: ...
    @overload
    def append(conststructmrpt, constdouble) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def get_average(self, out_mean: CPose2D) -> None: ...
    @overload
    def get_average(classmrpt) -> void: ...

class SE_average_3UL_t:
    enable_exception_on_undeterminate: bool
    def __init__(self) -> None: ...
    @overload
    def append(self, p: CPose3D) -> None: ...
    @overload
    def append(constclassmrpt) -> void: ...
    @overload
    def append(self, p: CPose3D, weight: float) -> None: ...
    @overload
    def append(constclassmrpt, constdouble) -> void: ...
    @overload
    def append(self, p: mrpt.pymrpt.mrpt.math.TPose3D, weight: float) -> None: ...
    @overload
    def append(conststructmrpt, constdouble) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def get_average(self, out_mean: CPose3D) -> None: ...
    @overload
    def get_average(classmrpt) -> void: ...

class SO_average_2UL_t:
    enable_exception_on_undeterminate: bool
    def __init__(self) -> None: ...
    @overload
    def append(self, orientation_rad: float) -> None: ...
    @overload
    def append(constdouble) -> void: ...
    @overload
    def append(self, orientation_rad: float, weight: float) -> None: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def get_average(self) -> float: ...
    @overload
    def get_average() -> double: ...

class SO_average_3UL_t:
    enable_exception_on_undeterminate: bool
    def __init__(self) -> None: ...
    @overload
    def append(self, M: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def append(self, M: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t, weight: float) -> None: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def get_average(self) -> mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t: ...

class TConstructorFlags_Poses:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    UNINITIALIZED_POSE: ClassVar[TConstructorFlags_Poses] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TInterpolatorMethod:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    imLinear2Neig: ClassVar[TInterpolatorMethod] = ...
    imLinear4Neig: ClassVar[TInterpolatorMethod] = ...
    imLinearSlerp: ClassVar[TInterpolatorMethod] = ...
    imSSLLLL: ClassVar[TInterpolatorMethod] = ...
    imSSLSLL: ClassVar[TInterpolatorMethod] = ...
    imSpline: ClassVar[TInterpolatorMethod] = ...
    imSplineSlerp: ClassVar[TInterpolatorMethod] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

@overload
def sensor_poses_from_yaml(d: mrpt.pymrpt.mrpt.containers.yaml) -> Dict[str,CPose3D]: ...
@overload
def sensor_poses_from_yaml(d: mrpt.pymrpt.mrpt.containers.yaml, referenceFrame: str) -> Dict[str,CPose3D]: ...
def sensor_poses_from_yaml_file(*args, **kwargs) -> Any: ...
