#include "sticore.h"
#include "pdc.h"
#include "hppa.h"
#include "../malloc.h"
#include "../string.h"

#define ARTIST_VRAM_IDX 0x4a0
#define ARTIST_VRAM_BITMASK 0x5a0
#define ARTIST_VRAM_WRITE_INCR_X 0x600
#define ARTIST_VRAM_BYTE_WRITE 0x620
#define ARTIST_CMAP_ACCESS 0x18000
#define ARTIST_DST_BM_ACCESS 0x18004
#define ARTIST_SRC_BM_ACCESS 0x18008
#define ARTIST_BGCOLOR 0x18014
#define ARTIST_FGCOLOR 0x18010
#define ARTIST_BITMAP_OP 0x1801c
#define ARTIST_PLANE_BITMASK 0x18018
#define ARTIST_VRAM_DEST 0x800
#define ARTIST_VRAM_SIZE 0x804
#define ARTIST_VRAM_SRC 0x808

#define ARTIST_VRAM_SIZE_TRIGGER_WINFILL 0xa04
#define ARTIST_VRAM_DEST_TRIGGER_BLOCKMOVE 0xb00

#define __stiheader __attribute__((section(".sti.hdr")))
#define __stidata __attribute__((section(".sti.data")))
#define __stitext __attribute__((section(".sti.text")))
#define __stifont __attribute__((section(".sti.font"))) __aligned(32)

/* Don't ask - HP-UX assumes a certain order of functions
 * when it copies them to RAM. So we put the functions into
 * different sections and order them in the linker script.
 */

#define __stifunc(_name) __attribute__((section(".sti.text." _name)))

#define STI_F_EXTEND(x) ((void*)(long)(int)(x))

static const __stidata char user_data[256] __aligned(32);

static const region_t sti_region_list[STI_REGION_MAX] __stidata __aligned(32) = {
    { .region_desc = { .offset = 0, .btlb = 1, .length = 2 }, },
    { .region_desc = { .offset = (ARTIST_FB_ADDR - LASI_GFX_HPA) / 4096, .btlb = 1, .length = (ARTIST_FB_ADDR - LASI_GFX_HPA) / 4096} },
    { .region_desc = { .offset = (0xf8100000 - LASI_GFX_HPA)/ 4096, .btlb = 1, .length = ((0xf8380000-0xf8100000) / 4096), } },
    { .region_desc = { .offset = (0xf8380000 - LASI_GFX_HPA)/ 4096, .sys_only = 1, .length = 1, .last = 1, } }
};

static struct font __stifont sti_rom_font_8x16 = {
    .hdr = {
        .first_char = 0,
        .last_char = 255,
        .width = 8,
        .height = 16,
        .font_type = STI_FONT_HPROMAN8,
        .bytes_per_char = 16,
        .underline_height = 1,
        .underline_pos = 15,
    },
    .font = {
         0x00, 0x48, 0x68, 0x58, 0x48, 0x48, 0x00, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x30, 0x08, 0x70, 0x00, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x30, 0x08, 0x70, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x78, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x78, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x78, 0x00, 0x1c, 0x22, 0x22, 0x2a, 0x1c, 0x04, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x78, 0x48, 0x48, 0x00, 0x12, 0x14, 0x18, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x0e, 0x10, 0x0c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x48, 0x48, 0x78, 0x48, 0x48, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x40, 0x40, 0x40, 0x40, 0x78, 0x00, 0x1e, 0x10, 0x1c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x40, 0x00, 0x1e, 0x10, 0x1c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x40, 0x40, 0x38, 0x00, 0x1c, 0x12, 0x1c, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x30, 0x08, 0x70, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x30, 0x08, 0x70, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x48, 0x48, 0x70, 0x00, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x48, 0x48, 0x70, 0x00, 0x04, 0x0c, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x48, 0x48, 0x70, 0x0c, 0x12, 0x02, 0x0c, 0x10, 0x1e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x48, 0x48, 0x70, 0x00, 0x1c, 0x02, 0x0c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x48, 0x48, 0x70, 0x00, 0x14, 0x14, 0x1e, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x48, 0x68, 0x58, 0x48, 0x48, 0x00, 0x12, 0x14, 0x18, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x30, 0x08, 0x70, 0x00, 0x22, 0x14, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x78, 0x00, 0x1c, 0x12, 0x1c, 0x12, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x40, 0x40, 0x38, 0x00, 0x12, 0x1a, 0x16, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x78, 0x00, 0x22, 0x36, 0x2a, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x30, 0x08, 0x70, 0x00, 0x1c, 0x12, 0x1c, 0x12, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x78, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x40, 0x00, 0x0e, 0x10, 0x0c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x58, 0x48, 0x38, 0x00, 0x0e, 0x10, 0x0c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x70, 0x50, 0x48, 0x00, 0x0e, 0x10, 0x0c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x48, 0x48, 0x48, 0x48, 0x30, 0x00, 0x0e, 0x10, 0x0c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x24, 0x24, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x10, 0x38, 0x54, 0x50, 0x30, 0x18, 0x14, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x24, 0x54, 0x28, 0x08, 0x10, 0x10, 0x20, 0x24, 0x4a, 0x44, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x30, 0x48, 0x48, 0x50, 0x20, 0x50, 0x8a, 0x84, 0x8c, 0x72, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x20, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x10, 0x54, 0x38, 0x7c, 0x38, 0x54, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x10, 0x20, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x5a, 0x5a, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x08, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x0c, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x1c, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x04, 0x0c, 0x14, 0x24, 0x44, 0x7e, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7e, 0x02, 0x02, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x30, 0x30, 0x10, 0x20, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x04, 0x08, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x4e, 0x52, 0x52, 0x52, 0x4c, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x4e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x42, 0x42, 0x44, 0x48, 0x50, 0x70, 0x48, 0x44, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x42, 0x42, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x4a, 0x3c, 0x04, 0x02, 0x00, 0x00,
         0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x50, 0x48, 0x44, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7e, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,
         0x00, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x1c, 0x22, 0x20, 0x20, 0x20, 0x78, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
         0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18, 0x00,
         0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x44, 0x48, 0x50, 0x68, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x32, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0x3c, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x08, 0x10, 0x20, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x10, 0x20, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
         0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x08, 0x04, 0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x2a, 0x54, 0x2a, 0x54, 0x2a, 0x54, 0x2a, 0x54, 0x2a, 0x54, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x40, 0x40, 0x38, 0x00, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x20, 0x20, 0x20, 0x70, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x0c, 0x10, 0x16, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x20, 0x20, 0x20, 0x70, 0x00, 0x1c, 0x12, 0x1c, 0x12, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x48, 0x48, 0x48, 0x48, 0x30, 0x00, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x00, 0xff, 0x00, 0x00,
         0x00, 0x70, 0x20, 0x20, 0x20, 0x70, 0x00, 0x22, 0x22, 0x14, 0x14, 0x08, 0x00, 0xff, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x0c, 0x10, 0x16, 0x12, 0x0c, 0x00, 0xff, 0x00, 0x00,
         0x00, 0x70, 0x20, 0x20, 0x20, 0x70, 0x00, 0x1c, 0x12, 0x1c, 0x12, 0x1c, 0x00, 0xff, 0x00, 0x00,
         0x00, 0xa8, 0xa8, 0xa8, 0xa8, 0x50, 0x00, 0x12, 0x12, 0x1e, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x70, 0x50, 0x48, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x48, 0x48, 0x30, 0x10, 0x10, 0x00, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x40, 0x58, 0x48, 0x30, 0x00, 0x1c, 0x12, 0x1c, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x38, 0x40, 0x40, 0x40, 0x38, 0x00, 0x12, 0x12, 0x0c, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x88, 0xd8, 0xa8, 0x88, 0x88, 0x00, 0x0c, 0x10, 0x16, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x12, 0x14, 0x18, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x04, 0x0c, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x0c, 0x12, 0x04, 0x08, 0x1e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x1c, 0x02, 0x1c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x14, 0x14, 0x1e, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x1e, 0x10, 0x1c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x0c, 0x10, 0x1c, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x1e, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x0c, 0x12, 0x0c, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x78, 0x08, 0x30, 0x00, 0x0c, 0x12, 0x1e, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x1c, 0x12, 0x1c, 0x12, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x1c, 0x12, 0x12, 0x12, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x1e, 0x10, 0x1c, 0x10, 0x1e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x30, 0x48, 0x38, 0x08, 0x30, 0x00, 0x1e, 0x10, 0x1c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x14, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x08, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x28, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x24, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x28, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x28, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x32, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x10, 0x08, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x28, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x12, 0x10, 0x3c, 0x10, 0x3c, 0x10, 0x70, 0x91, 0x6e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x04, 0x0c, 0x04, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x02, 0x06, 0x0e, 0x1e, 0x3e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x10, 0x08, 0x10, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x42, 0x3c, 0x10, 0x08, 0x10, 0x00,
         0x32, 0x4c, 0x00, 0x42, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x10, 0x00, 0x10, 0x10, 0x10, 0x20, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x41, 0x22, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x1c, 0x22, 0x41, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x12, 0x10, 0x10, 0x3c, 0x10, 0x10, 0x70, 0x91, 0x6e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x82, 0x44, 0x28, 0x10, 0x7c, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x1c, 0x20, 0x20, 0x10, 0x18, 0x24, 0x24, 0x18, 0x08, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x07, 0x08, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x49, 0x48, 0x48, 0x49, 0x3e, 0x08, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x08, 0x14, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x08, 0x14, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x10, 0x28, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x10, 0x28, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x18, 0x24, 0x18, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x10, 0x28, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3d, 0x42, 0x46, 0x4a, 0x4a, 0x52, 0x52, 0x62, 0x42, 0xbc, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3f, 0x48, 0x48, 0x48, 0x7e, 0x48, 0x48, 0x48, 0x48, 0x4f, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x08, 0x14, 0x08, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x42, 0x4e, 0x72, 0x42, 0xbc, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x09, 0x3f, 0x48, 0x49, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x20, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x10, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x18, 0x24, 0x44, 0x48, 0x70, 0x48, 0x44, 0x44, 0x64, 0x58, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x28, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0xe2, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x02, 0x07, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x10, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x20, 0x10, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x28, 0x10, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x28, 0x10, 0x00, 0x3c, 0x40, 0x3c, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x10, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
         0x24, 0x00, 0x41, 0x41, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
         0x00, 0x00, 0x38, 0x10, 0x10, 0x1c, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1c, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x40, 0x00, 0x0c, 0x12, 0x04, 0x08, 0x1e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x40, 0x00, 0x1c, 0x02, 0x0c, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x78, 0x40, 0x70, 0x40, 0x40, 0x00, 0x14, 0x14, 0x1e, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x20, 0x20, 0x20, 0x70, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x20, 0x60, 0x22, 0x24, 0x28, 0x14, 0x2c, 0x54, 0x1e, 0x04, 0x0e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x20, 0x60, 0x22, 0x24, 0x28, 0x10, 0x2c, 0x52, 0x04, 0x08, 0x1e, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x3e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x09, 0x12, 0x24, 0x48, 0x24, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x48, 0x24, 0x12, 0x09, 0x12, 0x24, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x7e, 0x5a, 0x5a, 0x56, 0x4e, 0x56, 0x5a, 0x5a, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
    }
};

static struct font __stifont sti_rom_font_6x13 = {
    .hdr = {
        .first_char = 0,
        .last_char = 255,
        .width = 6,
        .height = 13,
        .font_type = STI_FONT_HPROMAN8,
        .bytes_per_char = 13,
        .underline_height = 1,
        .underline_pos = 12,
    },
    .font = {
         0x00, 0x90, 0xd0, 0xb0, 0x90, 0x90, 0x00, 0x48, 0x48, 0x48, 0x48, 0x30, 0x00, 0x00, 0x70, 0x80,
         0x60, 0x10, 0xe0, 0x00, 0x48, 0x48, 0x78, 0x48, 0x48, 0x00, 0x00, 0x70, 0x80, 0x60, 0x10, 0xe0,
         0x00, 0x88, 0x50, 0x20, 0x50, 0x88, 0x00, 0x00, 0xf0, 0x80, 0xe0, 0x80, 0xf0, 0x00, 0x88, 0x50,
         0x20, 0x50, 0x88, 0x00, 0x00, 0xf0, 0x80, 0xe0, 0x80, 0xf0, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20,
         0x00, 0x00, 0xf0, 0x80, 0xe0, 0x80, 0xf0, 0x00, 0x70, 0x88, 0x88, 0xa8, 0x70, 0x10, 0x00, 0x60,
         0x90, 0xf0, 0x90, 0x90, 0x00, 0x48, 0x50, 0x60, 0x50, 0x48, 0x00, 0x00, 0x00, 0x30, 0x48, 0x48,
         0x48, 0x48, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x90, 0xe0, 0x90, 0xe0, 0x00, 0x38,
         0x40, 0x30, 0x08, 0x70, 0x00, 0x00, 0x90, 0x90, 0xf0, 0x90, 0x90, 0x00, 0xf8, 0x20, 0x20, 0x20,
         0x20, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0xf0, 0x00, 0x78, 0x40, 0x70, 0x40, 0x40, 0x00, 0x00,
         0x88, 0x88, 0x50, 0x50, 0x20, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0xf0, 0x80, 0xe0,
         0x80, 0x80, 0x00, 0x78, 0x40, 0x70, 0x40, 0x40, 0x00, 0x00, 0x70, 0x80, 0x80, 0x80, 0x70, 0x00,
         0x70, 0x48, 0x70, 0x50, 0x48, 0x00, 0x00, 0x70, 0x80, 0x60, 0x10, 0xe0, 0x00, 0x30, 0x48, 0x48,
         0x48, 0x30, 0x00, 0x00, 0x70, 0x80, 0x60, 0x10, 0xe0, 0x00, 0x38, 0x10, 0x10, 0x10, 0x38, 0x00,
         0x00, 0xe0, 0x90, 0x90, 0x90, 0xe0, 0x00, 0x40, 0x40, 0x40, 0x40, 0x78, 0x00, 0x00, 0xe0, 0x90,
         0x90, 0x90, 0xe0, 0x00, 0x10, 0x30, 0x10, 0x10, 0x38, 0x00, 0x00, 0xe0, 0x90, 0x90, 0x90, 0xe0,
         0x30, 0x48, 0x08, 0x30, 0x40, 0x78, 0x00, 0x00, 0xe0, 0x90, 0x90, 0x90, 0xe0, 0x00, 0x70, 0x08,
         0x30, 0x08, 0x70, 0x00, 0x00, 0xe0, 0x90, 0x90, 0x90, 0xe0, 0x00, 0x50, 0x50, 0x78, 0x10, 0x10,
         0x00, 0x00, 0x90, 0xd0, 0xb0, 0x90, 0x90, 0x00, 0x48, 0x50, 0x60, 0x50, 0x48, 0x00, 0x00, 0x70,
         0x80, 0x60, 0x10, 0xe0, 0x00, 0x88, 0x50, 0x20, 0x20, 0x20, 0x00, 0x00, 0xf0, 0x80, 0xe0, 0x80,
         0xf0, 0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x00, 0x70, 0x80, 0x80, 0x80, 0x70, 0x00, 0x48,
         0x68, 0x58, 0x48, 0x48, 0x00, 0x00, 0xf0, 0x80, 0xe0, 0x80, 0xf0, 0x00, 0x88, 0xd8, 0xa8, 0x88,
         0x88, 0x00, 0x00, 0x70, 0x80, 0x60, 0x10, 0xe0, 0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x00,
         0xf0, 0x80, 0xe0, 0x80, 0xf0, 0x00, 0x38, 0x40, 0x40, 0x40, 0x38, 0x00, 0x00, 0xf0, 0x80, 0xe0,
         0x80, 0x80, 0x00, 0x38, 0x40, 0x30, 0x08, 0x70, 0x00, 0x00, 0x70, 0x80, 0xb0, 0x90, 0x70, 0x00,
         0x38, 0x40, 0x30, 0x08, 0x70, 0x00, 0x00, 0xe0, 0x90, 0xe0, 0xa0, 0x90, 0x00, 0x38, 0x40, 0x30,
         0x08, 0x70, 0x00, 0x00, 0x90, 0x90, 0x90, 0x90, 0x60, 0x00, 0x38, 0x40, 0x30, 0x08, 0x70, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20,
         0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x50, 0x50, 0x50, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0x50, 0x50, 0xf8, 0x50,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x70, 0xa8, 0xa0, 0x70, 0x28, 0xa8, 0x70, 0x20, 0x00, 0x00,
         0x00, 0x00, 0x48, 0xa8, 0x50, 0x10, 0x20, 0x20, 0x50, 0x68, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x20, 0x50, 0x50, 0x20, 0x60, 0x98, 0x90, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x20,
         0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x10, 0x10, 0x10, 0x20, 0x20, 0x40, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xa8, 0x70, 0x70, 0xa8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
         0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x70, 0x88, 0x98, 0xa8, 0xc8, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
         0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x08, 0x10,
         0x20, 0x40, 0x80, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x08, 0x30, 0x08, 0x08, 0x88,
         0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x50, 0x90, 0xf8, 0x10, 0x10, 0x10, 0x00, 0x00,
         0x00, 0x00, 0x00, 0xf0, 0x80, 0x80, 0xf0, 0x08, 0x08, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x70, 0x88, 0x80, 0xf0, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08,
         0x10, 0x20, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x70, 0x88, 0x88,
         0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x78, 0x08, 0x08, 0x88, 0x70, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x08,
         0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0xf8,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x40,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x08, 0x10, 0x20, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x70, 0x98, 0xa8, 0xa8, 0x90, 0x80, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
         0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x88, 0x88, 0xf0,
         0x88, 0x88, 0x88, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x80, 0x80, 0x80, 0x80, 0x88,
         0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xf0, 0x00, 0x00,
         0x00, 0x00, 0x00, 0xf8, 0x80, 0x80, 0xf0, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,
         0xf8, 0x80, 0x80, 0xe0, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x80,
         0x80, 0x98, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0xf8, 0x88, 0x88,
         0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x90, 0x60, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x88, 0x90, 0xa0, 0xc0, 0xa0, 0x90, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
         0x80, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0xd8, 0xa8, 0x88,
         0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xc8, 0xc8, 0xa8, 0xa8, 0x98, 0x98, 0x88,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00,
         0x00, 0x00, 0xf0, 0x88, 0x88, 0xf0, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
         0x88, 0x88, 0x88, 0x88, 0x88, 0xa8, 0x70, 0x10, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x88, 0x88, 0xf0,
         0xa0, 0x90, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x80, 0x70, 0x08, 0x08, 0x88,
         0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x88, 0x88, 0x88, 0x50, 0x50, 0x50, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88,
         0x88, 0xa8, 0xd8, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x50, 0x20, 0x20, 0x50,
         0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x50, 0x20, 0x20, 0x20, 0x20, 0x00,
         0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x10, 0x20, 0x40, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
         0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x00, 0x00, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08,
         0x08, 0x08, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x50, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00,
         0x00, 0x40, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x70, 0x08, 0x78, 0x88, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0xf0,
         0x88, 0x88, 0x88, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x80, 0x80, 0x80,
         0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x78, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0xf8, 0x80, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x30, 0x48, 0x40, 0x40, 0xe0, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x78, 0x88, 0x88, 0x88, 0x78, 0x08, 0x88, 0x70, 0x00, 0x00, 0x80, 0x80, 0x80, 0xf0, 0x88, 0x88,
         0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x60, 0x20, 0x20, 0x20, 0x70, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x88, 0x70, 0x00,
         0x00, 0x80, 0x80, 0x80, 0x90, 0xa0, 0xc0, 0xa0, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10,
         0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xa8,
         0xa8, 0xa8, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xc8, 0x88, 0x88, 0x88,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xc8, 0x88, 0x88, 0xf0, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x68, 0x98, 0x88, 0x88, 0x78, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0,
         0xc8, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x80, 0x70, 0x08,
         0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf8, 0x20, 0x20, 0x20, 0x10, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x88, 0x88, 0x50, 0x50, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0xa8, 0xa8, 0xa8, 0xa8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x50, 0x20,
         0x50, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x78, 0x08,
         0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x10, 0x20, 0x40, 0xf8, 0x00, 0x00, 0x00, 0x00,
         0x18, 0x20, 0x20, 0x20, 0x40, 0x20, 0x20, 0x20, 0x18, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20,
         0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x60, 0x10, 0x10, 0x10, 0x08, 0x10,
         0x10, 0x10, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xa0, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xa8, 0x50, 0xa8, 0x50, 0xa8, 0x50, 0xa8, 0x00, 0x00, 0x00,
         0x00, 0x70, 0x80, 0x80, 0x80, 0x70, 0x00, 0x40, 0x40, 0x40, 0x40, 0x78, 0x00, 0x00, 0xe0, 0x40,
         0x40, 0x40, 0xe0, 0x00, 0x88, 0x88, 0x50, 0x50, 0x20, 0x00, 0x00, 0xe0, 0x90, 0xe0, 0x90, 0xe0,
         0x00, 0x30, 0x40, 0x58, 0x48, 0x30, 0x00, 0x00, 0xe0, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x70, 0x48,
         0x70, 0x48, 0x70, 0x00, 0x00, 0x90, 0x90, 0x90, 0x90, 0x60, 0x00, 0x40, 0x40, 0x40, 0x40, 0x78,
         0x00, 0x00, 0xe0, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x88, 0x88, 0x50, 0x50, 0x20, 0x00, 0x00, 0xe0,
         0x90, 0xe0, 0x90, 0xe0, 0x00, 0x30, 0x40, 0x58, 0x48, 0x30, 0x00, 0x00, 0xe0, 0x40, 0x40, 0x40,
         0xe0, 0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x00, 0xa8, 0xa8, 0xa8, 0xa8, 0x50, 0x00, 0x48,
         0x48, 0x78, 0x48, 0x48, 0x00, 0x00, 0xe0, 0x90, 0xe0, 0xa0, 0x90, 0x00, 0x70, 0x48, 0x48, 0x48,
         0x70, 0x00, 0x00, 0x88, 0x50, 0x20, 0x20, 0x20, 0x00, 0x78, 0x40, 0x70, 0x40, 0x78, 0x00, 0x00,
         0x60, 0x80, 0xb0, 0x90, 0x60, 0x00, 0x70, 0x48, 0x70, 0x50, 0x48, 0x00, 0x00, 0x70, 0x80, 0x80,
         0x80, 0x70, 0x00, 0x88, 0x50, 0x20, 0x20, 0x20, 0x00, 0x00, 0xe0, 0x90, 0xe0, 0x90, 0xe0, 0x00,
         0x48, 0x48, 0x48, 0x48, 0x30, 0x00, 0x00, 0x88, 0xd8, 0xa8, 0x88, 0x88, 0x00, 0x38, 0x40, 0x58,
         0x48, 0x30, 0x00, 0x00, 0xe0, 0x90, 0xe0, 0x90, 0xe0, 0x00, 0x48, 0x50, 0x60, 0x50, 0x48, 0x00,
         0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x30, 0x48, 0x48, 0x48, 0x30, 0x00, 0x00, 0x60, 0x90,
         0x70, 0x10, 0x60, 0x00, 0x10, 0x30, 0x10, 0x10, 0x38, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60,
         0x00, 0x30, 0x48, 0x10, 0x20, 0x78, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x70, 0x08,
         0x30, 0x08, 0x70, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x50, 0x50, 0x78, 0x10, 0x10,
         0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x78, 0x40, 0x70, 0x08, 0x70, 0x00, 0x00, 0x60,
         0x90, 0x70, 0x10, 0x60, 0x00, 0x30, 0x40, 0x70, 0x48, 0x30, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10,
         0x60, 0x00, 0x78, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x30,
         0x48, 0x30, 0x48, 0x30, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x30, 0x48, 0x38, 0x08,
         0x30, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x30, 0x48, 0x78, 0x48, 0x48, 0x00, 0x00,
         0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x70, 0x48, 0x70, 0x48, 0x70, 0x00, 0x00, 0x60, 0x90, 0x70,
         0x10, 0x60, 0x00, 0x38, 0x40, 0x40, 0x40, 0x38, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00,
         0x70, 0x48, 0x48, 0x48, 0x70, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x78, 0x40, 0x70,
         0x40, 0x78, 0x00, 0x00, 0x60, 0x90, 0x70, 0x10, 0x60, 0x00, 0x78, 0x40, 0x70, 0x40, 0x40, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x00,
         0x70, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x20, 0x50, 0x00, 0x70, 0x88, 0x88,
         0xf8, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x20, 0x10, 0x00, 0xf8, 0x80, 0x80, 0xf0, 0x80, 0x80,
         0xf8, 0x00, 0x00, 0x00, 0x20, 0x50, 0x00, 0xf8, 0x80, 0x80, 0xf0, 0x80, 0x80, 0xf8, 0x00, 0x00,
         0x00, 0x00, 0x50, 0x00, 0xf8, 0x80, 0x80, 0xf0, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x00, 0x20, 0x50,
         0x00, 0x70, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x70, 0x20,
         0x20, 0x20, 0x20, 0x20, 0x70, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x10, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xa0, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x00, 0x88, 0x88, 0x88, 0x88,
         0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x20, 0x50, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70,
         0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x20, 0x78, 0xf0, 0x20, 0x60, 0xa4, 0x78, 0x00, 0x00, 0x00,
         0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00,
         0x88, 0x88, 0x50, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x00, 0x88,
         0x88, 0x88, 0x88, 0x78, 0x08, 0x88, 0x70, 0x00, 0x00, 0x30, 0x48, 0x48, 0x30, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x80, 0x80, 0x80, 0x80, 0x88, 0x70, 0x20, 0x10,
         0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x80, 0x80, 0x80, 0x78, 0x20, 0x10, 0x20, 0x50, 0xa0,
         0x00, 0x88, 0xc8, 0xa8, 0xa8, 0x98, 0x98, 0x88, 0x00, 0x00, 0x00, 0x50, 0xa0, 0x00, 0x00, 0x00,
         0xb0, 0xc8, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x20, 0x20, 0x20,
         0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x20, 0x40, 0x80, 0x88, 0x70, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x70, 0x50, 0x50, 0x70, 0x88, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x28, 0x20, 0x20, 0x78, 0x20, 0x60, 0xa4, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x50,
         0x20, 0x70, 0x20, 0x70, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x20, 0x30, 0x48, 0x48,
         0x30, 0x10, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00, 0x18, 0x20, 0x20, 0x70, 0x20, 0x20, 0x20, 0xc0,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x70, 0xa8, 0xa0, 0xa8, 0x70, 0x20, 0x00, 0x00,
         0x20, 0x50, 0x00, 0x00, 0x00, 0x70, 0x08, 0x78, 0x88, 0x78, 0x00, 0x00, 0x00, 0x20, 0x50, 0x00,
         0x00, 0x00, 0x70, 0x88, 0xf8, 0x80, 0x78, 0x00, 0x00, 0x00, 0x20, 0x50, 0x00, 0x00, 0x00, 0x70,
         0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x20, 0x50, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88,
         0x78, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x00, 0x70, 0x08, 0x78, 0x88, 0x78, 0x00, 0x00,
         0x00, 0x10, 0x20, 0x00, 0x00, 0x00, 0x70, 0x88, 0xf8, 0x80, 0x78, 0x00, 0x00, 0x00, 0x10, 0x20,
         0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x00,
         0x88, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x00, 0x70, 0x08, 0x78,
         0x88, 0x78, 0x00, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x00, 0x70, 0x88, 0xf8, 0x80, 0x78, 0x00,
         0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x40,
         0x20, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00,
         0x00, 0x70, 0x08, 0x78, 0x88, 0x78, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x70, 0x88,
         0xf8, 0x80, 0x78, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x70,
         0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00, 0x00,
         0x30, 0x30, 0x00, 0x70, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x20, 0x50, 0x00,
         0x00, 0x00, 0x60, 0x20, 0x20, 0x20, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x48, 0x58, 0x58,
         0x68, 0x68, 0x48, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xa0, 0xa0, 0xf0, 0xa0, 0xa0, 0xa0,
         0xb8, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x70, 0x08, 0x78, 0x88, 0x78, 0x00, 0x00,
         0x00, 0x10, 0x20, 0x00, 0x00, 0x00, 0x60, 0x20, 0x20, 0x20, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x34, 0x48, 0x58, 0x68, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x50, 0x28, 0x78, 0xa0, 0x78, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x70, 0x88, 0x88, 0xf8, 0x88,
         0x88, 0x88, 0x00, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x00, 0x60, 0x20, 0x20, 0x20, 0x70, 0x00,
         0x00, 0x00, 0x00, 0x50, 0x00, 0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00,
         0x50, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0xf8,
         0x80, 0x80, 0xf0, 0x80, 0x80, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x60, 0x20,
         0x20, 0x20, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48, 0x90, 0xe0, 0x90, 0x88, 0xc8, 0xb0,
         0x00, 0x00, 0x00, 0x20, 0x50, 0x00, 0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00,
         0x10, 0x20, 0x00, 0x70, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x50, 0xa0, 0x00,
         0x70, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x50, 0xa0, 0x00, 0x00, 0x00, 0x70,
         0x08, 0x78, 0x88, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x48, 0x48, 0xe8, 0x48, 0x48, 0x48,
         0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0x70, 0x90, 0x90, 0x90, 0x60, 0x00, 0x00,
         0x00, 0x10, 0x20, 0x00, 0x70, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70, 0x00, 0x00, 0x00, 0x40, 0x20,
         0x00, 0x70, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0x70, 0x88,
         0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x40, 0x20, 0x00, 0x70, 0x88, 0x88, 0x88, 0x88,
         0x88, 0x70, 0x00, 0x00, 0x00, 0x50, 0xa0, 0x00, 0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00,
         0x00, 0x00, 0x50, 0xa0, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x50,
         0x20, 0x00, 0x70, 0x88, 0x80, 0x70, 0x08, 0x88, 0x70, 0x00, 0x00, 0x00, 0x50, 0x20, 0x00, 0x00,
         0x00, 0x70, 0x80, 0x70, 0x08, 0xf0, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0x88, 0x88, 0x88, 0x88,
         0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x88, 0x88, 0x50, 0x20, 0x20, 0x20, 0x20,
         0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x78, 0x08, 0x88, 0x70,
         0x00, 0xe0, 0x40, 0x40, 0x70, 0x48, 0x70, 0x40, 0x40, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x40, 0x40, 0x70, 0x48, 0x70, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60,
         0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90, 0x90, 0xd0,
         0xa8, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xe8, 0xe8, 0x68, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00,
         0x00, 0x00, 0xe0, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x30, 0x48, 0x48, 0x48, 0x30, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xc0, 0x40, 0x48,
         0x50, 0x30, 0x70, 0xd0, 0x78, 0x10, 0x38, 0x00, 0x00, 0x40, 0xc0, 0x40, 0x48, 0x50, 0x20, 0x70,
         0xc8, 0x10, 0x20, 0x78, 0x00, 0x00, 0x00, 0x70, 0x08, 0x78, 0x88, 0x78, 0x00, 0xf8, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x70, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x28, 0x50, 0xa0, 0x50, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8,
         0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x50, 0x28, 0x50,
         0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x00, 0xf8, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xf8, 0xa8, 0x98, 0x98, 0xa8, 0xf8, 0x70, 0x00, 0x00, 0x00,
    }
};


static struct font __stifont sti_rom_font_10x20 = {
    .hdr = {
        .first_char = 0,
        .last_char = 255,
        .width = 10,
        .height = 20,
        .font_type = STI_FONT_HPROMAN8,
        .bytes_per_char = 40,
        .underline_height = 1,
        .underline_pos = 19,
    },
    .font = {
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x64, 0x00, 0x54, 0x00, 0x4c, 0x00, 0x44, 0x00,
         0x44, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x07, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,
         0x40, 0x00, 0x38, 0x00, 0x04, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80,
         0x0f, 0x80, 0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x40, 0x00, 0x38, 0x00, 0x04, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x08, 0x80, 0x05, 0x00, 0x02, 0x00, 0x02, 0x00, 0x05, 0x00, 0x08, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
         0x40, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x08, 0x80, 0x05, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x05, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x7c, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
         0x40, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80,
         0x08, 0x80, 0x08, 0x80, 0x0a, 0x80, 0x07, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x7c, 0x00, 0x44, 0x00,
         0x44, 0x00, 0x00, 0x00, 0x08, 0x80, 0x09, 0x00, 0x0a, 0x00, 0x0e, 0x00, 0x09, 0x00, 0x08, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x21, 0x00, 0x21, 0x00, 0x21, 0x00, 0x21, 0x00, 0x21, 0x00, 0x21, 0x00, 0x21, 0x00, 0x21, 0x00,
         0x61, 0x80, 0x7f, 0x80, 0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x44, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00, 0x07, 0x00, 0x00, 0x80, 0x00, 0x80, 0x0f, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00,
         0x44, 0x00, 0x7c, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x02, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x7c, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x08, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x28, 0x00, 0x10, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x02, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x08, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80,
         0x08, 0x80, 0x0f, 0x00, 0x09, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x40, 0x00, 0x38, 0x00, 0x04, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x07, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,
         0x40, 0x00, 0x38, 0x00, 0x04, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x07, 0x00, 0x02, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x78, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80, 0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x0f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x78, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x80,
         0x07, 0x00, 0x00, 0x80, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0f, 0x80, 0x01, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00,
         0x64, 0x00, 0x54, 0x00, 0x4c, 0x00, 0x44, 0x00, 0x44, 0x00, 0x00, 0x00, 0x08, 0x80, 0x09, 0x00,
         0x0a, 0x00, 0x0e, 0x00, 0x09, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x40, 0x00, 0x38, 0x00, 0x04, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80, 0x05, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
         0x40, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80,
         0x0f, 0x00, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x3c, 0x00, 0x00, 0x00, 0x08, 0x80, 0x0c, 0x80, 0x0a, 0x80, 0x09, 0x80, 0x08, 0x80, 0x08, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
         0x40, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x08, 0x80, 0x0d, 0x80,
         0x0d, 0x80, 0x0a, 0x80, 0x08, 0x80, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x40, 0x00, 0x38, 0x00, 0x04, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80, 0x0f, 0x00, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
         0x40, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x70, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00, 0x07, 0x00, 0x00, 0x80, 0x00, 0x80, 0x0f, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x4c, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00,
         0x07, 0x00, 0x00, 0x80, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00, 0x78, 0x00, 0x48, 0x00,
         0x44, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00, 0x07, 0x00, 0x00, 0x80, 0x00, 0x80, 0x0f, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00,
         0x07, 0x00, 0x00, 0x80, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
         0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x14, 0x00, 0x14, 0x00, 0x14, 0x00, 0x7f, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14, 0x00, 0x7f, 0x00,
         0x14, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x3e, 0x00, 0x49, 0x00, 0x48, 0x00,
         0x48, 0x00, 0x3e, 0x00, 0x09, 0x00, 0x09, 0x00, 0x49, 0x00, 0x3e, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
         0x48, 0x80, 0x49, 0x00, 0x49, 0x00, 0x32, 0x00, 0x04, 0x00, 0x0c, 0x00, 0x08, 0x00, 0x13, 0x00,
         0x24, 0x80, 0x24, 0x80, 0x44, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x22, 0x00, 0x22, 0x00, 0x22, 0x00, 0x14, 0x00,
         0x18, 0x00, 0x18, 0x00, 0x28, 0x00, 0x44, 0x00, 0x42, 0x80, 0x43, 0x00, 0x43, 0x00, 0x3c, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
         0x06, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00,
         0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00, 0x08, 0x00, 0x04, 0x00, 0x02, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
         0x08, 0x00, 0x04, 0x00, 0x04, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
         0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x2a, 0x00,
         0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x2a, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x04, 0x00,
         0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00,
         0x20, 0x00, 0x20, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x41, 0x80, 0x42, 0x80,
         0x44, 0x80, 0x48, 0x80, 0x50, 0x80, 0x60, 0x80, 0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
         0x18, 0x00, 0x28, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x00, 0x80, 0x00, 0x80,
         0x01, 0x00, 0x06, 0x00, 0x18, 0x00, 0x20, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00,
         0x41, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x01, 0x00, 0x0e, 0x00, 0x01, 0x00, 0x00, 0x80,
         0x00, 0x80, 0x00, 0x80, 0x41, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03, 0x00, 0x05, 0x00, 0x09, 0x00, 0x11, 0x00,
         0x21, 0x00, 0x41, 0x00, 0x7f, 0x80, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7e, 0x00, 0x01, 0x00, 0x00, 0x80, 0x00, 0x80,
         0x00, 0x80, 0x00, 0x80, 0x41, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x20, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x5e, 0x00, 0x61, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80,
         0x00, 0x80, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00,
         0x04, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x21, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x21, 0x80, 0x1e, 0x80, 0x00, 0x80,
         0x00, 0x80, 0x00, 0x80, 0x01, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x0c, 0x00,
         0x30, 0x00, 0x40, 0x00, 0x30, 0x00, 0x0c, 0x00, 0x03, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x30, 0x00, 0x0c, 0x00,
         0x03, 0x00, 0x00, 0x80, 0x03, 0x00, 0x0c, 0x00, 0x30, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00,
         0x11, 0x00, 0x20, 0x80, 0x00, 0x80, 0x00, 0x80, 0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x4e, 0x80,
         0x52, 0x80, 0x52, 0x80, 0x52, 0x80, 0x52, 0x80, 0x4d, 0x80, 0x40, 0x00, 0x21, 0x00, 0x1e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00,
         0x0c, 0x00, 0x12, 0x00, 0x12, 0x00, 0x21, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x7f, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x21, 0x00, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80,
         0x21, 0x00, 0x3e, 0x00, 0x21, 0x00, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80, 0x21, 0x00, 0x7e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x21, 0x00, 0x40, 0x80, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x21, 0x00, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80,
         0x20, 0x80, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80, 0x21, 0x00, 0x7e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x21, 0x00, 0x40, 0x80, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x43, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x7f, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
         0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x41, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80,
         0x41, 0x00, 0x42, 0x00, 0x44, 0x00, 0x48, 0x00, 0x70, 0x00, 0x60, 0x00, 0x50, 0x00, 0x48, 0x00,
         0x44, 0x00, 0x42, 0x00, 0x41, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80,
         0x61, 0x80, 0x61, 0x80, 0x61, 0x80, 0x52, 0x80, 0x52, 0x80, 0x4c, 0x80, 0x4c, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x60, 0x80, 0x60, 0x80, 0x50, 0x80, 0x50, 0x80,
         0x48, 0x80, 0x4c, 0x80, 0x44, 0x80, 0x42, 0x80, 0x42, 0x80, 0x41, 0x80, 0x41, 0x80, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x41, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x41, 0x00, 0x7e, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x4c, 0x80, 0x23, 0x00, 0x1f, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x41, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x41, 0x00, 0x7e, 0x00, 0x48, 0x00, 0x44, 0x00, 0x42, 0x00, 0x41, 0x00, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x21, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x20, 0x00, 0x1e, 0x00, 0x01, 0x00, 0x00, 0x80,
         0x00, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x21, 0x00,
         0x21, 0x00, 0x21, 0x00, 0x12, 0x00, 0x12, 0x00, 0x12, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x4c, 0x80, 0x4c, 0x80, 0x52, 0x80,
         0x52, 0x80, 0x61, 0x80, 0x61, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x21, 0x00, 0x21, 0x00, 0x12, 0x00, 0x12, 0x00,
         0x0c, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00, 0x21, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x22, 0x00, 0x14, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x80, 0x00, 0x80, 0x01, 0x00, 0x02, 0x00,
         0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
         0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x20, 0x00, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x04, 0x00, 0x04, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x41, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x0c, 0x00, 0x0c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x41, 0x00, 0x01, 0x00, 0x3f, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x5c, 0x00, 0x62, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x62, 0x00, 0x5c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
         0x1d, 0x00, 0x23, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x23, 0x00, 0x1d, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x41, 0x00, 0x7f, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x09, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x3e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x23, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x01, 0x00, 0x01, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x5e, 0x00, 0x61, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x06, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x22, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x42, 0x00, 0x44, 0x00, 0x48, 0x00, 0x50, 0x00,
         0x68, 0x00, 0x44, 0x00, 0x42, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x00, 0x49, 0x00, 0x49, 0x00, 0x49, 0x00,
         0x49, 0x00, 0x49, 0x00, 0x49, 0x00, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x5e, 0x00, 0x61, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x22, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x5c, 0x00, 0x62, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x62, 0x00, 0x5c, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x23, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x5e, 0x00, 0x61, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x41, 0x00, 0x40, 0x00, 0x3e, 0x00,
         0x01, 0x00, 0x01, 0x00, 0x41, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x3e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x09, 0x00, 0x06, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x43, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x22, 0x00, 0x14, 0x00, 0x14, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x00, 0x49, 0x00, 0x49, 0x00, 0x49, 0x00,
         0x49, 0x00, 0x49, 0x00, 0x49, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x41, 0x00, 0x22, 0x00, 0x14, 0x00, 0x08, 0x00, 0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x41, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x7f, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x7f, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x18, 0x00, 0x30, 0x00, 0x18, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
         0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x06, 0x00, 0x03, 0x00, 0x06, 0x00, 0x04, 0x00,
         0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x80,
         0x4c, 0x80, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x80,
         0x55, 0x00, 0x2a, 0x80, 0x55, 0x00, 0x2a, 0x80, 0x55, 0x00, 0x2a, 0x80, 0x55, 0x00, 0x2a, 0x80,
         0x55, 0x00, 0x2a, 0x80, 0x55, 0x00, 0x2a, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x3c, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80,
         0x08, 0x80, 0x08, 0x80, 0x05, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x44, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00, 0x08, 0x00, 0x09, 0x80, 0x08, 0x80, 0x07, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80,
         0x0f, 0x00, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x44, 0x00,
         0x38, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80,
         0x08, 0x80, 0x08, 0x80, 0x05, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x44, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00, 0x08, 0x00, 0x09, 0x80, 0x08, 0x80, 0x07, 0x00,
         0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80,
         0x0f, 0x00, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x44, 0x00, 0x54, 0x00, 0x6c, 0x00, 0x6c, 0x00,
         0x44, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x80, 0x08, 0x80, 0x08, 0x80, 0x08, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x78, 0x00, 0x48, 0x00, 0x44, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80,
         0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x44, 0x00, 0x28, 0x00, 0x10, 0x00, 0x10, 0x00,
         0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x08, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x4c, 0x00, 0x44, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80,
         0x08, 0x80, 0x0f, 0x00, 0x09, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x3c, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80, 0x05, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00,
         0x44, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00, 0x78, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80,
         0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x6c, 0x00, 0x6c, 0x00, 0x54, 0x00, 0x44, 0x00,
         0x44, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00, 0x08, 0x00, 0x09, 0x80, 0x08, 0x80, 0x07, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00,
         0x44, 0x00, 0x78, 0x00, 0x44, 0x00, 0x44, 0x00, 0x78, 0x00, 0x00, 0x00, 0x08, 0x80, 0x09, 0x00,
         0x0a, 0x00, 0x0e, 0x00, 0x09, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80, 0x0b, 0x80, 0x0e, 0x80, 0x08, 0x80, 0x07, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x00,
         0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80, 0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x0f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x80,
         0x07, 0x00, 0x00, 0x80, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0f, 0x80, 0x01, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x08, 0x00,
         0x0f, 0x00, 0x00, 0x80, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00, 0x0f, 0x00, 0x08, 0x80, 0x08, 0x80, 0x07, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x80,
         0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80, 0x07, 0x00, 0x08, 0x80, 0x08, 0x80, 0x07, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80,
         0x08, 0x80, 0x07, 0x80, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x80, 0x08, 0x80, 0x08, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80,
         0x0f, 0x00, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x07, 0x80, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x07, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x08, 0x80,
         0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00,
         0x78, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x08, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x3c, 0x00, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x08, 0x00,
         0x0e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x0c, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00, 0x21, 0x00, 0x21, 0x00, 0x40, 0x80, 0x7f, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00,
         0x21, 0x00, 0x21, 0x00, 0x40, 0x80, 0x7f, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x7f, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7f, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00,
         0x7f, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00,
         0x1c, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00,
         0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x19, 0x00, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x00, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x3f, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
         0x09, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1e, 0x00, 0x08, 0x00, 0x1e, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x28, 0x00, 0x58, 0x80, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x22, 0x00, 0x14, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x01, 0x00,
         0x01, 0x00, 0x01, 0x00, 0x22, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00,
         0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00,
         0x04, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x21, 0x00, 0x1e, 0x00, 0x04, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x19, 0x00, 0x26, 0x00, 0x00, 0x00, 0x40, 0x80, 0x60, 0x80, 0x50, 0x80, 0x50, 0x80,
         0x48, 0x80, 0x4c, 0x80, 0x44, 0x80, 0x42, 0x80, 0x42, 0x80, 0x41, 0x80, 0x41, 0x80, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x19, 0x00, 0x26, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x61, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00,
         0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x00,
         0x10, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x80, 0x11, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x2d, 0x00,
         0x12, 0x00, 0x21, 0x00, 0x21, 0x00, 0x12, 0x00, 0x2d, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
         0x09, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1e, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x28, 0x00, 0x58, 0x80, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x22, 0x00,
         0x14, 0x00, 0x7f, 0x00, 0x08, 0x00, 0x7f, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x0c, 0x00, 0x12, 0x00, 0x10, 0x00, 0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x21, 0x00, 0x11, 0x00,
         0x0a, 0x00, 0x04, 0x00, 0x02, 0x00, 0x12, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0a, 0x00, 0x08, 0x00, 0x08, 0x00, 0x3e, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x28, 0x00, 0x30, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x1e, 0x00, 0x23, 0x00, 0x44, 0x00, 0x44, 0x00,
         0x48, 0x00, 0x48, 0x00, 0x51, 0x00, 0x3e, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x00, 0x00,
         0x3e, 0x00, 0x41, 0x00, 0x01, 0x00, 0x3f, 0x00, 0x41, 0x00, 0x41, 0x00, 0x43, 0x00, 0x3d, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x41, 0x00, 0x7f, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x00, 0x00,
         0x1c, 0x00, 0x22, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00,
         0x3e, 0x00, 0x41, 0x00, 0x01, 0x00, 0x3f, 0x00, 0x41, 0x00, 0x41, 0x00, 0x43, 0x00, 0x3d, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x41, 0x00, 0x7f, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00,
         0x1c, 0x00, 0x22, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00,
         0x3e, 0x00, 0x41, 0x00, 0x01, 0x00, 0x3f, 0x00, 0x41, 0x00, 0x41, 0x00, 0x43, 0x00, 0x3d, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x41, 0x00, 0x7f, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00,
         0x1c, 0x00, 0x22, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x10, 0x00, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00,
         0x3e, 0x00, 0x41, 0x00, 0x01, 0x00, 0x3f, 0x00, 0x41, 0x00, 0x41, 0x00, 0x43, 0x00, 0x3d, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x41, 0x00, 0x7f, 0x00,
         0x40, 0x00, 0x40, 0x00, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x00, 0x00,
         0x1c, 0x00, 0x22, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00,
         0x21, 0x00, 0x21, 0x00, 0x40, 0x80, 0x7f, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x00, 0x00, 0x18, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x80, 0x21, 0x00, 0x42, 0x80, 0x42, 0x80, 0x44, 0x80,
         0x44, 0x80, 0x48, 0x80, 0x48, 0x80, 0x50, 0x80, 0x50, 0x80, 0x60, 0x80, 0x21, 0x00, 0x5e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x80,
         0x0c, 0x00, 0x0c, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14, 0x00, 0x27, 0x00, 0x3c, 0x00, 0x3c, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x44, 0x00, 0x47, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x24, 0x00, 0x24, 0x00, 0x18, 0x00, 0x00, 0x00,
         0x3e, 0x00, 0x41, 0x00, 0x01, 0x00, 0x3f, 0x00, 0x41, 0x00, 0x41, 0x00, 0x43, 0x00, 0x3d, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 0x18, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x1d, 0x00, 0x22, 0x00, 0x45, 0x00, 0x49, 0x00, 0x51, 0x00, 0x61, 0x00, 0x22, 0x00, 0x5c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x44, 0x80, 0x04, 0x80, 0x3f, 0x00,
         0x44, 0x00, 0x44, 0x00, 0x44, 0x80, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00,
         0x21, 0x00, 0x21, 0x00, 0x40, 0x80, 0x7f, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0x00, 0x00, 0x18, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x06, 0x00, 0x18, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00,
         0x40, 0x00, 0x7c, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x7f, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 0x00, 0x00, 0x18, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x22, 0x00, 0x22, 0x00, 0x22, 0x00, 0x22, 0x00,
         0x2c, 0x00, 0x22, 0x00, 0x21, 0x00, 0x21, 0x00, 0x21, 0x00, 0x21, 0x00, 0x39, 0x00, 0x66, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x00, 0x00,
         0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00,
         0x21, 0x00, 0x21, 0x00, 0x40, 0x80, 0x7f, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x26, 0x00, 0x00, 0x00,
         0x0c, 0x00, 0x0c, 0x00, 0x12, 0x00, 0x12, 0x00, 0x21, 0x00, 0x21, 0x00, 0x40, 0x80, 0x7f, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x26, 0x00, 0x00, 0x00,
         0x3e, 0x00, 0x41, 0x00, 0x01, 0x00, 0x3f, 0x00, 0x41, 0x00, 0x41, 0x00, 0x43, 0x00, 0x3d, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00,
         0x21, 0x00, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80, 0x78, 0x80, 0x20, 0x80, 0x20, 0x80,
         0x20, 0x80, 0x20, 0x80, 0x21, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x08, 0x00, 0x14, 0x00, 0x02, 0x00,
         0x1d, 0x00, 0x23, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x18, 0x00, 0x00, 0x00,
         0x1c, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x30, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x30, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x26, 0x00, 0x00, 0x00,
         0x1e, 0x00, 0x21, 0x00, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x26, 0x00, 0x00, 0x00,
         0x1c, 0x00, 0x22, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x1e, 0x00, 0x21, 0x00, 0x40, 0x00, 0x40, 0x00, 0x20, 0x00, 0x1e, 0x00, 0x01, 0x00, 0x00, 0x80,
         0x00, 0x80, 0x40, 0x80, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00, 0x00,
         0x3e, 0x00, 0x41, 0x00, 0x40, 0x00, 0x3e, 0x00, 0x01, 0x00, 0x01, 0x00, 0x41, 0x00, 0x3e, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x00, 0x00,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
         0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x22, 0x00, 0x22, 0x00,
         0x14, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x22, 0x00, 0x22, 0x00, 0x00, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00, 0x41, 0x00,
         0x41, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x22, 0x00, 0x1c, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x30, 0x00, 0x30, 0x00, 0x3e, 0x00, 0x31, 0x00,
         0x30, 0x80, 0x30, 0x80, 0x31, 0x00, 0x3e, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x78, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
         0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x3e, 0x00, 0x21, 0x00, 0x20, 0x80, 0x20, 0x80,
         0x20, 0x80, 0x21, 0x00, 0x3e, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00, 0x42, 0x00,
         0x42, 0x00, 0x42, 0x00, 0x62, 0x80, 0x5d, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x7a, 0x00, 0x7a, 0x00, 0x7a, 0x00,
         0x7a, 0x00, 0x3a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
         0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x00, 0x00, 0x07, 0x00, 0x08, 0x80,
         0x08, 0x80, 0x08, 0x80, 0x08, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
         0x60, 0x00, 0x20, 0x00, 0x20, 0x80, 0x21, 0x00, 0x72, 0x00, 0x04, 0x00, 0x09, 0x00, 0x13, 0x00,
         0x25, 0x00, 0x49, 0x00, 0x0f, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x60, 0x00, 0x20, 0x00, 0x20, 0x80, 0x21, 0x00,
         0x72, 0x00, 0x04, 0x00, 0x0b, 0x80, 0x14, 0x40, 0x20, 0x80, 0x41, 0x00, 0x02, 0x00, 0x07, 0xc0,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x1e, 0x00, 0x21, 0x00, 0x01, 0x00, 0x1f, 0x00, 0x21, 0x00, 0x23, 0x00, 0x1d, 0x00, 0x00, 0x00,
         0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x21, 0x00, 0x21, 0x00, 0x21, 0x00,
         0x21, 0x00, 0x21, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x08, 0x80, 0x11, 0x00, 0x22, 0x00, 0x44, 0x00, 0x22, 0x00, 0x11, 0x00,
         0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
         0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x22, 0x00, 0x11, 0x00, 0x08, 0x80, 0x11, 0x00, 0x22, 0x00,
         0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00,
         0x08, 0x00, 0x7f, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,
         0x7f, 0x80, 0x7f, 0x80, 0x5e, 0x80, 0x5d, 0x80, 0x5b, 0x80, 0x57, 0x80, 0x47, 0x80, 0x5b, 0x80,
         0x5d, 0x80, 0x5e, 0x80, 0x7f, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    }
};



/* font TER16x32 from Linux kernel */
static struct font __stifont sti_rom_font_16x32 = {
    .hdr = {
        .first_char = 0,
        .last_char = 255,
        .width = 16,
        .height = 32,
        .font_type = STI_FONT_HPROMAN8,
        .bytes_per_char = 2*32,
        .underline_height = 1,
        .underline_pos = 31,
    },
    .font = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x7f, 0xfc,
	0xf0, 0x1e, 0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e,
	0xee, 0xee, 0xee, 0xee, 0xe0, 0x0e, 0xe0, 0x0e,
	0xe0, 0x0e, 0xe0, 0x0e, 0xef, 0xee, 0xe7, 0xce,
	0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e, 0xf0, 0x1e,
	0x7f, 0xfc, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 1 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x7f, 0xfc,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0xe3, 0x8e, 0xe3, 0x8e, 0xff, 0xfe, 0xff, 0xfe,
	0xff, 0xfe, 0xff, 0xfe, 0xe0, 0x0e, 0xf0, 0x1e,
	0xf8, 0x3e, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0x7f, 0xfc, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 2 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x78, 0x3c, 0xfc, 0x7e, 0xfe, 0xfe, 0xff, 0xfe,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0x7f, 0xfc, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0,
	0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 3 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x80, 0x07, 0xc0, 0x0f, 0xe0,
	0x1f, 0xf0, 0x3f, 0xf8, 0x7f, 0xfc, 0xff, 0xfe,
	0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0,
	0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 4 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x0f, 0xe0,
	0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0,
	0x07, 0xc0, 0x03, 0x80, 0x3b, 0xb8, 0x7f, 0xfc,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0x7f, 0xfc, 0x3b, 0xb8, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 5 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x07, 0xc0, 0x0f, 0xe0, 0x1f, 0xf0, 0x3f, 0xf8,
	0x7f, 0xfc, 0x7f, 0xfc, 0xff, 0xfe, 0xff, 0xfe,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7b, 0xbc,
	0x3b, 0xb8, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 6 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x0f, 0xf0,
	0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 7 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f,
	0xf0, 0x0f, 0xf0, 0x0f, 0xf8, 0x1f, 0xfc, 0x3f,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 8 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x07, 0xe0, 0x0e, 0x70, 0x0c, 0x30,
	0x0c, 0x30, 0x0e, 0x70, 0x07, 0xe0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 9 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xfc, 0x3f, 0xf8, 0x1f, 0xf1, 0x8f, 0xf3, 0xcf,
	0xf3, 0xcf, 0xf1, 0x8f, 0xf8, 0x1f, 0xfc, 0x3f,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 10 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xfe, 0x03, 0xfe,
	0x00, 0x1e, 0x00, 0x3e, 0x00, 0x76, 0x00, 0xe6,
	0x01, 0xc6, 0x03, 0x86, 0x3f, 0xe0, 0x7f, 0xf0,
	0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38,
	0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78,
	0x7f, 0xf0, 0x3f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 11 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8,
	0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x7f, 0xfc, 0x7f, 0xfc, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 12 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x3f, 0xfc, 0x3f, 0xfc, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0xf8, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 13 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x7f, 0xfe,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x7f, 0xfe, 0x7f, 0xfe, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x3e,
	0xf0, 0x3c, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 14 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x73, 0x9c, 0x73, 0x9c,
	0x3b, 0xb8, 0x1f, 0xf0, 0x0f, 0xe0, 0x7c, 0x7c,
	0x7c, 0x7c, 0x0f, 0xe0, 0x1f, 0xf0, 0x3b, 0xb8,
	0x73, 0x9c, 0x73, 0x9c, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 15 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0x00, 0xf0, 0x00, 0xfc, 0x00, 0xff, 0x00,
	0xff, 0xc0, 0xff, 0xf0, 0xff, 0xfc, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xfc, 0xff, 0xf0, 0xff, 0xc0,
	0xff, 0x00, 0xfc, 0x00, 0xf0, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 16 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x00, 0x0f, 0x00, 0x3f, 0x00, 0xff,
	0x03, 0xff, 0x0f, 0xff, 0x3f, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x3f, 0xff, 0x0f, 0xff, 0x03, 0xff,
	0x00, 0xff, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 17 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0f, 0xe0, 0x1f, 0xf0, 0x3b, 0xb8, 0x73, 0x9c,
	0x63, 0x8c, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x63, 0x8c,
	0x73, 0x9c, 0x3b, 0xb8, 0x1f, 0xf0, 0x0f, 0xe0,
	0x07, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 18 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 19 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x3f, 0xfe,
	0x79, 0xce, 0x71, 0xce, 0x71, 0xce, 0x71, 0xce,
	0x71, 0xce, 0x71, 0xce, 0x79, 0xce, 0x3f, 0xce,
	0x1f, 0xce, 0x01, 0xce, 0x01, 0xce, 0x01, 0xce,
	0x01, 0xce, 0x01, 0xce, 0x01, 0xce, 0x01, 0xce,
	0x01, 0xce, 0x01, 0xce, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 20 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0xe0, 0x0f, 0xf0, 0x1e, 0x78, 0x1c, 0x38,
	0x1c, 0x00, 0x1e, 0x00, 0x0f, 0xc0, 0x0f, 0xe0,
	0x1c, 0xf0, 0x1c, 0x78, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x1e, 0x38, 0x0f, 0x38, 0x07, 0xf0,
	0x03, 0xf0, 0x00, 0x78, 0x00, 0x38, 0x1c, 0x38,
	0x1e, 0x78, 0x0f, 0xf0, 0x07, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 21 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x7f, 0xfe,
	0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe,
	0x7f, 0xfe, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 22 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0f, 0xe0, 0x1f, 0xf0, 0x3b, 0xb8, 0x73, 0x9c,
	0x63, 0x8c, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x63, 0x8c, 0x73, 0x9c, 0x3b, 0xb8,
	0x1f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 23 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0f, 0xe0, 0x1f, 0xf0, 0x3b, 0xb8, 0x73, 0x9c,
	0x63, 0x8c, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 24 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x63, 0x8c,
	0x73, 0x9c, 0x3b, 0xb8, 0x1f, 0xf0, 0x0f, 0xe0,
	0x07, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 25 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0x70,
	0x00, 0x38, 0x00, 0x1c, 0x7f, 0xfe, 0x7f, 0xfe,
	0x7f, 0xfe, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 26 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0e, 0x00,
	0x1c, 0x00, 0x38, 0x00, 0x7f, 0xfe, 0x7f, 0xfe,
	0x7f, 0xfe, 0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 27 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 28 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x60, 0x0e, 0x70, 0x1c, 0x38,
	0x38, 0x1c, 0x70, 0x0e, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x70, 0x0e, 0x38, 0x1c, 0x1c, 0x38,
	0x0e, 0x70, 0x06, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 29 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x80, 0x01, 0x80, 0x03, 0xc0, 0x03, 0xc0,
	0x07, 0xe0, 0x07, 0xe0, 0x0f, 0xf0, 0x0f, 0xf0,
	0x1f, 0xf8, 0x1f, 0xf8, 0x3f, 0xfc, 0x3f, 0xfc,
	0x7f, 0xfe, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 30 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0x7f, 0xfe,
	0x3f, 0xfc, 0x3f, 0xfc, 0x1f, 0xf8, 0x1f, 0xf8,
	0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0, 0x07, 0xe0,
	0x03, 0xc0, 0x03, 0xc0, 0x01, 0x80, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 31 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 32 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 33 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 34 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x7f, 0xfc,
	0x7f, 0xfc, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x7f, 0xfc,
	0x7f, 0xfc, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 35 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x1f, 0xf0,
	0x3f, 0xf8, 0x7b, 0xbc, 0x73, 0x9c, 0x73, 0x80,
	0x73, 0x80, 0x73, 0x80, 0x7b, 0x80, 0x3f, 0xf0,
	0x1f, 0xf8, 0x03, 0xbc, 0x03, 0x9c, 0x03, 0x9c,
	0x03, 0x9c, 0x73, 0x9c, 0x7b, 0xbc, 0x3f, 0xf8,
	0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 36 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x1c, 0x3f, 0x9c,
	0x3b, 0xb8, 0x3b, 0xb8, 0x3f, 0xf0, 0x1f, 0x70,
	0x00, 0xe0, 0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0,
	0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x07, 0x00,
	0x0e, 0xf8, 0x0f, 0xfc, 0x1d, 0xdc, 0x1d, 0xdc,
	0x39, 0xfc, 0x38, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 37 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x1f, 0xe0,
	0x38, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x70,
	0x38, 0x70, 0x1c, 0xe0, 0x0f, 0xc0, 0x0f, 0x80,
	0x1f, 0xce, 0x38, 0xee, 0x70, 0x7c, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x78, 0x7c,
	0x3f, 0xee, 0x1f, 0xce, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 38 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 39 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x07, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x07, 0x00, 0x07, 0x00, 0x03, 0x80,
	0x01, 0xc0, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 40 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x07, 0x00,
	0x03, 0x80, 0x01, 0xc0, 0x01, 0xc0, 0x00, 0xe0,
	0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0,
	0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0,
	0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 41 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x1c, 0x70,
	0x0e, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x7f, 0xfc,
	0x7f, 0xfc, 0x03, 0x80, 0x07, 0xc0, 0x0e, 0xe0,
	0x1c, 0x70, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 42 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x7f, 0xfc,
	0x7f, 0xfc, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 43 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 44 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 45 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 46 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x70, 0x00, 0x70,
	0x00, 0xe0, 0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0,
	0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x07, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x1c, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 47 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x70, 0x7c, 0x70, 0xfc, 0x71, 0xdc, 0x73, 0x9c,
	0x77, 0x1c, 0x7e, 0x1c, 0x7c, 0x1c, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 48 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0x80,
	0x0f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x1f, 0xf0, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 49 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 50 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x3c, 0x0f, 0xf8,
	0x0f, 0xf8, 0x00, 0x3c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 51 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x3c,
	0x00, 0x7c, 0x00, 0xfc, 0x01, 0xdc, 0x03, 0x9c,
	0x07, 0x1c, 0x0e, 0x1c, 0x1c, 0x1c, 0x38, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 52 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x00, 0x3c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 53 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x3f, 0xf8,
	0x78, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 54 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x38,
	0x00, 0x38, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0,
	0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 55 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8,
	0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 56 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x3c,
	0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 57 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 58 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 59 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x38,
	0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00,
	0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0, 0x00, 0x70,
	0x00, 0x38, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 60 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 61 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x1c, 0x00,
	0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
	0x00, 0xe0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
	0x1c, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 62 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 63 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x3f, 0xfc,
	0x78, 0x0e, 0x70, 0x06, 0x71, 0xfe, 0x73, 0xfe,
	0x77, 0x8e, 0x77, 0x0e, 0x77, 0x0e, 0x77, 0x0e,
	0x77, 0x0e, 0x77, 0x0e, 0x77, 0x0e, 0x77, 0x9e,
	0x73, 0xfe, 0x71, 0xf6, 0x70, 0x00, 0x78, 0x00,
	0x3f, 0xfe, 0x1f, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 64 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 65 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x38, 0x7f, 0xf0, 0x7f, 0xf0,
	0x70, 0x38, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 66 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 67 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xc0, 0x7f, 0xf0,
	0x70, 0x78, 0x70, 0x38, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x38, 0x70, 0x78,
	0x7f, 0xf0, 0x7f, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 68 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x7f, 0xe0,
	0x7f, 0xe0, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 69 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x7f, 0xe0,
	0x7f, 0xe0, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 70 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x71, 0xfc,
	0x71, 0xfc, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 71 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc,
	0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 72 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x0f, 0xe0,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 73 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x78, 0x78,
	0x3f, 0xf0, 0x1f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 74 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x0c, 0x70, 0x1c,
	0x70, 0x38, 0x70, 0x70, 0x70, 0xe0, 0x71, 0xc0,
	0x73, 0x80, 0x77, 0x00, 0x7e, 0x00, 0x7c, 0x00,
	0x7c, 0x00, 0x7e, 0x00, 0x77, 0x00, 0x73, 0x80,
	0x71, 0xc0, 0x70, 0xe0, 0x70, 0x70, 0x70, 0x38,
	0x70, 0x1c, 0x70, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 75 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 76 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x0e, 0x70, 0x0e,
	0x78, 0x1e, 0x7c, 0x3e, 0x7e, 0x7e, 0x7e, 0x7e,
	0x77, 0xee, 0x73, 0xce, 0x73, 0xce, 0x71, 0x8e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 77 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x7c, 0x1c, 0x7e, 0x1c, 0x77, 0x1c, 0x73, 0x9c,
	0x71, 0xdc, 0x70, 0xfc, 0x70, 0x7c, 0x70, 0x3c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 78 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 79 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 80 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x73, 0x9c, 0x79, 0xfc,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x38, 0x00, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 81 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x7e, 0x00, 0x77, 0x00,
	0x73, 0x80, 0x71, 0xc0, 0x70, 0xe0, 0x70, 0x70,
	0x70, 0x38, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 82 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x78, 0x00, 0x3f, 0xf0,
	0x1f, 0xf8, 0x00, 0x3c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 83 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 84 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 85 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x0e, 0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0,
	0x07, 0xc0, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 86 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x71, 0x8e, 0x73, 0xce, 0x73, 0xce, 0x77, 0xee,
	0x7e, 0x7e, 0x7e, 0x7e, 0x7c, 0x3e, 0x78, 0x1e,
	0x70, 0x0e, 0x70, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 87 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x38, 0x38, 0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70,
	0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0, 0x07, 0xc0,
	0x07, 0xc0, 0x07, 0xc0, 0x0e, 0xe0, 0x0e, 0xe0,
	0x1c, 0x70, 0x1c, 0x70, 0x38, 0x38, 0x38, 0x38,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 88 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x1c, 0x70,
	0x1c, 0x70, 0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0,
	0x07, 0xc0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 89 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x38,
	0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 90 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x0f, 0xf0,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0f, 0xf0, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 91 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x1c, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x01, 0xc0, 0x01, 0xc0, 0x00, 0xe0, 0x00, 0xe0,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 92 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x0f, 0xf0,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x0f, 0xf0, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 93 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x07, 0xc0, 0x0e, 0xe0, 0x1c, 0x70,
	0x38, 0x38, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 94 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 95 */
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 96 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 97 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 98 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 99 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 100 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 101 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0xfe,
	0x03, 0xc0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x3f, 0xf8, 0x3f, 0xf8, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 102 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x3c, 0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0x00,	/* 103 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 104 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 105 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xf8, 0x00, 0xf8, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x3c, 0x78, 0x1f, 0xf0, 0x0f, 0xe0, 0x00, 0x00,	/* 106 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x1c, 0x38, 0x38, 0x38, 0x70, 0x38, 0xe0,
	0x39, 0xc0, 0x3b, 0x80, 0x3f, 0x00, 0x3f, 0x00,
	0x3b, 0x80, 0x39, 0xc0, 0x38, 0xe0, 0x38, 0x70,
	0x38, 0x38, 0x38, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 107 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x0f, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 108 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x73, 0xbc, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 109 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 110 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 111 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x00, 0x00,	/* 112 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00,	/* 113 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x73, 0xfc, 0x77, 0xfc, 0x7e, 0x00, 0x7c, 0x00,
	0x78, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 114 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x00,
	0x70, 0x00, 0x78, 0x00, 0x3f, 0xf0, 0x1f, 0xf8,
	0x00, 0x3c, 0x00, 0x1c, 0x00, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 115 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x7f, 0xf0, 0x7f, 0xf0, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x80,
	0x03, 0xfc, 0x01, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 116 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 117 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0,
	0x07, 0xc0, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 118 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x7b, 0xbc,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 119 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x38, 0x38,
	0x1c, 0x70, 0x0e, 0xe0, 0x07, 0xc0, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x38, 0x38, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 120 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x3c, 0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0x00,	/* 121 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 122 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x03, 0xf0,
	0x07, 0x80, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x3e, 0x00,
	0x3e, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x80,
	0x03, 0xf0, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 123 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 124 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3f, 0x00,
	0x07, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x01, 0xf0,
	0x01, 0xf0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x07, 0x80,
	0x3f, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 125 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x1c, 0x3f, 0x1c, 0x77, 0x9c, 0x73, 0xdc,
	0x71, 0xf8, 0x70, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 126 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0f, 0xe0, 0x1e, 0xf0, 0x3c, 0x78, 0x78, 0x3c,
	0xf0, 0x1e, 0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e,
	0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e,
	0xff, 0xfe, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 127 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x00, 0x00,	/* 128 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 129 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 130 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 131 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 132 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 133 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x0e, 0xe0,
	0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 134 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x00, 0x00,	/* 135 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 136 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 137 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 138 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 139 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 140 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 141 */
	0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 142 */
	0x00, 0x00, 0x07, 0xc0, 0x0e, 0xe0, 0x0e, 0xe0,
	0x0e, 0xe0, 0x07, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 143 */
	0x00, 0x00, 0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x7f, 0xe0,
	0x7f, 0xe0, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 144 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7e, 0xf8, 0x7f, 0xfc, 0x03, 0x9e, 0x03, 0x8e,
	0x03, 0x8e, 0x3f, 0x8e, 0x7f, 0xfe, 0xf3, 0xfe,
	0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xf3, 0xce,
	0x7f, 0xfe, 0x3e, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 145 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x7f, 0xfe,
	0xf1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
	0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xff, 0xfe,
	0xff, 0xfe, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
	0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
	0xe1, 0xfe, 0xe1, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 146 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 147 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 148 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 149 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 150 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 151 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x3c, 0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0x00,	/* 152 */
	0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 153 */
	0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 154 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x1f, 0xf0, 0x3f, 0xf8, 0x7b, 0xbc, 0x73, 0x9c,
	0x73, 0x80, 0x73, 0x80, 0x73, 0x80, 0x73, 0x80,
	0x73, 0x80, 0x73, 0x80, 0x73, 0x9c, 0x7b, 0xbc,
	0x3f, 0xf8, 0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 155 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x0f, 0xf0,
	0x1e, 0x78, 0x1c, 0x38, 0x1c, 0x00, 0x1c, 0x00,
	0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x7f, 0xe0,
	0x7f, 0xe0, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00,
	0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 156 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x38, 0x38, 0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70,
	0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0, 0x07, 0xc0,
	0x03, 0x80, 0x03, 0x80, 0x3f, 0xf8, 0x3f, 0xf8,
	0x03, 0x80, 0x03, 0x80, 0x3f, 0xf8, 0x3f, 0xf8,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 157 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x80,
	0xe3, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
	0xe1, 0xc0, 0xe1, 0xc0, 0xe3, 0xc0, 0xff, 0xf0,
	0xff, 0x70, 0xe0, 0x70, 0xe3, 0xfe, 0xe3, 0xfe,
	0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70,
	0xe0, 0x7e, 0xe0, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 158 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x03, 0xfc,
	0x03, 0x9c, 0x03, 0x9c, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x1f, 0xf0, 0x1f, 0xf0,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x73, 0x80, 0x73, 0x80,
	0x7f, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 159 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 160 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 161 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 162 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 163 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x38, 0x3b, 0xb8,
	0x3b, 0xb8, 0x39, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 164 */
	0x00, 0x00, 0x1f, 0x38, 0x3b, 0xb8, 0x3b, 0xb8,
	0x39, 0xf0, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x7c, 0x1c, 0x7e, 0x1c, 0x77, 0x1c, 0x73, 0x9c,
	0x71, 0xdc, 0x70, 0xfc, 0x70, 0x7c, 0x70, 0x3c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 165 */
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x1f, 0xf0,
	0x00, 0x38, 0x00, 0x38, 0x0f, 0xf8, 0x1f, 0xf8,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1f, 0xf8,
	0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,
	0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 166 */
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x1f, 0xf0,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1f, 0xf0,
	0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,
	0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 167 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 168 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 169 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 170 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x3c, 0x00,
	0x7c, 0x06, 0x1c, 0x0e, 0x1c, 0x1c, 0x1c, 0x38,
	0x1c, 0x70, 0x1c, 0xe0, 0x1d, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x0e, 0xfc, 0x1d, 0xfe, 0x39, 0xce,
	0x71, 0xce, 0x60, 0x1c, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xfe, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 171 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x1e, 0x00,
	0x3e, 0x00, 0x0e, 0x00, 0x0e, 0x06, 0x0e, 0x0e,
	0x0e, 0x1c, 0x0e, 0x38, 0x0e, 0x70, 0x00, 0xe0,
	0x01, 0xce, 0x03, 0x9e, 0x07, 0x3e, 0x0e, 0x7e,
	0x1c, 0xee, 0x39, 0xce, 0x73, 0xfe, 0x63, 0xfe,
	0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 172 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 173 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xce, 0x03, 0x9c, 0x07, 0x38, 0x0e, 0x70,
	0x1c, 0xe0, 0x39, 0xc0, 0x73, 0x80, 0x73, 0x80,
	0x39, 0xc0, 0x1c, 0xe0, 0x0e, 0x70, 0x07, 0x38,
	0x03, 0x9c, 0x01, 0xce, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 174 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x73, 0x80, 0x39, 0xc0, 0x1c, 0xe0, 0x0e, 0x70,
	0x07, 0x38, 0x03, 0x9c, 0x01, 0xce, 0x01, 0xce,
	0x03, 0x9c, 0x07, 0x38, 0x0e, 0x70, 0x1c, 0xe0,
	0x39, 0xc0, 0x73, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 175 */
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,	/* 176 */
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,	/* 177 */
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,	/* 178 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 179 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0xff, 0x80, 0xff, 0x80,
	0xff, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 180 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0x03, 0x80,
	0x03, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 181 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0xfe, 0x70, 0xfe, 0x70,
	0xfe, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 182 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0xff, 0xf0,
	0xff, 0xf0, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 183 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0x03, 0x80,
	0x03, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 184 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0xfe, 0x70, 0xfe, 0x70, 0xfe, 0x70, 0x00, 0x70,
	0x00, 0x70, 0xfe, 0x70, 0xfe, 0x70, 0xfe, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 185 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 186 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xf0, 0xff, 0xf0, 0xff, 0xf0, 0x00, 0x70,
	0x00, 0x70, 0xfe, 0x70, 0xfe, 0x70, 0xfe, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 187 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0xfe, 0x70, 0xfe, 0x70, 0xfe, 0x70, 0x00, 0x70,
	0x00, 0x70, 0xff, 0xf0, 0xff, 0xf0, 0xff, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 188 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0xff, 0xf0, 0xff, 0xf0,
	0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 189 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0x03, 0x80,
	0x03, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 190 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x80, 0xff, 0x80,
	0xff, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 191 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0xff, 0x03, 0xff,
	0x03, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 192 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 193 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 194 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0xff, 0x03, 0xff,
	0x03, 0xff, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 195 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 196 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 197 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0xff, 0x03, 0xff, 0x03, 0xff, 0x03, 0x80,
	0x03, 0x80, 0x03, 0xff, 0x03, 0xff, 0x03, 0xff,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 198 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x7f, 0x0e, 0x7f,
	0x0e, 0x7f, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 199 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x00,
	0x0e, 0x00, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 200 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x7f,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 201 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 202 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 203 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x7f,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 204 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 205 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 206 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 207 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 208 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 209 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 210 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0f, 0xff, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 211 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0xff, 0x03, 0xff, 0x03, 0xff, 0x03, 0x80,
	0x03, 0x80, 0x03, 0xff, 0x03, 0xff, 0x03, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 212 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xff, 0x03, 0xff, 0x03, 0xff, 0x03, 0x80,
	0x03, 0x80, 0x03, 0xff, 0x03, 0xff, 0x03, 0xff,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 213 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x0f, 0xff,
	0x0f, 0xff, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 214 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 215 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x80,
	0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 216 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0xff, 0x80, 0xff, 0x80,
	0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 217 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x03, 0xff,
	0x03, 0xff, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 218 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 219 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 220 */
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,	/* 221 */
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,	/* 222 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 223 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xee, 0x3f, 0xfe, 0x78, 0x3c, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x78, 0x3c,
	0x3f, 0xfe, 0x1f, 0xee, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 224 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0, 0x7f, 0xf0,
	0x70, 0x78, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x70, 0x7f, 0xf0, 0x7f, 0xf0,
	0x70, 0x38, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x00, 0x00,	/* 225 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 226 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 227 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 228 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xfe, 0x3f, 0xfe, 0x78, 0xf0, 0x70, 0x78,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 229 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x3c, 0x70, 0x7c, 0x70, 0xfc,
	0x7f, 0xdc, 0x7f, 0x9c, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x00, 0x00,	/* 230 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0xc0,
	0x01, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 231 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x1f, 0xf0, 0x3f, 0xf8, 0x7b, 0xbc, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x7b, 0xbc, 0x3f, 0xf8, 0x1f, 0xf0,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 232 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x77, 0xdc,
	0x77, 0xdc, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 233 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 234 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xf0,
	0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
	0x0f, 0xe0, 0x1f, 0xf0, 0x38, 0x38, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 235 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf8,
	0x7f, 0xfc, 0xe7, 0xce, 0xe3, 0x8e, 0xe3, 0x8e,
	0xe3, 0x8e, 0xe3, 0x8e, 0xe7, 0xce, 0x7f, 0xfc,
	0x3e, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 236 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x38, 0x00, 0x38, 0x0f, 0xf0, 0x1f, 0xf8,
	0x38, 0xfc, 0x38, 0xfc, 0x39, 0xdc, 0x39, 0xdc,
	0x3b, 0x9c, 0x3b, 0x9c, 0x3f, 0x1c, 0x3f, 0x1c,
	0x1f, 0xf8, 0x0f, 0xf0, 0x1c, 0x00, 0x1c, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 237 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x07, 0xfc, 0x1f, 0xfc, 0x3c, 0x00,
	0x38, 0x00, 0x70, 0x00, 0x70, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x70, 0x00, 0x70, 0x00, 0x38, 0x00,
	0x3c, 0x00, 0x1f, 0xfc, 0x07, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 238 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x1f, 0xf0,
	0x3c, 0x78, 0x38, 0x38, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 239 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 240 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x7f, 0xfc,
	0x7f, 0xfc, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 241 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0,
	0x00, 0x70, 0x00, 0x38, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xfc, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 242 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0,
	0x00, 0x70, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xfc, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 243 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x03, 0xfc,
	0x03, 0x9c, 0x03, 0x9c, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 244 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x73, 0x80, 0x73, 0x80,
	0x7f, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 245 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 246 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x1c,
	0x7f, 0xbc, 0x7b, 0xfc, 0x70, 0xf8, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x1c, 0x7f, 0xbc, 0x7b, 0xfc,
	0x70, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 247 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0xe0, 0x1f, 0xf0, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1f, 0xf0, 0x0f, 0xe0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 248 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0, 0x07, 0xe0,
	0x07, 0xe0, 0x07, 0xe0, 0x03, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 249 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 250 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e,
	0x00, 0x3e, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x78, 0x38, 0x3c, 0x38,
	0x1e, 0x38, 0x0f, 0x38, 0x07, 0xb8, 0x03, 0xf8,
	0x01, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 251 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xe0, 0x1f, 0xf0, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 252 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0,
	0x1f, 0xf0, 0x1c, 0x70, 0x1c, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
	0x1f, 0xf0, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 253 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x1f, 0xf8,
	0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8,
	0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8,
	0x1f, 0xf8, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 254 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	/* 255 */
	}
};

static struct font * fontlist[] = {
		&sti_rom_font_8x16,
		&sti_rom_font_6x13,
		&sti_rom_font_10x20,
		&sti_rom_font_16x32
};

static const mon_tbl_desc __stidata sti_mon_table[] = {
    { .x = 1280, .y = 1024, .hz = 72, .class_vesa = 1, .index = 0 },
    { .x = 1024, .y = 768, .hz = 72, .class_vesa = 1, .index = 0 },
    { .x = 768, .y = 600, .hz = 72, .class_vesa = 1, .index = 0 },
    { .x = 640, .y = 480, .hz = 72, .class_vesa = 1, .index = 0 },
};

struct sti_rom __stiheader sti_proc_rom = {
    .type = { 0x03, 0x03, 0x03, 0x03 },
    .num_mons = ARRAY_SIZE(sti_mon_table),
    .revno = { 0x84, 0x07 },
    .graphics_id = { 0x2b4ded6d, 0x40a00499 },
};

static void __stitext write_artist(struct sti_glob_cfg *cfg,
                                   int reg, u32 val)
{
    gsc_writel(STI_F_EXTEND(cfg->region_ptrs[2] + reg), val);
}

static int __stifunc("state_mgmt") sti_state_mgmt(struct sti_state_flags *flags,
                                                  struct sti_state_inptr *in,
                                                  struct sti_state_outptr *out,
                                                  struct sti_glob_cfg *cfg)
{
    (void)flags;
    (void)in;
    (void)cfg;
    out->errno = 0;
    return 0;
}

static u32 __stifunc("block_move") sti_bmove(struct sti_blkmv_flags *flags,
                                             struct sti_blkmv_inptr *in,
                                             struct sti_blkmv_outptr *out,
                                             struct sti_glob_cfg *cfg)
{
    write_artist(cfg, ARTIST_PLANE_BITMASK, 0xffffffff);
    write_artist(cfg, ARTIST_BITMAP_OP, 0x03000300);
    write_artist(cfg, ARTIST_SRC_BM_ACCESS, 0x2ea01000);
    write_artist(cfg, ARTIST_DST_BM_ACCESS, 0x2ea01000);
    write_artist(cfg, ARTIST_FGCOLOR, in->fg_color);
    write_artist(cfg, ARTIST_BGCOLOR, in->bg_color);

    if (flags->clear) {
        write_artist(cfg, ARTIST_VRAM_DEST, (in->dest_x << 16) | (in->dest_y));
        barrier();
        write_artist(cfg, ARTIST_VRAM_SIZE_TRIGGER_WINFILL,
            (in->width << 16) | (in->height));
    } else {
        write_artist(cfg, ARTIST_VRAM_SIZE, (in->width << 16) | (in->height));
        write_artist(cfg, ARTIST_VRAM_SRC, (in->src_x << 16) | (in->src_y));
        barrier();
        write_artist(cfg, ARTIST_VRAM_DEST_TRIGGER_BLOCKMOVE,
            (in->dest_x << 16) | (in->dest_y));
    }
    out->errno = 0;
    return 0;
}

/* can not call millicode routines in STI ROM code */
static inline int inline_mul(int val, int mul)
{
    switch (mul) {
    case 7:     return (val << 3) - val;
    case 6:     return (val << 2) + (val << 1);
    case 5:     return (val << 2) + val;
    case 4:     return (val << 2);
    case 3:     return (val << 1) + val;
    case 2:     return (val << 1);
    case 1:     return val;
    case 0:     return 0;
    default:    return 0;
    }
}

static int __stifunc("font_unpmv") sti_font_unpmv(struct sti_font_flags *flags,
                                                  struct sti_font_inptr *in,
                                                  struct sti_font_outptr *out,
                                                  struct sti_glob_cfg *cfg)
{
    struct font *font = (struct font *) ROM_EXTEND(in->font_start_addr);
    int bpc = font->hdr.bytes_per_char;
    int width = font->hdr.width;
    unsigned char *src;
    int c, y, pitch;
    (void)flags;

    /* same as: src = &font->font[in->index * bpc]; */
    c = in->index;
    y = inline_mul(c, bpc & 7);
    if (bpc & 8) y += c << 3;
    if (bpc & 16) y += c << 4;
    if (bpc & 32) y += c << 5;
    if (bpc & 64) y += c << 6;
    if (bpc & 128) y += c << 7;
    src = &font->font[y];

    write_artist(cfg, ARTIST_VRAM_IDX,
        (in->dest_y << 13) | (in->dest_x << 2));

    write_artist(cfg, ARTIST_FGCOLOR, in->fg_color);
    write_artist(cfg, ARTIST_BGCOLOR, in->bg_color);
    write_artist(cfg, ARTIST_BITMAP_OP, 0x23000300);
    write_artist(cfg, ARTIST_VRAM_BITMASK, 0xffffffff << (32 - width));
    write_artist(cfg, ARTIST_DST_BM_ACCESS, 0x2ea01000);
    write_artist(cfg, ARTIST_PLANE_BITMASK, 7);
    barrier();

    pitch = (width + 7) / 8;
    for (y = 0; y < bpc; y += pitch) {
        u32 val = 0;
        switch (pitch) {
            case 4:     val |= src[y+3] << 0;  /* fall through */
            case 3:     val |= src[y+2] << 8;  /* fall through */
            case 2:     val |= src[y+1] << 16; /* fall through */
            default:    val |= src[y+0] << 24; /* fall through */
        }
        write_artist(cfg, ARTIST_VRAM_BYTE_WRITE, val);
        barrier();
    }
    out->errno = 0;
    return 0;
}

static int __stifunc("init_graph") sti_init_graph(struct sti_init_flags *flags,
        struct sti_init_inptr *in,
        struct sti_init_outptr *out,
        struct sti_glob_cfg *cfg)
{
    u32 *cmap = STI_F_EXTEND(cfg->region_ptrs[1]);
    u32 resolution = *(u32 *)STI_F_EXTEND(cfg->region_ptrs[2] + 0x111110);

    out->errno = 0;
    if (resolution & (1 << 31)) {
        cfg->text_planes = 1;
    } else {
        cfg->text_planes = in->text_planes;
        if (cfg->text_planes < 0 || cfg->text_planes > 3)
            cfg->text_planes = 3;
    }
    out->text_planes = cfg->text_planes;

    cfg->onscreen_x = (resolution >> 16) & 0xfff;
    cfg->onscreen_y = resolution & 0xfff;
    cfg->offscreen_x = 0;
    cfg->offscreen_y = 0;
    cfg->total_x = 2048;  /* hardcoded width */
    cfg->total_y = cfg->onscreen_y;
    if (cfg->total_y < 1024)
        cfg->total_y = 1024;

    if (flags->clear) {
        /* clear screen */
        write_artist(cfg, ARTIST_VRAM_BITMASK, 0xffffffff);
        write_artist(cfg, ARTIST_FGCOLOR, 1);
        write_artist(cfg, ARTIST_BGCOLOR, 0);
        write_artist(cfg, ARTIST_VRAM_DEST, 0);
        barrier();
        write_artist(cfg, ARTIST_VRAM_SIZE_TRIGGER_WINFILL,
            (cfg->total_x << 16) | cfg->total_y);
    }

    if (flags->init_cmap_tx) {
        /* STI color map */
        write_artist(cfg, ARTIST_CMAP_ACCESS, 0x3ba0f000);
        cmap[0x100] = 0x000000; /* black */
        cmap[0x101] = 0xffffff; /* white */
        cmap[0x102] = 0xff0000; /* red */
        cmap[0x103] = 0xffff00; /* yellow */
        cmap[0x104] = 0x00ff00; /* green */
        cmap[0x105] = 0x00ffff; /* cyan */
        cmap[0x106] = 0x0000ff; /* blue */
        cmap[0x107] = 0xff00ff; /* magenta */
        write_artist(cfg, ARTIST_DST_BM_ACCESS, 0x2ea0f000);
    }
    return 0;
}

static __stifunc("self_test") int sti_self_test(struct sti_init_flags *flags,
                                                struct sti_init_inptr *in,
                                                struct sti_init_outptr *out,
                                                struct sti_glob_cfg *cfg)
{
    (void)flags;
    (void)in;
    (void)cfg;

    out->errno = 0;
    return 0;
}

static __stifunc("inq_conf") int sti_inq_conf(struct sti_conf_flags *flags,
                                              struct sti_conf_inptr *in,
                                              struct sti_conf_outptr *out,
                                              struct sti_glob_cfg *cfg)
{
    (void)in;
    (void)flags;

    out->errno = 0;
    out->onscreen_x = cfg->onscreen_x;
    out->onscreen_y = cfg->onscreen_y;
    out->total_x = cfg->total_x;
    out->total_y = cfg->total_y;
    out->bits_per_pixel = 8;
    out->bits_used = 8;
    out->planes = cfg->text_planes;
    /* attributes for GCDESCRIBE. See graphics.h and framebuf.h include files. */
    out->attributes = 0x1836;
    out->dev_name[0] = 'H';
    out->dev_name[1] = 'P';
    out->dev_name[2] = 'A';
    out->dev_name[3] = '2';
    out->dev_name[4] = '0';
    out->dev_name[5] = '8';
    out->dev_name[6] = 'L';
    out->dev_name[7] = 'C';

    switch(cfg->total_x) {
    default:
    /* default to 1280 if user gave some odd resolution */
        out->dev_name[8] = '1';
        out->dev_name[9] = '2';
        out->dev_name[10] = '8';
        out->dev_name[11] = '0';
        out->dev_name[12] = '\0';
        break;

    case 1024:
        out->dev_name[8] = '1';
        out->dev_name[9] = '0';
        out->dev_name[10] = '2';
        out->dev_name[11] = '4';
        out->dev_name[12] = '\0';
        break;

    case 800:
        out->dev_name[8] = '8';
        out->dev_name[9] = '0';
        out->dev_name[10] = '0';
        out->dev_name[11] = '\0';
        break;

    case 640:
        out->dev_name[8] = '6';
        out->dev_name[9] = '4';
        out->dev_name[10] = '0';
        out->dev_name[11] = '\0';
        break;

    }
    return 0;
}

int __stifunc("excep_hdlr") sti_excep_hdlr(void)
{
    return 0;
}

int __stifunc("set_cm_entry") sti_set_cm_entry(struct setcm_flags *flags,
                                               struct setcm_inptr *in,
                                               struct setcm_outptr *out,
                                               struct sti_glob_cfg *cfg)
{
    u32 *cmap = STI_F_EXTEND(cfg->region_ptrs[1]);
    (void)flags;
    (void)cfg;

    cmap[in->entry & 0xffff] = in->value;
    out->errno = 0;
    return 0;
}

int __stifunc("dma_ctrl") sti_dma_ctrl(void)
{
    return 0;
}

void __stifunc("end") sti_end(void)
{
}

static void update_crc(struct sti_rom *rom)
{
    u8 *c, *romend = (u8 *)rom + rom->last_addr - 2;
    u16 code = 0, poly = 0x8408, accum = 0;
    int i, j;

    for (c = (u8 *)rom, j = 0; c <= romend; c++, j++) {
        accum = (accum << 8) | (*c & 0xff);
        if (j & 1) {
            accum ^= code;
            for (i = 0; i < 16; i++) {
                /* do a left rotate */
                if (accum & 0x8000) {
                    accum = (accum << 1) | 0x0001;
                    accum ^= poly;
                } else {
                    accum <<= 1;
                }
            }
            code = accum;
        }
    }
    *(u16 *)(romend+1) = code;
}

#define STI_OFFSET(_x) ((u32)&(_x) - (u32)&_sti_rom_start)
#define STI_FONT_OFFSET(_next,_from) ((u32)(_next) - (u32)(_from))

void sti_rom_init(void)
{
    unsigned int sti_rom_size;
    extern int sti_font; /* in parisc.c, from opt/font fw_cfg option */
    struct font *font_ptr, *font_next, *font_start;
    int i;

    /* STI ROM already initialized? */
    if (sti_proc_rom.font_start)
	return;

    /* allocate first LMMIO range for STI when running on Astro */
    add_lmmio_directed_range(0x2000000, 0);

    sti_rom_size = (_sti_rom_end - _sti_rom_start) / 4096;
    if (sti_region_list[0].region_desc.length != sti_rom_size) {
        /* The STI ROM size is wrong. Try to fix it.
         * If it's not writeable, we have to patch the source code. */
        region_t *rp = (region_t *) &sti_region_list[0];
        rp->region_desc.length = sti_rom_size;
    }

    /* Swap selected font as first, then chain all. */
    if (sti_font <= 0 || sti_font > ARRAY_SIZE(fontlist))
	sti_font = 1;

    /* Swap selected font in as first font */
    font_next = fontlist[0];
    fontlist[0] = fontlist[sti_font - 1];
    fontlist[sti_font - 1] = font_next;

#define ENABLE_FONTCOPY
#ifdef ENABLE_FONTCOPY
    {
    struct font *fontlist_temp[ARRAY_SIZE(fontlist)];
    unsigned long font_size, font_addr;
    /* * The trivial swapping above breaks the sti driver on older 64-bit Linux
     * kernels which take the "next_font" pointer as unsigned int (instead of
     * signed int) and thus calculates a wrong font start address.  Avoid the crash
     * by sorting the fonts in memory. Maybe HP-UX has problems with that too?
     * A Linux kernel patch to avoid that was added in kernel 6.7.
     */
    #define FONT_SIZE(f) (sizeof(f->hdr) + f->hdr.bytes_per_char * (unsigned int)(f->hdr.last_char - f->hdr.first_char + 1))
    font_start = fontlist[0];   /* the lowest font ptr */
    for (i = 0; i < ARRAY_SIZE(fontlist); i++) {
	font_ptr = fontlist[i];
        if (font_ptr < font_start)      /* is font ptr lower? */
            font_start = font_ptr;
        font_size = FONT_SIZE(font_ptr);
        font_next = malloc_tmplow(font_size);
        memcpy(font_next, font_ptr, font_size);
        fontlist_temp[i] = font_next;
    }
    /* font_start is now starting address */
    font_addr = (unsigned long) font_start;
    for (i = 0; i < ARRAY_SIZE(fontlist); i++) {
	font_ptr = fontlist_temp[i];
        font_size = FONT_SIZE(font_ptr);
        memcpy((void *)font_addr, font_ptr, font_size);
        malloc_pfree((unsigned long) font_ptr);
        fontlist[i] = (struct font *) font_addr;
        font_addr += font_size;
        font_addr = ALIGN(font_addr, 32);
    }
    }
#endif

    /* Now chain all fonts */
    font_start = fontlist[0];
    sti_proc_rom.font_start = STI_OFFSET(*font_start);
    for (i = 0; i < ARRAY_SIZE(fontlist)-1; i++) {
	font_ptr = fontlist[i];
        if (i ==  ARRAY_SIZE(fontlist)-1) {
            /* last entry? */
            font_ptr->hdr.next_font = 0;
            continue;
        }
	font_next = fontlist[i+1];
	font_ptr->hdr.next_font = STI_FONT_OFFSET(font_next, font_start);
    }

    sti_proc_rom.last_addr = _sti_rom_end - _sti_rom_start - 1;

    sti_proc_rom.state_mgmt = STI_OFFSET(sti_state_mgmt);
    sti_proc_rom.inq_conf = STI_OFFSET(sti_inq_conf);
    sti_proc_rom.init_graph =  STI_OFFSET(sti_init_graph);
    sti_proc_rom.block_move = STI_OFFSET(sti_bmove);
    sti_proc_rom.region_list = STI_OFFSET(sti_region_list);
    sti_proc_rom.font_unpmv = STI_OFFSET(sti_font_unpmv);
    sti_proc_rom.self_test = STI_OFFSET(sti_self_test);
    sti_proc_rom.mon_tbl_addr = STI_OFFSET(sti_mon_table);
    sti_proc_rom.user_data_addr = STI_OFFSET(user_data);
    sti_proc_rom.excep_hdlr = STI_OFFSET(sti_excep_hdlr);
    sti_proc_rom.set_cm_entry = STI_OFFSET(sti_set_cm_entry);
    sti_proc_rom.dma_ctrl = STI_OFFSET(sti_dma_ctrl);
    sti_proc_rom.end = STI_OFFSET(sti_end);
    update_crc(&sti_proc_rom);
}
