# ./play.it community-maintained games collection

The codebase is maintained at [https://git.dotslashplay.it/games-community/]

Bug reports should be sent to [bugs@dotslashplay.it], and support requests to [requests@dotslashplay.it]

[https://git.dotslashplay.it/games-community/]: https://git.dotslashplay.it/games-community/
[bugs@dotslashplay.it]: mailto:bugs@dotslashplay.it
[requests@dotslashplay.it]: mailto:requests@dotslashplay.it

## Description

./play.it is a free software building native packages from installers for
Windows or Linux, mainly those sold by stores focusing on DRM-free games
distribution. The goal is that a game installed via ./play.it is
indistinguishable from a game installed via the official repositories of your
favourite distribution.

This specific repository provides game scripts that can be used with ./play.it
to install a collection of DRM-free games. It is maintained by the same team
than the ./play.it library and tools.

## Installation

### Distributions providing ./play.it

The following distributions provide installation instructions in their official documentation:

- [Debian]
- [Gentoo]
- [Ubuntu] (French article)

[Debian]: https://wiki.debian.org/Games/PlayIt#Installation
[Gentoo]: https://wiki.gentoo.org/wiki/Play.it#Installation
[Ubuntu]: https://doc.ubuntu-fr.org/play.it#installation

In most cases, these instructions should work in the same way for derivatives of these distributions.

### Installation from git

If your distribution does not already have a package for this ./play.it collection, you can
install it from this git repository.

```
git clone --branch main --depth 1 https://git.dotslashplay.it/games-community play.it-community.git
cd play.it-community.git
make install
```

## Usage

Usage instructions are provided on the main ./play.it repository:
[./play.it: Installer for DRM-free commercial games — Usage]

[./play.it: Installer for DRM-free commercial games — Usage]: https://git.dotslashplay.it/scripts/about/#usage

## Contributing

### First contribution

There is no real rule for your first contribution. You can host your updated code anywhere you like and contact us via any way described in the [Contact information] section below. It is OK to expose your updated code through GitHub or GitLab.com if you have nothing better at hand, but we would be thankful if you would instead use some hosting outside of these big silos.

[Contact information]: #contact-information

We do not enforce any workflow like merge/pull requests or any such thing. We are interested in the result of your work, not in how you got to it. So shatter your shackles, and for once take pleasure in working *however you like*! You are not even required to use git if you do not know or do not like this tool.

Please try to follow these simple guidelines, and your contribution is probably going to be accepted quickly:

- Run `make check` before submitting your code, to ensure you did not break anything by accident;
- Use tabs for indentation. No real developer would ever indent anything with spaces.

### Regular contributions

If you keep contributing on a more regular basis (sending 3 patches in the same year would already make you a regular) we can grant you direct write access to the repositories hosted at git.dotslashplay.it. This is not mandatory, if for some reason you can not or do not want to work with git you can simply keep following the "First contribution" guidelines, and forget about this whole "Regular contributions" section.

To grant you such an access we need nothing but a public SSH key, that you can send us through any way described in the [Contact information] section below.

[Contact information]: #contact-information

Once you have been granted access, you should add the following to your local SSH configuration:

```
Host git.dotslashplay.it
    Port 1962
    User gitolite3
```

You should then update the remote of your local repository, with the following command (assuming a remote named "upstream"):

```
git remote set-url --push upstream ssh://git.dotslashplay.it/games-community
```

Since these repositories are worked on by several people, there are a couple extra guidelines that you should follow:

- Your work should always be pushed to a dedicated branch, never on the main branch;
- Game script updates, including bug fixes, should be pushed to branches named with a "update/" prefix;
- Addition of new game scripts should be pushed to branches named with a "new/" prefix;
- You are allowed to push code to branches opened by other contributors, but please communicate with them if you plan to do so;
- Force push and branches deletion are not allowed, if you want a branch to be deleted please ask us to do it for you.

## Supported games

- 140
- 1365
- 6180 The Moon
- A Bewitching Revolution
- A Boy and His Blob
- A Hat in Time
- A House of Many Doors
- A Lullaby of Colors
- A Musical Story
- A Plague Tale: Innocence
- A Story About My Uncle
- A Tale of Paper: Refolded (full game and free demo)
- Accelerate
- Action Henk
- Afterdream
- Akalabeth: World of Doom
- Alan Wake’s American Nightmare
- Amnesia: The Dark Descent
- Among the Sleep
- Anarcute
- Anima: Gate of Memories
- Anodyne
- Ape Out
- Aquaria
- Aragami
- Arcanum: Of Steamworks and Magick Obscura
- Art of Fighting 2
- Ascendant
- Assassinʼs Creed
- Assault Android Cactus
- Asura
- Atone: Heart of the Elder Tree
- Aztez
- Baseball Stars 2
- Basingstoke
- Batman: Arkham series:
    - Batman: Arkham Asylum
    - Batman: Arkham City
    - Batman: Arkham Origins
    - Batman: Arkham Knight
- Battle Chef Brigade
- Beatbuddy: Tale of the Guardians
- Bee Simulator
- BFF or Die
- Binaries
- Bio Menace
- Biped
- Bit.Trip games:
    - Bit.Trip BEAT
    - Bit.Trip Runner
    - Bit.Trip Presents… Runner2: Future Legend of Rhythm Alien
    - Bit.Trip: Runner 3
- Bleed series:
    - Bleed
    - Bleed 2
- Bombshell
- Book of Demons
- Braid
- Broforce
- Brütal Legend
- Bubbles the Cat
- Butcher (full game and free demo)
- Candleman
- Capsized
- Cat Quest series:
    - Cat Quest
    - Cat Quest 2
- Cats are Liquid series:
    - A Light in the Shadows
    - A Better Place
- Celeste
- Chained Echoes
- Chronology
- Convoy
- Cook, Serve, Delicious! 2!!
- Cornerstone: The Song of Tyrim
- Costume Quest
- CrossCode (full game and free demo)
- Crossing Souls (free demo only)
- Cryptark
- Crypt of the NecroDancer:
    - Crypt of the NecroDancer
    - Amplified
- Dark Echo
- Darksiders 2
- Deadbolt
- Dead Cells:
    - Dead Cells
    - Rise of the Giant
    - The Bad Seed
- Deadlight
- Death’s Door
- Deep Sky Derelicts
- Deltarune - Chapter 1
- Dex
- Dicey Dungeons
- Dinʼs Curse
- Disney 1994 games:
    - Aladdin
    - The Jungle Book
    - The Lion King
- Divinity series:
    - Divine Divinity
    - Divinity: Original Sin
- Donʼt Starve:
    - Donʼt Starve
    - Reign of Giants
    - Shipwrecked
- Dragon Age: Origins
- Dreaming Sarah
- Duet
- Duke Nukem 3D
- Dust: An Elysian Tail
- Dustforce DX
- Earthlock
- Earthworm Jim
- Element4l
- Elephantasy
- Enter the Gungeon
- Epistory - Typing Chronicles
- Escape Goat series:
    - Escape Goat
    - Escape Goat 2
- Eschalon: Book 1
- Evan’s Remains
- Everspace
- Evoland series:
    - Evoland
    - Evoland 2, A Slight Case of Spacetime Continuum Disorder
- Fallout series:
    - Fallout
    - Fallout 2
    - Fallout: New Vegas
- Fatal Fury Special
- Feist
- Fez
- Figment series:
    - Figment
    - Figment 2: Creed Valley
- Flashout 3D: Enhanced Edition
- Flat Kingdom
- FlatOut series:
    - FlatOut
    - FlatOut 2
- Forced
- Forgotton Anne
- Fossil Echo
- Fotonica
- Four Sided Fantasy
- Ghost of a Tale
- Giana Sisters series:
    - Giana Sisters: Twisted Dreams
    - Giana Sisters: Rise of the Owlverlord
- Grip
- Gris
- Grow: Song of the Evertree
- Guide of the Butterfly
- Gun-Toting Cats
- Haimrik
- Hammerwatch
- Hand Of Fate
- Haven
- Hellblade: Senuaʼs Sacrifice
- Heroine’s Quest: The Herald of Ragnarok
- Hitman: Codename 47
- Hoa
- Hob
- Hollow Knight
- Horizon Zero Dawn
- Hotline Miami
- Hot Pot Panic
- Hounds of Valor (demo)
- Iconoclasts
- Ikenfell
- Indivisible
- Inner
- Intrusion 2
- Itorah
- Jotun
- Journey to the Savage Planet
- Just Cause 2
- Just one, must choose
- JYDGE
- Kero Blaster
- Kind Words
- Kingdom Come: Deliverance:
    - Kingdom Come: Deliverance
    - A woman's lot
    - Band of bastards
    - From the ashes
    - HD Sound pack
    - HD Texture pack
    - HD Voice pack
    - The amorous adventures of bold sir Hans Capon
    - Treasures of the past
- King of the Monsters
- Kingsway
- Knights of Pen and Paper
- Kyn
- La•Mulana
- Legend of Grimrock
- Lego Batman: The Videogame
- Lego Harry Potter: Years 1-4
- Lennaʼs Inception
- Lilaʼs Sky Ark
- Limbo
- Litil Divil
- Little Bug
- Little Nightmares 1
- Lo-Fi Room
- Lords of Xulima
- Lost Ruins
- Lost Words: Beyond the Page
- Lovers in a Dangerous Spacetime
- Mable & the Wood
- Man Oʼ War: Corsair - Warhammer Naval Battles
- Mark of the Ninja:
    - Mark of the Ninja
    - Mark of the Ninja - Special Edition
- Medieval Dynasty
- Melodyʼs Escape
- Metal Slug series:
    - Metal Slug 2
    - Metal Slug 3
- Minecraft 4K
- Minit
- Minute of Islands
- Mirrorʼs Edge
- Mobius
- Momodora: Reverie Under the Moonlight
- Monad
- Monster Sanctuary
- Moon Hunters
- Mortal Kombat series:
    - Mortal Kombat 1
    - Mortal Kombat 2
    - Mortal Kombat 3
- Museum of Mechanics: Lockpicking
- Mushroom 11
- My Memory of Us
- Oh Jeez, Oh No, My Rabbits Are Gone !!!
- My Time at Portia
- Nanotale - Typing Chronicles
- neon Drive
- Neurodeck: Psychological Deckbuilder
- Never Alone
- Neverending Nightmares
- Neverwinter Nights:
    - Neverwinter Nights
    - Neverwinter Nights: Enhanced Edition
- Nihilumbra
- Noita
- No Manʼs Sky
- NyxQuest: Kindred Spirits
- Ocean’s Heart
- Octodad Dadliest Catch
- Oddworld: Abeʼs Oddysee
- One Hand Clapping
- Ori and the Blind Forest
- Osmos
- Out of Line
- Overgrowth
- Overload
- Owlboy
- Pacapong
- Pandemonium!
- Paper Sorcerer
- Papers, Please
- Papo and Yo
- Particulars
- Pavilion
- Peck N Run
- Pendula Swing: The Complete Journey
- Phoning Home
- Pid
- Pier Solar and the Great Architects
- Pikuniku
- Pilgrims
- Pine
- Pink Heaven
- Pink Hour
- Pinstripe
- Pirates:
    - Pirates!
    - Pirates Gold
- Pixel Piracy
- Planet Alpha
- Plant Daddy
- Pokemon Insurgence
- Poly Bridge
- Potion Craft: Alchemy simulator (full game and free demo)
- Prince of Persia (2008)
- Privateer
- Project Feline
- Proteus
- Psychonauts
- Puddle
- Pulse
- Quench
- Quern - Undying Thoughts
- Quiet as a Stone
- Race The Sun:
    - Race The Sun
    - Sunrise
- Reassembly
- Rebel Galaxy
- République
- Restless Soul
- Retrace
- Retro City Rampage
- Reventure
- Risk of Rain
- Road 96
- Robin Hood: The Legend of Sherwood
- Rogue legacy
- Röki
- Sable
- Sagebrush
- Samurai Shodown 2
- Scarf
- Scarlet Hood and the Wicked Wood
- Seasons After Fall
- Secrets of Raetikon
- Sengoku 3
- Sentris
- Shantae and the Pirateʼs Curse
- Shelter series:
    - Shelter
    - Shelter 2
    - Paws: A Shelter 2 Game
- Shovel Knight: Treasure Trove
- Six Cats Under
- Skyshineʼs Bedlam
- Slay the Spire
- Slipways
- Solar 2
- Solar Flux
- Solstice
- SOMA
- Sort the Court
- South Scrimshaw, Part One
- Sovereign Syndicate
- Space Tail: Every Journey Leads Home
- Spelunky
- Spiritfarer
- SpringBack
- Stargunner
- Starship Titanic
- Starship Traveller
- Star-Twine
- Star Vikings (free demo only)
- Star Wars Battlefront 2
- SteamWorld games:
    - SteamWorld Dig
    - SteamWorld Dig 2
    - SteamWorld Heist
    - SteamWorld Quest
- Steel Rats
- Sticky Business
- Stories: The Path of Destinies
- Strafe
- Strike Suit Zero
- Summer in Mara
- Sunblaze
- Sundered
- Sunlight
- Superhot
- Super Meat Boy
- Supercow
- Symphonia
- Symphony
- System Shock 2
- Tag: The Power of Paint
- Tales of the Neon Sea
- Tandem: A Tale of Shadows
- Tangledeep
- Tengami
- Terraria
- Teslagrad
- The Adventures of Shuggy
- The Aquatic Adventure of the Last Human
- The Bardʼs Tale 4
- The Binding of Isaac:
    - Rebirth
    - Afterbirth
    - Afterbirth +
    - Repentance
- The Coma
- The Council
- The Count Lucanor
- The Deer God
- The Elder Scrolls series:
    - The Elder Scrolls: Arena
    - The Elder Scrolls 2: Daggerfall
    - The Elder Scrolls 5: Skyrim
    - The Elder Scrolls 5: Skyrim - Anniversary Upgrade
- The Fall
- The Flame in the Flood
- The Girl and the Robot
- The Great Perhaps
- The Hive
- The King of Fighters 2000
- The Kingʼs Bird
- The Last Tinker: City of Colors
- The Planet Crafter
- There is no Game: Wrong Dimension
- The Search
- The Smurfs: Mission Vileaf
- The Sojourn
- The Stillness of the Wind
- The Subject
- The Swords of Ditto: Mormoʼs Curse
- The Temple of Elemental Evil
- The Warlock of Firetop Mountain
- The Westport Independent
- The Witcher series:
    - The Witcher 2: Assassins of Kings
    - The Witcher 3: Wild Hunt
- The World Begins With You
- The World Next Door
- Thief 3: Deadly Shadows
- Thomas Was Alone
- Time Loader
- Tiny and Big: Grandpaʼs Leftovers
- Tiny Hunter
- Toki Tori 2
- Toren
- Total Annihilation: Kingdoms
- Touhou series:
    - Touhou Chireiden ~ Subterranean Animism (free demo only)
    - Touhou Seirensen ~ Undefined Fantastic Object (free demo only)
    - Touhou Touhou Shinreibyou ~ Ten Desires (free demo only)
    - Touhou Kishinjou ~ Double Dealing Character (free demo only)
    - Touhou Hifuu Nightmare Diary ~ Violet Detector
    - Touhou Koumakyou ~ the Embodiment of Scarlet Devil (free demo only)
    - Touhou Kaeizuka ~ Phantasmagoria of Flower View (free demo only)
- Tower of Guns
- Townscaper
- TrackMania Nations Forever
- Trine series:
    - Trine
    - Trine 2
- Triple Triad Gold
- Tulpa
- TUNIC
- Turnip Boy Commits Tax Evasion
- Ultima 4: Quest of the Avatar
- Undertale
- unEpic
- Unsung Warriors Prologue Prologue
- Unwording
- Urtuk: The Desolation
- Utopias
- Vagrus - The Riven Realms: Prologue
- Vambrace: Cold Soul
- Vampire: The Masquerade - Redemption
- The Incredible Adventures of Van Helsing: Final Cut
- Vaporum
- Volgarr the Viking
- VVVVVV
- Wandersong
- Warhammer 40,000: Dakka Squadron
- War§ow
- We, the Revolution
- What Happened to Survey Team 4?
- Wing Commander series:
    - Wing Commander
    - Wing Commander 2
    - Wing Commander 3
- Witch Thief
- WitchWay
- Wonder Boy: The Dragon's Trap
- World to the West
- Yoku’s Island Express
- Yono and the Celestial Elephants
- Yooka Laylee
- Ys 1: Ancient Ys Vanished Omen
- Yume Nikki
- Ziggurat

## Contact information

### IRC channel

Some ./play.it developers and users can be reached on IRC, channel is `#play.it`
on network `irc.oftc.net`. The main language on this IRC channel is English, but
some of us understand French too.

### E-mail

A contact e-mail for feedback can usually be found in each ./play.it game
script. Open one of these files with any text editor to see the contact e-mail.
