// Copyright (c) 2003 by Jim Lynch.
// Copyright (c) 2010-2012,2026 by Philipp Schafft.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this software; see the file COPYING.  If not, write to
//    the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//    Boston, MA 02110-1301, USA.

#include "str-conversions.h"

#include <cstdlib>
#include <cstring>
#include <string>

long CStringToLong(const char *string)
{
    std::istringstream in(string);
    long result;

    in >> result;

    return result;
}

char *LongToNewCString(long theLong)
{
    std::ostringstream out;

    out << theLong;

    return MakeCStringCopy(out);
}

char *MakeCStringCopy(const std::string &orig)
{
    char *tmp = new char[orig.size() + 1];

    if(tmp)
    {
        strcpy(tmp, orig.c_str());
    }

    return tmp;
}

char *MakeCStringCopy(const char *orig)
{
    char *tmp = new char[strlen(orig) + 1];

    if(tmp)
    {
        strcpy(tmp, orig);
    }

    return tmp;
}

// this copies the current contents of an ostrstream to a C string
// whose bytes are allocated w/ new. (so free them w/ delete[])

char *MakeCStringCopy(const std::ostringstream &orig)
{
    std::string theStrObj = orig.str();
    const char *theStr = theStrObj.c_str();
    int stringSize = strlen(theStr);
    char *tmp = new char[stringSize + 1];

    if(tmp)
    {
        strcpy(tmp, theStr);
    }

    return tmp;
}

