import * as Ot from "@ot-builder/ot";
import { Data } from "@ot-builder/prelude";
import { CoordRectifier, GlyphReferenceRectifier } from "../interface";
export declare namespace RectifyImpl {
    function Id<R, X>(r: R, x: X): X;
    function maybeT<R, X>(rec: R, x: null | undefined | X, fn: (rec: R, x: X) => null | undefined | X): X | null | undefined;
    function maybe2T<R1, R2, X>(rec1: R1, rec2: R2, x: null | undefined | X, fn: (rec1: R1, rec2: R2, x: X) => null | undefined | X): X | null | undefined;
    function setAllT<R, X>(rec: R, xs: ReadonlySet<X>, fn: (rec: R, x: X) => null | undefined | X): Set<X> | null;
    function setSomeT<R, X>(rec: R, xs: ReadonlySet<X>, fn: (rec: R, x: X) => null | undefined | X): Set<X>;
    function listAllT<R, X>(rectifier: R, m: ReadonlyArray<X>, fn: (re: R, x: X) => null | undefined | X): X[] | null;
    function listAll2T<R1, R2, X>(rectifier1: R1, rectifier2: R2, m: ReadonlyArray<X>, fn: (r1: R1, r2: R2, x: X) => null | undefined | X): X[] | null;
    function listSomeT<R, X>(rectifier: R, m: ReadonlyArray<X>, fn: (re: R, x: X) => null | undefined | X): X[];
    function listSome2T<R1, R2, X>(rectifier1: R1, rectifier2: R2, m: ReadonlyArray<X>, fn: (re: R1, re2: R2, x: X) => null | undefined | X): X[];
    function listSparseT<R, X>(rectifier: R, m: ReadonlyArray<null | undefined | X>, fn: (re: R, x: X) => null | undefined | X): (X | null | undefined)[];
    function mapAllT<R, X, Y>(rectifier: R, m: ReadonlyMap<X, Y>, fnX: (re: R, x: X) => null | undefined | X, fnY: (re: R, y: Y) => null | undefined | Y): Map<X, Y> | null;
    function mapAllT2<R, X, Y>(rectifier: R, m: ReadonlyMap<X, Y>, fnX: (re: R, x: X) => null | undefined | X, fnY: (re: R, x1: X, y: Y) => null | undefined | Y): Map<X, Y> | null;
    function bimapSomeT<R1, R2, X, Y>(rectifier1: R1, rectifier2: R2, m: ReadonlyMap<X, Y>, fnX: (re: R1, x: X) => null | undefined | X, fnY: (re: R2, y: Y) => null | undefined | Y): Map<X, Y>;
    function bimapSome2T<R1, R2, X, Y>(rectifier1: R1, rectifier2: R2, m: ReadonlyMap<X, Y>, fnX: (re: R1, x: X) => null | undefined | X, fnY: (r1: R1, r2: R2, y: Y) => null | undefined | Y): Map<X, Y>;
    function mapSomeT<R, X, Y>(rectifier: R, m: ReadonlyMap<X, Y>, fnX: (re: R, x: X) => null | undefined | X, fnY: (re: R, y: Y) => null | undefined | Y): Map<X, Y>;
    function bimapSomeT2<R1, R2, X, Y>(rectifier1: R1, rectifier2: R2, m: ReadonlyMap<X, Y>, fnX: (re: R1, x: X) => null | undefined | X, fnY: (re: R2, x1: X, y: Y) => null | undefined | Y): Map<X, Y>;
    function mapSomeT2<R, X, Y>(rectifier: R, m: ReadonlyMap<X, Y>, fnX: (re: R, x: X) => null | undefined | X, fnY: (re: R, x1: X, y: Y) => null | undefined | Y): Map<X, Y>;
    namespace Glyph {
        function single(rectifier: GlyphReferenceRectifier, g: Ot.Glyph): Ot.Glyph | null | undefined;
        function setAll(rec: GlyphReferenceRectifier, gs: ReadonlySet<Ot.Glyph>): Set<Ot.Glyph> | null;
        function setSome(rec: GlyphReferenceRectifier, gs: ReadonlySet<Ot.Glyph>): Set<Ot.Glyph>;
        function setSomeN(rec: GlyphReferenceRectifier, gs: Data.Maybe<ReadonlySet<Ot.Glyph>>): Set<Ot.Glyph> | null;
        function listAll(rec: GlyphReferenceRectifier, gs: ReadonlyArray<Ot.Glyph>): Ot.Glyph[] | null;
        function listSome(rec: GlyphReferenceRectifier, gs: ReadonlyArray<Ot.Glyph>): Ot.Glyph[];
        function listSparse(rec: GlyphReferenceRectifier, gs: ReadonlyArray<Ot.Glyph>): (Ot.Glyph | null | undefined)[];
        function bimapAll(rec: GlyphReferenceRectifier, gm: ReadonlyMap<Ot.Glyph, Ot.Glyph>): Map<Ot.Glyph, Ot.Glyph> | null;
        function bimapSome(rec: GlyphReferenceRectifier, gm: ReadonlyMap<Ot.Glyph, Ot.Glyph>): Map<Ot.Glyph, Ot.Glyph>;
        function mapAll<X>(rec: GlyphReferenceRectifier, gm: ReadonlyMap<Ot.Glyph, X>): Map<Ot.Glyph, X> | null;
        function mapSome<X>(rec: GlyphReferenceRectifier, gm: ReadonlyMap<Ot.Glyph, X>): Map<Ot.Glyph, X>;
        function comapAll<X>(rec: GlyphReferenceRectifier, gm: ReadonlyMap<X, Ot.Glyph>): Map<X, Ot.Glyph> | null;
        function comapSome<X>(rec: GlyphReferenceRectifier, gm: ReadonlyMap<X, Ot.Glyph>): Map<X, Ot.Glyph>;
        function mapAllTX<X>(rec: GlyphReferenceRectifier, gm: ReadonlyMap<Ot.Glyph, X>, fn: (rec: GlyphReferenceRectifier, x: X) => null | undefined | X): Map<Ot.Glyph, X> | null;
        function mapSomeTX<X>(rec: GlyphReferenceRectifier, gm: ReadonlyMap<Ot.Glyph, X>, fn: (rec: GlyphReferenceRectifier, x: X) => null | undefined | X): Map<Ot.Glyph, X>;
        function mapSomeTY<R2, X>(rec: GlyphReferenceRectifier, rec2: R2, gm: ReadonlyMap<Ot.Glyph, X>, fn: (rec: R2, x: X) => null | undefined | X): Map<Ot.Glyph, X>;
        function mapSomeTY2<R2, X>(rec: GlyphReferenceRectifier, rec2: R2, gm: ReadonlyMap<Ot.Glyph, X>, fn: (rec1: GlyphReferenceRectifier, rec2: R2, x: X) => null | undefined | X): Map<Ot.Glyph, X>;
        function comapAllTY<X>(rec: GlyphReferenceRectifier, gm: ReadonlyMap<X, Ot.Glyph>, fn: (rec: GlyphReferenceRectifier, x: X) => null | undefined | X): Map<X, Ot.Glyph> | null;
        function comapSomeTY<X>(rec: GlyphReferenceRectifier, gm: ReadonlyMap<X, Ot.Glyph>, fn: (rec: GlyphReferenceRectifier, x: X) => null | undefined | X): Map<X, Ot.Glyph>;
    }
    namespace Coord {
        function list(rec: CoordRectifier, arr: ReadonlyArray<Ot.Var.Value>): Ot.Var.Value[];
    }
    namespace Elim {
        function findInSet<L>(l: null | undefined | L, ls: ReadonlySet<L>): NonNullable<L> | null;
        function findInMap<L>(l: null | undefined | L, ls: ReadonlyMap<L, L>): L | null | undefined;
        function comapSomeT<K, L, A extends unknown[]>(a: ReadonlyMap<K, L>, fn: (l: L, ...args: A) => null | undefined | L, ...args: A): Map<K, L>;
        function listSomeT<L, A extends unknown[]>(a: ReadonlyArray<L>, fn: (l: L, ...args: A) => null | undefined | L, ...args: A): L[];
        function listSome<L>(a: ReadonlyArray<null | undefined | L>, ls: ReadonlySet<L>): L[];
        function listSomeOpt<L>(a: ReadonlyArray<null | undefined | L>, ls: ReadonlySet<L>): L[] | null;
    }
    function getGlyphPoints(g: Ot.Glyph): Ot.Glyph.Point[];
}
//# sourceMappingURL=index.d.ts.map