; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -global-isel \
; RUN:     -verify-machineinstrs -stop-after=irtranslator < %s | FileCheck %s

; Passing ppc_fp128 in registers (in fp registers as f64)
define void @test_ppc_fp128_1(ppc_fp128 %a, ppc_fp128 %b, ppc_fp128 %c, ppc_fp128 %d, ppc_fp128 %e) {
  ; CHECK-LABEL: name: test_ppc_fp128_1
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $f2
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $f1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $f4
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $f3
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $f6
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $f5
  ; CHECK-NEXT:   [[MV2:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY4]](s64), [[COPY5]](s64)
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(s64) = COPY $f8
  ; CHECK-NEXT:   [[COPY7:%[0-9]+]]:_(s64) = COPY $f7
  ; CHECK-NEXT:   [[MV3:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY6]](s64), [[COPY7]](s64)
  ; CHECK-NEXT:   [[COPY8:%[0-9]+]]:_(s64) = COPY $f10
  ; CHECK-NEXT:   [[COPY9:%[0-9]+]]:_(s64) = COPY $f9
  ; CHECK-NEXT:   [[MV4:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY8]](s64), [[COPY9]](s64)
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  ret void
}

define void @test_ppc_fp128_2(i32 %a, i32 %b, ppc_fp128 %c, i32 %d) {
  ; CHECK-LABEL: name: test_ppc_fp128_2
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $f1, $f2, $x3, $x4, $x7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[COPY]](s64)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s32) = G_TRUNC [[COPY1]](s64)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $f2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $f1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY2]](s64), [[COPY3]](s64)
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK-NEXT:   [[TRUNC2:%[0-9]+]]:_(s32) = G_TRUNC [[COPY4]](s64)
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  ret void
}

define void @test_ppc_fp128_3(ppc_fp128 %a, i32 %b, ppc_fp128 %c, i32 %d, i32 %e) {
  ; CHECK-LABEL: name: test_ppc_fp128_3
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $f1, $f2, $f3, $f4, $x5, $x8, $x9
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $f2
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $f1
  ; CHECK-NEXT:   [[MV:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY]](s64), [[COPY1]](s64)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[COPY2]](s64)
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $f4
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $f3
  ; CHECK-NEXT:   [[MV1:%[0-9]+]]:_(s128) = G_MERGE_VALUES [[COPY3]](s64), [[COPY4]](s64)
  ; CHECK-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $x8
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s32) = G_TRUNC [[COPY5]](s64)
  ; CHECK-NEXT:   [[COPY6:%[0-9]+]]:_(s64) = COPY $x9
  ; CHECK-NEXT:   [[TRUNC2:%[0-9]+]]:_(s32) = G_TRUNC [[COPY6]](s64)
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  ret void
}

; Passing fp128 in registers (in vector registers)
define void @test_fp128_1(fp128 %a, fp128 %b, fp128 %c, fp128 %d, fp128 %e) {
  ; CHECK-LABEL: name: test_fp128_1
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $v2, $v3, $v4, $v5, $v6
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s128) = COPY $v2
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s128) = COPY $v3
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s128) = COPY $v4
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s128) = COPY $v5
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s128) = COPY $v6
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  ret void
}

define void @test_fp128_2(i32 %a, i32 %b, fp128 %c, i32 %d) {
  ; CHECK-LABEL: name: test_fp128_2
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $v2, $x3, $x4, $x7
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x3
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[COPY]](s64)
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x4
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s32) = G_TRUNC [[COPY1]](s64)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s128) = COPY $v2
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x7
  ; CHECK-NEXT:   [[TRUNC2:%[0-9]+]]:_(s32) = G_TRUNC [[COPY3]](s64)
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  ret void
}

define void @test_fp128_3(fp128 %a, i32 %b, fp128 %c, i32 %d, i32 %e) {
  ; CHECK-LABEL: name: test_fp128_3
  ; CHECK: bb.1.entry:
  ; CHECK-NEXT:   liveins: $v2, $v3, $x5, $x9, $x10
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(s128) = COPY $v2
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $x5
  ; CHECK-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[COPY1]](s64)
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:_(s128) = COPY $v3
  ; CHECK-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $x9
  ; CHECK-NEXT:   [[TRUNC1:%[0-9]+]]:_(s32) = G_TRUNC [[COPY3]](s64)
  ; CHECK-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $x10
  ; CHECK-NEXT:   [[TRUNC2:%[0-9]+]]:_(s32) = G_TRUNC [[COPY4]](s64)
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  ret void
}

