/* Generated by wayland-scanner 1.23.1 */

#ifndef UKUI_BLUR_V1_CLIENT_PROTOCOL_H
#define UKUI_BLUR_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ukui_blur_v1 The ukui_blur_v1 protocol
 * @section page_ifaces_ukui_blur_v1 Interfaces
 * - @subpage page_iface_ukui_blur_manager_v1 - blur object factory
 * - @subpage page_iface_ukui_blur_surface_v1 - blur object for a surface
 * @section page_copyright_ukui_blur_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 KylinSoft Co., Ltd.
 * SPDX-License-Identifier: MulanPSL-2.0
 *
 * </pre>
 */
struct ukui_blur_manager_v1;
struct ukui_blur_surface_v1;
struct wl_region;
struct wl_surface;

#ifndef UKUI_BLUR_MANAGER_V1_INTERFACE
#define UKUI_BLUR_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ukui_blur_manager_v1 ukui_blur_manager_v1
 * @section page_iface_ukui_blur_manager_v1_desc Description
 *
 * This protocol provides a way to improve visuals of translucent surfaces
 * by blurring background behind them.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_ukui_blur_manager_v1_api API
 * See @ref iface_ukui_blur_manager_v1.
 */
/**
 * @defgroup iface_ukui_blur_manager_v1 The ukui_blur_manager_v1 interface
 *
 * This protocol provides a way to improve visuals of translucent surfaces
 * by blurring background behind them.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface ukui_blur_manager_v1_interface;
#endif
#ifndef UKUI_BLUR_SURFACE_V1_INTERFACE
#define UKUI_BLUR_SURFACE_V1_INTERFACE
/**
 * @page page_iface_ukui_blur_surface_v1 ukui_blur_surface_v1
 * @section page_iface_ukui_blur_surface_v1_desc Description
 *
 * The blur object provides a way to specify a region behind a surface
 * that should be blurred by the compositor.
 *
 * If the wl_surface associated with the ukui_blur_surface_v1 object has been
 * destroyed, this object becomes inert.
 * @section page_iface_ukui_blur_surface_v1_api API
 * See @ref iface_ukui_blur_surface_v1.
 */
/**
 * @defgroup iface_ukui_blur_surface_v1 The ukui_blur_surface_v1 interface
 *
 * The blur object provides a way to specify a region behind a surface
 * that should be blurred by the compositor.
 *
 * If the wl_surface associated with the ukui_blur_surface_v1 object has been
 * destroyed, this object becomes inert.
 */
extern const struct wl_interface ukui_blur_surface_v1_interface;
#endif

#ifndef UKUI_BLUR_MANAGER_V1_ERROR_ENUM
#define UKUI_BLUR_MANAGER_V1_ERROR_ENUM
enum ukui_blur_manager_v1_error {
	/**
	 * the surface has already a blur object associated
	 */
	UKUI_BLUR_MANAGER_V1_ERROR_BLUR_EXISTS = 0,
};
#endif /* UKUI_BLUR_MANAGER_V1_ERROR_ENUM */

#define UKUI_BLUR_MANAGER_V1_DESTROY 0
#define UKUI_BLUR_MANAGER_V1_GET_BLUR 1


/**
 * @ingroup iface_ukui_blur_manager_v1
 */
#define UKUI_BLUR_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_blur_manager_v1
 */
#define UKUI_BLUR_MANAGER_V1_GET_BLUR_SINCE_VERSION 1

/** @ingroup iface_ukui_blur_manager_v1 */
static inline void
ukui_blur_manager_v1_set_user_data(struct ukui_blur_manager_v1 *ukui_blur_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_blur_manager_v1, user_data);
}

/** @ingroup iface_ukui_blur_manager_v1 */
static inline void *
ukui_blur_manager_v1_get_user_data(struct ukui_blur_manager_v1 *ukui_blur_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_blur_manager_v1);
}

static inline uint32_t
ukui_blur_manager_v1_get_version(struct ukui_blur_manager_v1 *ukui_blur_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_blur_manager_v1);
}

/**
 * @ingroup iface_ukui_blur_manager_v1
 *
 * Informs the server that the client will no longer be using this
 * protocol object. Existing objects created by this object are not
 * affected.
 */
static inline void
ukui_blur_manager_v1_destroy(struct ukui_blur_manager_v1 *ukui_blur_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_blur_manager_v1,
			 UKUI_BLUR_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_blur_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ukui_blur_manager_v1
 *
 * Instantiate an interface extension for the given wl_surface to
 * blur background behind it. If the given wl_surface already has
 * a ukui_blur_surface_v1 object associated, the blur_exists protocol
 * error will be raised.
 */
static inline struct ukui_blur_surface_v1 *
ukui_blur_manager_v1_get_blur(struct ukui_blur_manager_v1 *ukui_blur_manager_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ukui_blur_manager_v1,
			 UKUI_BLUR_MANAGER_V1_GET_BLUR, &ukui_blur_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) ukui_blur_manager_v1), 0, NULL, surface);

	return (struct ukui_blur_surface_v1 *) id;
}

#define UKUI_BLUR_SURFACE_V1_DESTROY 0
#define UKUI_BLUR_SURFACE_V1_SET_REGION 1
#define UKUI_BLUR_SURFACE_V1_SET_LEVEL 2


/**
 * @ingroup iface_ukui_blur_surface_v1
 */
#define UKUI_BLUR_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_blur_surface_v1
 */
#define UKUI_BLUR_SURFACE_V1_SET_REGION_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_blur_surface_v1
 */
#define UKUI_BLUR_SURFACE_V1_SET_LEVEL_SINCE_VERSION 1

/** @ingroup iface_ukui_blur_surface_v1 */
static inline void
ukui_blur_surface_v1_set_user_data(struct ukui_blur_surface_v1 *ukui_blur_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_blur_surface_v1, user_data);
}

/** @ingroup iface_ukui_blur_surface_v1 */
static inline void *
ukui_blur_surface_v1_get_user_data(struct ukui_blur_surface_v1 *ukui_blur_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_blur_surface_v1);
}

static inline uint32_t
ukui_blur_surface_v1_get_version(struct ukui_blur_surface_v1 *ukui_blur_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_blur_surface_v1);
}

/**
 * @ingroup iface_ukui_blur_surface_v1
 *
 * Informs the server that the client will no longer be using this
 * protocol object. The blur region will be unset on the next commit.
 */
static inline void
ukui_blur_surface_v1_destroy(struct ukui_blur_surface_v1 *ukui_blur_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_blur_surface_v1,
			 UKUI_BLUR_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_blur_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ukui_blur_surface_v1
 *
 * This request sets the region of the surface that will have its
 * background blurred.
 *
 * The blur region is specified in the surface-local coordinates.
 * The initial value for the blur region is empty. Setting the pending
 * blur region has copy semantics, and the wl_region object can be
 * destroyed immediately. A NULL wl_region causes the blur region to be
 * set to infinite.
 *
 * The blur region is double-buffered state, and will be applied on
 * the next wl_surface.commit.
 *
 * The blur algorithm is subject to compositor policies.
 */
static inline void
ukui_blur_surface_v1_set_region(struct ukui_blur_surface_v1 *ukui_blur_surface_v1, struct wl_region *region)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_blur_surface_v1,
			 UKUI_BLUR_SURFACE_V1_SET_REGION, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_blur_surface_v1), 0, region);
}

/**
 * @ingroup iface_ukui_blur_surface_v1
 *
 * Change blur algorithm level in compositor.
 * The range of level is 1 to 15.
 * The compositor default blur algorithm level is 5.
 * The blur level will be applied on the next wl_surface.commit.
 */
static inline void
ukui_blur_surface_v1_set_level(struct ukui_blur_surface_v1 *ukui_blur_surface_v1, uint32_t level)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_blur_surface_v1,
			 UKUI_BLUR_SURFACE_V1_SET_LEVEL, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_blur_surface_v1), 0, level);
}

#ifdef  __cplusplus
}
#endif

#endif
