/*
 *
 * Copyright (C) 2024, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhenyu Wang <wangzhenyu@kylinos.cn>
 *
 */

#include "abstractinterface.h"
#include "kysdk-waylandhelper_global.h"
#include "ukui-decoration-client.h"
#include "ukui-decoration-manager.h"
#include "ukuistylehelper.h"
#include "wayland-plasma-window-management-client-protocol.h"
#include "waylandhelper.h"
#include "windowinfo.h"
#include "windowmanager.h"
#include "wmregister.h"
#include "xcbinterface.h"

#include "blurmanager.h"

#include "abstractinterface.h"
#include "blurabstractinterface.h"
#include "blurmanager.h"
#include "blurwaylandinterface.h"
#include "blurxcbinterface.h"
#include "extidlenotifier.h"
#include "idlenotifier.h"
#include "kdewaylandinterface.h"
#include "kyatoms_p.h"
#include "kysdk-waylandhelper_global.h"
#include "netwm.h"
#include "outputinfo.h"
#include "ukui-blur-manager-client-protocol.h"
#include "ukui-decoration-client.h"
#include "ukui-decoration-manager.h"
#include "ukui-shell-client-protocol.h"
#include "ukui-shell-manager.h"
#include "ukui-window-management-client-protocol.h"
#include "ukuiblur.h"
#include "ukuishell.h"
#include "ukuistylehelper.h"
#include "ukuiwaylandinterface.h"
#include "ukuiwaylandpointer.h"
#include "ukuiwindowmanagement.h"
#include "wayland-ext-idle-notify-v1-client-protocol.h"
#include "wayland-plasma-window-management-client-protocol.h"
#include "wayland-xdg-activation-v1-client-protocol.h"
#include "waylandhelper.h"
#include "windowinfo.h"
#include "windowmanager.h"
#include "wmregister.h"
#include "xcbinterface.h"
#include "xdgactivation.h"

#include <KWindowSystem>
#include <QDebug>
#include <QtTest>
#include "xatom-helper.h"

using namespace kdk;

class WaylandHelperTest : public QObject
{
    Q_OBJECT

private slots:
    //    void blurabstractinterfaceTest();
    void blurmanagerTest();
    void blurwaylandinterfaceTest();
    void blurxcbinterfaceTest();
    void ukuiblurTest();
    void ukuidecorationmanagerTest();
    void ukuishellmansgerTest();
    void waylandhelperTest();
    void windowinfoTest();
    void windowmanagerTest();
    void abstractinterfaceTest();
    void extidlenotifierTest();
    void idlenotifierTest();
    void kdewaylandinterfaceTest();
    void kyatomsTest();
    void outputinfoTest();
    void ukuishellTest();
    // void xcbinterfaceTest();
    // void waylandinterfaceTest();
    void ukuistylehelperTest();
    void ukuidecorationmanager();
    void wmregisterTest();
    void xatomhelperTest();
};

void WaylandHelperTest::blurmanagerTest()
{
    QWindow window;
    kdk::BlurManager::self()->setBlurBehindWithStrength(&window);
}

void WaylandHelperTest::blurwaylandinterfaceTest()
{
    BlurWaylandInterface face;
    QWindow window;
    face.setBlurBehindWithStrength(&window);
    //    face.handleGlobal(void*(),wl_region(),uint_32());
}

void WaylandHelperTest::blurxcbinterfaceTest()
{
    BlurXcbInterface face;
    QWindow window;
    face.setBlurBehindWithStrength(&window);

    //    QEvent::Hide
}

void WaylandHelperTest::ukuiblurTest()
{
    UkuiBlur blur;
    blur.isValid();
    //    ukui_blur_surface_v1 surface;
    //    blur.setup(&surface);
    //    blur.setRegion(Region());
    //    blur.setStrength(uint32_t(10));
    blur.release();
    blur.destroy();

    UkuiBlurManager manager;
    manager.isValid();
    manager.eventQueue();
    manager.release();
    manager.destroy();
}

void WaylandHelperTest::ukuidecorationmanagerTest()
{
    UKUIDecorationManager *manager = UKUIDecorationManager::getInstance();

    manager->supportUKUIDecoration();

    QWindow window;
    manager->moveWindow(&window);
    manager->removeHeaderBar(&window);
    manager->setCornerRadius(&window, 8, 8, 8, 8);
}

void WaylandHelperTest::ukuishellmansgerTest()
{
    UkuiShellManager *manager = UkuiShellManager::getInstance();
    QWindow window;
    manager->removeHeaderBar(&window);
    manager->ukuishellReady();
}

void WaylandHelperTest::waylandhelperTest()
{
    WaylandHelper::self()->isWaylandServer();
    WaylandHelper::self()->isWaylandClient();
}

void WaylandHelperTest::windowinfoTest()
{
    WindowInfo info;
    info.setIsGroupable(true);
    info.setHasSkipSwitcher(true);
}

void WaylandHelperTest::windowmanagerTest()
{
    //    WindowId*id= activeWindow
    QWindow window;
    window.setIcon(QIcon::fromTheme("kylin-music"));

    WindowManager *manager = WindowManager::self();
    QList<WindowId> list = manager->windows();

    WindowId id = manager->currentActiveWindow();
    manager->getwindowInfo(id);
    manager->keepWindowAbove(id);
    manager->getWindowTitle(id);
    manager->getWindowIcon(id);
    manager->getWindowGroup(id);
    manager->closeWindow(id);
    manager->activateWindow(id);
    manager->maximizeWindow(id);
    manager->minimizeWindow(id);
    manager->getPid(id);
    manager->showDesktop();
    manager->hideDesktop();
    manager->currentDesktop();
    manager->getWindowType(id);

    manager->setGeometry(&window, QRect(0, 0, window.width(), window.height()));
    manager->setSkipSwitcher(&window, true);
    manager->setSkipSwitcher(&window, false);
    manager->setSkipTaskBar(&window, true);
    manager->setSkipTaskBar(&window, false);
    manager->skipTaskBar(id);
    manager->skipSwitcher(id);
    manager->isShowingDesktop();
    manager->setOnAllDesktops(id);
    manager->isOnAllDesktops(id);
    manager->isOnCurrentDesktop(id);
    manager->isOnDesktop(id, 0);
    manager->setPanelTakefocus(&window, true);
    manager->setPanelTakefocus(&window, false);
    manager->demandAttention(id);
    manager->getProcessName(id);

    emit manager->windowAdded(id);
    emit manager->windowRemoved(id);
    emit manager->activeWindowChanged(id);
    emit manager->windowChanged(id);
    emit manager->currentDesktopChanged();
    emit manager->isShowingDesktopChanged();
    emit manager->titleChanged(id);
    emit manager->iconChanged(id);
    emit manager->activeChanged(id);
    emit manager->fullscreenChanged(id);
    emit manager->keepAboveChanged(id);
    emit manager->minimizeWindow(id);
    emit manager->maximizeWindow(id);
    emit manager->onAllDesktopsChanged(id);
    emit manager->demandsAttentionChanged(id);
    emit manager->skipTaskbarChanged(id);
    emit manager->skipSwitcherChanged(id);
    emit manager->geometryChanged(id);
}

void WaylandHelperTest::abstractinterfaceTest()
{
    WindowManager *manager = WindowManager::self();
    WindowId id = manager->currentActiveWindow();

    //    AbstractInterface::currentDesktop();
    //    AbstractInterface::currentActivity();
    //    AbstractInterface::setPlasmaDesktop(id);
    //    AbstractInterface::isValidFor(id);
    //    AbstractInterface face;
    //    face.requestInfo(id);
    //    face.requestActivate(id);
}

void WaylandHelperTest::extidlenotifierTest()
{
    ExtIdleNotifier notifier;
    notifier.isValid();
    notifier.release();
    notifier.destroy();

    ExtIdleNotification ext;
    ext.isValid();
    ext.release();
    ext.destroy();

    emit ext.idled();
    emit ext.resumed();
}

void WaylandHelperTest::idlenotifierTest()
{
    IdleNotifier idle;
    idle.setIdleInterval(1000);

    emit idle.idled();
    emit idle.resumed();
}

void WaylandHelperTest::kdewaylandinterfaceTest()
{
    WindowManager *manager = WindowManager::self();
    WindowId id = manager->currentActiveWindow();

    KdeWaylandInterface face;
    face.requestInfo(id);
    face.requestActivate(id);

    face.requestToggleKeepAbove(id);
    face.requestToggleMaximized(id);
    face.requestToggleMinimized(id);
    face.iconFor(id);
    face.titleFor(id);
    face.windowGroupFor(id);
    face.pid(id);
    face.hideCurrentDesktop();
    face.showCurrentDesktop();

    face.windowCanBeDragged(id);
    face.windowCanBeMaximized(id);

    face.activeWindow();
    QWindow window;
    face.setGeometry(&window, QRect(0, 0, window.width(), window.height()));
    face.setSkipTaskBar(&window, true);
    face.setSkipTaskBar(&window, false);
    face.setSkipSwitcher(&window, true);
    face.setSkipSwitcher(&window, false);
    face.skipSwitcher(id);
    face.skipTaskBar(id);
    face.isShowingDesktop();
    face.setOnAllDesktops(id);
    face.windowType(id);
    face.setPanelTakefocus(&window, true);
    face.setPanelTakefocus(&window, false);
    face.demandAttention(id);
    face.windowGeometry(id);
    face.setWindowLayer(&window, WindowLayer::Normal);
    face.setWindowLayer(&window, WindowLayer::Desktop);
    face.setWindowLayer(&window, WindowLayer::Panel);
    face.setWindowLayer(&window, WindowLayer::OnScreenDisplay);
    face.setWindowLayer(&window, WindowLayer::Notification);
    face.setWindowLayer(&window, WindowLayer::ToolTip);
    face.setWindowLayer(&window, WindowLayer::CriticalNotification);
    face.setWindowLayer(&window, WindowLayer::AppletPop);
    face.setWindowLayer(&window, WindowLayer::ScreenLock);
    face.setWindowLayer(&window, WindowLayer::Watermark);
    face.setWindowLayer(&window, WindowLayer::SystemWindow);
    face.setWindowLayer(&window, WindowLayer::InputPanel);
    face.setWindowLayer(&window, WindowLayer::Logout);
    face.setWindowLayer(&window, WindowLayer::ScreenLockNotification);
    face.setWindowLayer(&window, WindowLayer::Switcher);
    face.setWindowLayer(&window, WindowLayer::Authentication);
    face.windowLayer(&window);
    face.requestClose(id);
}

void WaylandHelperTest::kyatomsTest()
{
    //    KyAtom
}

void WaylandHelperTest::outputinfoTest()
{
    //    OutputInfo info;
    //    info.outputName();
    //    info.usableArea();
}

void WaylandHelperTest::ukuishellTest()
{
    UkuiShell shell;
    shell.isValid();

    shell.eventQueue();
    shell.setEventQueue(shell.eventQueue());
    shell.seatName();
    shell.outputName();
    shell.isCurrentOutputReady();
    //    shell.updateCurrentOutput();

    emit shell.removed();
    emit shell.currentOutputReady();
    emit shell.interfaceAboutToBeReleased();
    emit shell.interfaceAboutToBeDestroyed();
    shell.release();
    shell.destroy();
}

// void WaylandHelperTest::xcbinterfaceTest()
// {
//     WindowManager *manager = WindowManager::self();
//     WindowId id = manager->currentActiveWindow();

//     QWindow window;

//     XcbInterface face;
//     face.requestInfo(id);
//     face.requestActivate(id);
//     face.requestClose(id);
//     face.requestToggleKeepAbove(id);
//     face.requestToggleMaximized(id);
//     face.requestToggleMinimized(id);
//     //    manager->getwindowInfo(id).setIsMinimized(true);
//     //    face.requestInfo(id).setIsMinimized(true);
//     //  window.showMinimized();
//     //    qDebug()<<"xxxxxxxxxxx"<<manager->getwindowInfo(id).isMinimized()<<face.requestInfo(id).isMinimized()
//     //           <<manager->getwindowInfo(id).isMaximized()<<face.requestInfo(id).isMaximized();

//     //    face.requestToggleMinimized(id);
//     face.iconFor(id);
//     face.titleFor(id);
//     face.windowGroupFor(id);
//     face.showCurrentDesktop();
//     face.hideCurrentDesktop();
//     face.pid(id);
//     face.activeWindow();
//     face.windowCanBeDragged(id);
//     face.windowCanBeMaximized(id);
//     face.setGeometry(&window, QRect(0, 0, window.width(), window.height()));
//     face.setSkipTaskBar(&window, true);
//     face.setSkipTaskBar(&window, false);
//     face.setSkipSwitcher(&window, true);
//     face.setSkipSwitcher(&window, false);
//     face.skipSwitcher(id);
//     face.skipTaskBar(id);
//     face.isShowingDesktop();
//     face.setOnAllDesktops(id);
//     face.windowType(id);
//     face.setPanelTakefocus(&window, true);
//     face.setPanelTakefocus(&window, false);
//     face.demandAttention(id);

//     manager->getwindowInfo(id);
//     face.inCurrentDesktopActivity(manager->getwindowInfo(id));
//     face.isPlasmaDesktop(QRect(0, 0, 600, 480));
//     face.currentDesktop();
//     face.currentActivity();
//     face.setPlasmaDesktop(id);
//     face.isValidFor(id);

//     emit KWindowSystem::self()->windowRemoved(window.winId());
//     emit KWindowSystem::self()->currentDesktopChanged(0);
//     emit KWindowSystem::self()->windowChanged(window.winId(), NET::WMState, NET::WM2UserTime);
// }

// void WaylandHelperTest::waylandinterfaceTest()
//{
//     WindowManager* manager = WindowManager::self();
//     WindowId id = manager->currentActiveWindow();

//    QWindow window;

//    WaylandInterface face;
//    face.requestInfo(id);
//    face.requestActivate(id);
//    face.requestClose(id);
//    face.requestToggleKeepAbove(id);
//    face.requestToggleMaximized(id);
//    face.requestToggleMinimized(id);
//    face.iconFor(id);
//    face.titleFor(id);
//    face.windowGroupFor(id);
//    face.showCurrentDesktop();
//    face.hideCurrentDesktop();
//    face.pid(id);
//    face.activeWindow();
//    face.windowCanBeDragged(id);
//    face.windowCanBeMaximized(id);
//    face.setGeometry(&window,QRect(0,0,window.width(),window.height()));
//    face.setSkipTaskBar(&window,true);
//    face.setSkipTaskBar(&window,false);
//    face.setSkipSwitcher(&window,true);
//    face.setSkipSwitcher(&window,false);
//    face.skipSwitcher(id);
//    face.skipTaskBar(id);
//    face.isShowingDesktop();
//    face.setOnAllDesktops(id);
//    face.windowType(id);
//    face.setPanelTakefocus(&window,true);
//    face.setPanelTakefocus(&window,false);
//    face.demandAttention(id);
//}

void WaylandHelperTest::ukuistylehelperTest()
{
    UkuiStyleHelper *ukui = UkuiStyleHelper::self();

    QWidget widget;
    ukui->removeHeader(&widget);
    ukui->removeHeader(nullptr);

    widget.installEventFilter(ukui);
    //    QTest::showWindow(widget);

    QEvent event(QEvent::Show);
    QCoreApplication::sendEvent(&widget, &event);
    UkuiStyleHelper *ukui1 = UkuiStyleHelper::self();
}

void WaylandHelperTest::ukuidecorationmanager()
{
    //    UKUIDecorationManager::getInstance();
    //    UKUIDecorationManager* manager = UKUIDecorationManager::getInstance();
    //    QWidget widget;
    //    manager->supportUKUIDecoration();
    //    manager->moveWindow(widget.windowHandle());
    //    manager->removeHeaderBar(widget.windowHandle());
    //    manager->setCornerRadius(widget.windowHandle(),8,8,8,8);
}

void WaylandHelperTest::wmregisterTest()
{
    WmRegister *wm = new WmRegister();
    delete wm;
}

void WaylandHelperTest::xatomhelperTest()
{
    XAtomHelper *helper = XAtomHelper::getInstance();
    QWidget widget;

    helper->isFrameLessWindow(widget.winId());
    helper->isWindowDecorateBorderOnly(widget.winId());
    MotifWmHints hints;
    hints.flags = MWM_HINTS_FUNCTIONS | MWM_HINTS_DECORATIONS;
    hints.functions = MWM_FUNC_ALL;
    hints.decorations = MWM_DECOR_BORDER;
    helper->isWindowMotifHintDecorateBorderOnly(hints);
    helper->isUKUIDecorationWindow(widget.winId());
    helper->getWindowBorderRadius(widget.winId());
    UnityCorners corners;
    corners.topLeft = 8;
    corners.topRight = 8;
    corners.bottomLeft = 8;
    corners.bottomRight = 8;
    helper->setWindowBorderRadius(widget.winId(), corners);
    helper->setWindowBorderRadius(widget.winId(), 8, 8, 8, 8);
    helper->setUKUIDecoraiontHint(widget.winId(), true);
    helper->setUKUIDecoraiontHint(widget.winId(), false);
    helper->setWindowMotifHint(widget.winId(), hints);
    helper->getWindowMotifHint(widget.winId());
    helper->isUKUICsdSupported();
}

QTEST_MAIN(WaylandHelperTest)

#include "waylandtest.moc"
