# Security Policy

## Supported Versions

The following table outlines which versions of `scram` are actively supported with security updates. Please upgrade to a supported release to ensure you receive patches for any security issues.

| Version | Supported          | Java support |
| ------- | ------------------ | ------------ |
| 3.x     | :white_check_mark: | Java 8+      |
| < 3.0   | :x:                | Java 7+      |

## Reporting a Vulnerability

If you believe you have found a security vulnerability, please report it to us privately through GitHub’s security advisory system:  
[Report a vulnerability](../../security/advisories/new)

We will investigate promptly and work with you to fix the issue.

---

## Security Best Practices for Users

- Always use the latest supported version of `scram`.  
- Monitor [GitHub Releases](https://github.com/ongres/scram/releases) for security patches.  
- Consider subscribing to repository notifications for updates.
