/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QString>
#include <QList>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/ChemicalGroupRule.hpp"
#include "MsXpS/libXpertMassCore/Prop.hpp"
#include "MsXpS/libXpertMassCore/Utils.hpp"


namespace MsXpS
{

namespace libXpertMassCore
{


class DECLSPEC ChemicalGroup
{
  public:
  ChemicalGroup(const QString &name   = QString(),
                float pka             = 7.0,
                bool is_acid_charged  = true,
                Enums::ChemicalGroupTrapped = Enums::ChemicalGroupTrapped::NEVER);
  ChemicalGroup(const ChemicalGroup &other);

  ~ChemicalGroup();

  ChemicalGroup &operator=(const ChemicalGroup &other);

  void setName(QString);
  QString getName() const;

  void setPka(float);
  float getPka() const;

  void setAcidCharged(bool);
  bool isAcidCharged() const;

  void setPolRule(Enums::ChemicalGroupTrapped);
  Enums::ChemicalGroupTrapped getPolRule() const;

  const std::vector<ChemicalGroupRuleSPtr> &getRulesCstRef() const;
  std::vector<ChemicalGroupRuleSPtr> &getRulesRef();

  ChemicalGroupRuleSPtr findRuleByEntity(const QString &entity,
                                         std::size_t &index) const;
  ChemicalGroupRuleSPtr findRuleByName(const QString &name,
                                       std::size_t &index) const;
  ChemicalGroupRuleSPtr findRuleByEntityAndName(const QString &entity,
                                                const QString &name,
                                                std::size_t &index) const;

  bool renderXmlMnmElement(const QDomElement &element);
  bool renderXmlMdfElement(const QDomElement &element);

  bool validate(ErrorList *error_list_p) const;
  bool isValid() const;

  protected:
  QString m_name;
  float m_pka;
  bool m_acidCharged;
  Enums::ChemicalGroupTrapped m_polymerizationRule;
  std::vector<ChemicalGroupRuleSPtr> m_rules;
  mutable bool m_isValid = false;
};


class DECLSPEC ChemicalGroupProp : public Prop
{
  public:
  ChemicalGroupProp(const QString & = QString(), ChemicalGroup * = 0);
  ChemicalGroupProp(const ChemicalGroupProp &other);

  ~ChemicalGroupProp();

  virtual void deleteData();

  using Prop::operator=;
  ChemicalGroupProp &operator=(const ChemicalGroupProp &other);

  ChemicalGroupProp *cloneOut() const;

  bool renderXmlElement(const QDomElement &element, int version = 1);
  QString formatXmlElement(int offset,
                           const QString &indent = Utils::xmlIndentationToken);
};

} // namespace libXpertMassCore

} // namespace MsXpS
