# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class CertificateInfo(_Model):
    """The Security Domain download operation requires customer to provide N certificates (minimum 3
    and maximum 10) containing a public key in JWK format.

    :ivar certificates: Certificates needed from customer. Required.
    :vartype certificates: list[~azure.keyvault.securitydomain.models.SecurityDomainJsonWebKey]
    :ivar required: Customer to specify the number of certificates (minimum 2 and maximum 10) to
     restore Security Domain.
    :vartype required: int
    """

    certificates: List["_models.SecurityDomainJsonWebKey"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Certificates needed from customer. Required."""
    required: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Customer to specify the number of certificates (minimum 2 and maximum 10) to restore Security
     Domain."""

    @overload
    def __init__(
        self,
        *,
        certificates: List["_models.SecurityDomainJsonWebKey"],
        required: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Error(_Model):
    """The key vault server error.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The key vault server error.
    :vartype inner_error: ~azure.keyvault.securitydomain.models.Error
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    inner_error: Optional["_models.Error"] = rest_field(name="innererror", visibility=["read"])
    """The key vault server error."""


class KeyVaultError(_Model):
    """The key vault error exception.

    :ivar error: The key vault server error.
    :vartype error: ~azure.keyvault.securitydomain.models.Error
    """

    error: Optional["_models.Error"] = rest_field(visibility=["read"])
    """The key vault server error."""


class SecurityDomain(_Model):
    """The Security Domain.

    :ivar value: The Security Domain. Required.
    :vartype value: str
    """

    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Security Domain. Required."""

    @overload
    def __init__(
        self,
        *,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityDomainJsonWebKey(_Model):
    """A JSON Web Key (JWK) for use in a security domain operation.

    :ivar kid: Key identifier. Required.
    :vartype kid: str
    :ivar kty: JsonWebKey Key Type (kty), as defined in
     `https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40
     <https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40>`_. For Security Domain
     this value must be RSA. Required.
    :vartype kty: str
    :ivar key_ops: Supported key operations. Required.
    :vartype key_ops: list[str]
    :ivar n: RSA modulus. Required.
    :vartype n: str
    :ivar e: RSA public exponent. Required.
    :vartype e: str
    :ivar x5_c: X509 certificate chain parameter. Required.
    :vartype x5_c: list[str]
    :ivar use: Public Key Use Parameter. This is optional and if present must be enc.
    :vartype use: str
    :ivar x5_t: X509 certificate SHA1 thumbprint. This is optional.
    :vartype x5_t: str
    :ivar x5_t_s256: X509 certificate SHA256 thumbprint. Required.
    :vartype x5_t_s256: str
    :ivar alg: Algorithm intended for use with the key. Required.
    :vartype alg: str
    """

    kid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key identifier. Required."""
    kty: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """JsonWebKey Key Type (kty), as defined in
     `https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40
     <https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40>`_. For Security Domain
     this value must be RSA. Required."""
    key_ops: List[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Supported key operations. Required."""
    n: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA modulus. Required."""
    e: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """RSA public exponent. Required."""
    x5_c: List[str] = rest_field(name="x5c", visibility=["read", "create", "update", "delete", "query"])
    """X509 certificate chain parameter. Required."""
    use: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Public Key Use Parameter. This is optional and if present must be enc."""
    x5_t: Optional[str] = rest_field(name="x5t", visibility=["read", "create", "update", "delete", "query"])
    """X509 certificate SHA1 thumbprint. This is optional."""
    x5_t_s256: str = rest_field(name="x5t#S256", visibility=["read", "create", "update", "delete", "query"])
    """X509 certificate SHA256 thumbprint. Required."""
    alg: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Algorithm intended for use with the key. Required."""

    @overload
    def __init__(
        self,
        *,
        kid: str,
        kty: str,
        key_ops: List[str],
        n: str,
        e: str,
        x5_c: List[str],
        x5_t_s256: str,
        alg: str,
        use: Optional[str] = None,
        x5_t: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityDomainOperationStatus(_Model):
    """The Security Domain operation status.

    :ivar status: Operation status. Known values are: "Success", "InProgress", and "Failed".
    :vartype status: str or ~azure.keyvault.securitydomain.models.OperationStatus
    :ivar status_details: Details of the operation status.
    :vartype status_details: str
    """

    status: Optional[Union[str, "_models.OperationStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation status. Known values are: \"Success\", \"InProgress\", and \"Failed\"."""
    status_details: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the operation status."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        status_details: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransferKey(_Model):
    """Security Domain transfer key.

    :ivar key_format: Specifies the format of the transfer key.
    :vartype key_format: str
    :ivar transfer_key: Specifies the transfer key in JWK format. Required.
    :vartype transfer_key: ~azure.keyvault.securitydomain.models.SecurityDomainJsonWebKey
    """

    key_format: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the format of the transfer key."""
    transfer_key: "_models.SecurityDomainJsonWebKey" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the transfer key in JWK format. Required."""

    @overload
    def __init__(
        self,
        *,
        transfer_key: "_models.SecurityDomainJsonWebKey",
        key_format: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
