# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from json import loads as _loads
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
# fmt: off

def build_accounts_get_account_properties_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_accounts_update_account_properties_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_accounts_get_access_keys_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/listkeys')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_accounts_regenerate_access_key_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/regeneratekeys')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collections_get_collection_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collections_create_or_update_collection_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collections_delete_collection_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collections_list_collections_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if skip_token is not None:
        query_parameters['$skipToken'] = _SERIALIZER.query("skip_token", skip_token, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collections_list_child_collection_names_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}/getChildCollectionNames')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if skip_token is not None:
        query_parameters['$skipToken'] = _SERIALIZER.query("skip_token", skip_token, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collections_get_collection_path_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}/getCollectionPath')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_resource_set_rules_get_resource_set_rule_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resourceSetRuleConfigs/defaultResourceSetRuleConfig')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_resource_set_rules_create_or_update_resource_set_rule_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resourceSetRuleConfigs/defaultResourceSetRuleConfig')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_resource_set_rules_delete_resource_set_rule_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resourceSetRuleConfigs/defaultResourceSetRuleConfig')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_resource_set_rules_list_resource_set_rules_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resourceSetRuleConfigs')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if skip_token is not None:
        query_parameters['$skipToken'] = _SERIALIZER.query("skip_token", skip_token, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class AccountsOperations(object):
    """AccountsOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def get_account_properties(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get an account.

        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "id": "str",  # Optional. Gets or sets the identifier.
                    "identity": {
                        "principalId": "str",  # Optional. Service principal object Id.
                        "tenantId": "str",  # Optional. Tenant Id.
                        "type": "SystemAssigned"  # Optional. Default value is "SystemAssigned". Identity Type. Possible values include: "SystemAssigned".
                    },
                    "location": "str",  # Optional. Gets or sets the location.
                    "name": "str",  # Optional. Gets or sets the name.
                    "properties": {
                        "cloudConnectors": {
                            "awsExternalId": "str"  # Optional. AWS external identifier."nConfigured in AWS to allow use of the role arn used for scanning.
                        },
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which the entity was created.
                        "createdBy": "str",  # Optional. Gets the creator of the entity.
                        "createdByObjectId": "str",  # Optional. Gets the creators of the entity's object id.
                        "endpoints": {
                            "catalog": "str",  # Optional. Gets the catalog endpoint.
                            "guardian": "str",  # Optional. Gets the guardian endpoint.
                            "scan": "str"  # Optional. Gets the scan endpoint.
                        },
                        "friendlyName": "str",  # Optional. Gets or sets the friendly name.
                        "managedResourceGroupName": "str",  # Optional. Gets or sets the managed resource group name.
                        "managedResources": {
                            "eventHubNamespace": "str",  # Optional. Gets the managed event hub namespace resource identifier.
                            "resourceGroup": "str",  # Optional. Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account.
                            "storageAccount": "str"  # Optional. Gets the managed storage account resource identifier.
                        },
                        "privateEndpointConnections": [
                            {
                                "id": "str",  # Optional. Gets or sets the identifier.
                                "name": "str",  # Optional. Gets or sets the name.
                                "properties": {
                                    "privateEndpoint": {
                                        "id": "str"  # Optional. The private endpoint identifier.
                                    },
                                    "privateLinkServiceConnectionState": {
                                        "actionsRequired": "str",  # Optional. The required actions.
                                        "description": "str",  # Optional. The description.
                                        "status": "str"  # Optional. The status. Possible values include: "Unknown", "Pending", "Approved", "Rejected", "Disconnected".
                                    },
                                    "provisioningState": "str"  # Optional. The provisioning state.
                                },
                                "type": "str"  # Optional. Gets or sets the type.
                            }
                        ],
                        "provisioningState": "str",  # Optional. Gets or sets the state of the provisioning. Possible values include: "Unknown", "Creating", "Moving", "Deleting", "SoftDeleting", "SoftDeleted", "Failed", "Succeeded", "Canceled".
                        "publicNetworkAccess": "Enabled"  # Optional. Default value is "Enabled". Gets or sets the public network access. Possible values include: "NotSpecified", "Enabled", "Disabled". Default value: "Enabled".
                    },
                    "sku": {
                        "capacity": 0,  # Optional. Gets or sets the sku capacity. Possible values include: 4, 16.
                        "name": "Standard"  # Optional. Default value is "Standard". Gets or sets the sku name. Possible values include: "Standard".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp of resource creation (UTC).
                        "createdBy": "str",  # Optional. The identity that created the resource.
                        "createdByType": "str",  # Optional. The type of identity that created the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                        "lastModifiedAt": "2020-02-20 00:00:00",  # Optional. The timestamp of the last modification the resource (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that last modified the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. A set of tags. Tags on the azure resource.
                    },
                    "type": "str"  # Optional. Gets or sets the type.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_accounts_get_account_properties_request(
            template_url=self.get_account_properties.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_account_properties.metadata = {'url': '/'}  # type: ignore


    @distributed_trace
    def update_account_properties(
        self,
        account_update_parameters,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Updates an account.

        :param account_update_parameters:
        :type account_update_parameters: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                account_update_parameters = {
                    "friendlyName": "str"  # Optional. The friendly name for the azure resource.
                }

                # response body for status code(s): 200
                response.json() == {
                    "id": "str",  # Optional. Gets or sets the identifier.
                    "identity": {
                        "principalId": "str",  # Optional. Service principal object Id.
                        "tenantId": "str",  # Optional. Tenant Id.
                        "type": "SystemAssigned"  # Optional. Default value is "SystemAssigned". Identity Type. Possible values include: "SystemAssigned".
                    },
                    "location": "str",  # Optional. Gets or sets the location.
                    "name": "str",  # Optional. Gets or sets the name.
                    "properties": {
                        "cloudConnectors": {
                            "awsExternalId": "str"  # Optional. AWS external identifier."nConfigured in AWS to allow use of the role arn used for scanning.
                        },
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which the entity was created.
                        "createdBy": "str",  # Optional. Gets the creator of the entity.
                        "createdByObjectId": "str",  # Optional. Gets the creators of the entity's object id.
                        "endpoints": {
                            "catalog": "str",  # Optional. Gets the catalog endpoint.
                            "guardian": "str",  # Optional. Gets the guardian endpoint.
                            "scan": "str"  # Optional. Gets the scan endpoint.
                        },
                        "friendlyName": "str",  # Optional. Gets or sets the friendly name.
                        "managedResourceGroupName": "str",  # Optional. Gets or sets the managed resource group name.
                        "managedResources": {
                            "eventHubNamespace": "str",  # Optional. Gets the managed event hub namespace resource identifier.
                            "resourceGroup": "str",  # Optional. Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account.
                            "storageAccount": "str"  # Optional. Gets the managed storage account resource identifier.
                        },
                        "privateEndpointConnections": [
                            {
                                "id": "str",  # Optional. Gets or sets the identifier.
                                "name": "str",  # Optional. Gets or sets the name.
                                "properties": {
                                    "privateEndpoint": {
                                        "id": "str"  # Optional. The private endpoint identifier.
                                    },
                                    "privateLinkServiceConnectionState": {
                                        "actionsRequired": "str",  # Optional. The required actions.
                                        "description": "str",  # Optional. The description.
                                        "status": "str"  # Optional. The status. Possible values include: "Unknown", "Pending", "Approved", "Rejected", "Disconnected".
                                    },
                                    "provisioningState": "str"  # Optional. The provisioning state.
                                },
                                "type": "str"  # Optional. Gets or sets the type.
                            }
                        ],
                        "provisioningState": "str",  # Optional. Gets or sets the state of the provisioning. Possible values include: "Unknown", "Creating", "Moving", "Deleting", "SoftDeleting", "SoftDeleted", "Failed", "Succeeded", "Canceled".
                        "publicNetworkAccess": "Enabled"  # Optional. Default value is "Enabled". Gets or sets the public network access. Possible values include: "NotSpecified", "Enabled", "Disabled". Default value: "Enabled".
                    },
                    "sku": {
                        "capacity": 0,  # Optional. Gets or sets the sku capacity. Possible values include: 4, 16.
                        "name": "Standard"  # Optional. Default value is "Standard". Gets or sets the sku name. Possible values include: "Standard".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp of resource creation (UTC).
                        "createdBy": "str",  # Optional. The identity that created the resource.
                        "createdByType": "str",  # Optional. The type of identity that created the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                        "lastModifiedAt": "2020-02-20 00:00:00",  # Optional. The timestamp of the last modification the resource (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that last modified the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. A set of tags. Tags on the azure resource.
                    },
                    "type": "str"  # Optional. Gets or sets the type.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = account_update_parameters

        request = build_accounts_update_account_properties_request(
            content_type=content_type,
            json=json,
            template_url=self.update_account_properties.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_account_properties.metadata = {'url': '/'}  # type: ignore


    @distributed_trace
    def get_access_keys(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """List the authorization keys associated with this account.

        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "atlasKafkaPrimaryEndpoint": "str",  # Optional. Gets or sets the primary connection string.
                    "atlasKafkaSecondaryEndpoint": "str"  # Optional. Gets or sets the secondary connection string.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_accounts_get_access_keys_request(
            template_url=self.get_access_keys.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_access_keys.metadata = {'url': '/listkeys'}  # type: ignore


    @distributed_trace
    def regenerate_access_key(
        self,
        key_options,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Regenerate the authorization keys associated with this data catalog.

        :param key_options:
        :type key_options: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                key_options = {
                    "keyType": "str"  # Optional. The access key type. Possible values include: "PrimaryAtlasKafkaKey", "SecondaryAtlasKafkaKey".
                }

                # response body for status code(s): 200
                response.json() == {
                    "atlasKafkaPrimaryEndpoint": "str",  # Optional. Gets or sets the primary connection string.
                    "atlasKafkaSecondaryEndpoint": "str"  # Optional. Gets or sets the secondary connection string.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = key_options

        request = build_accounts_regenerate_access_key_request(
            content_type=content_type,
            json=json,
            template_url=self.regenerate_access_key.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    regenerate_access_key.metadata = {'url': '/regeneratekeys'}  # type: ignore

class CollectionsOperations(object):
    """CollectionsOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def get_collection(
        self,
        collection_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get a collection.

        :param collection_name:
        :type collection_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "collectionProvisioningState": "str",  # Optional. Gets the state of the provisioning. Possible values include: "Unknown", "Creating", "Moving", "Deleting", "Failed", "Succeeded".
                    "description": "str",  # Optional. Gets or sets the description.
                    "friendlyName": "str",  # Optional. Gets or sets the friendly name of the collection.
                    "name": "str",  # Optional. Gets the name.
                    "parentCollection": {
                        "referenceName": "str",  # Optional. Gets or sets the reference name.
                        "type": "CollectionReference"  # Optional. Default value is "CollectionReference". Gets or sets the reference type property.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp of resource creation (UTC).
                        "createdBy": "str",  # Optional. The identity that created the resource.
                        "createdByType": "str",  # Optional. The type of identity that created the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                        "lastModifiedAt": "2020-02-20 00:00:00",  # Optional. The timestamp of the last modification the resource (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that last modified the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_collections_get_collection_request(
            collection_name=collection_name,
            template_url=self.get_collection.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_collection.metadata = {'url': '/collections/{collectionName}'}  # type: ignore


    @distributed_trace
    def create_or_update_collection(
        self,
        collection_name,  # type: str
        collection,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Creates or updates a collection entity.

        :param collection_name:
        :type collection_name: str
        :param collection:
        :type collection: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                collection = {
                    "collectionProvisioningState": "str",  # Optional. Gets the state of the provisioning. Possible values include: "Unknown", "Creating", "Moving", "Deleting", "Failed", "Succeeded".
                    "description": "str",  # Optional. Gets or sets the description.
                    "friendlyName": "str",  # Optional. Gets or sets the friendly name of the collection.
                    "name": "str",  # Optional. Gets the name.
                    "parentCollection": {
                        "referenceName": "str",  # Optional. Gets or sets the reference name.
                        "type": "CollectionReference"  # Optional. Default value is "CollectionReference". Gets or sets the reference type property.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp of resource creation (UTC).
                        "createdBy": "str",  # Optional. The identity that created the resource.
                        "createdByType": "str",  # Optional. The type of identity that created the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                        "lastModifiedAt": "2020-02-20 00:00:00",  # Optional. The timestamp of the last modification the resource (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that last modified the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "collectionProvisioningState": "str",  # Optional. Gets the state of the provisioning. Possible values include: "Unknown", "Creating", "Moving", "Deleting", "Failed", "Succeeded".
                    "description": "str",  # Optional. Gets or sets the description.
                    "friendlyName": "str",  # Optional. Gets or sets the friendly name of the collection.
                    "name": "str",  # Optional. Gets the name.
                    "parentCollection": {
                        "referenceName": "str",  # Optional. Gets or sets the reference name.
                        "type": "CollectionReference"  # Optional. Default value is "CollectionReference". Gets or sets the reference type property.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp of resource creation (UTC).
                        "createdBy": "str",  # Optional. The identity that created the resource.
                        "createdByType": "str",  # Optional. The type of identity that created the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                        "lastModifiedAt": "2020-02-20 00:00:00",  # Optional. The timestamp of the last modification the resource (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that last modified the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = collection

        request = build_collections_create_or_update_collection_request(
            collection_name=collection_name,
            content_type=content_type,
            json=json,
            template_url=self.create_or_update_collection.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_collection.metadata = {'url': '/collections/{collectionName}'}  # type: ignore


    @distributed_trace
    def delete_collection(
        self,
        collection_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Deletes a Collection entity.

        :param collection_name:
        :type collection_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_collections_delete_collection_request(
            collection_name=collection_name,
            template_url=self.delete_collection.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_collection.metadata = {'url': '/collections/{collectionName}'}  # type: ignore


    @distributed_trace
    def list_collections(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[Any]
        """List the collections in the account.

        :keyword skip_token:
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "count": 0.0,  # Optional. Total item count.
                    "nextLink": "str",  # Optional. The Url of next result page.
                    "value": [
                        {
                            "collectionProvisioningState": "str",  # Optional. Gets the state of the provisioning. Possible values include: "Unknown", "Creating", "Moving", "Deleting", "Failed", "Succeeded".
                            "description": "str",  # Optional. Gets or sets the description.
                            "friendlyName": "str",  # Optional. Gets or sets the friendly name of the collection.
                            "name": "str",  # Optional. Gets the name.
                            "parentCollection": {
                                "referenceName": "str",  # Optional. Gets or sets the reference name.
                                "type": "CollectionReference"  # Optional. Default value is "CollectionReference". Gets or sets the reference type property.
                            },
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",  # Optional. The timestamp of resource creation (UTC).
                                "createdBy": "str",  # Optional. The identity that created the resource.
                                "createdByType": "str",  # Optional. The type of identity that created the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                                "lastModifiedAt": "2020-02-20 00:00:00",  # Optional. The timestamp of the last modification the resource (UTC).
                                "lastModifiedBy": "str",  # Optional. The identity that last modified the resource.
                                "lastModifiedByType": "str"  # Optional. The type of identity that last modified the resource. Possible values include: "User", "Application", "ManagedIdentity", "Key".
                            }
                        }
                    ]
                }
        """
        skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_collections_list_collections_request(
                    skip_token=skip_token,
                    template_url=self.list_collections.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_collections_list_collections_request(
                    skip_token=skip_token,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_collections.metadata = {'url': '/collections'}  # type: ignore

    @distributed_trace
    def list_child_collection_names(
        self,
        collection_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[Any]
        """Lists the child collections names in the collection.

        :param collection_name:
        :type collection_name: str
        :keyword skip_token:
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "count": 0.0,  # Optional. Total item count.
                    "nextLink": "str",  # Optional. The Url of next result page.
                    "value": [
                        {
                            "friendlyName": "str",  # Optional. Gets or sets the friendly name of the collection.
                            "name": "str"  # Optional. Gets the name.
                        }
                    ]
                }
        """
        skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_collections_list_child_collection_names_request(
                    collection_name=collection_name,
                    skip_token=skip_token,
                    template_url=self.list_child_collection_names.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_collections_list_child_collection_names_request(
                    collection_name=collection_name,
                    skip_token=skip_token,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_child_collection_names.metadata = {'url': '/collections/{collectionName}/getChildCollectionNames'}  # type: ignore

    @distributed_trace
    def get_collection_path(
        self,
        collection_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Gets the parent name and parent friendly name chains that represent the collection path.

        :param collection_name:
        :type collection_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "parentFriendlyNameChain": [
                        "str"  # Optional. The friendly names of ancestors starting from the default (root) collection and ending with the immediate parent.
                    ],
                    "parentNameChain": [
                        "str"  # Optional. The names of ancestors starting from the default (root) collection and ending with the immediate parent.
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_collections_get_collection_path_request(
            collection_name=collection_name,
            template_url=self.get_collection_path.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_collection_path.metadata = {'url': '/collections/{collectionName}/getCollectionPath'}  # type: ignore

class ResourceSetRulesOperations(object):
    """ResourceSetRulesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def get_resource_set_rule(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get a resource set config service model.

        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "advancedResourceSet": {
                        "modifiedAt": "2020-02-20 00:00:00",  # Optional. Date at which ResourceSetProcessing property of the account is updated.
                        "resourceSetProcessing": "str"  # Optional. The advanced resource property of the account. Possible values include: "Default", "Advanced".
                    },
                    "name": "str",  # Optional. The name of the rule.
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "filterType": "Pattern",  # Optional. Default value is "Pattern". Possible values include: "Pattern", "Regex". Default value: "Pattern".
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "path": "str"  # Required. 
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str",  # Optional. The configuration rules for path pattern extraction.
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disableRecursiveReplacerApplication": bool,  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Optional. The configuration rules for path pattern extraction.
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "str",  # Optional. The configuration rules for path pattern extraction.
                                "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                "typeName": "str"  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "createdBy": "str",  # Required. 
                        "enableDefaultPatterns": bool,  # Required. 
                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                        "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                        "normalizationRules": [
                            {
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Optional. The configuration rules for path pattern extraction.
                                "dynamicReplacement": bool,  # Optional. The configuration rules for path pattern extraction.
                                "entityTypes": [
                                    "str"  # Optional. The configuration rules for path pattern extraction.
                                ],
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                "regex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "replaceWith": "str",  # Optional. The configuration rules for path pattern extraction.
                                "version": 0.0  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str",  # Optional. The configuration rules for path pattern extraction.
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disableRecursiveReplacerApplication": bool,  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Required. 
                                "doNotReplaceRegex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "regex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "replaceWith": "str"  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "filterType": "Pattern",  # Optional. Default value is "Pattern". Possible values include: "Pattern", "Regex". Default value: "Pattern".
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "path": "str"  # Required. 
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",  # Required. 
                                "rules": [
                                    {
                                        "displayName": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "isResourceSet": True,  # Optional. Default value is True. The configuration rules for path pattern extraction.
                                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                        "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "qualifiedName": "str"  # Required. 
                                    }
                                ],
                                "storeType": "str"  # Required. 
                            }
                        ],
                        "version": 0  # Optional. The configuration rules for path pattern extraction.
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_resource_set_rules_get_resource_set_rule_request(
            template_url=self.get_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace
    def create_or_update_resource_set_rule(
        self,
        resource_set_rule_config,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Creates or updates an resource set config.

        :param resource_set_rule_config:
        :type resource_set_rule_config: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource_set_rule_config = {
                    "advancedResourceSet": {
                        "modifiedAt": "2020-02-20 00:00:00",  # Optional. Date at which ResourceSetProcessing property of the account is updated.
                        "resourceSetProcessing": "str"  # Optional. The advanced resource property of the account. Possible values include: "Default", "Advanced".
                    },
                    "name": "str",  # Optional. The name of the rule.
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "filterType": "Pattern",  # Optional. Default value is "Pattern". Possible values include: "Pattern", "Regex". Default value: "Pattern".
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "path": "str"  # Required. 
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str",  # Optional. The configuration rules for path pattern extraction.
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disableRecursiveReplacerApplication": bool,  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Optional. The configuration rules for path pattern extraction.
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "str",  # Optional. The configuration rules for path pattern extraction.
                                "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                "typeName": "str"  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "createdBy": "str",  # Required. 
                        "enableDefaultPatterns": bool,  # Required. 
                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                        "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                        "normalizationRules": [
                            {
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Optional. The configuration rules for path pattern extraction.
                                "dynamicReplacement": bool,  # Optional. The configuration rules for path pattern extraction.
                                "entityTypes": [
                                    "str"  # Optional. The configuration rules for path pattern extraction.
                                ],
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                "regex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "replaceWith": "str",  # Optional. The configuration rules for path pattern extraction.
                                "version": 0.0  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str",  # Optional. The configuration rules for path pattern extraction.
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disableRecursiveReplacerApplication": bool,  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Required. 
                                "doNotReplaceRegex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "regex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "replaceWith": "str"  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "filterType": "Pattern",  # Optional. Default value is "Pattern". Possible values include: "Pattern", "Regex". Default value: "Pattern".
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "path": "str"  # Required. 
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",  # Required. 
                                "rules": [
                                    {
                                        "displayName": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "isResourceSet": True,  # Optional. Default value is True. The configuration rules for path pattern extraction.
                                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                        "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "qualifiedName": "str"  # Required. 
                                    }
                                ],
                                "storeType": "str"  # Required. 
                            }
                        ],
                        "version": 0  # Optional. The configuration rules for path pattern extraction.
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "advancedResourceSet": {
                        "modifiedAt": "2020-02-20 00:00:00",  # Optional. Date at which ResourceSetProcessing property of the account is updated.
                        "resourceSetProcessing": "str"  # Optional. The advanced resource property of the account. Possible values include: "Default", "Advanced".
                    },
                    "name": "str",  # Optional. The name of the rule.
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "filterType": "Pattern",  # Optional. Default value is "Pattern". Possible values include: "Pattern", "Regex". Default value: "Pattern".
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "path": "str"  # Required. 
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str",  # Optional. The configuration rules for path pattern extraction.
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disableRecursiveReplacerApplication": bool,  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Optional. The configuration rules for path pattern extraction.
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "str",  # Optional. The configuration rules for path pattern extraction.
                                "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                "typeName": "str"  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "createdBy": "str",  # Required. 
                        "enableDefaultPatterns": bool,  # Required. 
                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                        "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                        "normalizationRules": [
                            {
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Optional. The configuration rules for path pattern extraction.
                                "dynamicReplacement": bool,  # Optional. The configuration rules for path pattern extraction.
                                "entityTypes": [
                                    "str"  # Optional. The configuration rules for path pattern extraction.
                                ],
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                "regex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "replaceWith": "str",  # Optional. The configuration rules for path pattern extraction.
                                "version": 0.0  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str",  # Optional. The configuration rules for path pattern extraction.
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                "disableRecursiveReplacerApplication": bool,  # Optional. The configuration rules for path pattern extraction.
                                "disabled": bool,  # Required. 
                                "doNotReplaceRegex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "regex": {
                                    "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                    "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                },
                                "replaceWith": "str"  # Optional. The configuration rules for path pattern extraction.
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "filterType": "Pattern",  # Optional. Default value is "Pattern". Possible values include: "Pattern", "Regex". Default value: "Pattern".
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "name": "str",  # Required. 
                                "path": "str"  # Required. 
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",  # Required. 
                                "rules": [
                                    {
                                        "displayName": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "isResourceSet": True,  # Optional. Default value is True. The configuration rules for path pattern extraction.
                                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                        "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "qualifiedName": "str"  # Required. 
                                    }
                                ],
                                "storeType": "str"  # Required. 
                            }
                        ],
                        "version": 0  # Optional. The configuration rules for path pattern extraction.
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = resource_set_rule_config

        request = build_resource_set_rules_create_or_update_resource_set_rule_request(
            content_type=content_type,
            json=json,
            template_url=self.create_or_update_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace
    def delete_resource_set_rule(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Deletes a ResourceSetRuleConfig resource.

        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_resource_set_rules_delete_resource_set_rule_request(
            template_url=self.delete_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace
    def list_resource_set_rules(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[Any]
        """Get a resource set config service model.

        :keyword skip_token:
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "count": 0.0,  # Optional. Total item count.
                    "nextLink": "str",  # Optional. The Url of next result page.
                    "value": [
                        {
                            "advancedResourceSet": {
                                "modifiedAt": "2020-02-20 00:00:00",  # Optional. Date at which ResourceSetProcessing property of the account is updated.
                                "resourceSetProcessing": "str"  # Optional. The advanced resource property of the account. Possible values include: "Default", "Advanced".
                            },
                            "name": "str",  # Optional. The name of the rule.
                            "pathPatternConfig": {
                                "acceptedPatterns": [
                                    {
                                        "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                        "filterType": "Pattern",  # Optional. Default value is "Pattern". Possible values include: "Pattern", "Regex". Default value: "Pattern".
                                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                        "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                        "name": "str",  # Required. 
                                        "path": "str"  # Required. 
                                    }
                                ],
                                "complexReplacers": [
                                    {
                                        "createdBy": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "disableRecursiveReplacerApplication": bool,  # Optional. The configuration rules for path pattern extraction.
                                        "disabled": bool,  # Optional. The configuration rules for path pattern extraction.
                                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                        "modifiedBy": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "typeName": "str"  # Optional. The configuration rules for path pattern extraction.
                                    }
                                ],
                                "createdBy": "str",  # Required. 
                                "enableDefaultPatterns": bool,  # Required. 
                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                "normalizationRules": [
                                    {
                                        "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "disabled": bool,  # Optional. The configuration rules for path pattern extraction.
                                        "dynamicReplacement": bool,  # Optional. The configuration rules for path pattern extraction.
                                        "entityTypes": [
                                            "str"  # Optional. The configuration rules for path pattern extraction.
                                        ],
                                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                        "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "regex": {
                                            "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                        },
                                        "replaceWith": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "version": 0.0  # Optional. The configuration rules for path pattern extraction.
                                    }
                                ],
                                "regexReplacers": [
                                    {
                                        "condition": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                        "description": "str",  # Optional. The configuration rules for path pattern extraction.
                                        "disableRecursiveReplacerApplication": bool,  # Optional. The configuration rules for path pattern extraction.
                                        "disabled": bool,  # Required. 
                                        "doNotReplaceRegex": {
                                            "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                        },
                                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                        "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                        "name": "str",  # Required. 
                                        "regex": {
                                            "maxDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "maxLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDashes": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDigits": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDigitsOrLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minDots": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minHex": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minLetters": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "minUnderscores": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "options": 0,  # Optional. The configuration rules for path pattern extraction.
                                            "regexStr": "str"  # Optional. The configuration rules for path pattern extraction.
                                        },
                                        "replaceWith": "str"  # Optional. The configuration rules for path pattern extraction.
                                    }
                                ],
                                "rejectedPatterns": [
                                    {
                                        "createdBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                        "filterType": "Pattern",  # Optional. Default value is "Pattern". Possible values include: "Pattern", "Regex". Default value: "Pattern".
                                        "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                        "modifiedBy": "AzureDataCatalog",  # Optional. Default value is "AzureDataCatalog". The configuration rules for path pattern extraction.
                                        "name": "str",  # Required. 
                                        "path": "str"  # Required. 
                                    }
                                ],
                                "scopedRules": [
                                    {
                                        "bindingUrl": "str",  # Required. 
                                        "rules": [
                                            {
                                                "displayName": "str",  # Optional. The configuration rules for path pattern extraction.
                                                "isResourceSet": True,  # Optional. Default value is True. The configuration rules for path pattern extraction.
                                                "lastUpdatedTimestamp": 0.0,  # Optional. The configuration rules for path pattern extraction.
                                                "name": "str",  # Optional. The configuration rules for path pattern extraction.
                                                "qualifiedName": "str"  # Required. 
                                            }
                                        ],
                                        "storeType": "str"  # Required. 
                                    }
                                ],
                                "version": 0  # Optional. The configuration rules for path pattern extraction.
                            }
                        }
                    ]
                }
        """
        skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_resource_set_rules_list_resource_set_rules_request(
                    skip_token=skip_token,
                    template_url=self.list_resource_set_rules.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_resource_set_rules_list_resource_set_rules_request(
                    skip_token=skip_token,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_resource_set_rules.metadata = {'url': '/resourceSetRuleConfigs'}  # type: ignore
