waypipe(1)

# NAME

waypipe - A transparent proxy for Wayland applications

# SYNOPSIS

*waypipe* [options...] *ssh* [ssh options] _destination_ _command..._

*waypipe* [options...] *client*++
*waypipe* [options...] *server* -- _command..._++
*waypipe* *bench*++
*waypipe* [*--version*] [*-h*, *--help*]

\[options...\] = [*-c*, *--compress* C] [*-d*, *--debug*] [*-n*, *--no-gpu*] [*-o*, *--oneshot*] [*-s*, *--socket* S] [*--display* D] [*--drm-node* R] [*--remote-node* R] [*--remote-bin* R] [*--remote-socket* S] [*--login-shell*] [*--threads* T] [*--title-prefix* P] [*--unlink-socket*] [*--video* V] [*--vsock*] [*--secctx S*]


# DESCRIPTION

Waypipe is a proxy for Wayland clients, with the aim of supporting behavior
like *ssh -X*.

Prefixing an *ssh ...* command to become *waypipe ssh ...* will automatically
run *waypipe* both locally and remotely, and modify the ssh command to set up
forwarding between the two instances of *waypipe*. The remote instance
will act like a Wayland compositor, letting Wayland applications that are
run remotely be displayed locally.

When run as *waypipe client*, it will open a socket (by default at
_/tmp/waypipe-client.sock_) and will connect to the local Wayland compositor
and forward all Wayland applications which were linked to it over the socket
by a matching *waypipe server* instance.

When run as *waypipe server*, it will run the command that follows in its
command line invocation, set up its own Wayland compositor socket, and
try to connect to its matching *waypipe client* socket (by default
_/tmp/waypipe-server.sock_) and try to forward all the Wayland clients
that connect to fake compositor socket to the matching *waypipe client*.

The *waypipe bench* mode can be used to estimate which compression options
produce the lowest latency, for a given connection bandwidth and number of
threads. It tests two synthetic images, one made to be roughly as
compressible as images containing text, and one made to be roughly as
compressible as images containing pictures.

# OPTIONS

*-c C, --compress C*
	Select the compression method applied to data transfers. Options are
	_none_ (for high-bandwidth networks), _lz4_ (intermediate), _zstd_
	(slow connection). The default compression is _lz4_.† The compression
	level can be chosen by appending = followed by a number. For example,
	if *C* is _zstd=7_, waypipe will use level 7 Zstd compression.

	† Unless *waypipe* is built without LZ4 support, in which case the default
	compression will be _none_.

*-d, --debug*
	Print debug log messages.

*-h, --help*
	Show help message and quit.

*-n, --no-gpu*
	Block protocols like wayland-drm and linux-dmabuf which require access
	to e.g. render nodes.

*-o, --oneshot*
	Only permit a single connection, and exit when it is closed.

*-s S, --socket S*
	Use *S* as the path for the Unix socket. The default socket path for
	server mode is _/tmp/waypipe-server.sock_; for client mode, it is
	_/tmp/waypipe-client.sock_; and in ssh mode, *S* gives the prefix used by
	both the client and the server for their socket paths. (The actual socket
	paths in ssh mode add a randomized suffix to *S*.) The default prefix in ssh
	mode is _/tmp/waypipe_.

	When vsock is enabled use *S* to specify a CID and a port number.

*--version*
	Briefly describe Waypipe's version and the features it was built with,
	then quit. Possible features: LZ4 compression support, ZSTD compression
	support, ability to transfer DMABUFs, video compression support.

*--display D*
	For server or ssh mode, provide _WAYLAND_DISPLAY_ and let waypipe configure
	its Wayland display socket to have a matching path. (If *D* is not an
	absolute path, the socket will be created in the folder given by the
	environment variable _XDG_RUNTIME_DIR_.)

*--drm-node R*
	Specify the path *R* to the drm device that this instance of waypipe should
	use and (in server mode) notify connecting applications about.

*--remote-node R*
	In ssh mode, specify the path *R* to the drm device that the remote instance
	of waypipe (running in server mode) should use.

*--remote-bin R*
	In ssh mode, specify the path *R* to the waypipe binary on the remote
	computer, or its name if it is available in _PATH_. It defaults to
	*waypipe* if this option isn’t passed.

*--remote-socket R*
	In ssh mode, specify the prefix used by the remote *waypipe server* for
	its socket path. This overrides the *--socket* option, on the server side
	only.

*--login-shell*
	Only for server mode; if no command is being run, open a login shell.

*--threads T*
	Set the number of total threads (including the main thread) which a *waypipe*
	instance will create. These threads will be used to parallelize compression
	operations. This flag is passed on to *waypipe server* when given to *waypipe
	ssh*. The flag also controls the thread count for *waypipe bench*. The default
	behavior (choosable by setting *T* to _0_) is to use half as many threads
	as the computer has hardware threads available.

*--title-prefix P*
	Prepend *P* to any window titles specified using the XDG shell protocol. In
	ssh mode, the prefix is applied only on the client side.

*--unlink-socket*
	Only for server mode; on shutdown, unlink the Unix socket that waypipe connects to.

*--video V*
	Compress specific DMABUF formats using a lossy video codec. Opaque, 10-bit, and
	multiplanar formats, among others, are not supported. *V* is a comma separated 
	list of options to control the video encoding. (For example: *--video av1,hw*.)
	Later options supersede earlier ones.

	*none*
		Do not use video encoding.

	*h264*
		Use H.264 encoded video.
		
	*vp9*
		Use VP9 encoded video.

	*av1*
		Use VP9 encoded video.

	*sw*, *swenc*, *swdec*
		Use software encoding or decoding, when available.

	*hw*, *hwenc*, *hwdec*
		Use hardware encoding or decoding, when available.
		
	*bpf=B*
		Set the target bit rate of the video encoder, in units of bits per frame.
		*B* can be written as an integer or with exponential notation; thus
		*--video=bpf=7.5e5* is equivalent to *--video=bpf=750000*.

*--vsock*
	Use vsock instead of unix sockets. This is used when waypipe is running in
	virtual machines. With this option enabled specify a CID and a port number in *S*.
	CID is only used in the server mode and can be omitted when connecting from a
	guest virtual machine to host.

*--secctx S*
	Enable the Wayland security context protocol (client or ssh modes). Specify
	an application ID *S* that will be attached to the security context.

*--control C*++
*--hwvideo*++
*--allow-tiled*
	Options present in older versions of Waypipe that were removed.

# EXAMPLE 

The following *waypipe ssh* subcommand will attempt to run *weston-flower* on
the server _exserv_, displaying the result on the local system.

```
	waypipe ssh user@exserv weston-flower
```

One can obtain similar behavior by explicitly running waypipe and ssh:

```
	waypipe --socket /tmp/socket-client client  &
	ssh -R /tmp/socket-server:/tmp/socket-client user@exserv \\
		waypipe --socket /tmp/socket-server server -- weston-flower
	kill %1
```

Waypipe may be run locally without an SSH connection by specifying matching
socket paths. For example:

```
	waypipe --socket /tmp/waypipe.sock client &
	waypipe --socket /tmp/waypipe.sock server weston-simple-dmabuf-egl
	kill %1
	rm /tmp/waypipe.sock
```

Using transports other than SSH is a bit more complicated. A recipe with ncat
to connect to _remote_ from computer _local_:

```
    $ waypipe --socket /tmp/waypipe-remote.sock client &
    $ ncat --ssl -lk 12345 --sh-exec 'ncat -U /tmp/waypipe-remote.sock' &
    $ ssh user@remote

    > ncat -lkU /tmp/waypipe-local.sock --sh-exec 'ncat --ssl local 12345' &
    > waypipe --display wayland-local \\
                --socket /tmp/waypipe-local.sock server -- sleep inf &
    > WAYLAND_DISPLAY=wayland-local application
```

Given a certificate file, socat can also provide an encrypted connection
(remove 'verify=0' to check certificates):

```
    $ waypipe --socket /tmp/waypipe-remote.sock client &
    $ socat openssl-listen:12345,reuseaddr,cert=certificate.pem,verify=0,fork \\
        unix-connect:/tmp/waypipe-remote.sock
    $ ssh user@remote

    > socat unix-listen:/tmp/waypipe-local.sock,reuseaddr,fork \\
        openssl-connect:local:12345,verify=0 &
    > waypipe --socket /tmp/waypipe-local.sock server -- application
```

Many applications require specific environment variables to use Wayland instead
of X11. If ssh isn't configured to support loading _~/.ssh/environment_, or
to allow specific variables to be set with _AcceptEnv_/_SetEnv_, one can run
*waypipe ssh* without a command (and thereby open a login shell), or use *env*
to set the needed variables each time:

```
	 waypipe ssh user@host env XDG_SESSION_TYPE=wayland dolphin
```

In some cases, one may wish to set environment variables for the *waypipe
server* process itself; the above trick with *env* will not do this, because the
*env* process will be a child of *waypipe server*, not the other way around.
Instead, one can use _~/.ssh/environment_, or use the *--remote-bin* option to
change the remote Waypipe instance to a shell script that sets the environment
before running the actual *waypipe* program.

## Running waypipe in virtual machines

When running waypipe in virtual machines on the same host it is possible to use vsock
for efficient inter-vm communication. The following scenarios are supported:

- Running applications on host from guest.

```
	host> waypipe --vsock -s 1234 client
	guest> waypipe --vsock -s 1234 server weston-terminal
```

- Running applications in a guest virtual machine from host.

```
	guest> waypipe --vsock -s 1234 client
	host> waypipe --vsock -s 3:1234 server weston-terminal
```

In this example waypipe server connects to a virtual machine with CID 3 on port 1234.

- Running applications in a guest virtual machine from other guest virtual machines.
When running both client and server in virtual machines it is possble to enable the
VMADDR_FLAG_TO_HOST flag for sibling communication by prefixing the CID with an s:

```
	guest> waypipe --vsock -s 1234 client
	guest> waypipe --vsock -s s3:1234 server weston-terminal
```

In this case all packets will be routed to host where they can be forwarded to another
virtual machine with a vhost-device-vsock device or some other utility.

# ENVIRONMENT

When running as a server, by default _WAYLAND_DISPLAY_ will be set for the
invoked process.

If the *--oneshot* flag is set, waypipe will instead set _WAYLAND_SOCKET_ and
inherit an already connected socketpair file descriptor to the invoked (child)
process. Some programs open and close a Wayland connection repeatedly as part
of their initialization, and will not work correctly with this flag.

# EXIT STATUS

*waypipe ssh* will exit with the exit status code from the remote command, or
with return code 1 if there has been an error.

# SECURITY

Waypipe does not provide any strong security guarantees, and connecting to
untrusted servers is not recommended. It does not filter which Wayland
protocols the compositor makes available to the client (with a few exceptions
for protocols that require file descriptors which Waypipe cannot yet handle).
For example, if a Wayland compositor gives all its clients access to a
screenshot or lock-screen protocol, then proxied clients run under Waypipe
can also make screenshots or lock the screen.

In general, applications are not well tested against malicious compositors,
and compositors are not well tested against malicious clients. Waypipe can
connect the two, and may blindly forward denial-of-service and other attacks.

Waypipe itself is written in C and links to compression, graphics, and video
libraries; both it and these libraries may have security bugs. Some risk
can be avoided by building Waypipe with DMABUF support turned off, or
running Waypipe with the *--no-gpu* flag so that it does not expose graphics
libraries.

*waypipe ssh* has no explicit protections against timing attacks; an observer
to the resulting network traffic may, by studying the size and timing of
packets, learn information about the user's interaction with a Wayland client
proxied through *waypipe ssh*. For example: a lack of activity suggests the
user is not currently using the application, while an intermittant stream of
messages from the compositor to the client may indicate mouse movement (or
maybe something else: the contents of the messages are protected by *ssh*.)

The memory used by Waypipe processes may, at a given time, include Wayland
messages encoding user input, and the contents of current and recent frames
drawn for application windows. Swap should be encrypted to prevent this data
from being leaked to disk.

# BUGS

File bug reports at: https://gitlab.freedesktop.org/mstoeckl/waypipe/

## Common issues

Some programs (gnome-terminal, firefox, kate, among others) have special
mechanisms to ensure that only one process is running at a time. Starting
those programs under Waypipe while they are running under a different
Wayland compositor may silently open a window or tab in the original
instance of the program. Such programs may have a command line argument
to create a new instance.

The *waypipe ssh* command requires that the *ssh* executable supports Unix
socket forwarding; this is only supported in OpenSSH since version 6.7 (from
2014), and may require specific configuration. Other implementations of SSH may
not be able to forward Unix sockets; see the EXAMPLE section above for how to
use non-SSH transports.

# SEE ALSO

*weston*(1), *ssh*(1), *socat(1)*, *ncat(1)*
