#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 macaron
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Full Throttle Remastered
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250427.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='full-throttle-remastered'
GAME_NAME='Full Throttle Remastered'

ARCHIVE_BASE_0_NAME='full_throttle_remastered_en_gog_3_20993.sh'
ARCHIVE_BASE_0_MD5='2f4bf151e225e7dfa9bec31ed49b721c'
ARCHIVE_BASE_0_SIZE='5400000'
ARCHIVE_BASE_0_VERSION='1.0-gog20993'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/full_throttle_remastered'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_RELATIVE_PATH='lib'
CONTENT_LIBS_BIN_FILES='
libfmod.so.8'
CONTENT_GAME_BIN_FILES='
Throttle
gamecontrollerdb.txt'
CONTENT_GAME_DATA_FILES='
full.data'
CONTENT_DOC_DATA_FILES='
readme.txt'

APP_MAIN_EXE='Throttle'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Restore the full data file from its parts
	mv 'full.data.split00' 'full.data'
	cat 'full.data.split01' >> 'full.data'
	rm 'full.data.split01'
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Force the use of system-provided SDL
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(launcher_tweak_sdl_override)"
PKG_BIN_DEPENDENCIES_LIBRARIES="$(dependencies_list_native_libraries 'PKG_BIN')
libSDL2-2.0.so.0"

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
