#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2021 Hoël Bézier <hoelbezier@riseup.net>
set -o errexit

###
# Age of Mythology
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250605.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='age-of-mythology'
GAME_NAME='Age of Mythology'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_DEMO_0_NAME='mtrial.exe'
ARCHIVE_BASE_DEMO_0_MD5='c475268b774c0fd469802e915b3c3803'
ARCHIVE_BASE_DEMO_0_TYPE='cabinet'
ARCHIVE_BASE_DEMO_0_SIZE='550000'
ARCHIVE_BASE_DEMO_0_VERSION='1.0-archiveorg1'
ARCHIVE_BASE_DEMO_0_URL='https://archive.org/details/AgeOfMythologyDemo'

CONTENT_PATH_DEFAULT='aom'
CONTENT_GAME_BIN_FILES='
mp3dec.asi
*.exe
*.dll'
CONTENT_GAME0_BIN_PATH='.'
CONTENT_GAME0_BIN_FILES='
*.dll'
CONTENT_FONTS_DATA_FILES='
arialuni.ttf
gio_bk.ttf
per_____.ttf'
CONTENT_FONTS0_DATA_PATH='.'
CONTENT_FONTS0_DATA_FILES='
georgiab.ttf
georgiai.ttf
georgia.ttf
georgiaz.ttf'
CONTENT_GAME_DATA_FILES='
ai
anim
avi
data
docs
fonts
gfxconfig
god powers
history
models
ppdata
rm
scenario
sound
startup
textures
trigger
10??
20??
30??
*.bmp'
CONTENT_DOC_DATA_PATH='.'
CONTENT_DOC_DATA_FILES='
*.rtf'

USER_PERSISTENT_FILES='
startup/persistent.cfg
rts3banglog.txt
*.XMB
*.xml
.xs'
USER_PERSISTENT_DIRECTORIES='
cameratracks
default
language
savegame
screenshots
users'

## Without a virtual desktop,
## keyboard input is lost on loss of focus.
WINE_VIRTUAL_DESKTOP='1600x1200'

APP_MAIN_EXE='aom.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Rename files with truncated names.
	mv 'gfxcon_1' 'gfxconfig'
	mv 'godpow_1' 'god powers'
	mv 'sound/cinema_1' 'sound/cinematics'
	mv 'sound/music/interf_1' 'sound/music/interface'
	mv '1028/dwin0000.dll' '1028/dwintl.dll'
	mv '1029/dwin0001.dll' '1029/dwintl.dll'
	mv '1030/dwin0002.dll' '1030/dwintl.dll'
	mv '1031/dwin0003.dll' '1031/dwintl.dll'
	mv '1031/msil0000.bin' '1031/msiloadr.bin'
	mv '1031/webl0000.bin' '1031/webloadr.bin'
	mv '1032/dwin0004.dll' '1032/dwintl.dll'
	mv '1033/dwin0005.dll' '1033/dwintl.dll'
	mv '1033/msil0001.bin' '1033/msiloadr.bin'
	mv '1033/webl0001.bin' '1033/webloadr.bin'
	mv '1035/dwin0006.dll' '1035/dwintl.dll'
	mv '1036/dwin0007.dll' '1036/dwintl.dll'
	mv '1036/msil0002.bin' '1036/msiloadr.bin'
	mv '1036/webl0002.bin' '1036/webloadr.bin'
	mv '1037/dwin0008.dll' '1037/dwintl.dll'
	mv '1038/dwin0009.dll' '1038/dwintl.dll'
	mv '1040/dwin000a.dll' '1040/dwintl.dll'
	mv '1040/msil0003.bin' '1040/msiloadr.bin'
	mv '1040/webl0003.bin' '1040/webloadr.bin'
	mv '1041/dwin000b.dll' '1041/dwintl.dll'
	mv '1041/msil0004.bin' '1041/msiloadr.bin'
	mv '1041/webl0004.bin' '1041/webloadr.bin'
	mv '1042/dwin000c.dll' '1042/dwintl.dll'
	mv '1042/msil0005.bin' '1042/msiloadr.bin'
	mv '1042/webl0005.bin' '1042/webloadr.bin'
	mv '1043/dwin000d.dll' '1043/dwintl.dll'
	mv '1044/dwin000e.dll' '1044/dwintl.dll'
	mv '1045/dwin000f.dll' '1045/dwintl.dll'
	mv '1046/dwin0010.dll' '1046/dwintl.dll'
	mv '1048/dwin0011.dll' '1048/dwintl.dll'
	mv '1049/dwin0012.dll' '1049/dwintl.dll'
	mv '1050/dwin0013.dll' '1050/dwintl.dll'
	mv '1051/dwin0014.dll' '1051/dwintl.dll'
	mv '1053/dwin0015.dll' '1053/dwintl.dll'
	mv '1054/dwin0016.dll' '1054/dwintl.dll'
	mv '1055/dwin0017.dll' '1055/dwintl.dll'
	mv '1060/dwin0018.dll' '1060/dwintl.dll'
	mv '2052/dwin0019.dll' '2052/dwintl.dll'
	mv '2052/msil0006.bin' '2052/msiloadr.bin'
	mv '2052/webl0006.bin' '2052/webloadr.bin'
	mv '2070/dwin001a.dll' '2070/dwintl.dll'
	mv '3076/dwin001b.dll' '3076/dwintl.dll'
	mv '3082/dwin001c.dll' '3082/dwintl.dll'
	mv '3082/msil0007.bin' '3082/msiloadr.bin'
	mv '3082/webl0007.bin' '3082/webloadr.bin'
	mv 'ai/ao9982_1.xs' 'ai/aomdefaultaiprogress.xs'
	mv 'ai/aomdef_1.xs' 'ai/aomdefaultai.xs'
	mv 'ai/aomdef_2.xs' 'ai/aomdefaultaieconomy.xs'
	mv 'ai/aomdef_3.xs' 'ai/aomdefaultaigodpowers.xs'
	mv 'ai/aomdef_4.xs' 'ai/aomdefaultaimilitary.xs'
	mv 'ai/defaul_1.xml' 'ai/defaultboom.xml'
	mv 'ai/defaul_2.xml' 'ai/defaultrandom.xml'
	mv 'ai/defaul_3.xml' 'ai/defaultrush.xml'
	mv 'ai/scn17a_1.xs' 'ai/scn17altp2.xs'
	mv 'ai/scn28p_1.xs' 'ai/scn28p234.xs'
	mv 'ai/scnlib_1.xs' 'ai/scn lib.xs'
	mv 'autopa_1.exe' 'autopatcher.exe'
	mv 'avi/aomlog_1.bik' 'avi/aom logo.bik'
	mv 'data/fimbul_1.lgt' 'data/fimbulwinter.lgt'
	mv 'data/ghostl_1.lgt' 'data/ghost lake.lgt'
	mv 'data/learnt_1.cpn' 'data/learn to play.cpn'
	mv 'data/mainca_1.cpn' 'data/main campaign.cpn'
	mv 'data/prword_1.xml' 'data/prwordlist.xml'
	mv 'docs/aomais_1.rtf' 'docs/aom ai script help file.rtf'
	mv 'docs/aomce__1.pdf' 'docs/aomce_egyptianqrc_en.pdf'
	mv 'docs/aomce__2.pdf' 'docs/aomce_greekqrc_en.pdf'
	mv 'docs/aomce__3.pdf' 'docs/aomce_norseqrc_en.pdf'
	mv 'docs/aom_in_1.pdf' 'docs/aom_ingamemanual.pdf'
	mv 'docs/aomran_1.rtf' 'docs/aom random map help file.rtf'
	mv 'docs/aomsce_1.rtf' 'docs/aom scenario editor faq.rtf'
	mv 'docs/aomsta_1.pdf' 'docs/aomstandard_manual_en.pdf'
	mv 'docs/troubl_1.rtf' 'docs/troubleshooting crashing issues.rtf'
	mv 'docs/troubl_2.rtf' 'docs/troubleshooting display problems.rtf'
	mv 'esocli_1.dll' 'esoclientdll.dll'
	mv 'fonts/arialu_1.msk' 'fonts/arial unicode ms.msk'
	mv 'fonts/courie_1.msk' 'fonts/courier new.msk'
	mv 'fonts/frizqu_1.msk' 'fonts/friz quadrata tt.msk'
	mv 'fonts/giovan_1.msk' 'fonts/giovanni book.msk'
	mv 'fonts/giovan_2.msk' 'fonts/giovanni test.msk'
	mv 'fonts/giovan_3.msk' 'fonts/giovanniitctt.msk'
	mv 'fonts/imeuis_1.xml' 'fonts/imeuisettings.xml'
	mv 'fonts/timesn_1.msk' 'fonts/times new roman.msk'
	mv 'gfxconfig/0x015d_1.gfx' 'gfxconfig/0x015d_number9.gfx'
	mv 'gfxconfig/0x0315_1.gfx' 'gfxconfig/0x0315_sis.gfx'
	mv 'gfxconfig/0x1002_1.gfx' 'gfxconfig/0x1002_ati.gfx'
	mv 'gfxconfig/0x100c_1.gfx' 'gfxconfig/0x100c_tseng.gfx'
	mv 'gfxconfig/0x1013_1.gfx' 'gfxconfig/0x1013_cirruslogic.gfx'
	mv 'gfxconfig/0x1023_1.gfx' 'gfxconfig/0x1023_trident.gfx'
	mv 'gfxconfig/0x1029_1.gfx' 'gfxconfig/0x1029_trident.gfx'
	mv 'gfxconfig/0x102b_1.gfx' 'gfxconfig/0x102b_matrox.gfx'
	mv 'gfxconfig/0x1039_1.gfx' 'gfxconfig/0x1039_sis.gfx'
	mv 'gfxconfig/0x104a_1.gfx' 'gfxconfig/0x104a_stmicroelectronics.gfx'
	mv 'gfxconfig/0x104c_1.gfx' 'gfxconfig/0x104c_3dlabs.gfx'
	mv 'gfxconfig/0x104e_1.gfx' 'gfxconfig/0x104e_oaktech.gfx'
	mv 'gfxconfig/0x10c8_1.gfx' 'gfxconfig/0x10c8_neomagic.gfx'
	mv 'gfxconfig/0x10d9_1.gfx' 'gfxconfig/0x10d9_3dfx.gfx'
	mv 'gfxconfig/0x10de_1.gfx' 'gfxconfig/0x10de_nvidia.gfx'
	mv 'gfxconfig/0x110b_1.gfx' 'gfxconfig/0x110b_chromatic.gfx'
	mv 'gfxconfig/0x1142_1.gfx' 'gfxconfig/0x1142_3dfx.gfx'
	mv 'gfxconfig/0x1163_1.gfx' 'gfxconfig/0x1163_rendition.gfx'
	mv 'gfxconfig/0x121a_1.gfx' 'gfxconfig/0x121a_3dfx.gfx'
	mv 'gfxconfig/0x12d2_1.gfx' 'gfxconfig/0x12d2_nvidia.gfx'
	mv 'gfxconfig/0x14af_1.gfx' 'gfxconfig/0x14af_guillemot.gfx'
	mv 'gfxconfig/0x3d3d_1.gfx' 'gfxconfig/0x3d3d_3dlabs.gfx'
	mv 'gfxconfig/0x5333_1.gfx' 'gfxconfig/0x5333_s3.gfx'
	mv 'gfxconfig/0x8086_1.gfx' 'gfxconfig/0x8086_intel.gfx'
	mv 'gfxconfig/cyberb_1.gfx' 'gfxconfig/cyberbladexp.gfx'
	mv 'gfxconfig/geforc_1.gfx' 'gfxconfig/geforce1and2.gfx'
	mv 'gfxconfig/mt40b6_1.tss' 'gfxconfig/mtlinearblendalphaemissivespecularfactor_nvidia.tss'
	mv 'gfxconfig/mt6b37_1.tss' 'gfxconfig/mtlinearblendalphaemissivespecularfactor.tss'
	mv 'gfxconfig/mt6db5_1.tss' 'gfxconfig/mtlinearblendinversealpha.tss'
	mv 'gfxconfig/mt81aa_1.tss' 'gfxconfig/mtlinearblend_nvidia.tss'
	mv 'gfxconfig/mt8378_1.tss' 'gfxconfig/mtlinearblendemissivespecularfactor.tss'
	mv 'gfxconfig/mta5c3_1.tss' 'gfxconfig/mtlinearblendemissivespecularfactor_nvidia.tss'
	mv 'gfxconfig/mtadda_1.tss' 'gfxconfig/mtaddalpha.tss'
	mv 'gfxconfig/mtadda_2.tss' 'gfxconfig/mtaddalpha_nvidia.tss'
	mv 'gfxconfig/mtaddf_1.tss' 'gfxconfig/mtaddfactor.tss'
	mv 'gfxconfig/mtaddf_2.tss' 'gfxconfig/mtaddfactor_nvidia.tss'
	mv 'gfxconfig/mtaddi_1.tss' 'gfxconfig/mtaddinversealpha.tss'
	mv 'gfxconfig/mtaddi_2.tss' 'gfxconfig/mtaddinversealpha_nvidia.tss'
	mv 'gfxconfig/mte0b7_1.tss' 'gfxconfig/mtlinearblendalpha_nvidia.tss'
	mv 'gfxconfig/mtee67_1.tss' 'gfxconfig/mtlinearblendinversealpha_nvidia.tss'
	mv 'gfxconfig/mtemis_1.tss' 'gfxconfig/mtemissivespecularfactor.tss'
	mv 'gfxconfig/mtemis_2.tss' 'gfxconfig/mtemissivespecularfactor2stage.tss'
	mv 'gfxconfig/mtemis_3.tss' 'gfxconfig/mtemissivespecularfactornotx.tss'
	mv 'gfxconfig/mtemis_4.tss' 'gfxconfig/mtemissivespecularfactornotx2stage.tss'
	mv 'gfxconfig/mtfade_1.tss' 'gfxconfig/mtfadelightmapbyalpha.tss'
	mv 'gfxconfig/mtfogm_1.tss' 'gfxconfig/mtfogmask.tss'
	mv 'gfxconfig/mtfogm_2.tss' 'gfxconfig/mtfogmask2stage.tss'
	mv 'gfxconfig/mtligh_1.tss' 'gfxconfig/mtlightmap.tss'
	mv 'gfxconfig/mtline_1.tss' 'gfxconfig/mtlinearblend.tss'
	mv 'gfxconfig/mtline_2.tss' 'gfxconfig/mtlinearblend2stage.tss'
	mv 'gfxconfig/mtline_3.tss' 'gfxconfig/mtlinearblendalpha.tss'
	mv 'gfxconfig/mtline_4.tss' 'gfxconfig/mtlinearblendalpha2stage.tss'
	mv 'gfxconfig/mtoff2_1.tss' 'gfxconfig/mtoff2stage.tss'
	mv 'gfxconfig/mtoffn_1.tss' 'gfxconfig/mtoffnotx.tss'
	mv 'gfxconfig/mtoffn_2.tss' 'gfxconfig/mtoffnotx2stage.tss'
	mv 'gfxconfig/mtoffn_3.tss' 'gfxconfig/mtoffnovtxalpha.tss'
	mv 'gfxconfig/mtoffn_4.tss' 'gfxconfig/mtoffnovtxalpha2stage.tss'
	mv 'gfxconfig/mtoffo_1.tss' 'gfxconfig/mtoffonlyalpha.tss'
	mv 'gfxconfig/mtoffo_2.tss' 'gfxconfig/mtoffonlyalpha2stage.tss'
	mv 'gfxconfig/mtsepa_1.tss' 'gfxconfig/mtseparatealpha.tss'
	mv 'gfxconfig/mtspec_1.tss' 'gfxconfig/mtspecularbump.tss'
	mv 'gfxconfig/mtspec_2.tss' 'gfxconfig/mtspecularbump2stage.tss'
	mv 'gfxconfig/permed_1.gfx' 'gfxconfig/permedia2.gfx'
	mv 'gfxconfig/permed_2.gfx' 'gfxconfig/permedia3.gfx'
	mv 'gfxconfig/radeon_1.gfx' 'gfxconfig/radeon7500.gfx'
	mv 'gfxconfig/radeon_2.gfx' 'gfxconfig/radeon8500.gfx'
	mv 'gfxconfig/ragelt_1.gfx' 'gfxconfig/rageltpro.gfx'
	mv 'gfxconfig/refere_1.gfx' 'gfxconfig/reference.gfx'
	mv 'gfxconfig/savage_1.gfx' 'gfxconfig/savage2000.gfx'
	mv 'god powers/godpow_1.bar' 'god powers/godpowers.bar'
	mv 'history/arrows_1.txt' 'history/arrow ships.txt'
	mv 'history/blackm_1.txt' 'history/black map.txt'
	mv 'history/buildi_1.txt' 'history/buildings.txt'
	mv 'history/fogofw_1.txt' 'history/fog of war.txt'
	mv 'history/godpow_1.txt' 'history/god powers.txt'
	mv 'history/herode_1.txt' 'history/hero death model.txt'
	mv 'history/hippop_1.txt' 'history/hippopotamus.txt'
	mv 'history/humans_1.txt' 'history/human soldiers.txt'
	mv 'history/lineof_1.txt' 'history/line of sight.txt'
	mv 'history/mythun_1.txt' 'history/myth units.txt'
	mv 'history/popula_1.txt' 'history/population.txt'
	mv 'history/rammin_1.txt' 'history/ramming ships.txt'
	mv 'history/rammmi_1.txt' 'history/rammming ships.txt'
	mv 'history/sieges_1.txt' 'history/siege ships.txt'
	mv 'history/siegew_1.txt' 'history/siege weapons.txt'
	mv 'history/tableo_1.xmb' 'history/table of contents.xmb'
	mv 'history/techs/adzeof_1.txt' 'history/techs/adze of wepwawet.txt'
	mv 'history/techs/aegiss_1.txt' 'history/techs/aegis shield.txt'
	mv 'history/techs/age1ha_1.txt' 'history/techs/age 1 hades.txt'
	mv 'history/techs/age1is_1.txt' 'history/techs/age 1 isis.txt'
	mv 'history/techs/age1lo_1.txt' 'history/techs/age 1 loki.txt'
	mv 'history/techs/age1od_1.txt' 'history/techs/age 1 odin.txt'
	mv 'history/techs/age1po_1.txt' 'history/techs/age 1 poseidon.txt'
	mv 'history/techs/age1ra_1.txt' 'history/techs/age 1 ra.txt'
	mv 'history/techs/age1se_1.txt' 'history/techs/age 1 set.txt'
	mv 'history/techs/age1th_1.txt' 'history/techs/age 1 thor.txt'
	mv 'history/techs/age1ze_1.txt' 'history/techs/age 1 zeus.txt'
	mv 'history/techs/age2an_1.txt' 'history/techs/age 2 anubis.txt'
	mv 'history/techs/age2ar_1.txt' 'history/techs/age 2 ares.txt'
	mv 'history/techs/age2at_1.txt' 'history/techs/age 2 athena.txt'
	mv 'history/techs/age2ba_1.txt' 'history/techs/age 2 bast.txt'
	mv 'history/techs/age2fo_1.txt' 'history/techs/age 2 forseti.txt'
	mv 'history/techs/age2fr_1.txt' 'history/techs/age 2 freyja.txt'
	mv 'history/techs/age2he_1.txt' 'history/techs/age 2 heimdall.txt'
	mv 'history/techs/age2he_2.txt' 'history/techs/age 2 hermes.txt'
	mv 'history/techs/age2pt_1.txt' 'history/techs/age 2 ptah.txt'
	mv 'history/techs/age3ap_1.txt' 'history/techs/age 3 aphrodite.txt'
	mv 'history/techs/age3ap_2.txt' 'history/techs/age 3 apollo.txt'
	mv 'history/techs/age3br_1.txt' 'history/techs/age 3 bragi.txt'
	mv 'history/techs/age3di_1.txt' 'history/techs/age 3 dionysos.txt'
	mv 'history/techs/age3ha_1.txt' 'history/techs/age 3 hathor.txt'
	mv 'history/techs/age3ne_1.txt' 'history/techs/age 3 nephthys.txt'
	mv 'history/techs/age3nj_1.txt' 'history/techs/age 3 njord.txt'
	mv 'history/techs/age3se_1.txt' 'history/techs/age 3 sekhmet.txt'
	mv 'history/techs/age3sk_1.txt' 'history/techs/age 3 skadi.txt'
	mv 'history/techs/age4ar_1.txt' 'history/techs/age 4 artemis.txt'
	mv 'history/techs/age4ba_1.txt' 'history/techs/age 4 baldr.txt'
	mv 'history/techs/age4he_1.txt' 'history/techs/age 4 hel.txt'
	mv 'history/techs/age4he_2.txt' 'history/techs/age 4 hephaestus.txt'
	mv 'history/techs/age4he_3.txt' 'history/techs/age 4 hera.txt'
	mv 'history/techs/age4ho_1.txt' 'history/techs/age 4 horus.txt'
	mv 'history/techs/age4os_1.txt' 'history/techs/age 4 osiris.txt'
	mv 'history/techs/age4th_1.txt' 'history/techs/age 4 thoth.txt'
	mv 'history/techs/age4ty_1.txt' 'history/techs/age 4 tyr.txt'
	mv 'history/techs/ambass_1.txt' 'history/techs/ambassadors.txt'
	mv 'history/techs/anastr_1.txt' 'history/techs/anastrophe.txt'
	mv 'history/techs/ancest_1.txt' 'history/techs/ancestors.txt'
	mv 'history/techs/animal_1.txt' 'history/techs/animal magnetism.txt'
	mv 'history/techs/archit_1.txt' 'history/techs/architects.txt'
	mv 'history/techs/arctic_1.txt' 'history/techs/arctic gale.txt'
	mv 'history/techs/arctic_2.txt' 'history/techs/arctic winds.txt'
	mv 'history/techs/atefcr_1.txt' 'history/techs/atef crown.txt'
	mv 'history/techs/atheni_1.txt' 'history/techs/athenian wall.txt'
	mv 'history/techs/aurora_1.txt' 'history/techs/aurora borealis.txt'
	mv 'history/techs/axeofv_1.txt' 'history/techs/axe of vengeance.txt'
	mv 'history/techs/baccha_1.txt' 'history/techs/bacchanalia.txt'
	mv 'history/techs/ballis_1.txt' 'history/techs/ballista tower.txt'
	mv 'history/techs/berser_1.txt' 'history/techs/berserkergang.txt'
	mv 'history/techs/boilin_1.txt' 'history/techs/boiling oil.txt'
	mv 'history/techs/bonebo_1.txt' 'history/techs/bone bow.txt'
	mv 'history/techs/bookof_1.txt' 'history/techs/book of thoth.txt'
	mv 'history/techs/bowsaw_1.txt' 'history/techs/bow saw.txt'
	mv 'history/techs/br2276_1.txt' 'history/techs/bronze weapons.txt'
	mv 'history/techs/brdd97_1.txt' 'history/techs/bronze weapons thor.txt'
	mv 'history/techs/bronze_1.txt' 'history/techs/bronze mail.txt'
	mv 'history/techs/bronze_2.txt' 'history/techs/bronze mail thor.txt'
	mv 'history/techs/bronze_3.txt' 'history/techs/bronze shields.txt'
	mv 'history/techs/bronze_4.txt' 'history/techs/bronze shields thor.txt'
	mv 'history/techs/burnin_1.txt' 'history/techs/burning pitch.txt'
	mv 'history/techs/burnin_2.txt' 'history/techs/burning pitch thor.txt'
	mv 'history/techs/callof_1.txt' 'history/techs/call of valhalla.txt'
	mv 'history/techs/carpen_1.txt' 'history/techs/carpenters.txt'
	mv 'history/techs/carrie_1.txt' 'history/techs/carrier pigeons.txt'
	mv 'history/techs/ceasef_1.txt' 'history/techs/cease fire.txt'
	mv 'history/techs/ch5cf5_1.txt' 'history/techs/heavy chariots.txt'
	mv 'history/techs/ch9a9d_1.txt' 'history/techs/champion slingers.txt'
	mv 'history/techs/ch9fb2_1.txt' 'history/techs/medium archers.txt'
	mv 'history/techs/cha3d9_1.txt' 'history/techs/champion archers.txt'
	mv 'history/techs/cha9ae_1.txt' 'history/techs/heavy axemen.txt'
	mv 'history/techs/champi_1.txt' 'history/techs/champion camelry.txt'
	mv 'history/techs/champi_2.txt' 'history/techs/heavy camels.txt'
	mv 'history/techs/champi_3.txt' 'history/techs/medium cavalry.txt'
	mv 'history/techs/champi_4.txt' 'history/techs/heavy camelry.txt'
	mv 'history/techs/chcf33_1.txt' 'history/techs/medium infantry.txt'
	mv 'history/techs/citade_1.txt' 'history/techs/citadel wall.txt'
	mv 'history/techs/cityof_1.txt' 'history/techs/city of the dead.txt'
	mv 'history/techs/co3e7a_1.txt' 'history/techs/conscript archers.txt'
	mv 'history/techs/co3f35_1.txt' 'history/techs/conscript migdol soldiers.txt'
	mv 'history/techs/co73d0_1.txt' 'history/techs/conscript barracks soldiers.txt'
	mv 'history/techs/co8f28_1.txt' 'history/techs/copper weapons.txt'
	mv 'history/techs/coc88d_1.txt' 'history/techs/copper weapons thor.txt'
	mv 'history/techs/coe3f7_1.txt' 'history/techs/conscript sailors.txt'
	mv 'history/techs/conscr_1.txt' 'history/techs/conscript cavalry.txt'
	mv 'history/techs/conscr_2.txt' 'history/techs/conscript longhouse soldiers.txt'
	mv 'history/techs/conscr_3.txt' 'history/techs/conscript hill fort soldiers.txt'
	mv 'history/techs/conscr_4.txt' 'history/techs/conscript infantry.txt'
	mv 'history/techs/copper_1.txt' 'history/techs/copper mail.txt'
	mv 'history/techs/copper_2.txt' 'history/techs/copper mail thor.txt'
	mv 'history/techs/copper_3.txt' 'history/techs/copper shields.txt'
	mv 'history/techs/copper_4.txt' 'history/techs/copper shields thor.txt'
	mv 'history/techs/create_1.txt' 'history/techs/create gold.txt'
	mv 'history/techs/crenel_1.txt' 'history/techs/crenellations.txt'
	mv 'history/techs/criosp_1.txt' 'history/techs/criosphinx.txt'
	mv 'history/techs/crocod_1.txt' 'history/techs/crocodopolis.txt'
	mv 'history/techs/deimos_1.txt' 'history/techs/deimos sword of dread.txt'
	mv 'history/techs/desert_1.txt' 'history/techs/desert wind.txt'
	mv 'history/techs/divine_1.txt' 'history/techs/divine blood.txt'
	mv 'history/techs/drafth_1.txt' 'history/techs/draft horses.txt'
	mv 'history/techs/dragon_1.txt' 'history/techs/dragonscale shields.txt'
	mv 'history/techs/dwarve_1.txt' 'history/techs/dwarven auger.txt'
	mv 'history/techs/dwarve_2.txt' 'history/techs/dwarven mail.txt'
	mv 'history/techs/dwarve_3.txt' 'history/techs/dwarven shields.txt'
	mv 'history/techs/dwarve_4.txt' 'history/techs/dwarven weapons.txt'
	mv 'history/techs/earthq_1.txt' 'history/techs/earthquake.txt'
	mv 'history/techs/eldhri_1.txt' 'history/techs/eldhrimnir kettle.txt'
	mv 'history/techs/electr_1.txt' 'history/techs/electrum bullets.txt'
	mv 'history/techs/enclos_1.txt' 'history/techs/enclosed deck.txt'
	mv 'history/techs/engine_1.txt' 'history/techs/engineers.txt'
	mv 'history/techs/enyosb_1.txt' 'history/techs/enyos bow of horror.txt'
	mv 'history/techs/eyesin_1.txt' 'history/techs/eyes in the forest.txt'
	mv 'history/techs/faceof_1.txt' 'history/techs/face of the gorgon.txt'
	mv 'history/techs/feetof_1.txt' 'history/techs/feet of the jackal.txt'
	mv 'history/techs/flames_1.txt' 'history/techs/flames of typhon.txt'
	mv 'history/techs/flamin_1.txt' 'history/techs/flaming weapons.txt'
	mv 'history/techs/floodc_1.txt' 'history/techs/flood control.txt'
	mv 'history/techs/floodo_1.txt' 'history/techs/flood of the nile.txt'
	mv 'history/techs/forest_1.txt' 'history/techs/forest fire.txt'
	mv 'history/techs/forgeo_1.txt' 'history/techs/forge of olympus.txt'
	mv 'history/techs/fortif_1.txt' 'history/techs/fortified wall.txt'
	mv 'history/techs/fortif_2.txt' 'history/techs/fortify town center.txt'
	mv 'history/techs/funera_1.txt' 'history/techs/funeral barge.txt'
	mv 'history/techs/funera_2.txt' 'history/techs/funeral rites.txt'
	mv 'history/techs/golden_1.txt' 'history/techs/golden apples.txt'
	mv 'history/techs/granit_1.txt' 'history/techs/granite blood.txt'
	mv 'history/techs/greate_1.txt' 'history/techs/greatest of fifty.txt'
	mv 'history/techs/greath_1.txt' 'history/techs/great hunt.txt'
	mv 'history/techs/guardt_1.txt' 'history/techs/guard tower.txt'
	mv 'history/techs/hallof_1.txt' 'history/techs/hall of thanes.txt'
	mv 'history/techs/hamarr_1.txt' 'history/techs/hamarrtroll.txt'
	mv 'history/techs/hammer_1.txt' 'history/techs/hammer of the gods.txt'
	mv 'history/techs/handax_1.txt' 'history/techs/hand axe.txt'
	mv 'history/techs/handof_1.txt' 'history/techs/hand of talos.txt'
	mv 'history/techs/healin_1.txt' 'history/techs/healing spring.txt'
	mv 'history/techs/heavya_1.txt' 'history/techs/champion axemen.txt'
	mv 'history/techs/heavya_2.txt' 'history/techs/heavy spearmen.txt'
	mv 'history/techs/heavyc_1.txt' 'history/techs/champion camels.txt'
	mv 'history/techs/heavyc_2.txt' 'history/techs/medium axemen.txt'
	mv 'history/techs/heavyc_3.txt' 'history/techs/heavy archers.txt'
	mv 'history/techs/heavyc_4.txt' 'history/techs/medium slingers.txt'
	mv 'history/techs/heavye_1.txt' 'history/techs/heavy infantry.txt'
	mv 'history/techs/heavyi_1.txt' 'history/techs/champion chariots.txt'
	mv 'history/techs/heavys_1.txt' 'history/techs/heavy elephants.txt'
	mv 'history/techs/heavys_2.txt' 'history/techs/champion cavalry.txt'
	mv 'history/techs/hierac_1.txt' 'history/techs/hieracosphinx.txt'
	mv 'history/techs/huntin_1.txt' 'history/techs/hunting dogs.txt'
	mv 'history/techs/huntre_1.txt' 'history/techs/huntress axe.txt'
	mv 'history/techs/husban_1.txt' 'history/techs/husbandry.txt'
	mv 'history/techs/ironma_1.txt' 'history/techs/iron mail.txt'
	mv 'history/techs/ironma_2.txt' 'history/techs/iron mail thor.txt'
	mv 'history/techs/ironsh_1.txt' 'history/techs/iron shields.txt'
	mv 'history/techs/ironsh_2.txt' 'history/techs/iron shields thor.txt'
	mv 'history/techs/ironwe_1.txt' 'history/techs/iron weapons.txt'
	mv 'history/techs/ironwe_2.txt' 'history/techs/iron weapons thor.txt'
	mv 'history/techs/irriga_1.txt' 'history/techs/irrigation.txt'
	mv 'history/techs/labyri_1.txt' 'history/techs/labyrinth of minos.txt'
	mv 'history/techs/leathe_1.txt' 'history/techs/leather frame shield.txt'
	mv 'history/techs/levyar_1.txt' 'history/techs/levy cavalry.txt'
	mv 'history/techs/levyba_1.txt' 'history/techs/levy hill fort soldiers.txt'
	mv 'history/techs/levyca_1.txt' 'history/techs/levy longhouse soldiers.txt'
	mv 'history/techs/levyhi_1.txt' 'history/techs/levy migdol soldiers.txt'
	mv 'history/techs/levyin_1.txt' 'history/techs/levy barracks soldiers.txt'
	mv 'history/techs/levylo_1.txt' 'history/techs/levy archers.txt'
	mv 'history/techs/levymi_1.txt' 'history/techs/levy infantry.txt'
	mv 'history/techs/lightn_1.txt' 'history/techs/lightning storm.txt'
	mv 'history/techs/locust_1.txt' 'history/techs/locust swarm.txt'
	mv 'history/techs/lonewa_1.txt' 'history/techs/lone wanderer.txt'
	mv 'history/techs/longse_1.txt' 'history/techs/long serpent.txt'
	mv 'history/techs/lordof_1.txt' 'history/techs/lord of horses.txt'
	mv 'history/techs/me699b_1.txt' 'history/techs/champion spearmen.txt'
	mv 'history/techs/me78ac_1.txt' 'history/techs/champion infantry.txt'
	mv 'history/techs/medium_1.txt' 'history/techs/heavy cavalry.txt'
	mv 'history/techs/medium_2.txt' 'history/techs/champion elephants.txt'
	mv 'history/techs/medium_3.txt' 'history/techs/heavy slingers.txt'
	mv 'history/techs/medium_4.txt' 'history/techs/medium spearmen.txt'
	mv 'history/techs/meteor_1.txt' 'history/techs/meteoric iron mail.txt'
	mv 'history/techs/mithri_1.txt' 'history/techs/mithril breastplate.txt'
	mv 'history/techs/monstr_1.txt' 'history/techs/monstrous rage.txt'
	mv 'history/techs/navalo_1.txt' 'history/techs/naval oxybeles.txt'
	mv 'history/techs/necrop_1.txt' 'history/techs/necropolis.txt'
	mv 'history/techs/newkin_1.txt' 'history/techs/new kingdom.txt'
	mv 'history/techs/olympi_1.txt' 'history/techs/olympic parentage.txt'
	mv 'history/techs/omnisc_1.txt' 'history/techs/omniscience.txt'
	mv 'history/techs/pestil_1.txt' 'history/techs/pestilence.txt'
	mv 'history/techs/phobos_1.txt' 'history/techs/phobos spear of panic.txt'
	mv 'history/techs/pigsti_1.txt' 'history/techs/pig sticker.txt'
	mv 'history/techs/prospe_1.txt' 'history/techs/prosperity.txt'
	mv 'history/techs/purses_1.txt' 'history/techs/purse seine.txt'
	mv 'history/techs/ramoft_1.txt' 'history/techs/ram of the west wind.txt'
	mv 'history/techs/rebell_1.txt' 'history/techs/rebellion.txt'
	mv 'history/techs/reinfo_1.txt' 'history/techs/reinforced hull.txt'
	mv 'history/techs/restor_1.txt' 'history/techs/restoration.txt'
	mv 'history/techs/ringgi_1.txt' 'history/techs/ring giver.txt'
	mv 'history/techs/roarof_1.txt' 'history/techs/roar of orthus.txt'
	mv 'history/techs/sacred_1.txt' 'history/techs/sacred cats.txt'
	mv 'history/techs/safegu_1.txt' 'history/techs/safeguard.txt'
	mv 'history/techs/saltam_1.txt' 'history/techs/salt amphora.txt'
	mv 'history/techs/sandst_1.txt' 'history/techs/sandstorm.txt'
	mv 'history/techs/scallo_1.txt' 'history/techs/scalloped axe.txt'
	mv 'history/techs/serpen_1.txt' 'history/techs/serpent spear.txt'
	mv 'history/techs/shaftm_1.txt' 'history/techs/shaft mine.txt'
	mv 'history/techs/shafts_1.txt' 'history/techs/shafts of plague.txt'
	mv 'history/techs/should_1.txt' 'history/techs/shoulder of talos.txt'
	mv 'history/techs/signal_1.txt' 'history/techs/signal fires.txt'
	mv 'history/techs/skelet_1.txt' 'history/techs/skeleton power.txt'
	mv 'history/techs/skinof_1.txt' 'history/techs/skin of the rhino.txt'
	mv 'history/techs/slings_1.txt' 'history/techs/slings of the sun.txt'
	mv 'history/techs/snowst_1.txt' 'history/techs/snow storm.txt'
	mv 'history/techs/sonofo_1.txt' 'history/techs/son of osiris.txt'
	mv 'history/techs/sonsof_1.txt' 'history/techs/sons of sleipnir.txt'
	mv 'history/techs/spearo_1.txt' 'history/techs/spear on the horizon.txt'
	mv 'history/techs/spirit_1.txt' 'history/techs/spirit of maat.txt'
	mv 'history/techs/spirit_2.txt' 'history/techs/spirited charge.txt'
	mv 'history/techs/stones_1.txt' 'history/techs/stones of red linen.txt'
	mv 'history/techs/stonew_1.txt' 'history/techs/stone wall.txt'
	mv 'history/techs/sundri_1.txt' 'history/techs/sundried mud brick.txt'
	mv 'history/techs/sunray_1.txt' 'history/techs/sun ray.txt'
	mv 'history/techs/swinea_1.txt' 'history/techs/swine array.txt'
	mv 'history/techs/sylvan_1.txt' 'history/techs/sylvan lore.txt'
	mv 'history/techs/taxcol_1.txt' 'history/techs/tax collectors.txt'
	mv 'history/techs/temple_1.txt' 'history/techs/temple of healing.txt'
	mv 'history/techs/thraci_1.txt' 'history/techs/thracian horses.txt'
	mv 'history/techs/thunde_1.txt' 'history/techs/thundering hooves.txt'
	mv 'history/techs/thuris_1.txt' 'history/techs/thurisaz rune.txt'
	mv 'history/techs/triera_1.txt' 'history/techs/trierarch.txt'
	mv 'history/techs/tuskso_1.txt' 'history/techs/tusks of apedemak.txt'
	mv 'history/techs/underm_1.txt' 'history/techs/undermine.txt'
	mv 'history/techs/underw_1.txt' 'history/techs/underworld passage.txt'
	mv 'history/techs/valley_1.txt' 'history/techs/valley of the kings.txt'
	mv 'history/techs/vaults_1.txt' 'history/techs/vaults of erebus.txt'
	mv 'history/techs/walkin_1.txt' 'history/techs/walking woods.txt'
	mv 'history/techs/watcht_1.txt' 'history/techs/watch tower.txt'
	mv 'history/techs/weapon_1.txt' 'history/techs/weapon of the titans.txt'
	mv 'history/techs/willof_1.txt' 'history/techs/will of kronos.txt'
	mv 'history/techs/winged_1.txt' 'history/techs/winged messenger.txt'
	mv 'history/techs/winter_1.txt' 'history/techs/winter harvest.txt'
	mv 'history/techs/wratho_1.txt' 'history/techs/wrath of the deep.txt'
	mv 'history/units/agamem_1.txt' 'history/units/agamemnon.txt'
	mv 'history/units/anim0000.txt' 'history/units/animal attractor.txt'
	mv 'history/units/apeofs_1.txt' 'history/units/ape of set.txt'
	mv 'history/units/archer_1.txt' 'history/units/archery range.txt'
	mv 'history/units/arkant_1.txt' 'history/units/arkantos.txt'
	mv 'history/units/arkantos.txt' 'history/units/arkantosman.txt'
	mv 'history/units/atlant_1.txt' 'history/units/atlantis wall connector.txt'
	mv 'history/units/atlant_2.txt' 'history/units/atlantis wall long.txt'
	mv 'history/units/bandit_1.txt' 'history/units/bandit migdol.txt'
	mv 'history/units/battle_1.txt' 'history/units/battle boar.txt'
	mv 'history/units/berryb_1.txt' 'history/units/berry bush.txt'
	mv 'history/units/bolder_1.txt' 'history/units/bolder rolling.txt'
	mv 'history/units/bolder_2.txt' 'history/units/bolder rolling dead.txt'
	mv 'history/units/bolder_3.txt' 'history/units/bolder rolling 2.txt'
	mv 'history/units/bolder_4.txt' 'history/units/bolder wall.txt'
	mv 'history/units/broken_1.txt' 'history/units/broken column.txt'
	mv 'history/units/carava_1.txt' 'history/units/caravan egyptian.txt'
	mv 'history/units/carava_2.txt' 'history/units/caravan greek.txt'
	mv 'history/units/carava_3.txt' 'history/units/caravan norse.txt'
	mv 'history/units/cataph_1.txt' 'history/units/cataphract.txt'
	mv 'history/units/chario_1.txt' 'history/units/chariot archer.txt'
	mv 'history/units/charon_1.txt' 'history/units/charon ferry.txt'
	mv 'history/units/cita0000.txt' 'history/units/citadel center.txt'
	mv 'history/units/column_1.txt' 'history/units/columns broken.txt'
	mv 'history/units/column_2.txt' 'history/units/columns fallen.txt'
	mv 'history/units/constr_1.txt' 'history/units/construction extra large.txt'
	mv 'history/units/constr_2.txt' 'history/units/construction large.txt'
	mv 'history/units/constr_3.txt' 'history/units/construction medium.txt'
	mv 'history/units/constr_4.txt' 'history/units/construction small.txt'
	mv 'history/units/croc0000.txt' 'history/units/crocodile.txt'
	mv 'history/units/crocod_2.txt' 'history/units/crocodile of set.txt'
	mv 'history/units/crossb_1.txt' 'history/units/crossbowman.txt'
	mv 'history/units/crowne_1.txt' 'history/units/crowned crane.txt'
	mv 'history/units/digpil_1.txt' 'history/units/dig pile.txt'
	mv 'history/units/dwar0000.txt' 'history/units/dwarven forge.txt'
	mv 'history/units/dwarff_1.txt' 'history/units/dwarf foundry.txt'
	mv 'history/units/einher_1.txt' 'history/units/einheriar.txt'
	mv 'history/units/excava_1.txt' 'history/units/excavation.txt'
	mv 'history/units/fallen_1.txt' 'history/units/fallen columns.txt'
	mv 'history/units/fencei_1.txt' 'history/units/fence iron.txt'
	mv 'history/units/fences_1.txt' 'history/units/fence stone.txt'
	mv 'history/units/fencew_1.txt' 'history/units/fence wood.txt'
	mv 'history/units/fenris_1.txt' 'history/units/fenris wolf.txt'
	mv 'history/units/fimbul_1.txt' 'history/units/fimbulwinter wolf.txt'
	mv 'history/units/firegi_1.txt' 'history/units/fire giant.txt'
	mv 'history/units/fishin_1.txt' 'history/units/fishing ship egyptian.txt'
	mv 'history/units/fishin_2.txt' 'history/units/fishing ship greek.txt'
	mv 'history/units/fishin_3.txt' 'history/units/fishing ship norse.txt'
	mv 'history/units/fish_m_1.txt' 'history/units/fish - mahi.txt'
	mv 'history/units/fish_p_1.txt' 'history/units/fish - perch.txt'
	mv 'history/units/fish_s_1.txt' 'history/units/fish - salmon.txt'
	mv 'history/units/flying_1.txt' 'history/units/flying purple hippo.txt'
	mv 'history/units/folsta_1.txt' 'history/units/folstag flag bearer.txt'
	mv 'history/units/frostg_1.txt' 'history/units/frost giant.txt'
	mv 'history/units/gargar_1.txt' 'history/units/gargarensis.txt'
	mv 'history/units/gatera_1.txt' 'history/units/gate ram.txt'
	mv 'history/units/gatera_2.txt' 'history/units/gate ram 2.txt'
	mv 'history/units/gazell_1.txt' 'history/units/gazelle of set.txt'
	mv 'history/units/ghosts_1.txt' 'history/units/ghost ship.txt'
	mv 'history/units/giantg_1.txt' 'history/units/giant gate ram 2.txt'
	mv 'history/units/giantg_2.txt' 'history/units/giant gate ram.txt'
	mv 'history/units/giraff_1.txt' 'history/units/giraffe.txt'
	mv 'history/units/giraffe.txt' 'history/units/giraffe of set.txt'
	mv 'history/units/gold0000.txt' 'history/units/golden lion.txt'
	mv 'history/units/goldmi_1.txt' 'history/units/gold mine.txt'
	mv 'history/units/goldmi_2.txt' 'history/units/gold mine dwarven.txt'
	mv 'history/units/goldmi_3.txt' 'history/units/gold mine small.txt'
	mv 'history/units/goldmi_4.txt' 'history/units/gold mine tiny.txt'
	mv 'history/units/greatb_1.txt' 'history/units/great box.txt'
	mv 'history/units/greatb_2.txt' 'history/units/great box cart.txt'
	mv 'history/units/greatb_3.txt' 'history/units/great box cart 2.txt'
	mv 'history/units/guardi_1.txt' 'history/units/guardian sleeping.txt'
	mv 'history/units/hadesd_1.txt' 'history/units/hades door.txt'
	mv 'history/units/hadess_1.txt' 'history/units/hades shade.txt'
	mv 'history/units/he001a_1.txt' 'history/units/hero greek perseus.txt'
	mv 'history/units/he0444_1.txt' 'history/units/hero greek hippolyta.txt'
	mv 'history/units/he2813_1.txt' 'history/units/hero greek bellerophon.txt'
	mv 'history/units/he29cd_1.txt' 'history/units/hero greek polyphemus.txt'
	mv 'history/units/he9adf_1.txt' 'history/units/hero greek odysseus.txt'
	mv 'history/units/hea167_1.txt' 'history/units/hero greek jason.txt'
	mv 'history/units/heal0000.txt' 'history/units/healing spring object.txt'
	mv 'history/units/hedc5b_1.txt' 'history/units/hero greek chiron.txt'
	mv 'history/units/hee615_1.txt' 'history/units/hero greek heracles.txt'
	mv 'history/units/hef21d_1.txt' 'history/units/hero greek theseus.txt'
	mv 'history/units/helepo_1.txt' 'history/units/helepolis.txt'
	mv 'history/units/herobo_1.txt' 'history/units/hero boar 2.txt'
	mv 'history/units/herobo_2.txt' 'history/units/hero boar.txt'
	mv 'history/units/herogr_1.txt' 'history/units/hero greek achilles.txt'
	mv 'history/units/herogr_2.txt' 'history/units/hero greek ajax.txt'
	mv 'history/units/herogr_3.txt' 'history/units/hero greek argo.txt'
	mv 'history/units/herogr_4.txt' 'history/units/hero greek atalanta.txt'
	mv 'history/units/herono_1.txt' 'history/units/hero norse.txt'
	mv 'history/units/herora_1.txt' 'history/units/hero ragnorok.txt'
	mv 'history/units/hillfo_1.txt' 'history/units/hill fort.txt'
	mv 'history/units/hipp0000.txt' 'history/units/hippopotamus.txt'
	mv 'history/units/hippoc_1.txt' 'history/units/hippocampus.txt'
	mv 'history/units/hippoo_1.txt' 'history/units/hippo of set.txt'
	mv 'history/units/hyenao_1.txt' 'history/units/hyena of set.txt'
	mv 'history/units/hypasp_1.txt' 'history/units/hypaspist.txt'
	mv 'history/units/jailwa_1.txt' 'history/units/jail wall.txt'
	mv 'history/units/jormun_1.txt' 'history/units/jormund elver.txt'
	mv 'history/units/kraken_1.txt' 'history/units/kraken.txt'
	mv 'history/units/kraken.txt' 'history/units/kraken spc.txt'
	mv 'history/units/lazerb_1.txt' 'history/units/lazer bear.txt'
	mv 'history/units/leviat_1.txt' 'history/units/leviathan.txt'
	mv 'history/units/lighth_1.txt' 'history/units/lighthouse.txt'
	mv 'history/units/longho_1.txt' 'history/units/longhouse.txt'
	mv 'history/units/lumber_1.txt' 'history/units/lumber camp.txt'
	mv 'history/units/mantic_1.txt' 'history/units/manticore.txt'
	mv 'history/units/mercen_1.txt' 'history/units/mercenary cavalry.txt'
	mv 'history/units/mercen_2.txt' 'history/units/mercenary.txt'
	mv 'history/units/migdol_1.txt' 'history/units/migdol stronghold.txt'
	mv 'history/units/mining_1.txt' 'history/units/mining camp.txt'
	mv 'history/units/monkey_1.txt' 'history/units/monkey raft.txt'
	mv 'history/units/monkey_2.txt' 'history/units/monkey relic.txt'
	mv 'history/units/monume_1.txt' 'history/units/monument 2.txt'
	mv 'history/units/monume_2.txt' 'history/units/monument 3.txt'
	mv 'history/units/monume_3.txt' 'history/units/monument 4.txt'
	mv 'history/units/monume_4.txt' 'history/units/monument 5.txt'
	mv 'history/units/mounta_1.txt' 'history/units/mountain giant.txt'
	mv 'history/units/navals_1.txt' 'history/units/naval shipyard.txt'
	mv 'history/units/nemean_1.txt' 'history/units/nemean lion.txt'
	mv 'history/units/nidh0000.txt' 'history/units/nidhogg.txt'
	mv 'history/units/oakaut_1.txt' 'history/units/oak autumn.txt'
	mv 'history/units/oaktre_1.txt' 'history/units/oak tree.txt'
	mv 'history/units/oldman_1.txt' 'history/units/old man.txt'
	mv 'history/units/oxcart_1.txt' 'history/units/ox cart.txt'
	mv 'history/units/petrob_1.txt' 'history/units/petrobolos.txt'
	mv 'history/units/petsuc_1.txt' 'history/units/petsuchos.txt'
	mv 'history/units/pharao_1.txt' 'history/units/pharaoh of osiris.txt'
	mv 'history/units/pharao_2.txt' 'history/units/pharaoh secondary.txt'
	mv 'history/units/phoeni_1.txt' 'history/units/phoenix egg.txt'
	mv 'history/units/pigspe_1.txt' 'history/units/pig special.txt'
	mv 'history/units/pinede_1.txt' 'history/units/pine dead.txt'
	mv 'history/units/pinesn_1.txt' 'history/units/pine snow.txt'
	mv 'history/units/pirate_1.txt' 'history/units/pirate ship.txt'
	mv 'history/units/plenty_1.txt' 'history/units/plenty vault koth.txt'
	mv 'history/units/plenty_2.txt' 'history/units/plenty vault.txt'
	mv 'history/units/polarb_1.txt' 'history/units/polar bear.txt'
	mv 'history/units/portab_1.txt' 'history/units/portable ram.txt'
	mv 'history/units/poseid_1.txt' 'history/units/poseidon statue.txt'
	mv 'history/units/prodro_1.txt' 'history/units/prodromos.txt'
	mv 'history/units/pyrami_1.txt' 'history/units/pyramid large.txt'
	mv 'history/units/raidin_1.txt' 'history/units/raiding cavalry.txt'
	mv 'history/units/ramm0000.txt' 'history/units/ramming ship egyptian.txt'
	mv 'history/units/rammin_2.txt' 'history/units/ramming ship greek.txt'
	mv 'history/units/rammin_3.txt' 'history/units/ramming ship norse.txt'
	mv 'history/units/reginl_1.txt' 'history/units/reginleif.txt'
	mv 'history/units/rhinoc_1.txt' 'history/units/rhinoceros of set.txt'
	mv 'history/units/rhinoc_2.txt' 'history/units/rhinocerous.txt'
	mv 'history/units/savann_1.txt' 'history/units/savannah tree.txt'
	mv 'history/units/scaffo_1.txt' 'history/units/scaffolding.txt'
	mv 'history/units/scorpi_1.txt' 'history/units/scorpion man.txt'
	mv 'history/units/seasna_1.txt' 'history/units/sea snake.txt'
	mv 'history/units/seatur_1.txt' 'history/units/sea turtle.txt'
	mv 'history/units/sentin_1.txt' 'history/units/sentinel main.txt'
	mv 'history/units/settle_1.txt' 'history/units/settlement level 1.txt'
	mv 'history/units/settle_2.txt' 'history/units/settlement.txt'
	mv 'history/units/shabak_1.txt' 'history/units/shaba ka.txt'
	mv 'history/units/shadeo_1.txt' 'history/units/shade of erebus.txt'
	mv 'history/units/shadeo_2.txt' 'history/units/shade of hades.txt'
	mv 'history/units/shipwr_1.txt' 'history/units/shipwreck.txt'
	mv 'history/units/sieg0000.txt' 'history/units/siege ship egyptian.txt'
	mv 'history/units/siegec_1.txt' 'history/units/siege camp.txt'
	mv 'history/units/sieges_2.txt' 'history/units/siege ship greek.txt'
	mv 'history/units/sieges_3.txt' 'history/units/siege ship norse.txt'
	mv 'history/units/sieget_1.txt' 'history/units/siege tower.txt'
	mv 'history/units/skrael_1.txt' 'history/units/skraeling.txt'
	mv 'history/units/sleepi_1.txt' 'history/units/sleeping guardian.txt'
	mv 'history/units/st9642_1.txt' 'history/units/statue pharaoh.txt'
	mv 'history/units/statue_1.txt' 'history/units/statue lion left.txt'
	mv 'history/units/statue_2.txt' 'history/units/statue lion right.txt'
	mv 'history/units/statue_3.txt' 'history/units/statue of lightning.txt'
	mv 'history/units/statue_4.txt' 'history/units/statue of major god.txt'
	mv 'history/units/storeh_1.txt' 'history/units/storehouse.txt'
	mv 'history/units/swordb_1.txt' 'history/units/sword bearers.txt'
	mv 'history/units/tamari_1.txt' 'history/units/tamarisk tree.txt'
	mv 'history/units/taproo_1.txt' 'history/units/taproot large.txt'
	mv 'history/units/temp0000.txt' 'history/units/temple underworld.txt'
	mv 'history/units/thorha_1.txt' 'history/units/thor hammer haft.txt'
	mv 'history/units/thorha_2.txt' 'history/units/thor hammer head.txt'
	mv 'history/units/throwi_1.txt' 'history/units/throwing axeman.txt'
	mv 'history/units/titanb_1.txt' 'history/units/titan bad.txt'
	mv 'history/units/transp_1.txt' 'history/units/transport ship egyptian.txt'
	mv 'history/units/transp_2.txt' 'history/units/transport ship greek.txt'
	mv 'history/units/transp_3.txt' 'history/units/transport ship norse.txt'
	mv 'history/units/trojan_1.txt' 'history/units/trojan horse.txt'
	mv 'history/units/troyga_1.txt' 'history/units/troy gate.txt'
	mv 'history/units/troywa_1.txt' 'history/units/troy wall connector.txt'
	mv 'history/units/troywa_2.txt' 'history/units/troy wall long.txt'
	mv 'history/units/troywa_3.txt' 'history/units/troy wall short.txt'
	mv 'history/units/unde0000.txt' 'history/units/underworld passage spc.txt'
	mv 'history/units/villag_1.txt' 'history/units/villager egyptian.txt'
	mv 'history/units/villag_2.txt' 'history/units/villager greek.txt'
	mv 'history/units/villag_3.txt' 'history/units/villager norse.txt'
	mv 'history/units/waaa05_1.txt' 'history/units/walking woods pine.txt'
	mv 'history/units/waca6e_1.txt' 'history/units/walking woods savannah.txt'
	mv 'history/units/walk0000.txt' 'history/units/walking woods oak.txt'
	mv 'history/units/walkin_2.txt' 'history/units/walking woods palm.txt'
	mv 'history/units/walkin_3.txt' 'history/units/walking woods pine dead.txt'
	mv 'history/units/walkin_4.txt' 'history/units/walking woods pine snow.txt'
	mv 'history/units/wallat_1.txt' 'history/units/wall atlantis connector.txt'
	mv 'history/units/wallat_2.txt' 'history/units/wall atlantis long.txt'
	mv 'history/units/wallco_1.txt' 'history/units/wall connector.txt'
	mv 'history/units/walllo_1.txt' 'history/units/wall long.txt'
	mv 'history/units/wallme_1.txt' 'history/units/wall medium.txt'
	mv 'history/units/wallsh_1.txt' 'history/units/wall short.txt'
	mv 'history/units/warele_1.txt' 'history/units/war elephant.txt'
	mv 'history/units/waterb_1.txt' 'history/units/water buffalo.txt'
	mv 'history/units/wellof_1.txt' 'history/units/well of urd.txt'
	mv 'history/units/wonder_1.txt' 'history/units/wonder spc.txt'
	mv 'loadin_1.bmp' 'loading1024.bmp'
	mv 'loadin_2.bmp' 'loading1280.bmp'
	mv 'loadin_3.bmp' 'loading640.bmp'
	mv 'loadin_4.bmp' 'loading800.bmp'
	mv 'models/sfxabo_1.lng' 'models/sfx a bolt.lng'
	mv 'models/sfxaos_1.lng' 'models/sfx a osiris.lng'
	mv 'models/sfxape_1.lng' 'models/sfx a petosuchus.lng'
	mv 'models/sfxgli_1.lng' 'models/sfx g lightning bolt large.lng'
	mv 'models/sfxgli_2.lng' 'models/sfx g lightning bolt medium.lng'
	mv 'models/sfxgli_3.lng' 'models/sfx g lightning bolt small.lng'
	mv 'moviep_1.exe' 'movieplayer.exe'
	mv 'rm/acropo_1.xml' 'rm/acropolis.xml'
	mv 'rm/acropo_1.xs' 'rm/acropolis.xs'
	mv 'rm/archip_1.xml' 'rm/archipelago.xml'
	mv 'rm/archip_1.xs' 'rm/archipelago.xs'
	mv 'rm/fastra_1.set' 'rm/fastrandom.set'
	mv 'rm/ghostl_1.xml' 'rm/ghost lake.xml'
	mv 'rm/ghostl_1.xs' 'rm/ghost lake.xs'
	mv 'rm/jotunh_1.xml' 'rm/jotunheim.xml'
	mv 'rm/jotunh_1.xs' 'rm/jotunheim.xs'
	mv 'rm/kingof_1.xml' 'rm/king of the hill.xml'
	mv 'rm/kingof_1.xs' 'rm/king of the hill.xs'
	mv 'rm/medite_1.xml' 'rm/mediterranean.xml'
	mv 'rm/medite_1.xs' 'rm/mediterranean.xs'
	mv 'rm/random_1.set' 'rm/randommaps.set'
	mv 'rm/rivern_1.xml' 'rm/river nile.xml'
	mv 'rm/rivern_1.xs' 'rm/river nile.xs'
	mv 'rm/seaofw_1.xml' 'rm/sea of worms.xml'
	mv 'rm/seaofw_1.xs' 'rm/sea of worms.xs'
	mv 'rm/sudden_1.xml' 'rm/sudden death.xml'
	mv 'rm/sudden_1.xs' 'rm/sudden death.xs'
	mv 'rm/teammi_1.xml' 'rm/team migration.xml'
	mv 'rm/teammi_1.xs' 'rm/team migration.xs'
	mv 'rm/theunk_1.xml' 'rm/the unknown.xml'
	mv 'rm/theunk_1.xs' 'rm/the unknown.xs'
	mv 'rm/valley_1.xml' 'rm/valley of kings.xml'
	mv 'rm/valley_1.xs' 'rm/valley of kings.xs'
	mv 'rm/vinlan_1.xml' 'rm/vinlandsaga.xml'
	mv 'rm/vinlan_1.xs' 'rm/vinlandsaga.xs'
	mv 'rm/wateri_1.xml' 'rm/watering hole.xml'
	mv 'rm/wateri_1.xs' 'rm/watering hole.xs'
	mv 'rockal_1.dll' 'rockalldll.dll'
	mv 'rts3ba_1.txt' 'rts3banglog.txt'
	mv 'scenario/scenar_1.bar' 'scenario/scenarios.bar'
	mv 'sound/aheroh_1.wav' 'sound/aherohasfallen.wav'
	mv 'sound/cinematics/04_in/armyar_1.wav' 'sound/cinematics/04_in/armyarrive.wav'
	mv 'sound/cinematics/04_in/music1_1.mp3' 'sound/cinematics/04_in/music 1.mp3'
	mv 'sound/cinematics/04_in/music2_1.mp3' 'sound/cinematics/04_in/music 2.mp3'
	mv 'sound/cinematics/04_in/wavesb_1.mp3' 'sound/cinematics/04_in/wavesbirdsmix.mp3'
	mv 'sound/cinematics/04_out/wave0000.mp3' 'sound/cinematics/04_out/wavesbirds.mp3'
	mv 'sound/cinematics/05_out/boatsp_1.mp3' 'sound/cinematics/05_out/boatspass.mp3'
	mv 'sound/cinematics/05_out/kamosl_1.mp3' 'sound/cinematics/05_out/kamosleap.mp3'
	mv 'sound/cinematics/05_out/leviat_1.mp3' 'sound/cinematics/05_out/leviathangrunt.mp3'
	mv 'sound/cinematics/05_out/musi0000.mp3' 'sound/cinematics/05_out/music.mp3'
	mv 'sound/cinematics/1/wave0001.mp3' 'sound/cinematics/1/waves.mp3'
	mv 'sound/cinematics/3/ambi0000.mp3' 'sound/cinematics/3/ambience.mp3'
	mv 'sound/cinematics/3/boat0000.mp3' 'sound/cinematics/3/boatpass.mp3'
	mv 'sound/cinematics/3/wave0002.mp3' 'sound/cinematics/3/waves.mp3'
	mv 'sound/cinematics/a/dreamt_1.mp3' 'sound/cinematics/a/dreamthing.mp3'
	mv 'sound/cinematics/a/lostso_1.mp3' 'sound/cinematics/a/lostsouls.mp3'
	mv 'sound/cinematics/a/wave0003.mp3' 'sound/cinematics/a/waves.mp3'
	mv 'sound/dialog/kastor_1.mp3' 'sound/dialog/kastor061.mp3'
	mv 'sound/dialog/kastor_2.mp3' 'sound/dialog/kastor062.mp3'
	mv 'sound/music/culture/greekt_1.mp3' 'sound/music/culture/greek to me.mp3'
	mv 'sound/music/culture/ndnile_1.mp3' 'sound/music/culture/n. d. nile.mp3'
	mv 'sound/music/culture/ofnors_1.mp3' 'sound/music/culture/of norse not!.mp3'
	mv 'sound/music/fight/iwishi_1.mp3' 'sound/music/fight/i wish i could throw shapes.mp3'
	mv 'sound/music/fight/oi_tha_1.mp3' 'sound/music/fight/oi, that pops!!!.mp3'
	mv 'sound/music/fight/rotloa_1.mp3' 'sound/music/fight/rot loaf.mp3'
	mv 'sound/music/fight/thefir_1.mp3' 'sound/music/fight/the fire brigade.mp3'
	mv 'sound/music/interface/acatna_1.mp3' 'sound/music/interface/a cat named mittens.mp3'
	mv 'sound/music/interface/ganksn_1.mp3' "sound/music/interface/gank sneakin'.mp3"
	mv 'sound/music/interface/ifyouc_1.mp3' 'sound/music/interface/if you can use a doorknob.mp3'
	mv 'sound/music/interface/ma_ams_1.mp3' "sound/music/interface/ma'am...some other sunset.mp3"
	mv 'sound/music/quiet/behold_1.mp3' 'sound/music/quiet/behold the great science fi (mellow mix).mp3'
	mv 'sound/music/quiet/eatyou_1.mp3' 'sound/music/quiet/eat your potatoes (mellow mix).mp3'
	mv 'sound/music/quiet/_finel_1.mp3' 'sound/music/quiet/(fine layers of) slaysenflite (mellow mix).mp3'
	mv 'sound/music/quiet/flavor_1.mp3' 'sound/music/quiet/flavor cats (in the comfort zone) (mellow mix).mp3'
	mv 'sound/music/quiet/neverm_1.mp3' 'sound/music/quiet/never mind the slacks and bashers (mellow mix).mp3'
	mv 'sound/music/quiet/thebal_1.mp3' 'sound/music/quiet/the ballad of ace lebaron (mellow mix).mp3'
	mv 'sound/music/standard/beho0000.mp3' 'sound/music/standard/behold the great science fi.mp3'
	mv 'sound/music/standard/eaty0000.mp3' 'sound/music/standard/eat your potatoes.mp3'
	mv 'sound/music/standard/_fin0000.mp3' 'sound/music/standard/(fine layers of) slaysenflite.mp3'
	mv 'sound/music/standard/flav0000.mp3' 'sound/music/standard/flavor cats (in the comfort zone).mp3'
	mv 'sound/music/standard/neve0000.mp3' 'sound/music/standard/never mind the slacks and bashers.mp3'
	mv 'sound/music/standard/theb0000.mp3' 'sound/music/standard/the ballad of ace lebaron.mp3'
	mv 'startup/gamese_1.bar' 'startup/gamesettings.bar'
	mv 'textures/cursors/co0576_1.cur' 'textures/cursors/command god no isis mono icon.cur'
	mv 'textures/cursors/co06af_1.cur' 'textures/cursors/command no god power mono icon.cur'
	mv 'textures/cursors/co085a_1.cur' 'textures/cursors/cursor_hyperlink.cur'
	mv 'textures/cursors/co0d51_1.cur' 'textures/cursors/command gather fish mono icon.cur'
	mv 'textures/cursors/co0ddb_1.cur' 'textures/cursors/command guard icon.cur'
	mv 'textures/cursors/co17c2_1.cur' 'textures/cursors/command resource drop off gold mono icon.cur'
	mv 'textures/cursors/co1b52_1.cur' 'textures/cursors/cursor_ankh.cur'
	mv 'textures/cursors/co1ec7_1.cur' 'textures/cursors/command gather berries icon.cur'
	mv 'textures/cursors/co36e9_1.cur' 'textures/cursors/command cursor icon.cur'
	mv 'textures/cursors/co3d45_1.cur' 'textures/cursors/command no god power icon.cur'
	mv 'textures/cursors/co3e43_1.cur' 'textures/cursors/command herdable gaia mono icon.cur'
	mv 'textures/cursors/co4014_1.cur' 'textures/cursors/command gather gold icon.cur'
	mv 'textures/cursors/co4096_1.cur' 'textures/cursors/command gather wood icon.cur'
	mv 'textures/cursors/co40d2_1.cur' 'textures/cursors/command gather food icon.cur'
	mv 'textures/cursors/co41d0_1.cur' 'textures/cursors/command gather fish icon.cur'
	mv 'textures/cursors/co4648_1.cur' 'textures/cursors/command gather berries mono icon.cur'
	mv 'textures/cursors/co48a6_1.cur' 'textures/cursors/command patrol icon.cur'
	mv 'textures/cursors/co4c41_1.cur' 'textures/cursors/command cursor mono icon.cur'
	mv 'textures/cursors/co4e87_1.cur' 'textures/cursors/command empower mono icon.cur'
	mv 'textures/cursors/co5d3d_1.cur' 'textures/cursors/command convert mono icon.cur'
	mv 'textures/cursors/co6199_1.cur' 'textures/cursors/command god no isis icon.cur'
	mv 'textures/cursors/co61d1_1.cur' 'textures/cursors/command resource drop off gold icon.cur'
	mv 'textures/cursors/co63d7_1.cur' 'textures/cursors/command convert icon.cur'
	mv 'textures/cursors/co67c2_1.cur' 'textures/cursors/command resource drop off food mono icon.cur'
	mv 'textures/cursors/co7449_1.cur' 'textures/cursors/command god power mono icon.cur'
	mv 'textures/cursors/co7874_1.cur' 'textures/cursors/command resource drop off wood mono icon.cur'
	mv 'textures/cursors/co7886_1.cur' 'textures/cursors/cursor_gather.cur'
	mv 'textures/cursors/co846f_1.cur' 'textures/cursors/command repair icon.cur'
	mv 'textures/cursors/co8c08_1.cur' 'textures/cursors/command god power icon.cur'
	mv 'textures/cursors/co8ebb_1.cur' 'textures/cursors/command guard mono icon.cur'
	mv 'textures/cursors/co8ff0_1.cur' 'textures/cursors/command help icon.cur'
	mv 'textures/cursors/co9852_1.cur' 'textures/cursors/command gather favor icon.cur'
	mv 'textures/cursors/coa0a9_1.cur' 'textures/cursors/command unboard icon.cur'
	mv 'textures/cursors/coa29a_1.cur' 'textures/cursors/command help mono icon.cur'
	mv 'textures/cursors/coa2d1_1.cur' 'textures/cursors/command resource drop off food icon.cur'
	mv 'textures/cursors/cob08a_1.cur' 'textures/cursors/command dangerous gaia mono icon.cur'
	mv 'textures/cursors/coba58_1.cur' 'textures/cursors/command herdable gaia icon.cur'
	mv 'textures/cursors/cobfd6_1.cur' 'textures/cursors/command build icon.cur'
	mv 'textures/cursors/cod7b8_1.cur' 'textures/cursors/command dangerous gaia icon.cur'
	mv 'textures/cursors/codcf9_1.cur' 'textures/cursors/command patrol mono icon.cur'
	mv 'textures/cursors/code16_1.cur' 'textures/cursors/command build mono icon.cur'
	mv 'textures/cursors/coe410_1.cur' 'textures/cursors/command gather wood mono icon.cur'
	mv 'textures/cursors/coe4c0_1.cur' 'textures/cursors/command gather gold mono icon.cur'
	mv 'textures/cursors/coe690_1.cur' 'textures/cursors/command resource drop off wood icon.cur'
	mv 'textures/cursors/coe8ee_1.cur' 'textures/cursors/command gather favor mono icon.cur'
	mv 'textures/cursors/coeb2a_1.cur' 'textures/cursors/command repair mono icon.cur'
	mv 'textures/cursors/coec91_1.cur' 'textures/cursors/command gather food mono icon.cur'
	mv 'textures/cursors/coed8a_1.cur' 'textures/cursors/command gather resource mono icon.cur'
	mv 'textures/cursors/cof31e_1.cur' 'textures/cursors/command resource drop off mono icon.cur'
	mv 'textures/cursors/cof67e_1.cur' 'textures/cursors/command unboard mono icon.cur'
	mv 'textures/cursors/comman_1.cur' 'textures/cursors/cursor_attack.cur'
	mv 'textures/cursors/comman_2.cur' 'textures/cursors/command attack mono icon.cur'
	mv 'textures/cursors/comman_3.cur' 'textures/cursors/command board icon.cur'
	mv 'textures/cursors/comman_4.cur' 'textures/cursors/command board mono icon.cur'
	mv 'textures/cursors/cu29a0_1.cur' 'textures/cursors/cursor_pray mono.cur'
	mv 'textures/cursors/cu3102_1.cur' 'textures/cursors/cursor_hyperlink mono.cur'
	mv 'textures/cursors/cu3753_1.cur' 'textures/cursors/cursor_build mono.cur'
	mv 'textures/cursors/cu5567_1.cur' 'textures/cursors/cursor_pray.cur'
	mv 'textures/cursors/cu6cd0_1.cur' 'textures/cursors/cursor_workon.cur'
	mv 'textures/cursors/cu89cd_1.cur' 'textures/cursors/cursor_gather mono.cur'
	mv 'textures/cursors/cu8a47_1.cur' 'textures/cursors/cursor_workon mono.cur'
	mv 'textures/cursors/cub6eb_1.cur' 'textures/cursors/command resource drop off icon.cur'
	mv 'textures/cursors/cuc6cb_1.cur' 'textures/cursors/cursor_build.cur'
	mv 'textures/cursors/cucae1_1.cur' 'textures/cursors/command gather resource icon.cur'
	mv 'textures/cursors/cue611_1.cur' 'textures/cursors/cursor_pointer.cur'
	mv 'textures/cursors/cue9f1_1.cur' 'textures/cursors/cursor_pointer mono.cur'
	mv 'textures/cursors/cursor_1.cur' 'textures/cursors/cursor_ankh mono.cur'
	mv 'textures/cursors/cursor_2.cur' 'textures/cursors/command empower icon.cur'
	mv 'textures/cursors/cursor_3.cur' 'textures/cursors/cursor_attack mono.cur'
	mv 'textures/cursors/cursor_4.cur' 'textures/cursors/command attack icon.cur'
	mv 'textures/cursors/sc7b34_1.cur' 'textures/cursors/scale_vert cursor.cur'
	mv 'textures/cursors/scale__1.cur' 'textures/cursors/scale_both cursor mono.cur'
	mv 'textures/cursors/scale__2.cur' 'textures/cursors/scale_both cursor.cur'
	mv 'textures/cursors/scale__3.cur' 'textures/cursors/scale_horiz cursor mono.cur'
	mv 'textures/cursors/scale__4.cur' 'textures/cursors/scale_horiz cursor.cur'
	mv 'textures/cursors/scbed3_1.cur' 'textures/cursors/scale_vert cursor mono.cur'
	mv 'trigger/basicv_1.xs' 'trigger/basicvcnomain.xs'
	mv 'trigger/rmsudd_1.xs' 'trigger/rmsuddendeathvc.xs'
	mv 'zoneac_1.dll' 'zoneaccessapi.dll'
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
