/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
// generated by Fast Light User Interface Designer (fluid) version 1.0104

#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl_Pixmap.H>
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Help_Dialog.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Counter.H>

#include <lb_subs.xpm>
#include <lb_supers.xpm>
#include <lb_select_font_color.xpm>
#include <lb_color_atom.xpm>
#include <lb_normal_str.xpm>
#include <lb_align.xpm>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <util.hpp>

#include <atom_prop.hpp>
#include <parse_residual.hpp> //da levare e mettere in editor


extern finestra_pr* MainWindow;

Fl_Pixmap image_lb_subs(lb_subs_xpm);
Fl_Pixmap image_lb_supers(lb_supers_xpm);
Fl_Pixmap image_lb_select_font_color(lb_select_font_color_xpm);
Fl_Pixmap image_lb_color_atom(lb_color_atom_xpm);
Fl_Pixmap image_lb_normal_str_atom(lb_normal_str_xpm);
Fl_Pixmap image_lb_align(lb_align_xpm);

void atom_prop_ok_cb(Fl_Widget* w, void* d){

  editor* ed=dynamic_cast<editor*>(MainWindow);
  atomo* atom=static_cast<atomo*>(d);
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  Fl_Input* valor=  dynamic_cast<Fl_Input*>(propr->child(12));

  int caric=strtol(valor->value(),NULL,0);

  Fl_Round_Button* piu=dynamic_cast<Fl_Round_Button*>(dynamic_cast<Fl_Group*>(propr->child(11))->child(0));

  if(!piu->value()){
    caric=-caric;
  }

 Fl_Round_Button* ch_pos_l_t=dynamic_cast<Fl_Round_Button*>(dynamic_cast<Fl_Group*>(propr->child(13))->child(0));
 Fl_Round_Button* ch_pos_r_t=dynamic_cast<Fl_Round_Button*>(dynamic_cast<Fl_Group*>(propr->child(13))->child(1));
 Fl_Round_Button* ch_pos_r_b=dynamic_cast<Fl_Round_Button*>(dynamic_cast<Fl_Group*>(propr->child(13))->child(2));


 if(ch_pos_l_t->value()){
   atom->position_charge(L_TOP);
 }else if(ch_pos_r_t->value()){
   atom->position_charge(R_TOP);
 }else if(ch_pos_r_b->value()){
   atom->position_charge(R_BOTTOM);
 }else{
   atom->position_charge(L_BOTTOM);
 }

  Fl_Input* lone_p=dynamic_cast<Fl_Input*>(propr->child(14));
  Fl_Input* lone_unp=dynamic_cast<Fl_Input*>(propr->child(15));
  int lone_p_int=strtol(lone_p->value(),NULL,0);
  int lone_unp_int=strtol(lone_unp->value(),NULL,0);
  etichetta* et=atom->etich_punt();
  Fl_Choice* dimensioni=dynamic_cast<Fl_Choice*>(propr->child(3));
  Fl_Choice* i_font=dynamic_cast<Fl_Choice*>(propr->child(2));
  int font_ch=i_font->value();

  et->font(font_ch);

  et->dim(strtol(dimensioni->mvalue()->text,NULL,0) );

  atom->doppietti(lone_p_int);
  atom->el_spaiati(lone_unp_int);
  atom->cariche(caric);

  if(propr->_r!=-1){
    et->cr(propr->_r);
    et->cg(propr->_g);
    et->cb(propr->_b);
  }

  if(propr->_ra!=-1){
    atom->cr(propr->_ra);
    atom->cg(propr->_ga);
    atom->cb(propr->_ba);
  }



  string prs_stringa;

  for(unsigned int i=0;i<et->vec_str().size();i++){
    prs_stringa +=((et->vec_str())[i]).first;
  }


  Fl_Check_Button* parse=dynamic_cast<Fl_Check_Button*>(propr->child(8));
  if(parse->value()){

    /***per provare*******************/

    parse_residue parse(prs_stringa);

    if(!parse.has_error()){

      gruppo pp=parse.return_fragment();
      cout << "DIFF" << pp.fin_atom() - pp.iniz_atom() << endl;


      vector<atomo>::iterator inatm3=pp.iniz_atom();
      vector<atomo>::iterator finatm3=pp.fin_atom();

      while(inatm3!=finatm3){
	(*inatm3).costruisci_arrivati();
	inatm3++;
      }

      int id_atomo_frag_iniz=atom->id();
      int id_atomo_frag_iniz_next=(atom->iniz_leg())->id_atomo();
      int id_group_frag_iniz=atom->id_gruppo();

      immagine*   la_imm=ed->ritorna_immagine();

      /*AGGIUNGIAMO, da questo momento i puntatori non sono piu' validi*/
      la_imm->aggiungi_gruppo(pp);


      gruppo& last=la_imm->ritorna_ultimo_gruppo();

      //atomo  legato a dummy
      atomo* fst_of_fragment=last.find_atomo_id(1);
      //atomo dummy
      atomo* dummy=last.find_atomo_id(0);
      //gruppo con l'atomo da espandere
      gruppo* frag_iniz=la_imm->find_group_id(id_group_frag_iniz);
      //atomo da espandere
      atom=frag_iniz->find_atomo_id(id_atomo_frag_iniz);
      //atomo legato a quello da espandere
      atomo* next=frag_iniz->find_atomo_id(id_atomo_frag_iniz_next);

      //calcoliamo  l'angolo che  forma  il legame  tra  l'atomo che  andra'
      //espanso e un suo primo vicino
      //posiizioni frammento espanso
      float posx_a=fst_of_fragment->pos_x()-dummy->pos_x();
      float posy_a=fst_of_fragment->pos_y()-dummy->pos_y();;
      //angolo in radianti del legame dummy--primo del frammento
      float angle_a=atan2f(posy_a,posx_a);

      //facciamo lo stesso con il legame puntodiespansione--un primo vicino
      float posx_b=next->pos_x() - atom->pos_x();
      float posy_b=next->pos_y() - atom->pos_y();
      float angle_b=atan2f(posy_b,posx_b);

      //calcoliamo la differenza,  si fa cosi oppure per  forza col prodotto
      //vettoriale?
      float delta_ang=angle_b-angle_a;
      last.ruota(-delta_ang,
		 fst_of_fragment->phys_pos_x(),
		 fst_of_fragment->phys_pos_y());


      last.ruota(M_PI,
		 dummy->phys_pos_x(),
		 dummy->phys_pos_y());

      last.trasla(atom->pos_x() - fst_of_fragment->pos_x(),
		  atom->pos_y() - fst_of_fragment->pos_y());

      //eliminiamo "atom"
      frag_iniz->purge_atom(id_atomo_frag_iniz);
      //puntatori non piu' validi
      next=frag_iniz->find_atomo_id(id_atomo_frag_iniz_next);

      //creiamo il nuovo legame
      la_imm->crea_legame_nuovo(next,fst_of_fragment,LEGAME_SINGOLO);


      //ora si tratta di eliminare "dummy"
      //cout << "*************************************************" << endl;
#ifdef DEBUG
      la_imm->dump_tmp_atom();
#endif
      gruppo* dummyelim=la_imm->find_group_id(id_group_frag_iniz);


      inatm3=dummyelim->iniz_atom();
      finatm3=dummyelim->fin_atom();
      while(inatm3!=finatm3){
	if(((*inatm3).etich()).to_raw_string()=="dummy"){
	  int id_dummynw=(*inatm3).id();
	  dummyelim->purge_atom(id_dummynw);
	  break;
	}
	inatm3++;
      }


    }
  }// END: if(parse->value())

  ed->redraw();
}


void atom_prop_charge_sing_el(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  atomo* atom=static_cast<atomo*>(d);
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  Fl_Input* lone_unp=dynamic_cast<Fl_Input*>(propr->child(15));
  int lone_unp_int=strtol(lone_unp->value(),NULL,0);
  atom->el_spaiati(lone_unp_int);
  ed->redraw();
}

void atom_prop_charge_pair_el(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  atomo* atom=static_cast<atomo*>(d);
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  Fl_Input* lone_p=dynamic_cast<Fl_Input*>(propr->child(14));
  int lone_p_int=strtol(lone_p->value(),NULL,0);
  atom->doppietti(lone_p_int);
  ed->redraw();
}


void atom_prop_charge_pos_cb(Fl_Widget* w, void* d){
  atom_prop_charge_cb(w->parent(),d);
}

void atom_prop_charge_cb(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  atomo* atom=static_cast<atomo*>(d);
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  Fl_Input* valor=  dynamic_cast<Fl_Input*>(propr->child(12));

  int caric=strtol(valor->value(),NULL,0);

  Fl_Round_Button* piu=dynamic_cast<Fl_Round_Button*>(dynamic_cast<Fl_Group*>(propr->child(11))->child(0));
  
  if(!piu->value()){
    caric=-caric;
  }

  Fl_Round_Button* ch_pos_l_t=dynamic_cast<Fl_Round_Button*>(dynamic_cast<Fl_Group*>(propr->child(13))->child(0));
  Fl_Round_Button* ch_pos_r_t=dynamic_cast<Fl_Round_Button*>(dynamic_cast<Fl_Group*>(propr->child(13))->child(1));
  Fl_Round_Button* ch_pos_r_b=dynamic_cast<Fl_Round_Button*>(dynamic_cast<Fl_Group*>(propr->child(13))->child(2));


  if(ch_pos_l_t->value()){
    atom->position_charge(L_TOP);
  }else if(ch_pos_r_t->value()){
    atom->position_charge(R_TOP);
  }else if(ch_pos_r_b->value()){
    atom->position_charge(R_BOTTOM);
  }else{
    atom->position_charge(L_BOTTOM);
  }

  atom->cariche(caric);
  ed->redraw();
}

void atom_prop_select_current_font_dimension(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  atomo* atom=static_cast<atomo*>(d);
  etichetta* et=atom->etich_punt();
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  Fl_Choice* dimensioni=dynamic_cast<Fl_Choice*>(propr->child(3));
  et->dim(strtol(dimensioni->mvalue()->text,NULL,0) );
  ed->redraw();
}

void atom_prop_select_current_font(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  atomo* atom=static_cast<atomo*>(d);
  etichetta* et=atom->etich_punt();
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  Fl_Choice* i_font=dynamic_cast<Fl_Choice*>(propr->child(2));
  int font_ch=i_font->value();
  et->font(font_ch);
  ed->redraw();
}

void atom_prop_select_valign_atom_cb(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  Fl_Counter* count=dynamic_cast<Fl_Counter*>(w);
  (propr->_atom->etich_punt())->v_offset(static_cast<int>(count->value()));
  ed->redraw();

}

void atom_prop_select_align_atom_cb(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  if(propr!=NULL){
    int nwpropr=(propr->_align + 1)%3;
    propr->_align=nwpropr;
    (propr->_atom->etich_punt())->allineamento(propr->_align);
  }
  ed->redraw();
}

void atom_prop_cancel_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();
}


void atom_prop_select_atom_color_cb(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  unsigned char r,g,b;
  int pushd=fl_color_chooser(_("pick a color..."), r, g, b);
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());
  if(pushd){
    propr->_ra=r;
    propr->_ga=g;
    propr->_ba=b;
    atomo* atom=static_cast<atomo*>(d);
    atom->cr(propr->_ra);
    atom->cg(propr->_ga);
    atom->cb(propr->_ba);
  }
  ed->redraw();
}

void atom_prop_select_string_color_cb(Fl_Widget* w, void* d){
  editor* ed=dynamic_cast<editor*>(MainWindow);
  unsigned char r,g,b;
  int pushd=fl_color_chooser(_("pick a color..."), r, g, b);
  atom_prop* propr=dynamic_cast<atom_prop*>(w->parent());

  if(pushd){
    propr->_r=r;
    propr->_g=g;
    propr->_b=b;
    atomo* atom=static_cast<atomo*>(d);
    etichetta* et=atom->etich_punt();
    et->cr(r);
    et->cg(g);
    et->cb(b);
  }

  ed->redraw();
}

Fl_Menu_Item voci_font_dim_atom[NUM_FONT_DIM];

Fl_Menu_Item a_voci_font_face[] = {
  {"helvetica", 0, 0, 0,},
  {"helvetica bold", 0, 0, 0,},
  {"helvetica italic", 0, 0, 0,},
  {"helvetica bold italic", 0, 0, 0,},

  {"courier", 0, 0, 0,},
  {"courier bold", 0, 0, 0,},
  {"courier italic", 0, 0, 0,},
  {"courier bold italic", 0, 0, 0,},

  {"times", 0, 0, 0,},
  {"times bold", 0, 0, 0,},
  {"times italic", 0, 0, 0,},
  {"times bold italic", 0, 0, 0,},

  {"symbol", 0, 0, 0,},

  {"screen", 0, 0, 0,},
  {"screen bold", 0, 0, 0,},

  {"zapf dingbats", 0, 0, 0,},

  {0}
};


bool atom_prop::check_if_type_etic(int typ){
  etichetta* etic=_atom->etich_punt();
  vector < pair<string,int> > stringhe=etic->vec_str();
  pair<string,int> pt= stringhe.back();

  if(pt.second==typ){
    return true;
  }else{
    return false;
  }

  return true;
}


bool atom_prop::check_if_type_etic(int typ,int pos) throw (out_of_range){
  etichetta* etic=_atom->etich_punt();
  vector < pair<string,int> > stringhe=etic->vec_str();

  if(etic->vec_str().size()< static_cast<unsigned int>(pos)){
    pos=0;
  }

  if(pos >=0){
    vector < pair<string,int> >::iterator it= stringhe.begin();
    pair<string,int> pt= *(it+pos);
    if(pt.second==typ){
      return true;
    }else{
      return false;
    }
  }else{
    string exc=_("error where < _vec_str.size() in class etichetta.");
    throw out_of_range(exc);
  }
}

int atom_prop::handle(int e){
  Fl_Window::handle(e);
  editor* editor_pr=dynamic_cast<editor*>(MainWindow);
  switch(e){

  case FL_FOCUS:
    return 0;


  case FL_KEYDOWN:
    {
      Fl_Button* apic=dynamic_cast<Fl_Button*>(child(5));
      Fl_Button* pedic=dynamic_cast<Fl_Button*>(child(6));
      etichetta* etic=_atom->etich_punt();
      string car;

      if(Fl::event_state(FL_SHIFT)){
	car=toupper(Fl::event_text()[0]);
      }else{
	car=Fl::event_text()[0];
      }

      if( !isalpha(car[0]) && !ispunct(car[0]) &&
	  !isdigit(car[0]) && !isblank(car[0]) &&
	  car[0]!='\b'){
	return 0;
      }

      if(car=="\b"){//cancellare l'ultimo
	int misur=etic->size_str()-1;
	vector < pair<string,int> > stringhe=etic->vec_str();
	vector < pair<string,int> >::iterator it= stringhe.begin() + misur;
	pair<string,int> pt= *(it);
	int tipo=pt.second;

	if(pt.first.length()==1){
	  if(stringhe.size()>1){
	    etic->elimina(misur);
	     if(apic->value()){
               _apici="";
	     }else if(pedic->value()){
               _pedici="";
	     }
	  }else{
	    etic->sostituisci(NO_ETIC,ET_STR,misur);
	    stringhe=etic->vec_str();
	  }
	}else{
	  string nuova=(pt.first).substr(0,pt.first.length()-1);
	  etic->sostituisci(nuova,tipo,misur);
	  if(apic->value()){
	    _apici=nuova;
	  }else if(pedic->value()){
	    _pedici=nuova;
	  }
	}
      }else{


	if(apic->value()){//dovremmo aggiungere un apice
	  if(check_if_type_etic(ET_APICE)){ //l'ultimo e' un apice
	    _apici+=car;
	    etic->sostituisci(_apici,ET_APICE , etic->size_str()-1);
	  }else if(check_if_type_etic(ET_STR)){//l'ultimo e' una stringa
	    _apici+=car;
	    etic->aggiungi(_apici,ET_APICE);
	  }else{ //l'ultimo e' un pedice
	    try{
	      if(check_if_type_etic(ET_STR,etic->size_str()-2)){ //il precedente e' una stringa
		cout << "PEDICI" << endl;
		_apici=car;
		etic->aggiungi(_apici,ET_APICE);
	      }else{ //il precedente non puo' che essere un apice
		_apici+=car;
		etic->sostituisci(_apici,ET_APICE , etic->size_str()-2);
	      }
	    }catch(out_of_range e){
	      cout << "Eccezione: " << e.what() << endl;
	    }
	  }
	}else if(pedic->value()){//dovremmo aggiungere un pedice

	  if(check_if_type_etic(ET_PEDICE)){
	    _pedici+=car;
	    etic->sostituisci(_pedici,ET_PEDICE , etic->size_str()-1);
	  }else if(check_if_type_etic(ET_STR)){//l'ultimo e' una stringa

	    _pedici+=car;
	    etic->aggiungi(_pedici,ET_PEDICE);
	  }else{//l'ultimo e' un apice
	    if(check_if_type_etic(ET_STR,etic->size_str()-2)){ //il precedente e' una stringa
	      _pedici=car;
	      etic->aggiungi(_pedici,ET_PEDICE);
	    }else{ //il precedente non puo' che essere un pedice
	      _pedici+=car;
	      etic->sostituisci(_pedici,ET_PEDICE , etic->size_str()-2);
	    }
	  }
	}else{
	  _apici="";
	  _pedici="";
	  if((*(etic->vec_str().begin())).first==NO_ETIC ||
	     (*(etic->vec_str().begin())).first==ETIC_IDR_UP){
	    etic->sostituisci(car,ET_STR , etic->size_str()-1);
	  }else{
	    etic->aggiungi(car,ET_STR);
	  }
	}
      }
      editor_pr->redraw();
      return 1;
    }
    default:
      return 0;

  }
  return 0;
}

atom_prop::atom_prop(atomo* at)
  :Fl_Window(600, 290,_("Atom Properties")),
   _atom(at),
   _r(-1),
   _g(-1),
   _b(-1),
   _ra(-1),
   _ga(-1),
   _ba(-1),
   _align((_atom->etich()).allineamento())
{

  { Fl_Box* o = new Fl_Box(10, 25, w()-10, 115, _("String")); //0
      o->box(FL_ENGRAVED_BOX);
      o->align(FL_ALIGN_TOP_LEFT);
  }

  { Fl_Button* o = new Fl_Button(155, 65, 30, 30); //1
      o->image(image_lb_select_font_color);
      o->align(FL_ALIGN_CLIP);
      o->callback(atom_prop_select_string_color_cb,_atom);

  }
  { Fl_Choice* o = new Fl_Choice(65, 33, 129, 22, _("Face:")); //2
      o->down_box(FL_BORDER_BOX);
      o->menu(a_voci_font_face);
      o->callback(atom_prop_select_current_font,_atom);
    }
  {
    Fl_Choice* p = new Fl_Choice(w()-10-115, 33, 115, 22, _("Dimension:")); //3
    p->down_box(FL_BORDER_BOX);
    for(int i=0;i<NUM_FONT_DIM-1;i++){
      ostringstream ostr;
      ostr << i+5;
      voci_font_dim_atom[i].text=strdup(ostr.str().c_str());
    }
    p->menu(voci_font_dim_atom);
    p->value(8);
    p->callback(atom_prop_select_current_font_dimension,_atom);
  }

  {
    Fl_Button* o = new Fl_Button(125, 65, 30, 30); //4
    o->image(image_lb_color_atom);
    o->callback(atom_prop_select_atom_color_cb,_atom);
  }

  { Fl_Button* o = new Fl_Button(185, 65, 30, 30); //5
    o->image(image_lb_supers);
    o->type(FL_RADIO_BUTTON);
  }
  { Fl_Button* o = new Fl_Button(215, 65, 30, 30);//6
    o->image(image_lb_subs);
    o->type(FL_RADIO_BUTTON);
  }
  { Fl_Button* o = new Fl_Button(245, 65, 30, 30);//7
    o->image(image_lb_normal_str_atom);
    o->type(FL_RADIO_BUTTON);
  }

  {
    Fl_Check_Button* o= new Fl_Check_Button(20,97,
					    129,22,
					    _("Parse string"));//8
    o->value(0);

  }

  {
    Fl_Counter* o=new Fl_Counter(w()-10-132,97 , 129, 22,
				 _("Vertical align")); // 9!!
    o->type(FL_SIMPLE_COUNTER);
    o->step(1.0);
    o->bounds(-5,5);
    o->value(at->etich().v_offset());
    o->callback(atom_prop_select_valign_atom_cb);
  }

  {
    Fl_Box* o = new Fl_Box(10, 155, w()-10, 75, _("Electrons and other"));//10
    o->box(FL_ENGRAVED_BOX);
    o->align(FL_ALIGN_TOP_LEFT);
  }

  ostringstream carichestr;
  bool piumen=true;
  carichestr << _atom->cariche();
  string num=carichestr.str();
  if (num[0]=='-'){
    piumen=false;
    num=carichestr.str().substr(1);
  }


  {
    Fl_Group* o = new Fl_Group(20, 180, 55, 60, _("Charge"));//11
    o->align(FL_ALIGN_TOP_LEFT);
  {
    Fl_Round_Button* o = new Fl_Round_Button(30, 180, 50, 20, "+");//0
    o->type(FL_RADIO_BUTTON);
    o->down_box(FL_ROUND_DOWN_BOX);
    if(piumen) o->set();
  }

  {
    Fl_Round_Button* o = new Fl_Round_Button(30, 205, 50, 20, "-");//1
    o->type(FL_RADIO_BUTTON);
    o->down_box(FL_ROUND_DOWN_BOX);
    if(!piumen) o->set();
  }

  o->end();

  }
  {
    Fl_Input* o = new Fl_Input(60, 192, 85, 25); //cariche n12
    o->type(2);
    o->value(num.c_str());
    o->when(FL_WHEN_CHANGED);
    o->callback(atom_prop_charge_cb,_atom);
  }



  //charge position
  {

    /*      0                   1
    	    +------------------+
	    |                  |
	    |                  |
	    |                  |
	   3+------------------+2
    */
    int pos=at->position_charge();
    int w_chg_pos=85;
    int h_chg_pos=125;
    int x_chg_pos=155;
    int w_button=20;
    int h_button=20;
    int x_button_left=x_chg_pos + w_chg_pos/2 - w_button;
    int y_button_left=180;

    Fl_Group* o = new Fl_Group(x_chg_pos, 180, w_chg_pos, h_chg_pos, _("Charge position"));//12
    o->align(FL_ALIGN_CENTER | FL_ALIGN_TOP);

  {
    Fl_Round_Button* o = new Fl_Round_Button(x_button_left, y_button_left,
					     w_button,h_button);//0
    o->type(FL_RADIO_BUTTON);
    o->down_box(FL_ROUND_DOWN_BOX);
    if(pos==L_TOP){
      o->setonly();
    }
    o->callback(atom_prop_charge_pos_cb,_atom);
  }

  {
    Fl_Round_Button* o = new Fl_Round_Button(x_button_left+w_button, y_button_left,
					     w_button,h_button);//1
    o->type(FL_RADIO_BUTTON);
    o->down_box(FL_ROUND_DOWN_BOX);
    if(pos==R_TOP){
      o->setonly();
    }
    o->callback(atom_prop_charge_pos_cb,_atom);
  }

  {
    Fl_Round_Button* o = new Fl_Round_Button(x_button_left+w_button, y_button_left+w_button,
					     w_button,h_button);//2
    o->type(FL_RADIO_BUTTON);
    o->down_box(FL_ROUND_DOWN_BOX);
    if(pos==R_BOTTOM){
      o->setonly();
    }
    o->callback(atom_prop_charge_pos_cb,_atom);
  }

  {
    Fl_Round_Button* o = new Fl_Round_Button(x_button_left, y_button_left+w_button,
					     w_button,h_button);//3
    o->type(FL_RADIO_BUTTON);
    o->down_box(FL_ROUND_DOWN_BOX);
    if(pos==L_BOTTOM){
      o->setonly();
    }
    o->callback(atom_prop_charge_pos_cb,_atom);
  }

  o->end();

  }

  { Fl_Input* o = new Fl_Input(w()-10-55, 195, 55, 25, _("Lone pair:"));//14
    o->type(2);
    ostringstream ostr;
    ostr << _atom->doppietti();
    o->value(ostr.str().c_str());
    o->when(FL_WHEN_CHANGED);
    o->callback(atom_prop_charge_pair_el,_atom);
    }

    { Fl_Input* o = new Fl_Input(w()-10-55, 166, 55, 25, _("Lone unpair:"));//15
      o->type(2);
      ostringstream ostr;
      ostr << _atom->el_spaiati();
      o->value(ostr.str().c_str());
      o->when(FL_WHEN_CHANGED);
      o->callback(atom_prop_charge_sing_el,_atom);
    }

    { Fl_Button* o = new Fl_Button(w()/2-LARG_BUTTON_DEFAULT*3.0, 240, 
                                   LARG_BUTTON_DEFAULT*3, LARG_BUTTON_DEFAULT, _("Close"));//16
      o->callback(atom_prop_cancel_cb);
    }


    {
      Fl_Return_Button* o = new Fl_Return_Button(w()/2, 240, 
                                                 LARG_BUTTON_DEFAULT*3, LARG_BUTTON_DEFAULT, _("Apply"));//17
      o->callback(atom_prop_ok_cb,_atom);

    }


    { Fl_Button* o = new Fl_Button(275, 65, 30, 30);//18
      o->image(image_lb_align);
      o->callback(atom_prop_select_align_atom_cb);
    }

    end();

    set_modal();

    dialog_position(this);
}


atom_prop::~atom_prop(){

}

void atom_win(atomo* at){
  atom_prop p(at);
  p.show();
  while(p.shown()){
    Fl::wait();
  }
}


