/* Data for function pow.
   Copyright (C) 2014-2024 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "svml_d_pow_data.h"

	.section .rodata, "a"
	.align 64

/* Data table for vector implementations of function pow.
   The table may contain polynomial, reduction, lookup coefficients and
   other coefficients obtained through different methods of research and
   experimental work.  */

	.globl __svml_dpow_data
__svml_dpow_data:

/* Lookup log(2) table (for HSW): */
.if .-__svml_dpow_data != _hsw_log2_table
.err
.endif
	.quad	0xc08ff00000000000
	.quad	0x0000000000000000
	.quad	0xc08ff005c3e0ffc2
	.quad	0xbd33ab2631d4676d
	.quad	0xc08ff00b84e236bc
	.quad	0xbd4563ba56cde925
	.quad	0xc08ff01143068126
	.quad	0x3d11790209e88471
	.quad	0xc08ff016fe50b6ee
	.quad	0xbd408517f8e37b00
	.quad	0xc08ff01cb6c3abd0
	.quad	0xbd44558b51cada94
	.quad	0xc08ff0226c622f52
	.quad	0xbd3ec312ed069b24
	.quad	0xc08ff0281f2f0cd0
	.quad	0xbd374a4cb0be9e8a
	.quad	0xc08ff02dcf2d0b86
	.quad	0x3d26eb3ac8ec0ef7
	.quad	0xc08ff0337c5eee92
	.quad	0xbd45984a60ff3d2f
	.quad	0xc08ff03926c7750a
	.quad	0xbd0f0cccdd01ee2f
	.quad	0xc08ff03ece6959f0
	.quad	0xbd3a5671e1bd4ae8
	.quad	0xc08ff0447347544c
	.quad	0xbd3a0976c0a2827d
	.quad	0xc08ff04a1564172a
	.quad	0x3d1e14ebaf30c95e
	.quad	0xc08ff04fb4c251a0
	.quad	0xbd46898809d2dc10
	.quad	0xc08ff0555164aee2
	.quad	0xbd4355e6ecb8e0f1
	.quad	0xc08ff05aeb4dd63c
	.quad	0x3cf3c6764fc87b4a
	.quad	0xc08ff06082806b1c
	.quad	0xbd4532c412ba94db
	.quad	0xc08ff06616ff0d24
	.quad	0xbd4465182838ed44
	.quad	0xc08ff06ba8cc5824
	.quad	0xbd47dc6d46384b31
	.quad	0xc08ff07137eae42a
	.quad	0xbd35af7a7c7c34f3
	.quad	0xc08ff076c45d4584
	.quad	0x3d18a0e14f76d994
	.quad	0xc08ff07c4e260cc8
	.quad	0xbd44e7e87341aeee
	.quad	0xc08ff081d547c6e4
	.quad	0xbd153121e9af5428
	.quad	0xc08ff08759c4fd14
	.quad	0xbd3f9ab3cf74baba
	.quad	0xc08ff08cdba034fa
	.quad	0xbd3f09941811b2ee
	.quad	0xc08ff0925adbf09a
	.quad	0xbd3a3c89a2cf3516
	.quad	0xc08ff097d77aae66
	.quad	0x3d291b415eeb24ed
	.quad	0xc08ff09d517ee940
	.quad	0x3d2c7a4ff65ddbc9
	.quad	0xc08ff0a2c8eb1886
	.quad	0xbd385a047f97bb3e
	.quad	0xc08ff0a83dc1b01a
	.quad	0x3d1124ac34b21259
	.quad	0xc08ff0adb005205e
	.quad	0xbd34f286d207e2c8
	.quad	0xc08ff0b31fb7d648
	.quad	0xbd33167ccc538261
	.quad	0xc08ff0b88cdc3b5e
	.quad	0xbd4542fe4ce30d63
	.quad	0xc08ff0bdf774b5c4
	.quad	0xbd41409e20d7191b
	.quad	0xc08ff0c35f83a83c
	.quad	0xbd40638b5ff73edf
	.quad	0xc08ff0c8c50b7232
	.quad	0x3d294aa31b9b6d65
	.quad	0xc08ff0ce280e6fba
	.quad	0xbd38723279ebfab6
	.quad	0xc08ff0d3888ef9a4
	.quad	0xbd124fad116078ef
	.quad	0xc08ff0d8e68f6572
	.quad	0xbd437350d69ea580
	.quad	0xc08ff0de4212056c
	.quad	0xbd45dd31d962d373
	.quad	0xc08ff0e39b19289e
	.quad	0x3d058b34834a501e
	.quad	0xc08ff0e8f1a71adc
	.quad	0xbd06d26859c7991e
	.quad	0xc08ff0ee45be24d0
	.quad	0xbd3ddb7886f88587
	.quad	0xc08ff0f397608bfc
	.quad	0xbd42d90e5edaecee
	.quad	0xc08ff0f8e69092be
	.quad	0xbd40c5eacb577b4a
	.quad	0xc08ff0fe33507858
	.quad	0xbce49209a68c72a1
	.quad	0xc08ff1037da278f2
	.quad	0xbd30e0f9c896007d
	.quad	0xc08ff108c588cda8
	.quad	0x3d2871a7610e40bd
	.quad	0xc08ff10e0b05ac84
	.quad	0xbd31da156756faad
	.quad	0xc08ff1134e1b4890
	.quad	0xbd28b7fcd690403e
	.quad	0xc08ff1188ecbd1d0
	.quad	0xbd46be4a29c44115
	.quad	0xc08ff11dcd197552
	.quad	0xbd36f6bd48a860f0
	.quad	0xc08ff12309065d28
	.quad	0xbd47913e788c5887
	.quad	0xc08ff1284294b07a
	.quad	0xbd28fe35da2ab291
	.quad	0xc08ff12d79c6937e
	.quad	0xbd3fb9b1aaf54bcc
	.quad	0xc08ff132ae9e278a
	.quad	0xbd3c343ea3e580eb
	.quad	0xc08ff137e11d8b10
	.quad	0xbd3f1140264356b8
	.quad	0xc08ff13d1146d9a8
	.quad	0xbd34c7e0166e1f56
	.quad	0xc08ff1423f1c2c12
	.quad	0xbd3d449e80431d92
	.quad	0xc08ff1476a9f983e
	.quad	0xbd474d3138e94164
	.quad	0xc08ff14c93d33152
	.quad	0x3d2370693afbcdb1
	.quad	0xc08ff151bab907a6
	.quad	0x3d1badba7fbb3d20
	.quad	0xc08ff156df5328d6
	.quad	0x3d2cea9347cb6655
	.quad	0xc08ff15c01a39fbc
	.quad	0xbd46879fa00b120a
	.quad	0xc08ff16121ac7480
	.quad	0xbd43cf0ff16ff990
	.quad	0xc08ff1663f6fac90
	.quad	0xbd43167ccc538261
	.quad	0xc08ff16b5aef4aae
	.quad	0xbd2f7081b8e33aad
	.quad	0xc08ff170742d4ef0
	.quad	0xbd13f94e00e7d6bc
	.quad	0xc08ff1758b2bb6c8
	.quad	0x3d22280434bda911
	.quad	0xc08ff17a9fec7d06
	.quad	0x3d1108740d92f890
	.quad	0xc08ff17fb27199de
	.quad	0xbd416d18135d3266
	.quad	0xc08ff184c2bd02f0
	.quad	0xbd1d97ee9124773b
	.quad	0xc08ff189d0d0ab42
	.quad	0xbd40ccd0edd00e4c
	.quad	0xc08ff18edcae8352
	.quad	0xbd36d76b9a843329
	.quad	0xc08ff193e6587910
	.quad	0xbd210f7ac89c6f2d
	.quad	0xc08ff198edd077e6
	.quad	0xbd40df02face8ca9
	.quad	0xc08ff19df31868c0
	.quad	0xbd41d4cc2f68b868
	.quad	0xc08ff1a2f632320c
	.quad	0x3d2e54d71deb636a
	.quad	0xc08ff1a7f71fb7ba
	.quad	0xbd373af6b5487f35
	.quad	0xc08ff1acf5e2db4e
	.quad	0xbd3927dfc23d9780
	.quad	0xc08ff1b1f27d7bd8
	.quad	0x3d2601ccfac2b557
	.quad	0xc08ff1b6ecf175f8
	.quad	0xbd45e96bed8cce30
	.quad	0xc08ff1bbe540a3f0
	.quad	0xbd1b76a46f31880a
	.quad	0xc08ff1c0db6cdd94
	.quad	0xbd3bdc81c4db3134
	.quad	0xc08ff1c5cf77f860
	.quad	0xbd304cc6600a133e
	.quad	0xc08ff1cac163c770
	.quad	0xbd3b912d8994b162
	.quad	0xc08ff1cfb1321b8c
	.quad	0xbd20009770ea1465
	.quad	0xc08ff1d49ee4c326
	.quad	0x3d2a40dc2d2a6bf7
	.quad	0xc08ff1d98a7d8a60
	.quad	0xbd269affffe47644
	.quad	0xc08ff1de73fe3b14
	.quad	0xbd301dc37c84e79a
	.quad	0xc08ff1e35b689cd2
	.quad	0xbd2953e61f15bd9b
	.quad	0xc08ff1e840be74e6
	.quad	0xbd34998f93e7aa3c
	.quad	0xc08ff1ed2401865e
	.quad	0x3cf5c14e55f57802
	.quad	0xc08ff1f205339208
	.quad	0xbd3e4e8eea54ce63
	.quad	0xc08ff1f6e4565680
	.quad	0x3d0aaa72ba2c6ba2
	.quad	0xc08ff1fbc16b9026
	.quad	0xbd30144751b3314f
	.quad	0xc08ff2009c74f930
	.quad	0x3d2a15a5b343a140
	.quad	0xc08ff205757449a0
	.quad	0xbd398eec5e85b29f
	.quad	0xc08ff20a4c6b3756
	.quad	0xbd1b361c7dddadb6
	.quad	0xc08ff20f215b7606
	.quad	0xbcc2de0634d33aa9
	.quad	0xc08ff213f446b744
	.quad	0xbce024b5b4e89254
	.quad	0xc08ff218c52eaa84
	.quad	0xbd451d49f63f4830
	.quad	0xc08ff21d9414fd24
	.quad	0x3d1f4c2417f39394
	.quad	0xc08ff22260fb5a60
	.quad	0xbd46eb9612e0b4f3
	.quad	0xc08ff2272be36b6c
	.quad	0xbd1a5bd9bcda22fd
	.quad	0xc08ff22bf4ced760
	.quad	0xbd41feb2fc708a78
	.quad	0xc08ff230bbbf4350
	.quad	0x3d13045428f88499
	.quad	0xc08ff23580b6523e
	.quad	0xbcfc14a31ce1b7e3
	.quad	0xc08ff23a43b5a52a
	.quad	0xbd38c9a2f2dbcaf9
	.quad	0xc08ff23f04bedb12
	.quad	0x3d1ecd417972c083
	.quad	0xc08ff243c3d390ee
	.quad	0xbd38e36471414f76
	.quad	0xc08ff24880f561c0
	.quad	0xbd3ce60916e52e91
	.quad	0xc08ff24d3c25e68e
	.quad	0x3d1d406db502402d
	.quad	0xc08ff251f566b664
	.quad	0xbd3a0d8c0e85a909
	.quad	0xc08ff256acb96662
	.quad	0xbd2dafbfd96d5335
	.quad	0xc08ff25b621f89b2
	.quad	0xbd455ede26f47b19
	.quad	0xc08ff260159ab196
	.quad	0xbd461f2e47488cf1
	.quad	0xc08ff264c72c6d64
	.quad	0xbd406b35c7c781db
	.quad	0xc08ff26976d64a8c
	.quad	0xbd20c369fc5a3d9b
	.quad	0xc08ff26e2499d49a
	.quad	0x3d20993376649b50
	.quad	0xc08ff272d078953a
	.quad	0x3d1664deafdbfed5
	.quad	0xc08ff2777a74143c
	.quad	0x3d282b53e791792d
	.quad	0xc08ff27c228dd794
	.quad	0x3ccc79237996a42b
	.quad	0xc08ff280c8c76360
	.quad	0xbd3125d6cbcd1095
	.quad	0xc08ff2856d2239ea
	.quad	0xbd3194cfcc6c23cf
	.quad	0xc08ff28a0f9fdbaa
	.quad	0x3cee35952fb0019c
	.quad	0xc08ff28eb041c748
	.quad	0xbd2286fbc7f749ff
	.quad	0xc08ff2934f0979a2
	.quad	0xbd4715fc9257edff
	.quad	0xc08ff297ebf86dd0
	.quad	0xbd35dcccaf649933
	.quad	0xc08ff29c87101d1e
	.quad	0xbd46d3f77ae3858b
	.quad	0xc08ff2a12051ff1c
	.quad	0xbd0432648cfc8738
	.quad	0xc08ff2a5b7bf8992
	.quad	0xbd3acdf73d83987f
	.quad	0xc08ff2aa4d5a3092
	.quad	0xbd2e6c522ceda3fb
	.quad	0xc08ff2aee123666e
	.quad	0xbd4195620f0359d8
	.quad	0xc08ff2b3731c9bc4
	.quad	0xbd3c70f15d3ebabd
	.quad	0xc08ff2b803473f7a
	.quad	0xbd3a1e7e802c4828
	.quad	0xc08ff2bc91a4bec4
	.quad	0xbd4572ca23a96c48
	.quad	0xc08ff2c11e368528
	.quad	0xbd415b2de01cea41
	.quad	0xc08ff2c5a8fdfc7c
	.quad	0xbd47dc11ebf92a98
	.quad	0xc08ff2ca31fc8cee
	.quad	0xbd474dca44f1db91
	.quad	0xc08ff2ceb9339d04
	.quad	0x3cfb88755d6ca189
	.quad	0xc08ff2d33ea4919a
	.quad	0xbd32e1a3152150d3
	.quad	0xc08ff2d7c250cdf0
	.quad	0xbd206adfcaa4bcf5
	.quad	0xc08ff2dc4439b3a2
	.quad	0x3d290d43956fa5d8
	.quad	0xc08ff2e0c460a2ae
	.quad	0x3d27158a37417c3a
	.quad	0xc08ff2e542c6f978
	.quad	0xbd1829434d994a2a
	.quad	0xc08ff2e9bf6e14cc
	.quad	0xbd2c3e1e30d370ea
	.quad	0xc08ff2ee3a574fde
	.quad	0xbd4677c8dfd9aa24
	.quad	0xc08ff2f2b3840452
	.quad	0xbd2788eba5c173ee
	.quad	0xc08ff2f72af58a34
	.quad	0xbd4588aec6dfa7dc
	.quad	0xc08ff2fba0ad3808
	.quad	0xbd47fe42f19c5879
	.quad	0xc08ff30014ac62c4
	.quad	0x3d2d5e6a8a4fb059
	.quad	0xc08ff30486f45dce
	.quad	0xbd0edb9d09608783
	.quad	0xc08ff308f7867b0c
	.quad	0xbd18dc7c094eee51
	.quad	0xc08ff30d66640ada
	.quad	0xbd46028f37225746
	.quad	0xc08ff311d38e5c16
	.quad	0xbd212d25b3252647
	.quad	0xc08ff3163f06bc16
	.quad	0xbd3906944ba567f4
	.quad	0xc08ff31aa8ce76b8
	.quad	0xbd2b8d59e8492d6e
	.quad	0xc08ff31f10e6d65a
	.quad	0xbd339eec34ce3ce3
	.quad	0xc08ff323775123e2
	.quad	0xbd3c22d2cad415ae
	.quad	0xc08ff327dc0ea6be
	.quad	0xbd42ce2af5839ab8
	.quad	0xc08ff32c3f20a4e8
	.quad	0xbd03719eb3af5b8d
	.quad	0xc08ff330a08862e2
	.quad	0xbd3feed12980ee19
	.quad	0xc08ff335004723c4
	.quad	0xbd2979a5db68721d
	.quad	0xc08ff3395e5e2932
	.quad	0x3cf7159b944f7fd7
	.quad	0xc08ff33dbaceb364
	.quad	0xbd377e236c73e71b
	.quad	0xc08ff342159a012a
	.quad	0xbd4568bb43ac99bb
	.quad	0xc08ff3466ec14fec
	.quad	0xbcf4275f1035e5e8
	.quad	0xc08ff34ac645dba6
	.quad	0xbd3cc58a505d117a
	.quad	0xc08ff34f1c28def8
	.quad	0x3d10bad7dfa568f7
	.quad	0xc08ff353706b9318
	.quad	0xbd3c27e675df639d
	.quad	0xc08ff357c30f2fe4
	.quad	0x3d06e3cb71b554e7
	.quad	0xc08ff35c1414ebd4
	.quad	0xbd40c353cb7112a5
	.quad	0xc08ff360637dfc0c
	.quad	0xbd30d199805b0aec
	.quad	0xc08ff364b14b9450
	.quad	0xbd381e2a51761f86
	.quad	0xc08ff368fd7ee710
	.quad	0xbd250520a377c7ec
	.quad	0xc08ff36d48192564
	.quad	0xbcef941453836236
	.quad	0xc08ff371911b7f10
	.quad	0xbd39e65cd77582e2
	.quad	0xc08ff375d887228a
	.quad	0x3d201640f615fa5c
	.quad	0xc08ff37a1e5d3cf2
	.quad	0xbce855a216719009
	.quad	0xc08ff37e629efa1e
	.quad	0xbd3ae66b65d78df9
	.quad	0xc08ff382a54d8498
	.quad	0xbd45cb804b949696
	.quad	0xc08ff386e66a05a0
	.quad	0xbd33de15e265b5d9
	.quad	0xc08ff38b25f5a52a
	.quad	0xbd46acfcfdca95de
	.quad	0xc08ff38f63f189ea
	.quad	0xbd1a3f6c066ebdd4
	.quad	0xc08ff393a05ed948
	.quad	0xbd3ecf4dff1e8ea2
	.quad	0xc08ff397db3eb770
	.quad	0xbd40d40bb2010158
	.quad	0xc08ff39c1492474a
	.quad	0xbd40f992ba145dcf
	.quad	0xc08ff3a04c5aaa80
	.quad	0xbd346fab3fa1a144
	.quad	0xc08ff3a48299017e
	.quad	0xbd23ea90adf6a54a
	.quad	0xc08ff3a8b74e6b74
	.quad	0xbd449e1389f86468
	.quad	0xc08ff3acea7c065c
	.quad	0xbd441dfc7d7c3321
	.quad	0xc08ff3b11c22eef6
	.quad	0xbd148ad9b560f3b7
	.quad	0xc08ff3b54c4440ca
	.quad	0x3cf1bfb62d6a3aa8
	.quad	0xc08ff3b97ae1162e
	.quad	0xbd2ac444ea257ffa
	.quad	0xc08ff3bda7fa8846
	.quad	0xbd39313aec658458
	.quad	0xc08ff3c1d391af06
	.quad	0x3d2a140de4db9aae
	.quad	0xc08ff3c5fda7a12e
	.quad	0xbd24c06f912ab9d1
	.quad	0xc08ff3ca263d7456
	.quad	0xbd426152c271eb36
	.quad	0xc08ff3ce4d543cea
	.quad	0xbd33483146784bd2
	.quad	0xc08ff3d272ed0e28
	.quad	0xbd44640a8fec6a2e
	.quad	0xc08ff3d69708fa2a
	.quad	0xbd479ca7cb93cc08
	.quad	0xc08ff3dab9a911e2
	.quad	0xbd3cc65b96825ec6
	.quad	0xc08ff3dedace651c
	.quad	0xbd2103e8f00d41c8
	.quad	0xc08ff3e2fa7a0280
	.quad	0xbd3ebdb1bbaf9ab0
	.quad	0xc08ff3e718acf798
	.quad	0xbd350343f8df4b43
	.quad	0xc08ff3eb356850ca
	.quad	0xbd3db11aa6a7cdea
	.quad	0xc08ff3ef50ad1960
	.quad	0xbd3b3b3864c60011
	.quad	0xc08ff3f36a7c5b86
	.quad	0xbd3310f9839f068a
	.quad	0xc08ff3f782d7204c
	.quad	0xbd40144751b3314f
	.quad	0xc08ff3fb99be6faa
	.quad	0xbd429875b0e43fd8
	.quad	0xc08ff3ffaf335080
	.quad	0x3cf9518ce032f41d
	.quad	0xc08ff403c336c894
	.quad	0x3d29ab66b62c5ca8
	.quad	0xc08ff407d5c9dc98
	.quad	0xbd437fc8cafdef46
	.quad	0xc08ff40be6ed9030
	.quad	0xbd2515e1cacac36e
	.quad	0xc08ff40ff6a2e5e6
	.quad	0xbd27f33943464056
	.quad	0xc08ff41404eadf38
	.quad	0xbd1cb6f70109b0f1
	.quad	0xc08ff41811c67c94
	.quad	0x3d24dc166e0e0c68
	.quad	0xc08ff41c1d36bd58
	.quad	0xbd3d990d1e0f6657
	.quad	0xc08ff420273c9fdc
	.quad	0xbcfea92d9e0e8ac2
	.quad	0xc08ff4242fd92166
	.quad	0xbd303cf98ab4e537
	.quad	0xc08ff428370d3e38
	.quad	0xbd2fbc00d8d6cbcf
	.quad	0xc08ff42c3cd9f18a
	.quad	0xbd2fd3fe3499ea9f
	.quad	0xc08ff4304140358e
	.quad	0xbd3532c412ba94db
	.quad	0xc08ff43444410372
	.quad	0xbd1f5ab329b483ec
	.quad	0xc08ff43845dd535e
	.quad	0xbd40444ebaaf2894
	.quad	0xc08ff43c46161c7c
	.quad	0xbd35897d184aaac4
	.quad	0xc08ff44044ec54f2
	.quad	0xbd1d4f639bb5cdf6
	.quad	0xc08ff4444260f1e6
	.quad	0xbd467d28344c2ff0
	.quad	0xc08ff4483e74e786
	.quad	0xbcccb52b4581174d
	.quad	0xc08ff44c392928fa
	.quad	0xbd449eb852b25382
	.quad	0xc08ff450327ea878
	.quad	0xbd450e785694a8c6
	.quad	0xc08ff4542a765738
	.quad	0xbd2410f5d3161a62
	.quad	0xc08ff45821112578
	.quad	0xbcc81e2b378ff59d
	.quad	0xc08ff45c16500280
	.quad	0xbd3e6009faee4be8
	.quad	0xc08ff4600a33dca6
	.quad	0x3d12b628e2d05d76
	.quad	0xc08ff463fcbda144
	.quad	0xbd3cbb828084fcb1
	.quad	0xc08ff467edee3cc8
	.quad	0xbd4085c5870d5301
	.quad	0xc08ff46bddc69aaa
	.quad	0xbd4475780e47156b
	.quad	0xc08ff46fcc47a574
	.quad	0xbcdbc76a2753b99b
	.quad	0xc08ff473b97246bc
	.quad	0xbd2012f1593ee62a
	.quad	0xc08ff477a547672e
	.quad	0xbd3d30c3d2643639
	.quad	0xc08ff47b8fc7ee8a
	.quad	0xbd062c45c4bc31c9
	.quad	0xc08ff47f78f4c3a0
	.quad	0xbd22642415d47384
	.quad	0xc08ff48360cecc5a
	.quad	0x3d2372fd3ff3197b
	.quad	0xc08ff4874756edb4
	.quad	0xbd4668c543d0b42b
	.quad	0xc08ff48b2c8e0bca
	.quad	0xbd33f65cadbe0d26
	.quad	0xc08ff48f107509ca
	.quad	0x3cfbfbf899cf2b3c
	.quad	0xc08ff492f30cc9fe
	.quad	0xbd307470f69809cc
	.quad	0xc08ff496d4562dce
	.quad	0xbd44115a1a340462
	.quad	0xc08ff49ab45215c0
	.quad	0xbcff5369fdf426cf
	.quad	0xc08ff49e93016172
	.quad	0xbd3fc02bc277071d
	.quad	0xc08ff4a27064efa8
	.quad	0xbd4728da988cc139
	.quad	0xc08ff4a64c7d9e44
	.quad	0xbd458147cf67745e
	.quad	0xc08ff4aa274c4a4a
	.quad	0xbd22100986691daa
	.quad	0xc08ff4ae00d1cfde
	.quad	0xbd36879fa00b120a
	.quad	0xc08ff4b1d90f0a4c
	.quad	0xbd40b68fc634db41
	.quad	0xc08ff4b5b004d404
	.quad	0xbd3c03254a7145e3
	.quad	0xc08ff4b985b4069c
	.quad	0xbcf4f144da6e4533
	.quad	0xc08ff4bd5a1d7ad0
	.quad	0x3d1b3d7b0e65d2ce
	.quad	0xc08ff4c12d420886
	.quad	0x3d0dd3d30f5deaa7
	.quad	0xc08ff4c4ff2286ce
	.quad	0x3d20dc60dc5befec
	.quad	0xc08ff4c8cfbfcbe0
	.quad	0xbd47f6a1ab3efbbe
	.quad	0xc08ff4cc9f1aad26
	.quad	0xbd429b21ae4817e9
	.quad	0xc08ff4d06d33ff32
	.quad	0x3d256a9ae5dca5a3
	.quad	0xc08ff4d43a0c95c2
	.quad	0x3cf38bc99b3611ce
	.quad	0xc08ff4d805a543c8
	.quad	0xbd0c6d2c37daf317
	.quad	0xc08ff4dbcffedb64
	.quad	0xbd262404772a151d
	.quad	0xc08ff4df991a2de8
	.quad	0xbd11c0de7b779cb3
	.quad	0xc08ff4e360f80bd6
	.quad	0xbd4424a06f870b9e
	.quad	0xc08ff4e7279944e8
	.quad	0xbd3a69393bab4fd0
	.quad	0xc08ff4eaecfea808
	.quad	0xbd266cccab240e90
	.quad	0xc08ff4eeb1290356
	.quad	0xbd38e9b57298d22f
	.quad	0xc08ff4f27419242c
	.quad	0x3d2eddd33ea4d6f1
	.quad	0xc08ff4f635cfd714
	.quad	0xbd476e0ed8a042be
	.quad	0xc08ff4f9f64de7dc
	.quad	0xbce66ae2a7ada553
	.quad	0xc08ff4fdb5942180
	.quad	0xbd0cd57d9d86514e
	.quad	0xc08ff50173a34e3c
	.quad	0xbd42efafb4bec72b
	.quad	0xc08ff505307c378a
	.quad	0xbd1a46dbdcc762d3
	.quad	0xc08ff508ec1fa61a
	.quad	0xbd354b383b0e8a55
	.quad	0xc08ff50ca68e61e0
	.quad	0x3d2c7d469ea019ad
	.quad	0xc08ff5105fc93208
	.quad	0xbd264adb1adca9a8
	.quad	0xc08ff51417d0dd04
	.quad	0x3ce5c601f0626dc8
	.quad	0xc08ff517cea62882
	.quad	0x3d18eb650003fb32
	.quad	0xc08ff51b8449d972
	.quad	0xbd326baaf0b591f8
	.quad	0xc08ff51f38bcb408
	.quad	0xbd461b8d0e43a37f
	.quad	0xc08ff522ebff7bbc
	.quad	0xbd33859a74f0d148
	.quad	0xc08ff5269e12f346
	.quad	0xbd3c57f2495fb7fa
	.quad	0xc08ff52a4ef7dca8
	.quad	0xbcd5dc21a39bf974
	.quad	0xc08ff52dfeaef926
	.quad	0x3d0aa0e9e6bca777
	.quad	0xc08ff531ad39094c
	.quad	0xbd47d0fa4fa0c208
	.quad	0xc08ff5355a96ccf4
	.quad	0x3d23bb5921006679
	.quad	0xc08ff53906c90336
	.quad	0xbd21f3e0c466e8f9
	.quad	0xc08ff53cb1d06a7c
	.quad	0xbd39f3ba83f85c08
	.quad	0xc08ff5405badc07a
	.quad	0x3d2e77ad7a4b71c0
	.quad	0xc08ff5440461c22a
	.quad	0xbd1f1bbd2926f164
	.quad	0xc08ff547abed2bd8
	.quad	0xbd44479667bb79bf
	.quad	0xc08ff54b5250b91e
	.quad	0xbd2094ef49b8484b
	.quad	0xc08ff54ef78d24de
	.quad	0xbd41fb87566dd18c
	.quad	0xc08ff5529ba32950
	.quad	0xbd3c6d8d86531d56
	.quad	0xc08ff5563e937ff8
	.quad	0xbd323e7492de8d74
	.quad	0xc08ff559e05ee1ac
	.quad	0xbcf63d8bd35fdc18
	.quad	0xc08ff55d81060692
	.quad	0xbd3cc78dae939320
	.quad	0xc08ff5612089a626
	.quad	0xbd44cf0e362f4a36
	.quad	0xc08ff564beea7736
	.quad	0xbd3a96d7a36f1545
	.quad	0xc08ff5685c292fe2
	.quad	0xbd4570af1a0bc9f4
	.quad	0xc08ff56bf84685a4
	.quad	0x3d1bdc90791aef03
	.quad	0xc08ff56f93432d44
	.quad	0xbd40d2abacfc0489
	.quad	0xc08ff5732d1fdaea
	.quad	0xbd39e35c1aa7693f
	.quad	0xc08ff576c5dd4210
	.quad	0xbd23c49c247ab6af
	.quad	0xc08ff57a5d7c1588
	.quad	0xbd4374da167aead5
	.quad	0xc08ff57df3fd0782
	.quad	0xbd2aeb8cb1ac05cd
	.quad	0xc08ff5818960c982
	.quad	0xbd3b1b8ae4633046
	.quad	0xc08ff5851da80c6c
	.quad	0xbd20899cee46ebe4
	.quad	0xc08ff588b0d3807c
	.quad	0xbcfc4413fd83dec1
	.quad	0xc08ff58c42e3d54c
	.quad	0xbd02101a9685c779
	.quad	0xc08ff58fd3d9b9d2
	.quad	0xbd45c074c957d037
	.quad	0xc08ff59363b5dc66
	.quad	0xbd3f7cc3df8803d1
	.quad	0xc08ff596f278eaba
	.quad	0xbd3961ecab44052e
	.quad	0xc08ff59a802391e2
	.quad	0xbd1979a5db68721d
	.quad	0xc08ff59e0cb67e50
	.quad	0xbd3e4ce321e589a9
	.quad	0xc08ff5a198325bdc
	.quad	0x3d0e321d11f8a0ce
	.quad	0xc08ff5a52297d5ba
	.quad	0x3d227ae8037b21bf
	.quad	0xc08ff5a8abe79684
	.quad	0x3d1ebefecd51a1be
	.quad	0xc08ff5ac34224836
	.quad	0xbd372c2fed3f759f
	.quad	0xc08ff5afbb489432
	.quad	0xbd46b82e2a9e810c
	.quad	0xc08ff5b3415b2340
	.quad	0x3d2e59ad84a6a593
	.quad	0xc08ff5b6c65a9d86
	.quad	0xbd249d97df07e357
	.quad	0xc08ff5ba4a47aa98
	.quad	0xbd46d25a5b8a19b2
	.quad	0xc08ff5bdcd22f172
	.quad	0x3d2e859780f0cdc7
	.quad	0xc08ff5c14eed186e
	.quad	0xbd4171cf05a99915
	.quad	0xc08ff5c4cfa6c55a
	.quad	0xbd41ef9459fef720
	.quad	0xc08ff5c84f509d68
	.quad	0x3d145ccfb66fabd2
	.quad	0xc08ff5cbcdeb4530
	.quad	0xbd46bf2e7459b97d
	.quad	0xc08ff5cf4b7760be
	.quad	0xbd36132520b9d027
	.quad	0xc08ff5d2c7f59382
	.quad	0x3d15872350f805d6
	.quad	0xc08ff5d643668058
	.quad	0xbd41835d469035a9
	.quad	0xc08ff5d9bdcac98e
	.quad	0xbd47b7378ad99d2e
	.quad	0xc08ff5dd372310dc
	.quad	0xbd472d51ea7c162e
	.quad	0xc08ff5e0af6ff76a
	.quad	0x3d2a8843781eda15
	.quad	0xc08ff5e426b21dc8
	.quad	0xbd44ea36d76b0bd8
	.quad	0xc08ff5e79cea2402
	.quad	0x3d2e03b336c24b74
	.quad	0xc08ff5eb1218a986
	.quad	0xbd45a7bfdb3c98b0
	.quad	0xc08ff5ee863e4d40
	.quad	0xbd37204f55bbf90d
	.quad	0xc08ff5f1f95bad84
	.quad	0xbd41b72e122257f1
	.quad	0xc08ff5f56b71681e
	.quad	0xbd1488084776534a
	.quad	0xc08ff5f8dc801a48
	.quad	0xbd2866405210e49e
	.quad	0xc08ff5fc4c8860b4
	.quad	0x3d1d45da26510032
	.quad	0xc08ff5ffbb8ad784
	.quad	0xbd2f386200388584
	.quad	0xc08ff60329881a52
	.quad	0xbd47e32446892fb9
	.quad	0xc08ff6069680c42e
	.quad	0xbd4330c4c4a27e40
	.quad	0xc08ff60a02756f9c
	.quad	0xbd0cb6f70109b0f1
	.quad	0xc08ff60d6d66b694
	.quad	0xbd4777531ab1b43f
	.quad	0xc08ff610d755328e
	.quad	0x3d118906313e79cf
	.quad	0xc08ff61440417c70
	.quad	0x3d0a5b363a6f499c
	.quad	0xc08ff617a82c2c9e
	.quad	0xbd39308437e74325
	.quad	0xc08ff61b0f15daf6
	.quad	0xbd3fef5f3fc61899
	.quad	0xc08ff61e74ff1ece
	.quad	0xbd3b85f3204507b9
	.quad	0xc08ff621d9e88ef6
	.quad	0xbd42fc8ea3276ba0
	.quad	0xc08ff6253dd2c1bc
	.quad	0x3d0d2fe4574e09b9
	.quad	0xc08ff628a0be4ce4
	.quad	0xbd3245829ca653e6
	.quad	0xc08ff62c02abc5b4
	.quad	0xbd42a385b236e315
	.quad	0xc08ff62f639bc0ee
	.quad	0xbd301f1e98d8979c
	.quad	0xc08ff632c38ed2ce
	.quad	0xbd3ded9b44542fd9
	.quad	0xc08ff63622858f12
	.quad	0xbd3d400fd651da9a
	.quad	0xc08ff639808088f6
	.quad	0x3d29f78153fcfec0
	.quad	0xc08ff63cdd805330
	.quad	0xbd46af859d47a29a
	.quad	0xc08ff64039858000
	.quad	0xbd3667f21fa8423f
	.quad	0xc08ff6439490a11e
	.quad	0xbd1b254cabaa042b
	.quad	0xc08ff646eea247c6
	.quad	0x3d1ee969a95f528f
	.quad	0xc08ff64a47bb04b4
	.quad	0xbd3821d36e0b7548
	.quad	0xc08ff64d9fdb682a
	.quad	0xbd3974e6432d9ee8
	.quad	0xc08ff650f70401ea
	.quad	0xbd1d74d044558154
	.quad	0xc08ff6544d356138
	.quad	0xbd371b3a63cddadf
	.quad	0xc08ff657a27014e0
	.quad	0x3d17b6aad08dc210
	.quad	0xc08ff65af6b4ab2c
	.quad	0xbd47d7bfb12454c5
	.quad	0xc08ff65e4a03b1f4
	.quad	0xbd373647bf25fa5f
	.quad	0xc08ff6619c5db68e
	.quad	0xbcf742a6b2827cf0
	.quad	0xc08ff664edc345d8
	.quad	0xbd02d3bbd925734c
	.quad	0xc08ff6683e34ec38
	.quad	0xbd03f7a55cd2af4c
	.quad	0xc08ff66b8db3359a
	.quad	0xbd308364fa508035
	.quad	0xc08ff66edc3ead74
	.quad	0x3d2b37bd36337985
	.quad	0xc08ff67229d7dec0
	.quad	0x3d22a424c693063d
	.quad	0xc08ff675767f5404
	.quad	0xbd166cccab240e90
	.quad	0xc08ff678c2359750
	.quad	0x3d2bce65acc07927
	.quad	0xc08ff67c0cfb323a
	.quad	0xbd25651ccd0e0880
	.quad	0xc08ff67f56d0ade6
	.quad	0xbd4533d5b4542c99
	.quad	0xc08ff6829fb69304
	.quad	0xbd22ce6312ebb81d
	.quad	0xc08ff685e7ad69ca
	.quad	0xbd2b6967f02b01d8
	.quad	0xc08ff6892eb5b9fe
	.quad	0xbd3bb55730409355
	.quad	0xc08ff68c74d00af2
	.quad	0xbd4352b18e47fcd2
	.quad	0xc08ff68fb9fce386
	.quad	0xbceed0798d1aa216
	.quad	0xc08ff692fe3cca22
	.quad	0xbd464b702b56565e
	.quad	0xc08ff696419044c4
	.quad	0xbd45909799f95e23
	.quad	0xc08ff69983f7d8f4
	.quad	0xbd2bebde1ac6e983
	.quad	0xc08ff69cc5740bc8
	.quad	0xbd18f7aac147fdc1
	.quad	0xc08ff6a0060561e8
	.quad	0x3d2653a2eb403f26
	.quad	0xc08ff6a345ac5f8a
	.quad	0x3d1769a8e6b40f5e
	.quad	0xc08ff6a684698876
	.quad	0xbd1770535b322bbf
	.quad	0xc08ff6a9c23d6004
	.quad	0xbd434df378df21ad
	.quad	0xc08ff6acff286920
	.quad	0xbd398cc3b5d08e15
	.quad	0xc08ff6b03b2b2644
	.quad	0xbd39d941e9e746a4
	.quad	0xc08ff6b376461980
	.quad	0x3d2fd2e802de76ad
	.quad	0xc08ff6b6b079c472
	.quad	0xbcf968ab16b0d7ba
	.quad	0xc08ff6b9e9c6a850
	.quad	0xbd3fa4a9eb6b8621
	.quad	0xc08ff6bd222d45e4
	.quad	0xbd36ad5bac74b87f
	.quad	0xc08ff6c059ae1d8a
	.quad	0x3d057c1b79ee9964
	.quad	0xc08ff6c39049af32
	.quad	0xbd0af5e9bb5386c2
	.quad	0xc08ff6c6c6007a64
	.quad	0xbce8467191344d58
	.quad	0xc08ff6c9fad2fe3c
	.quad	0xbd1148dad646cb9d
	.quad	0xc08ff6cd2ec1b96c
	.quad	0xbd4149540d5fceb9
	.quad	0xc08ff6d061cd2a40
	.quad	0xbd117b2f1731efbe
	.quad	0xc08ff6d393f5ce96
	.quad	0x3d25005be8c5610b
	.quad	0xc08ff6d6c53c23e6
	.quad	0x3d29a1979619fe2f
	.quad	0xc08ff6d9f5a0a740
	.quad	0x3d15ebe99c4f6416
	.quad	0xc08ff6dd2523d54c
	.quad	0xbd36d25a5b8a19b2
	.quad	0xc08ff6e053c62a4c
	.quad	0xbd47f3f2612caf97
	.quad	0xc08ff6e38188221c
	.quad	0xbd3848e9d1d92d88
	.quad	0xc08ff6e6ae6a382e
	.quad	0xbd3b4aada7453897
	.quad	0xc08ff6e9da6ce792
	.quad	0xbd2640ef87ede14b
	.quad	0xc08ff6ed0590aaf0
	.quad	0xbd2da89e835cc3d2
	.quad	0xc08ff6f02fd5fc8e
	.quad	0x3d2fa6e2ac948d1a
	.quad	0xc08ff6f3593d5648
	.quad	0xbd44bf3775fde250
	.quad	0xc08ff6f681c731a0
	.quad	0x3d2924ae921f7eca
	.quad	0xc08ff6f9a97407a8
	.quad	0xbd32994b351f388c
	.quad	0xc08ff6fcd0445118
	.quad	0xbd429af37d1edf2f
	.quad	0xc08ff6fff6388644
	.quad	0x3d2ed5a8a2de89da
	.quad	0xc08ff7031b511f16
	.quad	0xbd474d8b66a69572
	.quad	0xc08ff7063f8e9322
	.quad	0xbd3b20d190c69cff
	.quad	0xc08ff70962f15992
	.quad	0xbcf455bedf4083bc
	.quad	0xc08ff70c8579e930
	.quad	0xbd215844900583de
	.quad	0xc08ff70fa728b868
	.quad	0xbd054cda62d3926e
	.quad	0xc08ff712c7fe3d44
	.quad	0x3d2143e9a0cbd481
	.quad	0xc08ff715e7faed6e
	.quad	0x3d2a82ed66976b91
	.quad	0xc08ff719071f3e30
	.quad	0xbd318c64f0672cf9
	.quad	0xc08ff71c256ba478
	.quad	0xbd2c760bc9b188c4
	.quad	0xc08ff71f42e094d2
	.quad	0xbd2b88ca364674ac
	.quad	0xc08ff7225f7e836c
	.quad	0xbd46361ccd8974a5
	.quad	0xc08ff7257b45e41a
	.quad	0xbd24e3eb5884aae7
	.quad	0xc08ff72896372a4c
	.quad	0xbd38b1aff71c8605
	.quad	0xc08ff72bb052c91a
	.quad	0xbd429a0a140ddd8a
	.quad	0xc08ff72ec999333e
	.quad	0xbd43d6bb35ec114f
	.quad	0xc08ff731e20adb16
	.quad	0xbd2bd849ce4dc635
	.quad	0xc08ff734f9a832a2
	.quad	0xbd206c243749114c
	.quad	0xc08ff7381071ab88
	.quad	0xbd3595f2f68d91fd
	.quad	0xc08ff73b2667b714
	.quad	0xbd3017eb15bb7de4
	.quad	0xc08ff73e3b8ac636
	.quad	0x3d1c28798c12cc39
	.quad	0xc08ff7414fdb4982
	.quad	0xbd12ce6312ebb81d
	.quad	0xc08ff7446359b134
	.quad	0xbd4395510d1e3f81
	.quad	0xc08ff74776066d30
	.quad	0xbd3f86493917b407
	.quad	0xc08ff74a87e1ecfe
	.quad	0xbd10be3a57487484
	.quad	0xc08ff74d98ec9fcc
	.quad	0xbd2d5297837adb4b
	.quad	0xc08ff750a926f472
	.quad	0xbd43ae4d308b33a5
	.quad	0xc08ff753b8915972
	.quad	0x3d2d54d244e2aaee
	.quad	0xc08ff756c72c3cee
	.quad	0xbd35f097b0fe80a3
	.quad	0xc08ff759d4f80cba
	.quad	0xbd3077f1f5f0cc83
	.quad	0xc08ff75ce1f5364e
	.quad	0x3d19367107b8e917
	.quad	0xc08ff75fee2426ca
	.quad	0xbd33623c81400bcf
	.quad	0xc08ff762f9854afc
	.quad	0xbd33b55bcb161bac
	.quad	0xc08ff76604190f5a
	.quad	0x3d2eb3c3bf914b9c
	.quad	0xc08ff7690ddfe000
	.quad	0xbd45a6a7f43f6ec0
	.quad	0xc08ff76c16da28be
	.quad	0xbd3b253dff5e0495
	.quad	0xc08ff76f1f085508
	.quad	0x3d1b08127eec65d2
	.quad	0xc08ff772266acffc
	.quad	0xbd45b1799ceaeb51
	.quad	0xc08ff7752d02046c
	.quad	0xbd2e63bd0fcda210
	.quad	0xc08ff77832ce5cce
	.quad	0xbd148cd0a7bb24b2
	.quad	0xc08ff77b37d04348
	.quad	0x3d11ef56fa3d37b4
	.quad	0xc08ff77e3c0821ac
	.quad	0x3d1a768216f872eb
	.quad	0xc08ff7813f766178
	.quad	0xbd44b4a15a96316e
	.quad	0xc08ff784421b6bdc
	.quad	0xbd4258a7b2336919
	.quad	0xc08ff78743f7a9b2
	.quad	0x3d03f659faac5a20
	.quad	0xc08ff78a450b8380
	.quad	0xbd2401fbaaa67e3c
	.quad	0xc08ff78d4557617e
	.quad	0xbd476fa81cf6a494
	.quad	0xc08ff79044dbab94
	.quad	0xbd44f46b93eece0a
	.quad	0xc08ff7934398c956
	.quad	0xbd3c91f073716495
	.quad	0xc08ff796418f2208
	.quad	0xbd3672b0c88d4dd6
	.quad	0xc08ff7993ebf1c9e
	.quad	0xbd3fb554647678d1
	.quad	0xc08ff79c3b291fbe
	.quad	0xbd0bb98afdf33295
	.quad	0xc08ff79f36cd91ba
	.quad	0xbd3a1c40753a869f
	.quad	0xc08ff7a231acd89a
	.quad	0xbd3395510d1e3f81
	.quad	0xc08ff7a52bc75a14
	.quad	0xbcf98fd2dca61c14
	.quad	0xc08ff7a8251d7b8e
	.quad	0xbd40e7b8e7574248
	.quad	0xc08ff7ab1dafa224
	.quad	0xbd43f88ff2576e98
	.quad	0xc08ff7ae157e32a2
	.quad	0xbd1f61a96b8ce776
	.quad	0xc08ff7b10c899184
	.quad	0x3cde66be73b9da04
	.quad	0xc08ff7b402d222fa
	.quad	0xbd408d5c3f1d5c0d
	.quad	0xc08ff7b6f8584aea
	.quad	0xbd3cbebea25ecd9e
	.quad	0xc08ff7b9ed1c6cea
	.quad	0xbd2507d6dc1f27ef
	.quad	0xc08ff7bce11eec44
	.quad	0x3d2794d4c6c8f327
	.quad	0xc08ff7bfd4602bf4
	.quad	0xbd3f1e32799da52d
	.quad	0xc08ff7c2c6e08eb0
	.quad	0xbd35c01818adf4af
	.quad	0xc08ff7c5b8a076de
	.quad	0x3d2cfc4de6d73dea
	.quad	0xc08ff7c8a9a04696
	.quad	0xbd4227264a17d460
	.quad	0xc08ff7cb99e05fae
	.quad	0xbd0142b08bb672e8
	.quad	0xc08ff7ce896123a8
	.quad	0xbd2564fcfaea5fb3
	.quad	0xc08ff7d17822f3c2
	.quad	0x3d2aab1b2a41b090
	.quad	0xc08ff7d4662630ea
	.quad	0xbd46ac3b83ef359a
	.quad	0xc08ff7d7536b3bce
	.quad	0x3d241a2f220ccf53
	.quad	0xc08ff7da3ff274c6
	.quad	0xbd38f5d37680fd7c
	.quad	0xc08ff7dd2bbc3bec
	.quad	0x3d048a179268271d
	.quad	0xc08ff7e016c8f108
	.quad	0xbd471e548b69f12a
	.quad	0xc08ff7e30118f3a2
	.quad	0xbd41a23946dfa58c
	.quad	0xc08ff7e5eaaca2f4
	.quad	0xbd25330d5605f2a6
	.quad	0xc08ff7e8d3845df0
	.quad	0xbd319b14945cf6ba
	.quad	0xc08ff7ebbba08342
	.quad	0xbd4702e1863f7c92
	.quad	0xc08ff7eea3017150
	.quad	0xbd437cfeba9ff979
	.quad	0xc08ff7f189a78636
	.quad	0xbd3df6e958e938b0
	.quad	0xc08ff7f46f931fca
	.quad	0xbd37ca15910e7069
	.quad	0xc08ff7f754c49b9c
	.quad	0xbd15cfd00d77e6ec
	.quad	0xc08ff7fa393c56f4
	.quad	0xbd2a025d9e2442e6
	.quad	0xc08ff7fd1cfaaed6
	.quad	0xbd3258e9a821b7cc
	.quad	0xc08ff80000000000
	.quad	0x0000000000000000
	.rept	48
	.byte	0
	.endr

/* Lookup exp(2) table (for HSW): */
.if .-__svml_dpow_data != _hsw_dTe
.err
.endif
	.quad	0x3ff0000000000000
	.quad	0x3ff00b1afa5abcbf
	.quad	0x3ff0163da9fb3335
	.quad	0x3ff02168143b0281
	.quad	0x3ff02c9a3e778061
	.quad	0x3ff037d42e11bbcc
	.quad	0x3ff04315e86e7f85
	.quad	0x3ff04e5f72f654b1
	.quad	0x3ff059b0d3158574
	.quad	0x3ff0650a0e3c1f89
	.quad	0x3ff0706b29ddf6de
	.quad	0x3ff07bd42b72a836
	.quad	0x3ff0874518759bc8
	.quad	0x3ff092bdf66607e0
	.quad	0x3ff09e3ecac6f383
	.quad	0x3ff0a9c79b1f3919
	.quad	0x3ff0b5586cf9890f
	.quad	0x3ff0c0f145e46c85
	.quad	0x3ff0cc922b7247f7
	.quad	0x3ff0d83b23395dec
	.quad	0x3ff0e3ec32d3d1a2
	.quad	0x3ff0efa55fdfa9c5
	.quad	0x3ff0fb66affed31b
	.quad	0x3ff1073028d7233e
	.quad	0x3ff11301d0125b51
	.quad	0x3ff11edbab5e2ab6
	.quad	0x3ff12abdc06c31cc
	.quad	0x3ff136a814f204ab
	.quad	0x3ff1429aaea92de0
	.quad	0x3ff14e95934f312e
	.quad	0x3ff15a98c8a58e51
	.quad	0x3ff166a45471c3c2
	.quad	0x3ff172b83c7d517b
	.quad	0x3ff17ed48695bbc0
	.quad	0x3ff18af9388c8dea
	.quad	0x3ff1972658375d2f
	.quad	0x3ff1a35beb6fcb75
	.quad	0x3ff1af99f8138a1c
	.quad	0x3ff1bbe084045cd4
	.quad	0x3ff1c82f95281c6b
	.quad	0x3ff1d4873168b9aa
	.quad	0x3ff1e0e75eb44027
	.quad	0x3ff1ed5022fcd91d
	.quad	0x3ff1f9c18438ce4d
	.quad	0x3ff2063b88628cd6
	.quad	0x3ff212be3578a819
	.quad	0x3ff21f49917ddc96
	.quad	0x3ff22bdda27912d1
	.quad	0x3ff2387a6e756238
	.quad	0x3ff2451ffb82140a
	.quad	0x3ff251ce4fb2a63f
	.quad	0x3ff25e85711ece75
	.quad	0x3ff26b4565e27cdd
	.quad	0x3ff2780e341ddf29
	.quad	0x3ff284dfe1f56381
	.quad	0x3ff291ba7591bb70
	.quad	0x3ff29e9df51fdee1
	.quad	0x3ff2ab8a66d10f13
	.quad	0x3ff2b87fd0dad990
	.quad	0x3ff2c57e39771b2f
	.quad	0x3ff2d285a6e4030b
	.quad	0x3ff2df961f641589
	.quad	0x3ff2ecafa93e2f56
	.quad	0x3ff2f9d24abd886b
	.quad	0x3ff306fe0a31b715
	.quad	0x3ff31432edeeb2fd
	.quad	0x3ff32170fc4cd831
	.quad	0x3ff32eb83ba8ea32
	.quad	0x3ff33c08b26416ff
	.quad	0x3ff3496266e3fa2d
	.quad	0x3ff356c55f929ff1
	.quad	0x3ff36431a2de883b
	.quad	0x3ff371a7373aa9cb
	.quad	0x3ff37f26231e754a
	.quad	0x3ff38cae6d05d866
	.quad	0x3ff39a401b7140ef
	.quad	0x3ff3a7db34e59ff7
	.quad	0x3ff3b57fbfec6cf4
	.quad	0x3ff3c32dc313a8e5
	.quad	0x3ff3d0e544ede173
	.quad	0x3ff3dea64c123422
	.quad	0x3ff3ec70df1c5175
	.quad	0x3ff3fa4504ac801c
	.quad	0x3ff40822c367a024
	.quad	0x3ff4160a21f72e2a
	.quad	0x3ff423fb2709468a
	.quad	0x3ff431f5d950a897
	.quad	0x3ff43ffa3f84b9d4
	.quad	0x3ff44e086061892d
	.quad	0x3ff45c2042a7d232
	.quad	0x3ff46a41ed1d0057
	.quad	0x3ff4786d668b3237
	.quad	0x3ff486a2b5c13cd0
	.quad	0x3ff494e1e192aed2
	.quad	0x3ff4a32af0d7d3de
	.quad	0x3ff4b17dea6db7d7
	.quad	0x3ff4bfdad5362a27
	.quad	0x3ff4ce41b817c114
	.quad	0x3ff4dcb299fddd0d
	.quad	0x3ff4eb2d81d8abff
	.quad	0x3ff4f9b2769d2ca7
	.quad	0x3ff508417f4531ee
	.quad	0x3ff516daa2cf6642
	.quad	0x3ff5257de83f4eef
	.quad	0x3ff5342b569d4f82
	.quad	0x3ff542e2f4f6ad27
	.quad	0x3ff551a4ca5d920f
	.quad	0x3ff56070dde910d2
	.quad	0x3ff56f4736b527da
	.quad	0x3ff57e27dbe2c4cf
	.quad	0x3ff58d12d497c7fd
	.quad	0x3ff59c0827ff07cc
	.quad	0x3ff5ab07dd485429
	.quad	0x3ff5ba11fba87a03
	.quad	0x3ff5c9268a5946b7
	.quad	0x3ff5d84590998b93
	.quad	0x3ff5e76f15ad2148
	.quad	0x3ff5f6a320dceb71
	.quad	0x3ff605e1b976dc09
	.quad	0x3ff6152ae6cdf6f4
	.quad	0x3ff6247eb03a5585
	.quad	0x3ff633dd1d1929fd
	.quad	0x3ff6434634ccc320
	.quad	0x3ff652b9febc8fb7
	.quad	0x3ff6623882552225
	.quad	0x3ff671c1c70833f6
	.quad	0x3ff68155d44ca973
	.quad	0x3ff690f4b19e9538
	.quad	0x3ff6a09e667f3bcd
	.quad	0x3ff6b052fa75173e
	.quad	0x3ff6c012750bdabf
	.quad	0x3ff6cfdcddd47645
	.quad	0x3ff6dfb23c651a2f
	.quad	0x3ff6ef9298593ae5
	.quad	0x3ff6ff7df9519484
	.quad	0x3ff70f7466f42e87
	.quad	0x3ff71f75e8ec5f74
	.quad	0x3ff72f8286ead08a
	.quad	0x3ff73f9a48a58174
	.quad	0x3ff74fbd35d7cbfd
	.quad	0x3ff75feb564267c9
	.quad	0x3ff77024b1ab6e09
	.quad	0x3ff780694fde5d3f
	.quad	0x3ff790b938ac1cf6
	.quad	0x3ff7a11473eb0187
	.quad	0x3ff7b17b0976cfdb
	.quad	0x3ff7c1ed0130c132
	.quad	0x3ff7d26a62ff86f0
	.quad	0x3ff7e2f336cf4e62
	.quad	0x3ff7f3878491c491
	.quad	0x3ff80427543e1a12
	.quad	0x3ff814d2add106d9
	.quad	0x3ff82589994cce13
	.quad	0x3ff8364c1eb941f7
	.quad	0x3ff8471a4623c7ad
	.quad	0x3ff857f4179f5b21
	.quad	0x3ff868d99b4492ed
	.quad	0x3ff879cad931a436
	.quad	0x3ff88ac7d98a6699
	.quad	0x3ff89bd0a478580f
	.quad	0x3ff8ace5422aa0db
	.quad	0x3ff8be05bad61778
	.quad	0x3ff8cf3216b5448c
	.quad	0x3ff8e06a5e0866d9
	.quad	0x3ff8f1ae99157736
	.quad	0x3ff902fed0282c8a
	.quad	0x3ff9145b0b91ffc6
	.quad	0x3ff925c353aa2fe2
	.quad	0x3ff93737b0cdc5e5
	.quad	0x3ff948b82b5f98e5
	.quad	0x3ff95a44cbc8520f
	.quad	0x3ff96bdd9a7670b3
	.quad	0x3ff97d829fde4e50
	.quad	0x3ff98f33e47a22a2
	.quad	0x3ff9a0f170ca07ba
	.quad	0x3ff9b2bb4d53fe0d
	.quad	0x3ff9c49182a3f090
	.quad	0x3ff9d674194bb8d5
	.quad	0x3ff9e86319e32323
	.quad	0x3ff9fa5e8d07f29e
	.quad	0x3ffa0c667b5de565
	.quad	0x3ffa1e7aed8eb8bb
	.quad	0x3ffa309bec4a2d33
	.quad	0x3ffa42c980460ad8
	.quad	0x3ffa5503b23e255d
	.quad	0x3ffa674a8af46052
	.quad	0x3ffa799e1330b358
	.quad	0x3ffa8bfe53c12e59
	.quad	0x3ffa9e6b5579fdbf
	.quad	0x3ffab0e521356eba
	.quad	0x3ffac36bbfd3f37a
	.quad	0x3ffad5ff3a3c2774
	.quad	0x3ffae89f995ad3ad
	.quad	0x3ffafb4ce622f2ff
	.quad	0x3ffb0e07298db666
	.quad	0x3ffb20ce6c9a8952
	.quad	0x3ffb33a2b84f15fb
	.quad	0x3ffb468415b749b1
	.quad	0x3ffb59728de5593a
	.quad	0x3ffb6c6e29f1c52a
	.quad	0x3ffb7f76f2fb5e47
	.quad	0x3ffb928cf22749e4
	.quad	0x3ffba5b030a1064a
	.quad	0x3ffbb8e0b79a6f1f
	.quad	0x3ffbcc1e904bc1d2
	.quad	0x3ffbdf69c3f3a207
	.quad	0x3ffbf2c25bd71e09
	.quad	0x3ffc06286141b33d
	.quad	0x3ffc199bdd85529c
	.quad	0x3ffc2d1cd9fa652c
	.quad	0x3ffc40ab5fffd07a
	.quad	0x3ffc544778fafb22
	.quad	0x3ffc67f12e57d14b
	.quad	0x3ffc7ba88988c933
	.quad	0x3ffc8f6d9406e7b5
	.quad	0x3ffca3405751c4db
	.quad	0x3ffcb720dcef9069
	.quad	0x3ffccb0f2e6d1675
	.quad	0x3ffcdf0b555dc3fa
	.quad	0x3ffcf3155b5bab74
	.quad	0x3ffd072d4a07897c
	.quad	0x3ffd1b532b08c968
	.quad	0x3ffd2f87080d89f2
	.quad	0x3ffd43c8eacaa1d6
	.quad	0x3ffd5818dcfba487
	.quad	0x3ffd6c76e862e6d3
	.quad	0x3ffd80e316c98398
	.quad	0x3ffd955d71ff6075
	.quad	0x3ffda9e603db3285
	.quad	0x3ffdbe7cd63a8315
	.quad	0x3ffdd321f301b460
	.quad	0x3ffde7d5641c0658
	.quad	0x3ffdfc97337b9b5f
	.quad	0x3ffe11676b197d17
	.quad	0x3ffe264614f5a129
	.quad	0x3ffe3b333b16ee12
	.quad	0x3ffe502ee78b3ff6
	.quad	0x3ffe653924676d76
	.quad	0x3ffe7a51fbc74c83
	.quad	0x3ffe8f7977cdb740
	.quad	0x3ffea4afa2a490da
	.quad	0x3ffeb9f4867cca6e
	.quad	0x3ffecf482d8e67f1
	.quad	0x3ffee4aaa2188510
	.quad	0x3ffefa1bee615a27
	.quad	0x3fff0f9c1cb6412a
	.quad	0x3fff252b376bba97
	.quad	0x3fff3ac948dd7274
	.quad	0x3fff50765b6e4540
	.quad	0x3fff6632798844f8
	.quad	0x3fff7bfdad9cbe14
	.quad	0x3fff91d802243c89
	.quad	0x3fffa7c1819e90d8
	.quad	0x3fffbdba3692d514
	.quad	0x3fffd3c22b8f71f1
	.quad	0x3fffe9d96b2a23d9

/* General purpose constants:
 * hsw_dMantMask */
double_vector _hsw_dMantMask 0x000fffffffffffff

/* hsw_dOne */
double_vector _hsw_dOne 0x3ff0000000000000

/* hsw_dCvtMask */
double_vector _hsw_dCvtMask 0x4338000000000000

/* hsw_dMinNorm */
double_vector _hsw_dMinNorm 0x0010000000000000

/* hsw_dMaxNorm */
double_vector _hsw_dMaxNorm 0x7fefffffffffffff

/* hsw_lRndBit */
double_vector _hsw_lRndBit 0x0000040000000000

/* hsw_lRndMask */
double_vector _hsw_lRndMask 0xfffff80000000000

/* Log polynomial:
 * hsw_dc6 */
double_vector _hsw_dc6 0xbfcec1cfbbc5c90c

/* hsw_dc5 */
double_vector _hsw_dc5 0x3fd2776da3d26e6a

/* hsw_dc4 */
double_vector _hsw_dc4 0xbfd71547655d37e0

/* hsw_dc3 */
double_vector _hsw_dc3 0x3fdec709dc39fb02

/* hsw_dc1 */
double_vector _hsw_dc1 0x3c777a3a2c24613d

/* hsw_dc1h */
double_vector _hsw_dc1h 0x3ff71547652b82fe

/* hsw_dc2 */
double_vector _hsw_dc2 0xbfe71547652b82fe

/* Additional constants:
 * hsw_AbsMask */
double_vector _hsw_dAbsMask 0x7fffffffffffffff

/* hsw_dDomainRange */
double_vector _hsw_dDomainRange 0x408fec0000000000

/* hsw_dShifter */
double_vector _hsw_dShifter 0x42b800000003ff00

/* hsw_dIndexMask */
double_vector _hsw_dIndexMask 0x00000000000007f8

/* Exp polynomial:
 * hsw_dce4 */
double_vector _hsw_dce4 0x3f83b2ab930f15f9

/* hsw_dce3 */
double_vector _hsw_dce3 0x3fac6b090da1e0a9

/* hsw_dce2 */
double_vector _hsw_dce2 0x3fcebfbdff82c54d

/* hsw_dce1 */
double_vector _hsw_dce1 0x3fe62e42fefa39b9

/* Reciprocal lookup table for log part (non HSW): */
.if .-__svml_dpow_data != _rcp_t1
.err
.endif
	.quad	0x3ff7154740000000
	.quad	0x3ff70f8340000000
	.quad	0x3ff709c240000000
	.quad	0x3ff7040440000000
	.quad	0x3ff6fe4900000000
	.quad	0x3ff6f89080000000
	.quad	0x3ff6f2db00000000
	.quad	0x3ff6ed2840000000
	.quad	0x3ff6e77840000000
	.quad	0x3ff6e1cb40000000
	.quad	0x3ff6dc2100000000
	.quad	0x3ff6d67980000000
	.quad	0x3ff6d0d4c0000000
	.quad	0x3ff6cb32c0000000
	.quad	0x3ff6c593c0000000
	.quad	0x3ff6bff780000000
	.quad	0x3ff6ba5dc0000000
	.quad	0x3ff6b4c700000000
	.quad	0x3ff6af32c0000000
	.quad	0x3ff6a9a180000000
	.quad	0x3ff6a41300000000
	.quad	0x3ff69e8700000000
	.quad	0x3ff698fdc0000000
	.quad	0x3ff6937740000000
	.quad	0x3ff68df380000000
	.quad	0x3ff6887280000000
	.quad	0x3ff682f400000000
	.quad	0x3ff67d7840000000
	.quad	0x3ff677ff40000000
	.quad	0x3ff67288c0000000
	.quad	0x3ff66d1540000000
	.quad	0x3ff667a400000000
	.quad	0x3ff6623580000000
	.quad	0x3ff65cc9c0000000
	.quad	0x3ff6576080000000
	.quad	0x3ff651fa00000000
	.quad	0x3ff64c9600000000
	.quad	0x3ff6473480000000
	.quad	0x3ff641d5c0000000
	.quad	0x3ff63c7980000000
	.quad	0x3ff6372000000000
	.quad	0x3ff631c900000000
	.quad	0x3ff62c7480000000
	.quad	0x3ff6272280000000
	.quad	0x3ff621d340000000
	.quad	0x3ff61c8640000000
	.quad	0x3ff6173c00000000
	.quad	0x3ff611f440000000
	.quad	0x3ff60caf00000000
	.quad	0x3ff6076c40000000
	.quad	0x3ff6022c00000000
	.quad	0x3ff5fcee80000000
	.quad	0x3ff5f7b340000000
	.quad	0x3ff5f27a80000000
	.quad	0x3ff5ed4440000000
	.quad	0x3ff5e81040000000
	.quad	0x3ff5e2df00000000
	.quad	0x3ff5ddb040000000
	.quad	0x3ff5d883c0000000
	.quad	0x3ff5d359c0000000
	.quad	0x3ff5ce3240000000
	.quad	0x3ff5c90d40000000
	.quad	0x3ff5c3ea80000000
	.quad	0x3ff5beca40000000
	.quad	0x3ff5b9ac80000000
	.quad	0x3ff5b49100000000
	.quad	0x3ff5af7800000000
	.quad	0x3ff5aa6180000000
	.quad	0x3ff5a54d40000000
	.quad	0x3ff5a03b40000000
	.quad	0x3ff59b2bc0000000
	.quad	0x3ff5961ec0000000
	.quad	0x3ff59113c0000000
	.quad	0x3ff58c0b80000000
	.quad	0x3ff5870540000000
	.quad	0x3ff58201c0000000
	.quad	0x3ff57d0040000000
	.quad	0x3ff5780140000000
	.quad	0x3ff5730480000000
	.quad	0x3ff56e0a00000000
	.quad	0x3ff56911c0000000
	.quad	0x3ff5641c00000000
	.quad	0x3ff55f2880000000
	.quad	0x3ff55a3740000000
	.quad	0x3ff5554840000000
	.quad	0x3ff5505bc0000000
	.quad	0x3ff54b7140000000
	.quad	0x3ff5468900000000
	.quad	0x3ff541a340000000
	.quad	0x3ff53cbf80000000
	.quad	0x3ff537de40000000
	.quad	0x3ff532ff00000000
	.quad	0x3ff52e2240000000
	.quad	0x3ff5294780000000
	.quad	0x3ff5246f00000000
	.quad	0x3ff51f98c0000000
	.quad	0x3ff51ac4c0000000
	.quad	0x3ff515f300000000
	.quad	0x3ff5112340000000
	.quad	0x3ff50c5600000000
	.quad	0x3ff5078ac0000000
	.quad	0x3ff502c1c0000000
	.quad	0x3ff4fdfac0000000
	.quad	0x3ff4f93600000000
	.quad	0x3ff4f47380000000
	.quad	0x3ff4efb340000000
	.quad	0x3ff4eaf500000000
	.quad	0x3ff4e638c0000000
	.quad	0x3ff4e17ec0000000
	.quad	0x3ff4dcc700000000
	.quad	0x3ff4d81180000000
	.quad	0x3ff4d35dc0000000
	.quad	0x3ff4ceac80000000
	.quad	0x3ff4c9fd00000000
	.quad	0x3ff4c54fc0000000
	.quad	0x3ff4c0a4c0000000
	.quad	0x3ff4bbfbc0000000
	.quad	0x3ff4b754c0000000
	.quad	0x3ff4b2b000000000
	.quad	0x3ff4ae0d40000000
	.quad	0x3ff4a96c80000000
	.quad	0x3ff4a4ce00000000
	.quad	0x3ff4a03140000000
	.quad	0x3ff49b9700000000
	.quad	0x3ff496fe80000000
	.quad	0x3ff4926800000000
	.quad	0x3ff48dd3c0000000
	.quad	0x3ff4894180000000
	.quad	0x3ff484b100000000
	.quad	0x3ff48022c0000000
	.quad	0x3ff47b96c0000000
	.quad	0x3ff4770c80000000
	.quad	0x3ff4728440000000
	.quad	0x3ff46dfe00000000
	.quad	0x3ff46979c0000000
	.quad	0x3ff464f780000000
	.quad	0x3ff4607780000000
	.quad	0x3ff45bf940000000
	.quad	0x3ff4577d00000000
	.quad	0x3ff45302c0000000
	.quad	0x3ff44e8a40000000
	.quad	0x3ff44a1400000000
	.quad	0x3ff4459f80000000
	.quad	0x3ff4412d40000000
	.quad	0x3ff43cbcc0000000
	.quad	0x3ff4384e40000000
	.quad	0x3ff433e180000000
	.quad	0x3ff42f7700000000
	.quad	0x3ff42b0e40000000
	.quad	0x3ff426a780000000
	.quad	0x3ff4224280000000
	.quad	0x3ff41ddf80000000
	.quad	0x3ff4197e80000000
	.quad	0x3ff4151f40000000
	.quad	0x3ff410c200000000
	.quad	0x3ff40c66c0000000
	.quad	0x3ff4080d40000000
	.quad	0x3ff403b5c0000000
	.quad	0x3ff3ff6000000000
	.quad	0x3ff3fb0c00000000
	.quad	0x3ff3f6ba40000000
	.quad	0x3ff3f26a00000000
	.quad	0x3ff3ee1bc0000000
	.quad	0x3ff3e9cf80000000
	.quad	0x3ff3e58500000000
	.quad	0x3ff3e13c40000000
	.quad	0x3ff3dcf580000000
	.quad	0x3ff3d8b080000000
	.quad	0x3ff3d46d40000000
	.quad	0x3ff3d02c00000000
	.quad	0x3ff3cbec80000000
	.quad	0x3ff3c7aec0000000
	.quad	0x3ff3c37300000000
	.quad	0x3ff3bf3900000000
	.quad	0x3ff3bb00c0000000
	.quad	0x3ff3b6ca40000000
	.quad	0x3ff3b29580000000
	.quad	0x3ff3ae62c0000000
	.quad	0x3ff3aa3180000000
	.quad	0x3ff3a60240000000
	.quad	0x3ff3a1d4c0000000
	.quad	0x3ff39da900000000
	.quad	0x3ff3997f40000000
	.quad	0x3ff3955700000000
	.quad	0x3ff3913080000000
	.quad	0x3ff38d0bc0000000
	.quad	0x3ff388e900000000
	.quad	0x3ff384c7c0000000
	.quad	0x3ff380a840000000
	.quad	0x3ff37c8ac0000000
	.quad	0x3ff3786ec0000000
	.quad	0x3ff3745480000000
	.quad	0x3ff3703c00000000
	.quad	0x3ff36c2540000000
	.quad	0x3ff3681040000000
	.quad	0x3ff363fcc0000000
	.quad	0x3ff35feb40000000
	.quad	0x3ff35bdb40000000
	.quad	0x3ff357cd00000000
	.quad	0x3ff353c080000000
	.quad	0x3ff34fb5c0000000
	.quad	0x3ff34bac80000000
	.quad	0x3ff347a540000000
	.quad	0x3ff3439f80000000
	.quad	0x3ff33f9b40000000
	.quad	0x3ff33b9900000000
	.quad	0x3ff3379840000000
	.quad	0x3ff3339900000000
	.quad	0x3ff32f9bc0000000
	.quad	0x3ff32b9fc0000000
	.quad	0x3ff327a5c0000000
	.quad	0x3ff323ad40000000
	.quad	0x3ff31fb680000000
	.quad	0x3ff31bc140000000
	.quad	0x3ff317cdc0000000
	.quad	0x3ff313dbc0000000
	.quad	0x3ff30feb80000000
	.quad	0x3ff30bfd00000000
	.quad	0x3ff3080fc0000000
	.quad	0x3ff3042480000000
	.quad	0x3ff3003ac0000000
	.quad	0x3ff2fc5280000000
	.quad	0x3ff2f86bc0000000
	.quad	0x3ff2f48700000000
	.quad	0x3ff2f0a380000000
	.quad	0x3ff2ecc1c0000000
	.quad	0x3ff2e8e180000000
	.quad	0x3ff2e502c0000000
	.quad	0x3ff2e125c0000000
	.quad	0x3ff2dd4a40000000
	.quad	0x3ff2d97080000000
	.quad	0x3ff2d59840000000
	.quad	0x3ff2d1c180000000
	.quad	0x3ff2cdec40000000
	.quad	0x3ff2ca1880000000
	.quad	0x3ff2c64680000000
	.quad	0x3ff2c27600000000
	.quad	0x3ff2bea700000000
	.quad	0x3ff2bad9c0000000
	.quad	0x3ff2b70dc0000000
	.quad	0x3ff2b34380000000
	.quad	0x3ff2af7ac0000000
	.quad	0x3ff2abb340000000
	.quad	0x3ff2a7ed80000000
	.quad	0x3ff2a42980000000
	.quad	0x3ff2a066c0000000
	.quad	0x3ff29ca580000000
	.quad	0x3ff298e5c0000000
	.quad	0x3ff29527c0000000
	.quad	0x3ff2916b00000000
	.quad	0x3ff28dafc0000000
	.quad	0x3ff289f640000000
	.quad	0x3ff2863e00000000
	.quad	0x3ff2828740000000
	.quad	0x3ff27ed240000000
	.quad	0x3ff27b1e80000000
	.quad	0x3ff2776c40000000
	.quad	0x3ff273bb80000000
	.quad	0x3ff2700c40000000
	.quad	0x3ff26c5e80000000
	.quad	0x3ff268b200000000
	.quad	0x3ff2650740000000
	.quad	0x3ff2615dc0000000
	.quad	0x3ff25db5c0000000
	.quad	0x3ff25a0f40000000
	.quad	0x3ff2566a40000000
	.quad	0x3ff252c6c0000000
	.quad	0x3ff24f2480000000
	.quad	0x3ff24b83c0000000
	.quad	0x3ff247e480000000
	.quad	0x3ff24446c0000000
	.quad	0x3ff240aa40000000
	.quad	0x3ff23d0f40000000
	.quad	0x3ff23975c0000000
	.quad	0x3ff235dd80000000
	.quad	0x3ff23246c0000000
	.quad	0x3ff22eb180000000
	.quad	0x3ff22b1d80000000
	.quad	0x3ff2278b00000000
	.quad	0x3ff223fa00000000
	.quad	0x3ff2206a40000000
	.quad	0x3ff21cdc00000000
	.quad	0x3ff2194f00000000
	.quad	0x3ff215c380000000
	.quad	0x3ff2123940000000
	.quad	0x3ff20eb080000000
	.quad	0x3ff20b2940000000
	.quad	0x3ff207a340000000
	.quad	0x3ff2041ec0000000
	.quad	0x3ff2009b80000000
	.quad	0x3ff1fd1980000000
	.quad	0x3ff1f99900000000
	.quad	0x3ff1f619c0000000
	.quad	0x3ff1f29c00000000
	.quad	0x3ff1ef1fc0000000
	.quad	0x3ff1eba480000000
	.quad	0x3ff1e82ac0000000
	.quad	0x3ff1e4b280000000
	.quad	0x3ff1e13b80000000
	.quad	0x3ff1ddc5c0000000
	.quad	0x3ff1da5180000000
	.quad	0x3ff1d6de80000000
	.quad	0x3ff1d36cc0000000
	.quad	0x3ff1cffc40000000
	.quad	0x3ff1cc8d40000000
	.quad	0x3ff1c91f80000000
	.quad	0x3ff1c5b340000000
	.quad	0x3ff1c24840000000
	.quad	0x3ff1bede40000000
	.quad	0x3ff1bb7600000000
	.quad	0x3ff1b80ec0000000
	.quad	0x3ff1b4a900000000
	.quad	0x3ff1b14480000000
	.quad	0x3ff1ade140000000
	.quad	0x3ff1aa7f40000000
	.quad	0x3ff1a71e80000000
	.quad	0x3ff1a3bf40000000
	.quad	0x3ff1a06140000000
	.quad	0x3ff19d0480000000
	.quad	0x3ff199a900000000
	.quad	0x3ff1964ec0000000
	.quad	0x3ff192f5c0000000
	.quad	0x3ff18f9e00000000
	.quad	0x3ff18c47c0000000
	.quad	0x3ff188f280000000
	.quad	0x3ff1859ec0000000
	.quad	0x3ff1824c00000000
	.quad	0x3ff17efac0000000
	.quad	0x3ff17baa80000000
	.quad	0x3ff1785bc0000000
	.quad	0x3ff1750e40000000
	.quad	0x3ff171c1c0000000
	.quad	0x3ff16e76c0000000
	.quad	0x3ff16b2d00000000
	.quad	0x3ff167e440000000
	.quad	0x3ff1649d00000000
	.quad	0x3ff16156c0000000
	.quad	0x3ff15e11c0000000
	.quad	0x3ff15ace40000000
	.quad	0x3ff1578bc0000000
	.quad	0x3ff1544a80000000
	.quad	0x3ff1510a80000000
	.quad	0x3ff14dcbc0000000
	.quad	0x3ff14a8e40000000
	.quad	0x3ff14751c0000000
	.quad	0x3ff14416c0000000
	.quad	0x3ff140dcc0000000
	.quad	0x3ff13da400000000
	.quad	0x3ff13a6c80000000
	.quad	0x3ff1373600000000
	.quad	0x3ff1340100000000
	.quad	0x3ff130cd00000000
	.quad	0x3ff12d9a40000000
	.quad	0x3ff12a68c0000000
	.quad	0x3ff1273840000000
	.quad	0x3ff1240900000000
	.quad	0x3ff120db00000000
	.quad	0x3ff11dae40000000
	.quad	0x3ff11a8280000000
	.quad	0x3ff1175800000000
	.quad	0x3ff1142ec0000000
	.quad	0x3ff11106c0000000
	.quad	0x3ff10ddfc0000000
	.quad	0x3ff10ab9c0000000
	.quad	0x3ff1079540000000
	.quad	0x3ff10471c0000000
	.quad	0x3ff1014f80000000
	.quad	0x3ff0fe2e40000000
	.quad	0x3ff0fb0e40000000
	.quad	0x3ff0f7ef40000000
	.quad	0x3ff0f4d180000000
	.quad	0x3ff0f1b500000000
	.quad	0x3ff0ee9980000000
	.quad	0x3ff0eb7f40000000
	.quad	0x3ff0e86600000000
	.quad	0x3ff0e54e00000000
	.quad	0x3ff0e23700000000
	.quad	0x3ff0df2140000000
	.quad	0x3ff0dc0c80000000
	.quad	0x3ff0d8f900000000
	.quad	0x3ff0d5e6c0000000
	.quad	0x3ff0d2d540000000
	.quad	0x3ff0cfc540000000
	.quad	0x3ff0ccb640000000
	.quad	0x3ff0c9a840000000
	.quad	0x3ff0c69b40000000
	.quad	0x3ff0c38f80000000
	.quad	0x3ff0c08500000000
	.quad	0x3ff0bd7b80000000
	.quad	0x3ff0ba7300000000
	.quad	0x3ff0b76bc0000000
	.quad	0x3ff0b46580000000
	.quad	0x3ff0b16040000000
	.quad	0x3ff0ae5c40000000
	.quad	0x3ff0ab5940000000
	.quad	0x3ff0a85780000000
	.quad	0x3ff0a556c0000000
	.quad	0x3ff0a25700000000
	.quad	0x3ff09f5880000000
	.quad	0x3ff09c5ac0000000
	.quad	0x3ff0995e80000000
	.quad	0x3ff0966300000000
	.quad	0x3ff09368c0000000
	.quad	0x3ff0906f80000000
	.quad	0x3ff08d7740000000
	.quad	0x3ff08a8000000000
	.quad	0x3ff0878a00000000
	.quad	0x3ff0849500000000
	.quad	0x3ff081a100000000
	.quad	0x3ff07eae40000000
	.quad	0x3ff07bbc40000000
	.quad	0x3ff078cb80000000
	.quad	0x3ff075dbc0000000
	.quad	0x3ff072ed00000000
	.quad	0x3ff06fff80000000
	.quad	0x3ff06d12c0000000
	.quad	0x3ff06a2740000000
	.quad	0x3ff0673cc0000000
	.quad	0x3ff0645340000000
	.quad	0x3ff0616ac0000000
	.quad	0x3ff05e8340000000
	.quad	0x3ff05b9d00000000
	.quad	0x3ff058b780000000
	.quad	0x3ff055d340000000
	.quad	0x3ff052f000000000
	.quad	0x3ff0500d80000000
	.quad	0x3ff04d2c40000000
	.quad	0x3ff04a4c00000000
	.quad	0x3ff0476cc0000000
	.quad	0x3ff0448e80000000
	.quad	0x3ff041b140000000
	.quad	0x3ff03ed500000000
	.quad	0x3ff03bf9c0000000
	.quad	0x3ff0391fc0000000
	.quad	0x3ff0364680000000
	.quad	0x3ff0336e40000000
	.quad	0x3ff0309700000000
	.quad	0x3ff02dc0c0000000
	.quad	0x3ff02aeb80000000
	.quad	0x3ff0281740000000
	.quad	0x3ff0254400000000
	.quad	0x3ff02271c0000000
	.quad	0x3ff01fa080000000
	.quad	0x3ff01cd040000000
	.quad	0x3ff01a00c0000000
	.quad	0x3ff0173280000000
	.quad	0x3ff0146540000000
	.quad	0x3ff01198c0000000
	.quad	0x3ff00ecd80000000
	.quad	0x3ff00c0300000000
	.quad	0x3ff0093980000000
	.quad	0x3ff0067100000000
	.quad	0x3ff003a980000000
	.quad	0x3ff000e300000000
	.quad	0x3feffc3a80000000
	.quad	0x3feff6b140000000
	.quad	0x3feff129c0000000
	.quad	0x3fefeba480000000
	.quad	0x3fefe620c0000000
	.quad	0x3fefe09f40000000
	.quad	0x3fefdb1f80000000
	.quad	0x3fefd5a180000000
	.quad	0x3fefd02580000000
	.quad	0x3fefcaab80000000
	.quad	0x3fefc53340000000
	.quad	0x3fefbfbd00000000
	.quad	0x3fefba4880000000
	.quad	0x3fefb4d600000000
	.quad	0x3fefaf6540000000
	.quad	0x3fefa9f680000000
	.quad	0x3fefa48980000000
	.quad	0x3fef9f1e40000000
	.quad	0x3fef99b500000000
	.quad	0x3fef944dc0000000
	.quad	0x3fef8ee800000000
	.quad	0x3fef898440000000
	.quad	0x3fef842280000000
	.quad	0x3fef7ec280000000
	.quad	0x3fef796440000000
	.quad	0x3fef7407c0000000
	.quad	0x3fef6ead40000000
	.quad	0x3fef695480000000
	.quad	0x3fef63fd80000000
	.quad	0x3fef5ea880000000
	.quad	0x3fef595540000000
	.quad	0x3fef5403c0000000
	.quad	0x3fef4eb400000000
	.quad	0x3fef496640000000
	.quad	0x3fef441a00000000
	.quad	0x3fef3ecfc0000000
	.quad	0x3fef398740000000
	.quad	0x3fef344080000000
	.quad	0x3fef2efb80000000
	.quad	0x3fef29b880000000
	.quad	0x3fef247700000000
	.quad	0x3fef1f3780000000
	.quad	0x3fef19f980000000
	.quad	0x3fef14bd80000000
	.quad	0x3fef0f8340000000
	.quad	0x3fef0a4ac0000000
	.quad	0x3fef0513c0000000
	.quad	0x3feeffdec0000000
	.quad	0x3feefaab80000000
	.quad	0x3feef57a00000000
	.quad	0x3feef04a00000000
	.quad	0x3feeeb1c00000000
	.quad	0x3feee5ef80000000
	.quad	0x3feee0c500000000
	.quad	0x3feedb9c00000000
	.quad	0x3feed67500000000
	.quad	0x3feed14f80000000
	.quad	0x3feecc2bc0000000
	.quad	0x3feec709c0000000
	.quad	0x3feec1e940000000
	.quad	0x3feebccac0000000
	.quad	0x3feeb7adc0000000
	.quad	0x3feeb29280000000
	.quad	0x3feead7900000000
	.quad	0x3feea86140000000
	.quad	0x3feea34b40000000
	.quad	0x3fee9e36c0000000
	.quad	0x3fee992400000000
	.quad	0x3fee941300000000
	.quad	0x3fee8f0380000000
	.quad	0x3fee89f5c0000000
	.quad	0x3fee84e9c0000000
	.quad	0x3fee7fdf40000000
	.quad	0x3fee7ad680000000
	.quad	0x3fee75cf80000000
	.quad	0x3fee70ca00000000
	.quad	0x3fee6bc640000000
	.quad	0x3fee66c440000000
	.quad	0x3fee61c3c0000000
	.quad	0x3fee5cc500000000
	.quad	0x3fee57c7c0000000
	.quad	0x3fee52cc40000000
	.quad	0x3fee4dd280000000
	.quad	0x3fee48da00000000
	.quad	0x3fee43e380000000
	.quad	0x3fee3eee80000000
	.quad	0x3fee39fb00000000
	.quad	0x3fee350940000000
	.quad	0x3fee301940000000
	.quad	0x3fee2b2ac0000000
	.quad	0x3fee263dc0000000
	.quad	0x3fee215280000000
	.quad	0x3fee1c68c0000000
	.quad	0x3fee178080000000
	.quad	0x3fee129a00000000
	.quad	0x3fee0db540000000
	.quad	0x3fee08d1c0000000
	.quad	0x3fee03f000000000
	.quad	0x3fedff1000000000
	.quad	0x3fedfa3140000000
	.quad	0x3fedf55440000000
	.quad	0x3fedf07900000000
	.quad	0x3fedeb9f00000000
	.quad	0x3fede6c6c0000000
	.quad	0x3fede1f040000000
	.quad	0x3feddd1b00000000
	.quad	0x3fedd84780000000
	.quad	0x3fedd37580000000
	.quad	0x3fedcea500000000
	.quad	0x3fedc9d600000000
	.quad	0x3fedc508c0000000
	.quad	0x3fedc03d00000000
	.quad	0x3fedbb72c0000000
	.quad	0x3fedb6aa00000000
	.quad	0x3fedb1e2c0000000
	.quad	0x3fedad1d00000000
	.quad	0x3feda85900000000
	.quad	0x3feda39680000000
	.quad	0x3fed9ed540000000
	.quad	0x3fed9a15c0000000
	.quad	0x3fed9557c0000000
	.quad	0x3fed909b40000000
	.quad	0x3fed8be040000000
	.quad	0x3fed8726c0000000
	.quad	0x3fed826f00000000
	.quad	0x3fed7db880000000
	.quad	0x3fed790380000000
	.quad	0x3fed745000000000
	.quad	0x3fed6f9e40000000
	.quad	0x3fed6aedc0000000
	.quad	0x3fed663ec0000000
	.quad	0x3fed619140000000
	.quad	0x3fed5ce540000000
	.quad	0x3fed583ac0000000
	.quad	0x3fed5391c0000000
	.quad	0x3fed4eea40000000
	.quad	0x3fed4a4440000000
	.quad	0x3fed459f80000000
	.quad	0x3fed40fc80000000
	.quad	0x3fed3c5ac0000000
	.quad	0x3fed37bac0000000
	.quad	0x3fed331c00000000
	.quad	0x3fed2e7ec0000000
	.quad	0x3fed29e300000000
	.quad	0x3fed254880000000
	.quad	0x3fed20afc0000000
	.quad	0x3fed1c1840000000
	.quad	0x3fed178240000000
	.quad	0x3fed12edc0000000
	.quad	0x3fed0e5ac0000000
	.quad	0x3fed09c900000000
	.quad	0x3fed0538c0000000
	.quad	0x3fed00aa00000000
	.quad	0x3fecfc1c80000000
	.quad	0x3fecf790c0000000
	.quad	0x3fecf30600000000
	.quad	0x3fecee7d00000000
	.quad	0x3fece9f540000000
	.quad	0x3fece56f00000000
	.quad	0x3fece0ea40000000
	.quad	0x3fecdc66c0000000
	.quad	0x3fecd7e4c0000000
	.quad	0x3fecd36440000000
	.quad	0x3feccee500000000
	.quad	0x3fecca6740000000
	.quad	0x3fecc5eac0000000
	.quad	0x3fecc16fc0000000
	.quad	0x3fecbcf640000000
	.quad	0x3fecb87e00000000
	.quad	0x3fecb40740000000
	.quad	0x3fecaf91c0000000
	.quad	0x3fecab1dc0000000
	.quad	0x3feca6ab00000000
	.quad	0x3feca239c0000000
	.quad	0x3fec9dc9c0000000
	.quad	0x3fec995b40000000
	.quad	0x3fec94ee00000000
	.quad	0x3fec908240000000
	.quad	0x3fec8c17c0000000
	.quad	0x3fec87aec0000000
	.quad	0x3fec834700000000
	.quad	0x3fec7ee0c0000000
	.quad	0x3fec7a7bc0000000
	.quad	0x3fec761800000000
	.quad	0x3fec71b5c0000000
	.quad	0x3fec6d54c0000000
	.quad	0x3fec68f540000000
	.quad	0x3fec649700000000
	.quad	0x3fec603a00000000
	.quad	0x3fec5bde80000000
	.quad	0x3fec578440000000
	.quad	0x3fec532b80000000
	.quad	0x3fec4ed3c0000000
	.quad	0x3fec4a7dc0000000
	.quad	0x3fec4628c0000000
	.quad	0x3fec41d540000000
	.quad	0x3fec3d8300000000
	.quad	0x3fec393200000000
	.quad	0x3fec34e240000000
	.quad	0x3fec309400000000
	.quad	0x3fec2c4700000000
	.quad	0x3fec27fb80000000
	.quad	0x3fec23b100000000
	.quad	0x3fec1f6800000000
	.quad	0x3fec1b2040000000
	.quad	0x3fec16d9c0000000
	.quad	0x3fec1294c0000000
	.quad	0x3fec0e50c0000000
	.quad	0x3fec0a0e40000000
	.quad	0x3fec05cd00000000
	.quad	0x3fec018d00000000
	.quad	0x3febfd4e40000000
	.quad	0x3febf91100000000
	.quad	0x3febf4d4c0000000
	.quad	0x3febf09a00000000
	.quad	0x3febec6080000000
	.quad	0x3febe82840000000
	.quad	0x3febe3f140000000
	.quad	0x3febdfbb80000000
	.quad	0x3febdb8700000000
	.quad	0x3febd753c0000000
	.quad	0x3febd32200000000
	.quad	0x3febcef140000000
	.quad	0x3febcac1c0000000
	.quad	0x3febc693c0000000
	.quad	0x3febc266c0000000
	.quad	0x3febbe3b40000000
	.quad	0x3febba10c0000000
	.quad	0x3febb5e7c0000000
	.quad	0x3febb1bfc0000000
	.quad	0x3febad9940000000
	.quad	0x3feba973c0000000
	.quad	0x3feba54fc0000000
	.quad	0x3feba12cc0000000
	.quad	0x3feb9d0b00000000
	.quad	0x3feb98eac0000000
	.quad	0x3feb94cb80000000
	.quad	0x3feb90ad80000000
	.quad	0x3feb8c90c0000000
	.quad	0x3feb887540000000
	.quad	0x3feb845b00000000
	.quad	0x3feb8041c0000000
	.quad	0x3feb7c2a00000000
	.quad	0x3feb781340000000
	.quad	0x3feb73fe00000000
	.quad	0x3feb6fe9c0000000
	.quad	0x3feb6bd6c0000000
	.quad	0x3feb67c500000000
	.quad	0x3feb63b440000000
	.quad	0x3feb5fa500000000
	.quad	0x3feb5b96c0000000
	.quad	0x3feb5789c0000000
	.quad	0x3feb537e00000000
	.quad	0x3feb4f7380000000
	.quad	0x3feb4b6a00000000
	.quad	0x3feb476200000000
	.quad	0x3feb435b00000000
	.quad	0x3feb3f5540000000
	.quad	0x3feb3b5080000000
	.quad	0x3feb374d00000000
	.quad	0x3feb334ac0000000
	.quad	0x3feb2f49c0000000
	.quad	0x3feb2b49c0000000
	.quad	0x3feb274b40000000
	.quad	0x3feb234d80000000
	.quad	0x3feb1f5140000000
	.quad	0x3feb1b5600000000
	.quad	0x3feb175c00000000
	.quad	0x3feb136300000000
	.quad	0x3feb0f6b80000000
	.quad	0x3feb0b74c0000000
	.quad	0x3feb077f80000000
	.quad	0x3feb038b40000000
	.quad	0x3feaff9840000000
	.quad	0x3feafba640000000
	.quad	0x3feaf7b580000000
	.quad	0x3feaf3c600000000
	.quad	0x3feaefd780000000
	.quad	0x3feaebea40000000
	.quad	0x3feae7fe00000000
	.quad	0x3feae41300000000
	.quad	0x3feae02900000000
	.quad	0x3feadc4040000000
	.quad	0x3fead858c0000000
	.quad	0x3fead47240000000
	.quad	0x3fead08cc0000000
	.quad	0x3feacca8c0000000
	.quad	0x3feac8c580000000
	.quad	0x3feac4e380000000
	.quad	0x3feac102c0000000
	.quad	0x3feabd2300000000
	.quad	0x3feab94480000000
	.quad	0x3feab56700000000
	.quad	0x3feab18a80000000
	.quad	0x3feaadaf80000000
	.quad	0x3feaa9d540000000
	.quad	0x3feaa5fc40000000
	.quad	0x3feaa22440000000
	.quad	0x3fea9e4d80000000
	.quad	0x3fea9a77c0000000
	.quad	0x3fea96a340000000
	.quad	0x3fea92cfc0000000
	.quad	0x3fea8efd80000000
	.quad	0x3fea8b2c40000000
	.quad	0x3fea875c00000000
	.quad	0x3fea838cc0000000
	.quad	0x3fea7fbec0000000
	.quad	0x3fea7bf200000000
	.quad	0x3fea782640000000
	.quad	0x3fea745b80000000
	.quad	0x3fea7091c0000000
	.quad	0x3fea6cc940000000
	.quad	0x3fea6901c0000000
	.quad	0x3fea653b40000000
	.quad	0x3fea617600000000
	.quad	0x3fea5db1c0000000
	.quad	0x3fea59ee80000000
	.quad	0x3fea562c80000000
	.quad	0x3fea526b80000000
	.quad	0x3fea4eab80000000
	.quad	0x3fea4aecc0000000
	.quad	0x3fea472ec0000000
	.quad	0x3fea437200000000
	.quad	0x3fea3fb640000000
	.quad	0x3fea3bfbc0000000
	.quad	0x3fea384240000000
	.quad	0x3fea3489c0000000
	.quad	0x3fea30d240000000
	.quad	0x3fea2d1bc0000000
	.quad	0x3fea296680000000
	.quad	0x3fea25b200000000
	.quad	0x3fea21fec0000000
	.quad	0x3fea1e4cc0000000
	.quad	0x3fea1a9b80000000
	.quad	0x3fea16eb40000000
	.quad	0x3fea133c40000000
	.quad	0x3fea0f8e40000000
	.quad	0x3fea0be140000000
	.quad	0x3fea083540000000
	.quad	0x3fea048a40000000
	.quad	0x3fea00e080000000
	.quad	0x3fe9fd3780000000
	.quad	0x3fe9f98fc0000000
	.quad	0x3fe9f5e900000000
	.quad	0x3fe9f24340000000
	.quad	0x3fe9ee9e80000000
	.quad	0x3fe9eafac0000000
	.quad	0x3fe9e75800000000
	.quad	0x3fe9e3b640000000
	.quad	0x3fe9e01580000000
	.quad	0x3fe9dc7600000000
	.quad	0x3fe9d8d740000000
	.quad	0x3fe9d539c0000000
	.quad	0x3fe9d19d00000000
	.quad	0x3fe9ce0180000000
	.quad	0x3fe9ca66c0000000
	.quad	0x3fe9c6cd40000000
	.quad	0x3fe9c33480000000
	.quad	0x3fe9bf9d00000000
	.quad	0x3fe9bc0680000000
	.quad	0x3fe9b870c0000000
	.quad	0x3fe9b4dc40000000
	.quad	0x3fe9b148c0000000
	.quad	0x3fe9adb600000000
	.quad	0x3fe9aa2480000000
	.quad	0x3fe9a693c0000000
	.quad	0x3fe9a30440000000
	.quad	0x3fe99f7580000000
	.quad	0x3fe99be7c0000000
	.quad	0x3fe9985b40000000
	.quad	0x3fe994cf80000000
	.quad	0x3fe99144c0000000
	.quad	0x3fe98dbb00000000
	.quad	0x3fe98a3240000000
	.quad	0x3fe986aa80000000
	.quad	0x3fe98323c0000000
	.quad	0x3fe97f9e00000000
	.quad	0x3fe97c1900000000
	.quad	0x3fe9789540000000
	.quad	0x3fe9751240000000
	.quad	0x3fe9719080000000
	.quad	0x3fe96e0f80000000
	.quad	0x3fe96a8f80000000
	.quad	0x3fe9671040000000
	.quad	0x3fe9639240000000
	.quad	0x3fe9601540000000
	.quad	0x3fe95c9900000000
	.quad	0x3fe9591dc0000000
	.quad	0x3fe955a380000000
	.quad	0x3fe9522a40000000
	.quad	0x3fe94eb200000000
	.quad	0x3fe94b3a80000000
	.quad	0x3fe947c400000000
	.quad	0x3fe9444e80000000
	.quad	0x3fe940da00000000
	.quad	0x3fe93d6640000000
	.quad	0x3fe939f3c0000000
	.quad	0x3fe9368200000000
	.quad	0x3fe9331140000000
	.quad	0x3fe92fa140000000
	.quad	0x3fe92c3280000000
	.quad	0x3fe928c480000000
	.quad	0x3fe9255780000000
	.quad	0x3fe921eb40000000
	.quad	0x3fe91e8040000000
	.quad	0x3fe91b1600000000
	.quad	0x3fe917ac80000000
	.quad	0x3fe9144440000000
	.quad	0x3fe910dcc0000000
	.quad	0x3fe90d7640000000
	.quad	0x3fe90a1080000000
	.quad	0x3fe906abc0000000
	.quad	0x3fe9034800000000
	.quad	0x3fe8ffe540000000
	.quad	0x3fe8fc8340000000
	.quad	0x3fe8f92240000000
	.quad	0x3fe8f5c200000000
	.quad	0x3fe8f26300000000
	.quad	0x3fe8ef0480000000
	.quad	0x3fe8eba740000000
	.quad	0x3fe8e84ac0000000
	.quad	0x3fe8e4ef40000000
	.quad	0x3fe8e19480000000
	.quad	0x3fe8de3ac0000000
	.quad	0x3fe8dae1c0000000
	.quad	0x3fe8d78a00000000
	.quad	0x3fe8d432c0000000
	.quad	0x3fe8d0dcc0000000
	.quad	0x3fe8cd8780000000
	.quad	0x3fe8ca3300000000
	.quad	0x3fe8c6df80000000
	.quad	0x3fe8c38d00000000
	.quad	0x3fe8c03b40000000
	.quad	0x3fe8bcea80000000
	.quad	0x3fe8b99a80000000
	.quad	0x3fe8b64b80000000
	.quad	0x3fe8b2fd40000000
	.quad	0x3fe8afb000000000
	.quad	0x3fe8ac63c0000000
	.quad	0x3fe8a91840000000
	.quad	0x3fe8a5cd80000000
	.quad	0x3fe8a283c0000000
	.quad	0x3fe89f3b00000000
	.quad	0x3fe89bf300000000
	.quad	0x3fe898abc0000000
	.quad	0x3fe8956580000000
	.quad	0x3fe8922040000000
	.quad	0x3fe88edbc0000000
	.quad	0x3fe88b9800000000
	.quad	0x3fe8885540000000
	.quad	0x3fe8851380000000
	.quad	0x3fe881d240000000
	.quad	0x3fe87e9240000000
	.quad	0x3fe87b52c0000000
	.quad	0x3fe8781480000000
	.quad	0x3fe874d6c0000000
	.quad	0x3fe8719a00000000
	.quad	0x3fe86e5e40000000
	.quad	0x3fe86b2340000000
	.quad	0x3fe867e900000000
	.quad	0x3fe864afc0000000
	.quad	0x3fe8617740000000
	.quad	0x3fe85e3f80000000
	.quad	0x3fe85b08c0000000
	.quad	0x3fe857d300000000
	.quad	0x3fe8549dc0000000
	.quad	0x3fe8516980000000
	.quad	0x3fe84e3640000000
	.quad	0x3fe84b03c0000000
	.quad	0x3fe847d200000000
	.quad	0x3fe844a100000000
	.quad	0x3fe8417100000000
	.quad	0x3fe83e4200000000
	.quad	0x3fe83b1380000000
	.quad	0x3fe837e600000000
	.quad	0x3fe834b940000000
	.quad	0x3fe8318d80000000
	.quad	0x3fe82e6280000000
	.quad	0x3fe82b3840000000
	.quad	0x3fe8280f00000000
	.quad	0x3fe824e640000000
	.quad	0x3fe821bec0000000
	.quad	0x3fe81e97c0000000
	.quad	0x3fe81b71c0000000
	.quad	0x3fe8184c80000000
	.quad	0x3fe8152800000000
	.quad	0x3fe8120480000000
	.quad	0x3fe80ee1c0000000
	.quad	0x3fe80bbfc0000000
	.quad	0x3fe8089e80000000
	.quad	0x3fe8057e40000000
	.quad	0x3fe8025ec0000000
	.quad	0x3fe7ff4000000000
	.quad	0x3fe7fc2200000000
	.quad	0x3fe7f90500000000
	.quad	0x3fe7f5e8c0000000
	.quad	0x3fe7f2cd40000000
	.quad	0x3fe7efb280000000
	.quad	0x3fe7ec9880000000
	.quad	0x3fe7e97f80000000
	.quad	0x3fe7e66740000000
	.quad	0x3fe7e34fc0000000
	.quad	0x3fe7e03940000000
	.quad	0x3fe7dd2340000000
	.quad	0x3fe7da0e40000000
	.quad	0x3fe7d6fa00000000
	.quad	0x3fe7d3e680000000
	.quad	0x3fe7d0d3c0000000
	.quad	0x3fe7cdc1c0000000
	.quad	0x3fe7cab0c0000000
	.quad	0x3fe7c7a080000000
	.quad	0x3fe7c49100000000
	.quad	0x3fe7c18240000000
	.quad	0x3fe7be7440000000
	.quad	0x3fe7bb6700000000
	.quad	0x3fe7b85ac0000000
	.quad	0x3fe7b54f00000000
	.quad	0x3fe7b24440000000
	.quad	0x3fe7af3a40000000
	.quad	0x3fe7ac3100000000
	.quad	0x3fe7a92880000000
	.quad	0x3fe7a620c0000000
	.quad	0x3fe7a319c0000000
	.quad	0x3fe7a013c0000000
	.quad	0x3fe79d0e40000000
	.quad	0x3fe79a09c0000000
	.quad	0x3fe7970600000000
	.quad	0x3fe79402c0000000
	.quad	0x3fe7910080000000
	.quad	0x3fe78dff00000000
	.quad	0x3fe78afe40000000
	.quad	0x3fe787fe40000000
	.quad	0x3fe784ff00000000
	.quad	0x3fe7820080000000
	.quad	0x3fe77f02c0000000
	.quad	0x3fe77c05c0000000
	.quad	0x3fe77909c0000000
	.quad	0x3fe7760e40000000
	.quad	0x3fe7731380000000
	.quad	0x3fe77019c0000000
	.quad	0x3fe76d2080000000
	.quad	0x3fe76a2800000000
	.quad	0x3fe7673080000000
	.quad	0x3fe7643980000000
	.quad	0x3fe7614340000000
	.quad	0x3fe75e4e00000000
	.quad	0x3fe75b5940000000
	.quad	0x3fe7586580000000
	.quad	0x3fe7557240000000
	.quad	0x3fe7527fc0000000
	.quad	0x3fe74f8e40000000
	.quad	0x3fe74c9d40000000
	.quad	0x3fe749ad00000000
	.quad	0x3fe746bd80000000
	.quad	0x3fe743cec0000000
	.quad	0x3fe740e100000000
	.quad	0x3fe73df3c0000000
	.quad	0x3fe73b0740000000
	.quad	0x3fe7381b80000000
	.quad	0x3fe7353080000000
	.quad	0x3fe7324600000000
	.quad	0x3fe72f5c80000000
	.quad	0x3fe72c73c0000000
	.quad	0x3fe7298b80000000
	.quad	0x3fe726a440000000
	.quad	0x3fe723bd80000000
	.quad	0x3fe720d7c0000000
	.quad	0x3fe71df280000000
	.quad	0x3fe71b0e00000000
	.quad	0x3fe7182a40000000
	.quad	0x3fe7154740000000
	.quad	0x0000000000000000
	.rept	48
	.byte	0
	.endr

/* Log(2) lookup table for log part (non HSW): */
.if .-__svml_dpow_data != _log2_t1
.err
.endif
	.rept	2
	.quad	0x0000000000000000
	.endr
	.quad	0x3f5712e100000000
	.quad	0x3e0ee8a22f7c5987
	.quad	0x3f670fc100000000
	.quad	0x3e17e16043fd7529
	.quad	0x3f71497700000000
	.quad	0x3e239efb866b119c
	.quad	0x3f7709bb00000000
	.quad	0x3e1b5ea7ee997dc0
	.quad	0x3f7cc8aa00000000
	.quad	0x3e2efad156451e8d
	.quad	0x3f81430200000000
	.quad	0x3e204975bf955ee8
	.quad	0x3f84210300000000
	.quad	0x3e2e526353333f9a
	.quad	0x3f86fe5800000000
	.quad	0x3e2dbbc5d9986525
	.quad	0x3f89dae000000000
	.quad	0x3e211ae127d370f8
	.quad	0x3f8cb6ba00000000
	.quad	0x3e2af44e8a20fe77
	.quad	0x3f8f91e600000000
	.quad	0x3e1f77bd1cd9fbc7
	.quad	0x3f91363100000000
	.quad	0x3e40f52f789c83a3
	.quad	0x3f92a31800000000
	.quad	0x3e172308c2064b24
	.quad	0x3f940f9600000000
	.quad	0x3e2f342d9eb8aeed
	.quad	0x3f957bbb00000000
	.quad	0x3e4abb9a144866b7
	.quad	0x3f96e79800000000
	.quad	0x3e48b85ac72b0200
	.quad	0x3f98530c00000000
	.quad	0x3e2d1e01fbc85d86
	.quad	0x3f99be3600000000
	.quad	0x3e37d26f00cda0dd
	.quad	0x3f9b28f600000000
	.quad	0x3e3433218e840f16
	.quad	0x3f9c935b00000000
	.quad	0x3e4f50a107fb8c37
	.quad	0x3f9dfd7700000000
	.quad	0x3e3604e609a9e948
	.quad	0x3f9f673700000000
	.quad	0x3e489f0de52d1118
	.quad	0x3fa0684e00000000
	.quad	0x3e4d127bd17abd42
	.quad	0x3fa11cd300000000
	.quad	0x3e3a899b4ece6057
	.quad	0x3fa1d12900000000
	.quad	0x3e5f0d0f99858cfa
	.quad	0x3fa2855a00000000
	.quad	0x3e58b94e89d977a4
	.quad	0x3fa3395d00000000
	.quad	0x3e402a7f6bf76796
	.quad	0x3fa3ed3100000000
	.quad	0x3e3e342da3e0aab6
	.quad	0x3fa4a0de00000000
	.quad	0x3e58cae94cd5496b
	.quad	0x3fa5545500000000
	.quad	0x3e3fdc64d89d4032
	.quad	0x3fa607ad00000000
	.quad	0x3e37dfd30f154124
	.quad	0x3fa6bad500000000
	.quad	0x3e5eb1e05460b0e3
	.quad	0x3fa76dcf00000000
	.quad	0x3e490ead14c7109d
	.quad	0x3fa820a100000000
	.quad	0x3e5258eaf10715e3
	.quad	0x3fa8d34400000000
	.quad	0x3e242a28e25fb4d0
	.quad	0x3fa985bf00000000
	.quad	0x3dfa4a83c146ec0f
	.quad	0x3faa381200000000
	.quad	0x3e3c7de45fe856f6
	.quad	0x3faaea3500000000
	.quad	0x3e408258f0914a28
	.quad	0x3fab9c3000000000
	.quad	0x3e3f9589c628dfe0
	.quad	0x3fac4dfa00000000
	.quad	0x3e5721556bde9f1f
	.quad	0x3facff9c00000000
	.quad	0x3e5a8867f80f2a46
	.quad	0x3fadb11600000000
	.quad	0x3e4a583c979a598e
	.quad	0x3fae626700000000
	.quad	0x3e443847800c1405
	.quad	0x3faf138700000000
	.quad	0x3e1664a168a10688
	.quad	0x3fafc48600000000
	.quad	0x3e2eb49173242e2e
	.quad	0x3fb03aa900000000
	.quad	0x3e6b1b90df1d2899
	.quad	0x3fb092fb00000000
	.quad	0x3e6f4828dce8ef96
	.quad	0x3fb0eb3900000000
	.quad	0x3e57e8a84071ed7c
	.quad	0x3fb1436100000000
	.quad	0x3e6ea26e46fc50e3
	.quad	0x3fb19b7500000000
	.quad	0x3e64d3ec52377554
	.quad	0x3fb1f37000000000
	.quad	0x3e46a5728109990d
	.quad	0x3fb24b5900000000
	.quad	0x3e6b426b10e12ca0
	.quad	0x3fb2a32e00000000
	.quad	0x3e59bbba7c1b46c7
	.quad	0x3fb2faed00000000
	.quad	0x3e67f99638784faf
	.quad	0x3fb3529c00000000
	.quad	0x3e1e52f196858161
	.quad	0x3fb3aa3000000000
	.quad	0x3e67a4fe6def19e6
	.quad	0x3fb401b000000000
	.quad	0x3e0302a326e6a3dc
	.quad	0x3fb4591d00000000
	.quad	0x3e6fa21b2e435f49
	.quad	0x3fb4b07600000000
	.quad	0x3e58415e51626967
	.quad	0x3fb507b900000000
	.quad	0x3e3a033d6c5941c4
	.quad	0x3fb55ee600000000
	.quad	0x3e33c8467c54296b
	.quad	0x3fb5b60100000000
	.quad	0x3e5e02f5a12fe65d
	.quad	0x3fb60d0600000000
	.quad	0x3e6ecfc86d9ed70d
	.quad	0x3fb663f600000000
	.quad	0x3e5eb24497a376b8
	.quad	0x3fb6bad400000000
	.quad	0x3e48c77f72e2b40f
	.quad	0x3fb7119b00000000
	.quad	0x3e68ed7d5e52d89e
	.quad	0x3fb7684d00000000
	.quad	0x3e43fa7ea9d3799b
	.quad	0x3fb7beec00000000
	.quad	0x3e60571414f770db
	.quad	0x3fb8157900000000
	.quad	0x3e68c7d07f316ee3
	.quad	0x3fb86bf000000000
	.quad	0x3e6360f420c77bec
	.quad	0x3fb8c25000000000
	.quad	0x3e6d91c947d50fa1
	.quad	0x3fb918a300000000
	.quad	0x3e4b231ba93bd154
	.quad	0x3fb96eda00000000
	.quad	0x3e61d38c8099fddd
	.quad	0x3fb9c50300000000
	.quad	0x3e677eeb9b0174ac
	.quad	0x3fba1b1100000000
	.quad	0x3e69d6ddd016014c
	.quad	0x3fba711100000000
	.quad	0x3e626690842b7789
	.quad	0x3fbac6fa00000000
	.quad	0x3e5830b93095c531
	.quad	0x3fbb1cd000000000
	.quad	0x3e5c2b99518e0d2c
	.quad	0x3fbb729300000000
	.quad	0x3e66279b91823620
	.quad	0x3fbbc84400000000
	.quad	0x3e30adafc9057ecc
	.quad	0x3fbc1ddd00000000
	.quad	0x3e461ce45269682a
	.quad	0x3fbc736300000000
	.quad	0x3e5044ef5f2fe276
	.quad	0x3fbcc8d600000000
	.quad	0x3e4eb3dbd5234ce7
	.quad	0x3fbd1e3600000000
	.quad	0x3e2eb70a6e724019
	.quad	0x3fbd737e00000000
	.quad	0x3e5403a5977b9a51
	.quad	0x3fbdc8b700000000
	.quad	0x3e62d343b2886c33
	.quad	0x3fbe1ddd00000000
	.quad	0x3e5f443cfbd572a9
	.quad	0x3fbe72eb00000000
	.quad	0x3e632ff4a08c00ad
	.quad	0x3fbec7ea00000000
	.quad	0x3e611d934f5c870b
	.quad	0x3fbf1cd100000000
	.quad	0x3e610afc18ecc7fd
	.quad	0x3fbf71a900000000
	.quad	0x3e4c5db9d4383f15
	.quad	0x3fbfc66800000000
	.quad	0x3e6a615fe5dcf50a
	.quad	0x3fc00d8c00000000
	.quad	0x3e6f8684b8524b4d
	.quad	0x3fc037da00000000
	.quad	0x3e7471e52c396096
	.quad	0x3fc0621e00000000
	.quad	0x3e7a1aad94d3758a
	.quad	0x3fc08c5800000000
	.quad	0x3e7f9b4f573cd19d
	.quad	0x3fc0b68900000000
	.quad	0x3e4e88e925a98afd
	.quad	0x3fc0e0b100000000
	.quad	0x3e677212d0eeb433
	.quad	0x3fc10acd00000000
	.quad	0x3e63ff48e459228f
	.quad	0x3fc134e100000000
	.quad	0x3e63a241697adc33
	.quad	0x3fc15eeb00000000
	.quad	0x3e4f4a7ae82699a0
	.quad	0x3fc188ec00000000
	.quad	0x3e7d83a2e1fe8196
	.quad	0x3fc1b2e400000000
	.quad	0x3e6e765c52c5b577
	.quad	0x3fc1dcd100000000
	.quad	0x3e77eaa5780399be
	.quad	0x3fc206b400000000
	.quad	0x3e766c5ef95ab1fc
	.quad	0x3fc2308f00000000
	.quad	0x3e703a52d5db6084
	.quad	0x3fc25a6200000000
	.quad	0x3e51786d7d82f6f1
	.quad	0x3fc2842a00000000
	.quad	0x3e6641ea2ded60b8
	.quad	0x3fc2ade800000000
	.quad	0x3e4addfbeaa772f7
	.quad	0x3fc2d79b00000000
	.quad	0x3e67cdfbbc061e04
	.quad	0x3fc3014800000000
	.quad	0x3e717ad775a7481b
	.quad	0x3fc32ae800000000
	.quad	0x3e7e4f15a673baf4
	.quad	0x3fc3548300000000
	.quad	0x3e58eca1813fa934
	.quad	0x3fc37e1200000000
	.quad	0x3e7a3622382e96fb
	.quad	0x3fc3a79700000000
	.quad	0x3e7916bb2a2cea0a
	.quad	0x3fc3d11400000000
	.quad	0x3e61e6a28aaa11cb
	.quad	0x3fc3fa8800000000
	.quad	0x3e61a3ceca68f920
	.quad	0x3fc423f100000000
	.quad	0x3e705825c8caf8ed
	.quad	0x3fc44d5200000000
	.quad	0x3e572d6f71f4b037
	.quad	0x3fc476aa00000000
	.quad	0x3e6060fdf3cabb49
	.quad	0x3fc49ff700000000
	.quad	0x3e6df855c48e67aa
	.quad	0x3fc4c93e00000000
	.quad	0x3e60854767c83d89
	.quad	0x3fc4f27700000000
	.quad	0x3e7c27d2adfa3cf1
	.quad	0x3fc51bab00000000
	.quad	0x3e21e96f77a9b8ff
	.quad	0x3fc544d500000000
	.quad	0x3e69b89066da0127
	.quad	0x3fc56df400000000
	.quad	0x3e7831ab063f0639
	.quad	0x3fc5970b00000000
	.quad	0x3e62a3ff97f4402e
	.quad	0x3fc5c01b00000000
	.quad	0x3e5cfdec6aa61224
	.quad	0x3fc5e92000000000
	.quad	0x3e30bf99a341739b
	.quad	0x3fc6121900000000
	.quad	0x3e7589025c069af7
	.quad	0x3fc63b0c00000000
	.quad	0x3e73e7c70dc28176
	.quad	0x3fc663f600000000
	.quad	0x3e7319225255ed92
	.quad	0x3fc68cd700000000
	.quad	0x3e721d999e92e626
	.quad	0x3fc6b5af00000000
	.quad	0x3e6feaba3c111c8a
	.quad	0x3fc6de7e00000000
	.quad	0x3e67408ffba276e0
	.quad	0x3fc7074100000000
	.quad	0x3e7b9de032cb0fd0
	.quad	0x3fc72ffe00000000
	.quad	0x3e6fbab18df0f78e
	.quad	0x3fc758b100000000
	.quad	0x3e7eed8f544cc58a
	.quad	0x3fc7815c00000000
	.quad	0x3e5f34382f992a55
	.quad	0x3fc7a9ff00000000
	.quad	0x3e723a0bf2565894
	.quad	0x3fc7d29700000000
	.quad	0x3e6784d72660bf64
	.quad	0x3fc7fb2800000000
	.quad	0x3e53cef9f2a00fda
	.quad	0x3fc823ad00000000
	.quad	0x3e6636827e73660e
	.quad	0x3fc84c2b00000000
	.quad	0x3e6e0bc0ce905e5f
	.quad	0x3fc874a000000000
	.quad	0x3e5b40d32ca21b4f
	.quad	0x3fc89d0d00000000
	.quad	0x3e7a968650124684
	.quad	0x3fc8c56f00000000
	.quad	0x3e7724c9f4c54dc2
	.quad	0x3fc8edca00000000
	.quad	0x3e6b8d4ab3e3b13c
	.quad	0x3fc9161b00000000
	.quad	0x3e74576bcfdafe5e
	.quad	0x3fc93e6500000000
	.quad	0x3e7332208c376c3f
	.quad	0x3fc966a600000000
	.quad	0x3df175e083c82deb
	.quad	0x3fc98edc00000000
	.quad	0x3e79efce11aa7d30
	.quad	0x3fc9b70c00000000
	.quad	0x3e62ae7840b35985
	.quad	0x3fc9df3200000000
	.quad	0x3e4e8c13081d57dc
	.quad	0x3fca074e00000000
	.quad	0x3e60b028bf61097b
	.quad	0x3fca2f6200000000
	.quad	0x3e7fa41706304e8f
	.quad	0x3fca576d00000000
	.quad	0x3e7f0e5f94377493
	.quad	0x3fca7f7100000000
	.quad	0x3e6edeeabeeeab1a
	.quad	0x3fcaa76d00000000
	.quad	0x3e6fdf22f0ca6c0d
	.quad	0x3fcacf5d00000000
	.quad	0x3e676d3aee892f9c
	.quad	0x3fcaf74700000000
	.quad	0x3e7fbc37f3121ab7
	.quad	0x3fcb1f2800000000
	.quad	0x3e7717af8e5dd5b2
	.quad	0x3fcb46ff00000000
	.quad	0x3e70c006784d6d72
	.quad	0x3fcb6ece00000000
	.quad	0x3e75ebf2abe7a8f0
	.quad	0x3fcb969600000000
	.quad	0x3e570772e1aa6f94
	.quad	0x3fcbbe5300000000
	.quad	0x3e7507e05d60e5c4
	.quad	0x3fcbe60900000000
	.quad	0x3e6a479c1c7622d5
	.quad	0x3fcc0db700000000
	.quad	0x3e6a7653cad63a6a
	.quad	0x3fcc355b00000000
	.quad	0x3e63c6576ac08e77
	.quad	0x3fcc5cf700000000
	.quad	0x3e696181ff9674a7
	.quad	0x3fcc848b00000000
	.quad	0x3e74c88b88cb08d4
	.quad	0x3fccac1500000000
	.quad	0x3e768ee1a3f58613
	.quad	0x3fccd39700000000
	.quad	0x3e7bc7d00e53901c
	.quad	0x3fccfb1200000000
	.quad	0x3e4cb8c314503175
	.quad	0x3fcd228400000000
	.quad	0x3e6a40646984129b
	.quad	0x3fcd49ee00000000
	.quad	0x3e77864b48c32b3c
	.quad	0x3fcd714e00000000
	.quad	0x3e76dc470f22f1ee
	.quad	0x3fcd98a900000000
	.quad	0x3e153043b87205ac
	.quad	0x3fcdbff800000000
	.quad	0x3e7ce2096f5baed1
	.quad	0x3fcde74000000000
	.quad	0x3e76b6293b0e2ea0
	.quad	0x3fce0e8000000000
	.quad	0x3e69e5c03298a8d0
	.quad	0x3fce35b500000000
	.quad	0x3e7359a4add9086c
	.quad	0x3fce5ce400000000
	.quad	0x3e7fbba6e4320b0b
	.quad	0x3fce840c00000000
	.quad	0x3e57a7356760bf17
	.quad	0x3fceab2b00000000
	.quad	0x3e5412dd4c71d4aa
	.quad	0x3fced23f00000000
	.quad	0x3e708cbbd3de4f64
	.quad	0x3fcef94d00000000
	.quad	0x3e7ed1ec6fb9ef8f
	.quad	0x3fcf205400000000
	.quad	0x3e4b20911d7e37db
	.quad	0x3fcf474f00000000
	.quad	0x3e7192aee74aaf85
	.quad	0x3fcf6e4500000000
	.quad	0x3de9ff7395251cf5
	.quad	0x3fcf953200000000
	.quad	0x3e418fcf45710fc3
	.quad	0x3fcfbc1600000000
	.quad	0x3e77204d0144751b
	.quad	0x3fcfe2f200000000
	.quad	0x3e7df662b4d59d8e
	.quad	0x3fd004e300000000
	.quad	0x3e75d25f17b09d21
	.quad	0x3fd0184a00000000
	.quad	0x3e64044284485ca5
	.quad	0x3fd02bab00000000
	.quad	0x3e80a9a0c732cb2c
	.quad	0x3fd03f0900000000
	.quad	0x3e89a98ad1490635
	.quad	0x3fd0526300000000
	.quad	0x3e897756562a827f
	.quad	0x3fd065b900000000
	.quad	0x3e7f42d1cecd3768
	.quad	0x3fd0790a00000000
	.quad	0x3e8bb6060195a070
	.quad	0x3fd08c5900000000
	.quad	0x3e5c5a7b3a2bd335
	.quad	0x3fd09fa100000000
	.quad	0x3e8a2743f6a4cd20
	.quad	0x3fd0b2e700000000
	.quad	0x3e775f83f99025b0
	.quad	0x3fd0c62900000000
	.quad	0x3e87ca856421a674
	.quad	0x3fd0d96600000000
	.quad	0x3e814d2830ef12fd
	.quad	0x3fd0eca000000000
	.quad	0x3e62348eca90f220
	.quad	0x3fd0ffd600000000
	.quad	0x3e812fcf75d18b23
	.quad	0x3fd1130700000000
	.quad	0x3e73b4c2bf9f9dd3
	.quad	0x3fd1263600000000
	.quad	0x3e499ef30070a508
	.quad	0x3fd1395f00000000
	.quad	0x3e61edb0d9e8da9b
	.quad	0x3fd14c8400000000
	.quad	0x3e8f23ac3152c264
	.quad	0x3fd15fa600000000
	.quad	0x3e752ec233b712ad
	.quad	0x3fd172c400000000
	.quad	0x3e7a163986a7b84c
	.quad	0x3fd185dd00000000
	.quad	0x3e8f734fda450672
	.quad	0x3fd198f400000000
	.quad	0x3e7028962c15f52b
	.quad	0x3fd1ac0500000000
	.quad	0x3e8fd23e213f6416
	.quad	0x3fd1bf1300000000
	.quad	0x3e68e4e3166c3339
	.quad	0x3fd1d21e00000000
	.quad	0x3e70ea55e7da3fec
	.quad	0x3fd1e52300000000
	.quad	0x3e81b9e3403df05d
	.quad	0x3fd1f82500000000
	.quad	0x3e7e762367a00f4a
	.quad	0x3fd20b2400000000
	.quad	0x3e3388b4dd9d8704
	.quad	0x3fd21e1f00000000
	.quad	0x3e6603bbc7b763e4
	.quad	0x3fd2311400000000
	.quad	0x3e7f38b9f767e1c9
	.quad	0x3fd2440700000000
	.quad	0x3e8361c0e424306b
	.quad	0x3fd256f600000000
	.quad	0x3e53e15a0763e5f5
	.quad	0x3fd269e100000000
	.quad	0x3e5c346e0f5542ab
	.quad	0x3fd27cc800000000
	.quad	0x3e8623bac0f6e8e5
	.quad	0x3fd28fab00000000
	.quad	0x3e82d664ea511964
	.quad	0x3fd2a28b00000000
	.quad	0x3e244827751649e1
	.quad	0x3fd2b56500000000
	.quad	0x3e870662732a8325
	.quad	0x3fd2c83c00000000
	.quad	0x3e8db880f0396c05
	.quad	0x3fd2db1000000000
	.quad	0x3e8409b34923f5d0
	.quad	0x3fd2ede000000000
	.quad	0x3e899c121e8496e6
	.quad	0x3fd300ad00000000
	.quad	0x3e7c232f22d20f20
	.quad	0x3fd3137500000000
	.quad	0x3e73683d6c58ca0d
	.quad	0x3fd3263900000000
	.quad	0x3e836d65141862cf
	.quad	0x3fd338fa00000000
	.quad	0x3e75be12efc2f601
	.quad	0x3fd34bb600000000
	.quad	0x3e70751869f3b7a6
	.quad	0x3fd35e6f00000000
	.quad	0x3e89f95043bbfc91
	.quad	0x3fd3712400000000
	.quad	0x3e80d499b29f7615
	.quad	0x3fd383d500000000
	.quad	0x3e83dd8f4de52902
	.quad	0x3fd3968400000000
	.quad	0x3e748a73fa7e46e2
	.quad	0x3fd3a92e00000000
	.quad	0x3e6252112c0e2155
	.quad	0x3fd3bbd300000000
	.quad	0x3e52a1dc831e5ad7
	.quad	0x3fd3ce7500000000
	.quad	0x3e825d1013e78284
	.quad	0x3fd3e11400000000
	.quad	0x3e796f27f8ed6ab1
	.quad	0x3fd3f3af00000000
	.quad	0x3e81043c4e106f6a
	.quad	0x3fd4064500000000
	.quad	0x3e8723607a748d45
	.quad	0x3fd418d900000000
	.quad	0x3e7c5a76f3c6b991
	.quad	0x3fd42b6900000000
	.quad	0x3e7c13d54b6ede12
	.quad	0x3fd43df400000000
	.quad	0x3e7d02dc433313ae
	.quad	0x3fd4507c00000000
	.quad	0x3e8edba9f6e1776c
	.quad	0x3fd4630100000000
	.quad	0x3e86e864bf1d1aaa
	.quad	0x3fd4758100000000
	.quad	0x3e7cae90765abc31
	.quad	0x3fd487fe00000000
	.quad	0x3e849fe23646e5a5
	.quad	0x3fd49a7800000000
	.quad	0x3e479a36743be41d
	.quad	0x3fd4aced00000000
	.quad	0x3e8483e03299b840
	.quad	0x3fd4bf5f00000000
	.quad	0x3e7abba144c6b22b
	.quad	0x3fd4d1cd00000000
	.quad	0x3e774d20fdd9f23b
	.quad	0x3fd4e43800000000
	.quad	0x3e871d1f7aa47e01
	.quad	0x3fd4f69e00000000
	.quad	0x3e8f2860ba3b3db5
	.quad	0x3fd5090200000000
	.quad	0x3e83af1c17099bfe
	.quad	0x3fd51b6200000000
	.quad	0x3e785ff9de74a1b4
	.quad	0x3fd52dbe00000000
	.quad	0x3e709325cfafa80f
	.quad	0x3fd5401600000000
	.quad	0x3e6e6947ccf73d7a
	.quad	0x3fd5526a00000000
	.quad	0x3e738124d5db9ad7
	.quad	0x3fd564bb00000000
	.quad	0x3e86b2911c62b3a2
	.quad	0x3fd5770900000000
	.quad	0x3e6719bc759ee891
	.quad	0x3fd5895200000000
	.quad	0x3e869a322d9370bc
	.quad	0x3fd59b9800000000
	.quad	0x3e719789a94340e2
	.quad	0x3fd5addb00000000
	.quad	0x3e61c3d9786a1c1a
	.quad	0x3fd5c01a00000000
	.quad	0x3e37ef590a213419
	.quad	0x3fd5d25400000000
	.quad	0x3e8d54eb1103130f
	.quad	0x3fd5e48d00000000
	.quad	0x3e52f62a9cc12fd0
	.quad	0x3fd5f6c100000000
	.quad	0x3e6be9b244784641
	.quad	0x3fd608f100000000
	.quad	0x3e758a521184b277
	.quad	0x3fd61b1e00000000
	.quad	0x3e86042873323471
	.quad	0x3fd62d4700000000
	.quad	0x3e8fbc7d80b47bcf
	.quad	0x3fd63f6d00000000
	.quad	0x3e6e2c82077ea756
	.quad	0x3fd6518f00000000
	.quad	0x3e85ccef6bf767f4
	.quad	0x3fd663ae00000000
	.quad	0x3e46ead81df81e8f
	.quad	0x3fd675c900000000
	.quad	0x3e82dd03f10cd685
	.quad	0x3fd687e100000000
	.quad	0x3e3e902c6dbc1f0c
	.quad	0x3fd699f500000000
	.quad	0x3e84319abac9c4b2
	.quad	0x3fd6ac0600000000
	.quad	0x3e5b055166c24b15
	.quad	0x3fd6be1200000000
	.quad	0x3e7c3be07b4f7882
	.quad	0x3fd6d01b00000000
	.quad	0x3e8cfd93dd847e5d
	.quad	0x3fd6e22100000000
	.quad	0x3e6ace863358e8d7
	.quad	0x3fd6f42300000000
	.quad	0x3e83e40c6242bfe9
	.quad	0x3fd7062300000000
	.quad	0x3e610ab6a8479b5d
	.quad	0x3fd7181e00000000
	.quad	0x3e7cd689bcfd9cf6
	.quad	0x3fd72a1600000000
	.quad	0x3e8b1978624662cc
	.quad	0x3fd73c0b00000000
	.quad	0x3e3b1a8d9a80c213
	.quad	0x3fd74dfa00000000
	.quad	0x3e8f44cc629fadc5
	.quad	0x3fd75fe900000000
	.quad	0x3e70d17562376005
	.quad	0x3fd771d300000000
	.quad	0x3e731fbf269b0088
	.quad	0x3fd783b900000000
	.quad	0x3e52ab13f0273736
	.quad	0x3fd7959b00000000
	.quad	0x3e8ba45253b127d6
	.quad	0x3fd7a77b00000000
	.quad	0x3e852fa4783a4dfd
	.quad	0x3fd7b95700000000
	.quad	0x3e6528d527430d54
	.quad	0x3fd7cb2f00000000
	.quad	0x3e84f6c8a8c54418
	.quad	0x3fd7dd0500000000
	.quad	0x3e5f404ba538c133
	.quad	0x3fd7eed700000000
	.quad	0x3e81d08a084632f9
	.quad	0x3fd800a500000000
	.quad	0x3e84e2c39b578d96
	.quad	0x3fd8127000000000
	.quad	0x3e8641178f2c2b02
	.quad	0x3fd8243700000000
	.quad	0x3e781b9c28ee919e
	.quad	0x3fd835fa00000000
	.quad	0x3e8f7b17b6d5775c
	.quad	0x3fd847bc00000000
	.quad	0x3e89db0c612f1b2e
	.quad	0x3fd8597800000000
	.quad	0x3e8dffaae2cbad0f
	.quad	0x3fd86b3300000000
	.quad	0x3e70f5b6d0513247
	.quad	0x3fd87ce900000000
	.quad	0x3e6699b2d0c42cca
	.quad	0x3fd88e9b00000000
	.quad	0x3e8edc16362782b3
	.quad	0x3fd8a04b00000000
	.quad	0x3e83cd771d49fb4b
	.quad	0x3fd8b1f800000000
	.quad	0x3e60b05b11747e4c
	.quad	0x3fd8c3a100000000
	.quad	0x3e7f52c9816db2c1
	.quad	0x3fd8d54600000000
	.quad	0x3e782d70d541d6c1
	.quad	0x3fd8e6e800000000
	.quad	0x3e57aa91cc153dde
	.quad	0x3fd8f88600000000
	.quad	0x3e83f65a8e01affc
	.quad	0x3fd90a2100000000
	.quad	0x3e8ecae2475966df
	.quad	0x3fd91bba00000000
	.quad	0x3e591f169848d269
	.quad	0x3fd92d4f00000000
	.quad	0x3e3647c7943a8d23
	.quad	0x3fd93ee000000000
	.quad	0x3e8726bf3db3e718
	.quad	0x3fd9506d00000000
	.quad	0x3e8c1a18fafa10d5
	.quad	0x3fd961f900000000
	.quad	0x3e5b2740c198f220
	.quad	0x3fd9737f00000000
	.quad	0x3e887fb1536242b8
	.quad	0x3fd9850400000000
	.quad	0x3e7ec5c619b71f3e
	.quad	0x3fd9968400000000
	.quad	0x3e8366d3eb0e5d24
	.quad	0x3fd9a80200000000
	.quad	0x3e88a3c48f5901ad
	.quad	0x3fd9b97c00000000
	.quad	0x3e74a3bb2d70054b
	.quad	0x3fd9caf200000000
	.quad	0x3e825931e77b3ed9
	.quad	0x3fd9dc6600000000
	.quad	0x3e8ac1bd72bb6920
	.quad	0x3fd9edd600000000
	.quad	0x3e7d26c9777b80e6
	.quad	0x3fd9ff4200000000
	.quad	0x3e87cdf6b003fe44
	.quad	0x3fda10ad00000000
	.quad	0x3e32256c5f5257da
	.quad	0x3fda221200000000
	.quad	0x3e83b4a3ff1466d0
	.quad	0x3fda337600000000
	.quad	0x3e673fb048cd2b2f
	.quad	0x3fda44d600000000
	.quad	0x3e7844f0a7da3c13
	.quad	0x3fda563100000000
	.quad	0x3e8bcba6da5b37e1
	.quad	0x3fda678b00000000
	.quad	0x3e7325816e447b2d
	.quad	0x3fda78e100000000
	.quad	0x3e753defc2fb5aa0
	.quad	0x3fda8a3300000000
	.quad	0x3e8e9f688620242e
	.quad	0x3fda9b8300000000
	.quad	0x3e650c63633bbec2
	.quad	0x3fdaacce00000000
	.quad	0x3e8e38f926facedd
	.quad	0x3fdabe1800000000
	.quad	0x3e83efe3f1bc83ea
	.quad	0x3fdacf5d00000000
	.quad	0x3e809e9d83cd28e8
	.quad	0x3fdae0a000000000
	.quad	0x3e72f7a9feea5b2a
	.quad	0x3fdaf1df00000000
	.quad	0x3e83762377a3c900
	.quad	0x3fdb031b00000000
	.quad	0x3e7c7818efde9c0a
	.quad	0x3fdb145500000000
	.quad	0x3e618ff8ce39a19e
	.quad	0x3fdb258900000000
	.quad	0x3e8fd450b400cdc5
	.quad	0x3fdb36bc00000000
	.quad	0x3e861347926aa708
	.quad	0x3fdb47eb00000000
	.quad	0x3e8be7104fa3a380
	.quad	0x3fdb591700000000
	.quad	0x3e80fdc35b90ee8d
	.quad	0x3fdb6a4100000000
	.quad	0x3e056415269e9adc
	.quad	0x3fdb7b6600000000
	.quad	0x3e8ddbe05932e271
	.quad	0x3fdb8c8900000000
	.quad	0x3e73fe21df4fea38
	.quad	0x3fdb9da800000000
	.quad	0x3e60b2e6d80d2ce6
	.quad	0x3fdbaec400000000
	.quad	0x3e874289e4e1d49c
	.quad	0x3fdbbfdd00000000
	.quad	0x3e87ce1b050aa700
	.quad	0x3fdbd0f300000000
	.quad	0x3e65f3c859448338
	.quad	0x3fdbe20400000000
	.quad	0x3e8ffc7f79678a39
	.quad	0x3fdbf31400000000
	.quad	0x3e824a1ec9be7496
	.quad	0x3fdc042100000000
	.quad	0x3e8c2b16ec00f182
	.quad	0x3fdc152a00000000
	.quad	0x3e6a92654ec891d7
	.quad	0x3fdc263000000000
	.quad	0x3e7037888b90c7f8
	.quad	0x3fdc373200000000
	.quad	0x3e84e5a090419bc8
	.quad	0x3fdc483200000000
	.quad	0x3e882722e066f64d
	.quad	0x3fdc592f00000000
	.quad	0x3e6894ad710aef0c
	.quad	0x3fdc6a2900000000
	.quad	0x3e74290c06a50919
	.quad	0x3fdc7b1f00000000
	.quad	0x3e8829ea41109e48
	.quad	0x3fdc8c1200000000
	.quad	0x3e8011fb6ad70668
	.quad	0x3fdc9d0200000000
	.quad	0x3e8d1948f3cb0098
	.quad	0x3fdcadef00000000
	.quad	0x3e835c4dc117de0d
	.quad	0x3fdcbed900000000
	.quad	0x3e8e37710c7563b4
	.quad	0x3fdccfc000000000
	.quad	0x3e81b705b8191331
	.quad	0x3fdce0a400000000
	.quad	0x3e89474b1cfe31f4
	.quad	0x3fdcf18500000000
	.quad	0x3e71c8d86ee32d3b
	.quad	0x3fdd026300000000
	.quad	0x3e7815019917c831
	.quad	0x3fdd133d00000000
	.quad	0x3e86a58c1d40a370
	.quad	0x3fdd241400000000
	.quad	0x3e70c2fc81bc79c2
	.quad	0x3fdd34e900000000
	.quad	0x3e88ba3405adb567
	.quad	0x3fdd45ba00000000
	.quad	0x3e5ddba9ecf26bb9
	.quad	0x3fdd568800000000
	.quad	0x3e3d1ef9e850540f
	.quad	0x3fdd675300000000
	.quad	0x3e80065d34ca0dce
	.quad	0x3fdd781c00000000
	.quad	0x3e80d733e02d0dd1
	.quad	0x3fdd88e100000000
	.quad	0x3e870ef65b098f9c
	.quad	0x3fdd99a300000000
	.quad	0x3e52c86102e26030
	.quad	0x3fddaa6100000000
	.quad	0x3e8e80c9ef4c81d3
	.quad	0x3fddbb1e00000000
	.quad	0x3e7692e19cb2b425
	.quad	0x3fddcbd600000000
	.quad	0x3e8c462e64521547
	.quad	0x3fdddc8c00000000
	.quad	0x3e8d5a1dd411035e
	.quad	0x3fdded4000000000
	.quad	0x3e7c908df47a8f92
	.quad	0x3fddfdf000000000
	.quad	0x3e545cf17f40aa9d
	.quad	0x3fde0e9d00000000
	.quad	0x3e687c172ac42c55
	.quad	0x3fde1f4600000000
	.quad	0x3e78da98936314cf
	.quad	0x3fde2fed00000000
	.quad	0x3e4812e4ac4e8487
	.quad	0x3fde409100000000
	.quad	0x3e64755453322906
	.quad	0x3fde513100000000
	.quad	0x3e7528ae2e3ef4fa
	.quad	0x3fde61d000000000
	.quad	0x3e7501716cf4be90
	.quad	0x3fde726900000000
	.quad	0x3e8f3cea8b8b9869
	.quad	0x3fde830200000000
	.quad	0x3e7be69828149b31
	.quad	0x3fde939600000000
	.quad	0x3e8d5e2937a72435
	.quad	0x3fdea42800000000
	.quad	0x3e89bfbbe2698141
	.quad	0x3fdeb4b800000000
	.quad	0x3e56d15b8c6d35e8
	.quad	0x3fdec54400000000
	.quad	0x3e886f8d094b9a13
	.quad	0x3fded5cd00000000
	.quad	0x3e7b23c5dca4eff0
	.quad	0x3fdee65300000000
	.quad	0x3e7d463bf0218027
	.quad	0x3fdef6d600000000
	.quad	0x3e8b651c6050e055
	.quad	0x3fdf075600000000
	.quad	0x3e6b46a793b8e626
	.quad	0x3fdf17d400000000
	.quad	0x3e74650236b11f5f
	.quad	0x3fdf284e00000000
	.quad	0x3e77629298efa0ad
	.quad	0x3fdf38c500000000
	.quad	0x3e87d798bebcb6ab
	.quad	0x3fdf493a00000000
	.quad	0x3e7ccde6d2f4c9f7
	.quad	0x3fdf59ab00000000
	.quad	0x3e5186572a5ff9c8
	.quad	0x3fdf6a1a00000000
	.quad	0x3e799d006591c907
	.quad	0x3fdf7a8500000000
	.quad	0x3e841960e73ec979
	.quad	0x3fdf8aee00000000
	.quad	0x3e630aa8521479fd
	.quad	0x3fdf9b5300000000
	.quad	0x3e8e8b869c429d94
	.quad	0x3fdfabb700000000
	.quad	0x3e4350fc25c8a13b
	.quad	0x3fdfbc1700000000
	.quad	0x3e79009a6ef5d48a
	.quad	0x3fdfcc7300000000
	.quad	0x3e8306349a8abfef
	.quad	0x3fdfdcce00000000
	.quad	0x3e7d9f569f06bc1e
	.quad	0x3fdfed2500000000
	.quad	0x3e65160ec1d12919
	.quad	0x3fdffd7900000000
	.quad	0x3e5a83ff2555a494
	.quad	0x3fe006e500000000
	.quad	0x3e9afca83644de26
	.quad	0x3fe00f0d00000000
	.quad	0x3e53c49d9079d468
	.quad	0x3fe0173200000000
	.quad	0x3e9ae76be763882e
	.quad	0x3fe01f5700000000
	.quad	0x3e7f793285e25c81
	.quad	0x3fe0277a00000000
	.quad	0x3e800243639826ee
	.quad	0x3fe02f9b00000000
	.quad	0x3e9b301832f2c8a9
	.quad	0x3fe037bc00000000
	.quad	0x3e54b54b5457ab7c
	.quad	0x3fe03fda00000000
	.quad	0x3e9a32f3449fa7a6
	.quad	0x3fe047f700000000
	.quad	0x3e8e060e91d41da5
	.quad	0x3fe0501300000000
	.quad	0x3e8a3f382aa1e82b
	.quad	0x3fe0582d00000000
	.quad	0x3e9da8b4318c1dd2
	.quad	0x3fe0604700000000
	.quad	0x3e3f9274a07c17a6
	.quad	0x3fe0685e00000000
	.quad	0x3e95804ec5f0fe6d
	.quad	0x3fe0707400000000
	.quad	0x3e9c8eac786d0112
	.quad	0x3fe0788900000000
	.quad	0x3e958943fb66416b
	.quad	0x3fe0809d00000000
	.quad	0x3e33fb82cede51e0
	.quad	0x3fe088ae00000000
	.quad	0x3e9cc27b15563034
	.quad	0x3fe090bf00000000
	.quad	0x3e8581667ca3348d
	.quad	0x3fe098ce00000000
	.quad	0x3e8454acd057fbfa
	.quad	0x3fe0a0dc00000000
	.quad	0x3e91cf1c5c53f37d
	.quad	0x3fe0a8e800000000
	.quad	0x3e93b2b423f481d0
	.quad	0x3fe0b0f300000000
	.quad	0x3e7a8314e3b62474
	.quad	0x3fe0b8fd00000000
	.quad	0x3e574eeba208d495
	.quad	0x3fe0c10400000000
	.quad	0x3e961ac74d5ada6a
	.quad	0x3fe0c90b00000000
	.quad	0x3e926ddde7aa78b1
	.quad	0x3fe0d11000000000
	.quad	0x3e9f51b91d907509
	.quad	0x3fe0d91400000000
	.quad	0x3e9ca5d77a3bf837
	.quad	0x3fe0e11700000000
	.quad	0x3e84935ef97f078e
	.quad	0x3fe0e91800000000
	.quad	0x3e80395f3d5449d6
	.quad	0x3fe0f11800000000
	.quad	0x3e8a2c7cb38d9ed1
	.quad	0x3fe0f91600000000
	.quad	0x3e9677ba0152cbb4
	.quad	0x3fe1011300000000
	.quad	0x3e9b3a7927aec2fd
	.quad	0x3fe1090f00000000
	.quad	0x3e707f2889e8b7a9
	.quad	0x3fe1110900000000
	.quad	0x3e93bcf3ba17fb1f
	.quad	0x3fe1190200000000
	.quad	0x3e7cecd182c0b1e4
	.quad	0x3fe120f900000000
	.quad	0x3e95a3c2fb2785b2
	.quad	0x3fe128ef00000000
	.quad	0x3e9edbce6a636a11
	.quad	0x3fe130e400000000
	.quad	0x3e972c7da9b832d3
	.quad	0x3fe138d700000000
	.quad	0x3e9e74efeb672a03
	.quad	0x3fe140ca00000000
	.quad	0x3e2a1e54f6b89e31
	.quad	0x3fe148ba00000000
	.quad	0x3e90ad737019fd24
	.quad	0x3fe150a900000000
	.quad	0x3e9b639c287d2824
	.quad	0x3fe1589700000000
	.quad	0x3e9495b6dd3ddabd
	.quad	0x3fe1608400000000
	.quad	0x3e7f2aeffe31b5d0
	.quad	0x3fe1686f00000000
	.quad	0x3e827b385c52cc9f
	.quad	0x3fe1705900000000
	.quad	0x3e71e501d3944026
	.quad	0x3fe1784100000000
	.quad	0x3e99628a2c0e2602
	.quad	0x3fe1802800000000
	.quad	0x3e9c2e52f159a4bf
	.quad	0x3fe1880e00000000
	.quad	0x3e8976d9b0f3dfdd
	.quad	0x3fe18ff300000000
	.quad	0x3e628513cd04695c
	.quad	0x3fe197d600000000
	.quad	0x3e75b2da605bddf8
	.quad	0x3fe19fb700000000
	.quad	0x3e95ee648263ee18
	.quad	0x3fe1a79700000000
	.quad	0x3e9f6e601ac91256
	.quad	0x3fe1af7700000000
	.quad	0x3e5d155a178b90cd
	.quad	0x3fe1b75400000000
	.quad	0x3e9cfbe9de667b41
	.quad	0x3fe1bf3100000000
	.quad	0x3e744ae80f899fbd
	.quad	0x3fe1c70c00000000
	.quad	0x3e76d96ff1c879c9
	.quad	0x3fe1cee500000000
	.quad	0x3e9ecb5e2c072eb0
	.quad	0x3fe1d6be00000000
	.quad	0x3e71c11dbe1db818
	.quad	0x3fe1de9500000000
	.quad	0x3e625cbb9559d10f
	.quad	0x3fe1e66a00000000
	.quad	0x3e9841c66176bdde
	.quad	0x3fe1ee3f00000000
	.quad	0x3e78dd143c97c211
	.quad	0x3fe1f61200000000
	.quad	0x3e309f38f10515b8
	.quad	0x3fe1fde300000000
	.quad	0x3e9de1d02b7acb55
	.quad	0x3fe205b400000000
	.quad	0x3e7d6e666f069f9f
	.quad	0x3fe20d8300000000
	.quad	0x3e80c459b58a9a68
	.quad	0x3fe2155100000000
	.quad	0x3e4b3ac6c4422b43
	.quad	0x3fe21d1d00000000
	.quad	0x3e90a6dabdf57c13
	.quad	0x3fe224e800000000
	.quad	0x3e87a6f05e2e66b4
	.quad	0x3fe22cb200000000
	.quad	0x3e83ebcaaaa786ff
	.quad	0x3fe2347a00000000
	.quad	0x3e933c5177ae38be
	.quad	0x3fe23c4100000000
	.quad	0x3e9f44e5029b8b1d
	.quad	0x3fe2440700000000
	.quad	0x3e9635c0e894df30
	.quad	0x3fe24bcc00000000
	.quad	0x3e6e87f9f1f3590c
	.quad	0x3fe2538f00000000
	.quad	0x3e7feacb86a3b429
	.quad	0x3fe25b5100000000
	.quad	0x3e8cfdcf4e10a41a
	.quad	0x3fe2631100000000
	.quad	0x3e9f73a21fdde641
	.quad	0x3fe26ad100000000
	.quad	0x3e7a8b8011d56d3b
	.quad	0x3fe2728f00000000
	.quad	0x3e6f84bf7d5b34d0
	.quad	0x3fe27a4c00000000
	.quad	0x3e6985cc1c8f11b0
	.quad	0x3fe2820700000000
	.quad	0x3e88d25a6a02c803
	.quad	0x3fe289c100000000
	.quad	0x3e975fd4c3433e76
	.quad	0x3fe2917a00000000
	.quad	0x3e8825154781d2c2
	.quad	0x3fe2993200000000
	.quad	0x3e62791595e60d25
	.quad	0x3fe2a0e800000000
	.quad	0x3e605b4c41d5635b
	.quad	0x3fe2a89d00000000
	.quad	0x3e68e92900528496
	.quad	0x3fe2b05000000000
	.quad	0x3e9970145df6a281
	.quad	0xbfda8ff900000000
	.quad	0xbe86302155df0de3
	.quad	0xbfda809600000000
	.quad	0xbe8d2b316176fad0
	.quad	0xbfda713700000000
	.quad	0xbe824db2f6aceb96
	.quad	0xbfda61da00000000
	.quad	0xbe67117a804da234
	.quad	0xbfda527f00000000
	.quad	0xbe7f97f60ff5807b
	.quad	0xbfda432700000000
	.quad	0xbe809d5c44adaa28
	.quad	0xbfda33d200000000
	.quad	0xbe70e2c7de9ac83b
	.quad	0xbfda247f00000000
	.quad	0xbe8781011952fb40
	.quad	0xbfda152f00000000
	.quad	0xbe6794c0edaf9f16
	.quad	0xbfda05e100000000
	.quad	0xbe77ddf6e9895b08
	.quad	0xbfd9f69600000000
	.quad	0xbe73aef455ae3da8
	.quad	0xbfd9e74d00000000
	.quad	0xbe6eaf442c7ba9be
	.quad	0xbfd9d80600000000
	.quad	0xbe8dc93243f14070
	.quad	0xbfd9c8c300000000
	.quad	0xbe78d1ba7956f02d
	.quad	0xbfd9b98100000000
	.quad	0xbe8b8c1e78260310
	.quad	0xbfd9aa4300000000
	.quad	0xbe5ce27fc9d31391
	.quad	0xbfd99b0700000000
	.quad	0xbe634b6355f4087a
	.quad	0xbfd98bcd00000000
	.quad	0xbe6c94b4572fef43
	.quad	0xbfd97c9600000000
	.quad	0xbe5846721de94267
	.quad	0xbfd96d6100000000
	.quad	0xbe88b74acdde1f6a
	.quad	0xbfd95e2f00000000
	.quad	0xbe801a3e03f6b280
	.quad	0xbfd94f0000000000
	.quad	0xbe4b35095482043f
	.quad	0xbfd93fd200000000
	.quad	0xbe856437d9bb4a5c
	.quad	0xbfd930a800000000
	.quad	0xbe5db5b388b06a65
	.quad	0xbfd9218000000000
	.quad	0xbe79c93768c0e5d4
	.quad	0xbfd9125a00000000
	.quad	0xbe27f0e9d0aaf77a
	.quad	0xbfd9033700000000
	.quad	0xbe6e085f7c5942f1
	.quad	0xbfd8f41600000000
	.quad	0xbe81b98df5f47569
	.quad	0xbfd8e4f700000000
	.quad	0xbe8f3428ac4ddeec
	.quad	0xbfd8d5dc00000000
	.quad	0xbe7127ef6092650e
	.quad	0xbfd8c6c300000000
	.quad	0xbe7c262e6c66cdb8
	.quad	0xbfd8b7ac00000000
	.quad	0xbe876faffff4af15
	.quad	0xbfd8a89800000000
	.quad	0xbe635fdead9ef9a2
	.quad	0xbfd8998600000000
	.quad	0xbe7dfc6109e45ceb
	.quad	0xbfd88a7600000000
	.quad	0xbe8d94a9416e4721
	.quad	0xbfd87b6900000000
	.quad	0xbe80c9bd35322fa9
	.quad	0xbfd86c5f00000000
	.quad	0xbe45bd4714c8ffcf
	.quad	0xbfd85d5700000000
	.quad	0xbe7f0ac6abba5180
	.quad	0xbfd84e5100000000
	.quad	0xbe74a1d4fc76c4e2
	.quad	0xbfd83f4e00000000
	.quad	0xbe58c7bbd43ea059
	.quad	0xbfd8304d00000000
	.quad	0xbe8a18240481523a
	.quad	0xbfd8214e00000000
	.quad	0xbe8e4115e0e87309
	.quad	0xbfd8125300000000
	.quad	0xbe4067fcc9c54454
	.quad	0xbfd8035a00000000
	.quad	0xbe5519044060b3ca
	.quad	0xbfd7f46200000000
	.quad	0xbe81f1c2bab3efa5
	.quad	0xbfd7e56e00000000
	.quad	0xbe2f4f8116a92f1f
	.quad	0xbfd7d67c00000000
	.quad	0xbe7d00ebaf755412
	.quad	0xbfd7c78c00000000
	.quad	0xbe757cb332aa9b04
	.quad	0xbfd7b89f00000000
	.quad	0xbe6b67957924a221
	.quad	0xbfd7a9b400000000
	.quad	0xbe749441f289397f
	.quad	0xbfd79acb00000000
	.quad	0xbe853e207739b243
	.quad	0xbfd78be500000000
	.quad	0xbe6f940fb688810d
	.quad	0xbfd77d0100000000
	.quad	0xbe8b3df7ad1f744b
	.quad	0xbfd76e2000000000
	.quad	0xbe86b033ad082bc9
	.quad	0xbfd75f4100000000
	.quad	0xbe8a6afc121884da
	.quad	0xbfd7506500000000
	.quad	0xbe6a7683b47c1884
	.quad	0xbfd7418a00000000
	.quad	0xbe8b777e34575fd6
	.quad	0xbfd732b200000000
	.quad	0xbe8927fbbcb9ee5d
	.quad	0xbfd723dd00000000
	.quad	0xbe88c68d7090566b
	.quad	0xbfd7150b00000000
	.quad	0xbe4a2b2a2a0eb191
	.quad	0xbfd7063900000000
	.quad	0xbe8afbf68de6383b
	.quad	0xbfd6f76b00000000
	.quad	0xbe86ddf093045ea8
	.quad	0xbfd6e89f00000000
	.quad	0xbe8c8c435cc0756e
	.quad	0xbfd6d9d600000000
	.quad	0xbe786d3ae8f9661f
	.quad	0xbfd6cb0f00000000
	.quad	0xbe6832e43f6d9d88
	.quad	0xbfd6bc4a00000000
	.quad	0xbe747cb81361877f
	.quad	0xbfd6ad8800000000
	.quad	0xbe82035808f1c0f3
	.quad	0xbfd69ec800000000
	.quad	0xbe76ff1399db6922
	.quad	0xbfd6900a00000000
	.quad	0xbe7fcdb431863dd3
	.quad	0xbfd6814e00000000
	.quad	0xbe8f693d13fbb8d9
	.quad	0xbfd6729600000000
	.quad	0xbe834eb29036fad3
	.quad	0xbfd663df00000000
	.quad	0xbe899b456a12ce2e
	.quad	0xbfd6552b00000000
	.quad	0xbe772618a503c189
	.quad	0xbfd6467900000000
	.quad	0xbe72cc529275c5a3
	.quad	0xbfd637c900000000
	.quad	0xbe8344c9b19a2513
	.quad	0xbfd6291c00000000
	.quad	0xbe72be4c963d47b8
	.quad	0xbfd61a7100000000
	.quad	0xbe77cb0653b68de6
	.quad	0xbfd60bc800000000
	.quad	0xbe8b082faedc50d1
	.quad	0xbfd5fd2200000000
	.quad	0xbe86f7868080f7bc
	.quad	0xbfd5ee7e00000000
	.quad	0xbe6a9fb569e79a60
	.quad	0xbfd5dfdc00000000
	.quad	0xbe8cbdd5bf453a04
	.quad	0xbfd5d13d00000000
	.quad	0xbe6bb6ee545183dc
	.quad	0xbfd5c2a000000000
	.quad	0xbe87ec26c29aa221
	.quad	0xbfd5b40500000000
	.quad	0xbe8d5da983e3cbed
	.quad	0xbfd5a56d00000000
	.quad	0xbe80b6e1bfe5ec04
	.quad	0xbfd596d700000000
	.quad	0xbe8228784608b2df
	.quad	0xbfd5884300000000
	.quad	0xbe7116419622027e
	.quad	0xbfd579b200000000
	.quad	0xbe6aee6a38f29592
	.quad	0xbfd56b2200000000
	.quad	0xbe8a36af180d0f15
	.quad	0xbfd55c9500000000
	.quad	0xbe8c853372ca57cc
	.quad	0xbfd54e0b00000000
	.quad	0xbe7bb00ee04486c4
	.quad	0xbfd53f8300000000
	.quad	0xbe7cc02b891628da
	.quad	0xbfd530fd00000000
	.quad	0xbe63794fe93c7f63
	.quad	0xbfd5227900000000
	.quad	0xbe75d7854e0de2c5
	.quad	0xbfd513f800000000
	.quad	0xbe372da45519dce0
	.quad	0xbfd5057800000000
	.quad	0xbe79f8d2da727bf4
	.quad	0xbfd4f6fc00000000
	.quad	0xbe56cec60358c3fd
	.quad	0xbfd4e88000000000
	.quad	0xbe8602e65c350140
	.quad	0xbfd4da0800000000
	.quad	0xbe8328c92737a9b0
	.quad	0xbfd4cb9200000000
	.quad	0xbe6dc3078767b5b5
	.quad	0xbfd4bd1e00000000
	.quad	0xbe79203927cd12cc
	.quad	0xbfd4aead00000000
	.quad	0xbe55c17da1b07b42
	.quad	0xbfd4a03d00000000
	.quad	0xbe80825c25cbdda8
	.quad	0xbfd491d000000000
	.quad	0xbe7f601ba1cb823b
	.quad	0xbfd4836600000000
	.quad	0xbe2caebe06773e1b
	.quad	0xbfd474fd00000000
	.quad	0xbe72afc887224809
	.quad	0xbfd4669700000000
	.quad	0xbe60b454dababfee
	.quad	0xbfd4583200000000
	.quad	0xbe8777e382ef584f
	.quad	0xbfd449d000000000
	.quad	0xbe8d0defa65e43f7
	.quad	0xbfd43b7100000000
	.quad	0xbe8520e465f01125
	.quad	0xbfd42d1400000000
	.quad	0xbe68a9db3066f3ad
	.quad	0xbfd41eb900000000
	.quad	0xbe7418cd285c77e6
	.quad	0xbfd4106000000000
	.quad	0xbe6ce1f66985cea7
	.quad	0xbfd4020900000000
	.quad	0xbe8798904973ef89
	.quad	0xbfd3f3b500000000
	.quad	0xbe4967d2ab8251d8
	.quad	0xbfd3e56200000000
	.quad	0xbe8f242d496e3d08
	.quad	0xbfd3d71200000000
	.quad	0xbe86a393bba964c4
	.quad	0xbfd3c8c500000000
	.quad	0xbe507570cacef7bf
	.quad	0xbfd3ba7900000000
	.quad	0xbe6efe0fa4f69a96
	.quad	0xbfd3ac3000000000
	.quad	0xbe4b827373e0a286
	.quad	0xbfd39de800000000
	.quad	0xbe864ab3e2fb43d9
	.quad	0xbfd38fa300000000
	.quad	0xbe8f81504eb31318
	.quad	0xbfd3816100000000
	.quad	0xbe5d3164fb917590
	.quad	0xbfd3732000000000
	.quad	0xbe8ccb836b329f7f
	.quad	0xbfd364e200000000
	.quad	0xbe8133990d5010c8
	.quad	0xbfd356a600000000
	.quad	0xbe404bc113420455
	.quad	0xbfd3486c00000000
	.quad	0xbe697514cf0a57dc
	.quad	0xbfd33a3400000000
	.quad	0xbe6dce5b769a0eb8
	.quad	0xbfd32bfe00000000
	.quad	0xbe8e6e1dd018cc95
	.quad	0xbfd31dcb00000000
	.quad	0xbe817b505f20e7f3
	.quad	0xbfd30f9a00000000
	.quad	0xbe3835df86199ab1
	.quad	0xbfd3016b00000000
	.quad	0xbe69cf10d769bddb
	.quad	0xbfd2f33e00000000
	.quad	0xbe7168482a60bb7c
	.quad	0xbfd2e51400000000
	.quad	0xbe4bd6cdf5bcf5c4
	.quad	0xbfd2d6ea00000000
	.quad	0xbe8d924633fff084
	.quad	0xbfd2c8c500000000
	.quad	0xbe7542c49a05ee8f
	.quad	0xbfd2baa000000000
	.quad	0xbe8ac97c411279db
	.quad	0xbfd2ac7f00000000
	.quad	0xbe536acce9910bf7
	.quad	0xbfd29e5f00000000
	.quad	0xbe6e5f25492f16f4
	.quad	0xbfd2904100000000
	.quad	0xbe74df4847fe96f4
	.quad	0xbfd2822500000000
	.quad	0xbe763798f43090eb
	.quad	0xbfd2740c00000000
	.quad	0xbe5fb975ad3295a5
	.quad	0xbfd265f400000000
	.quad	0xbe8afcc065467993
	.quad	0xbfd257e000000000
	.quad	0xbe751f024a4452fe
	.quad	0xbfd249cc00000000
	.quad	0xbe8e6279a0249a31
	.quad	0xbfd23bbc00000000
	.quad	0xbe7631798bcda203
	.quad	0xbfd22dad00000000
	.quad	0xbe869d668ff512cd
	.quad	0xbfd21fa100000000
	.quad	0xbe4179cae9beee0d
	.quad	0xbfd2119700000000
	.quad	0xbe63fa3a108ec52d
	.quad	0xbfd2038e00000000
	.quad	0xbe7bbae8d6fb8a1c
	.quad	0xbfd1f58800000000
	.quad	0xbe807f90e4c2ec69
	.quad	0xbfd1e78400000000
	.quad	0xbe82bc2f5babe119
	.quad	0xbfd1d98200000000
	.quad	0xbe84baa4d8e71f1c
	.quad	0xbfd1cb8200000000
	.quad	0xbe86a24fc7020b2b
	.quad	0xbfd1bd8500000000
	.quad	0xbe8302982dfe3735
	.quad	0xbfd1af8900000000
	.quad	0xbe8536eece3209fa
	.quad	0xbfd1a19000000000
	.quad	0xbe823ace8fc13621
	.quad	0xbfd1939900000000
	.quad	0xbe7f9b761181cc82
	.quad	0xbfd185a400000000
	.quad	0xbe7c2e82add30fbf
	.quad	0xbfd177b100000000
	.quad	0xbe7a7defb44845fc
	.quad	0xbfd169c000000000
	.quad	0xbe7ad8fc5efe4b5f
	.quad	0xbfd15bd100000000
	.quad	0xbe7d8efa5836733a
	.quad	0xbfd14de400000000
	.quad	0xbe8177a6d8101fb8
	.quad	0xbfd13ffa00000000
	.quad	0xbe8030b69ab39bd3
	.quad	0xbfd1321100000000
	.quad	0xbe86067085d42483
	.quad	0xbfd1242a00000000
	.quad	0xbe8da8a239a3d693
	.quad	0xbfd1164700000000
	.quad	0xbe4d72294066a603
	.quad	0xbfd1086400000000
	.quad	0xbe7b1ba1dc449b96
	.quad	0xbfd0fa8400000000
	.quad	0xbe862896725de3dd
	.quad	0xbfd0eca600000000
	.quad	0xbe6a4d928a11e457
	.quad	0xbfd0deca00000000
	.quad	0xbe843a36b9d55575
	.quad	0xbfd0d0f000000000
	.quad	0xbe73f2208d19fe75
	.quad	0xbfd0c31800000000
	.quad	0xbe8d4bfe81a344c0
	.quad	0xbfd0b54200000000
	.quad	0xbe88ff16f1f6621d
	.quad	0xbfd0a76f00000000
	.quad	0xbe829e78b22b06aa
	.quad	0xbfd0999d00000000
	.quad	0xbe84e64b365fec9a
	.quad	0xbfd08bcd00000000
	.quad	0xbe8ab2bf39987eff
	.quad	0xbfd07e0000000000
	.quad	0xbe8ef00e6f310240
	.quad	0xbfd0703500000000
	.quad	0xbe7884f5dd34e44b
	.quad	0xbfd0626b00000000
	.quad	0xbe8d92500f14b471
	.quad	0xbfd054a400000000
	.quad	0xbe8307e1dd3ad028
	.quad	0xbfd046df00000000
	.quad	0xbe79971a63342c6a
	.quad	0xbfd0391c00000000
	.quad	0xbe760b6f55e8db61
	.quad	0xbfd02b5a00000000
	.quad	0xbe8302cf89e64237
	.quad	0xbfd01d9b00000000
	.quad	0xbe8a9f4c3efc935a
	.quad	0xbfd00fde00000000
	.quad	0xbe788f5a8dc51cdf
	.quad	0xbfd0022300000000
	.quad	0xbe8de87b8de45c1c
	.quad	0xbfcfe8d500000000
	.quad	0xbe73bc8feab63684
	.quad	0xbfcfcd6700000000
	.quad	0xbe766b590d531889
	.quad	0xbfcfb1fe00000000
	.quad	0xbe50ba5e451bff1a
	.quad	0xbfcf969700000000
	.quad	0xbe5d9e85a4fc1ce1
	.quad	0xbfcf7b3600000000
	.quad	0xbe687fbdab298db0
	.quad	0xbfcf5fd800000000
	.quad	0xbe5c831eaf201561
	.quad	0xbfcf447e00000000
	.quad	0xbe6c97cc28a0c985
	.quad	0xbfcf292900000000
	.quad	0xbe4096a784f160c8
	.quad	0xbfcf0dd800000000
	.quad	0xbe463a00e430058b
	.quad	0xbfcef28900000000
	.quad	0xbe7a9ae40adf8036
	.quad	0xbfced74100000000
	.quad	0xbe76178f7389c2b3
	.quad	0xbfcebbfc00000000
	.quad	0xbe628e408a6030db
	.quad	0xbfcea0bb00000000
	.quad	0xbe65370cfca139e2
	.quad	0xbfce857d00000000
	.quad	0xbe509b099c44098a
	.quad	0xbfce6a4300000000
	.quad	0xbe68d5caf2faef74
	.quad	0xbfce4f0e00000000
	.quad	0xbe4dd08f036b132f
	.quad	0xbfce33dd00000000
	.quad	0xbe64ccf4cb32e460
	.quad	0xbfce18af00000000
	.quad	0xbe64c4c42c4e4661
	.quad	0xbfcdfd8700000000
	.quad	0xbe70b81de05729de
	.quad	0xbfcde26000000000
	.quad	0xbe7a821176a0fe0e
	.quad	0xbfcdc74000000000
	.quad	0xbe669566643c24c3
	.quad	0xbfcdac2200000000
	.quad	0xbe767c88339625fc
	.quad	0xbfcd910900000000
	.quad	0xbe72da2735aa6c86
	.quad	0xbfcd75f300000000
	.quad	0xbe644c6d4a5f5ad6
	.quad	0xbfcd5ae300000000
	.quad	0xbe6396dd21fe2514
	.quad	0xbfcd3fd400000000
	.quad	0xbe6ca92ae56a4fcf
	.quad	0xbfcd24cb00000000
	.quad	0xbe7bdc846e0ed386
	.quad	0xbfcd09c600000000
	.quad	0xbe55b88be3ae865a
	.quad	0xbfcceec500000000
	.quad	0xbe3fc6a072116830
	.quad	0xbfccd3c600000000
	.quad	0xbe7b1a6214562c52
	.quad	0xbfccb8cd00000000
	.quad	0xbe5f2c91c96636d8
	.quad	0xbfcc9dd800000000
	.quad	0xbe60c3b48651cf97
	.quad	0xbfcc82e600000000
	.quad	0xbe5966f235766ddb
	.quad	0xbfcc67f800000000
	.quad	0xbe78ce14eae5dca8
	.quad	0xbfcc4d0e00000000
	.quad	0xbe625479353b5c4a
	.quad	0xbfcc322800000000
	.quad	0xbe6d333a7b285ac2
	.quad	0xbfcc174500000000
	.quad	0xbe7277affe5d329a
	.quad	0xbfcbfc6700000000
	.quad	0xbe67fffd12834efc
	.quad	0xbfcbe18d00000000
	.quad	0xbe7b862223583bcf
	.quad	0xbfcbc6b700000000
	.quad	0xbe649b874647b1f2
	.quad	0xbfcbabe300000000
	.quad	0xbe78929bf1c864a7
	.quad	0xbfcb911600000000
	.quad	0xbe74d074968f73d7
	.quad	0xbfcb764a00000000
	.quad	0xbe79fb251b935310
	.quad	0xbfcb5b8300000000
	.quad	0xbe769696568e41b9
	.quad	0xbfcb40c100000000
	.quad	0xbe65ed80b7eb91e0
	.quad	0xbfcb260200000000
	.quad	0xbe07d52c3932a2e4
	.quad	0xbfcb0b4700000000
	.quad	0xbe6b8ad7d7a99fe6
	.quad	0xbfcaf08f00000000
	.quad	0xbe7cbc2b9155b770
	.quad	0xbfcad5db00000000
	.quad	0xbe6aa03f2514a52b
	.quad	0xbfcabb2d00000000
	.quad	0xbe6cfb1d524b6daf
	.quad	0xbfcaa08000000000
	.quad	0xbe7a78cd1fbb1e99
	.quad	0xbfca85d900000000
	.quad	0xbe119017e37d4667
	.quad	0xbfca6b3400000000
	.quad	0xbe6184b897951f46
	.quad	0xbfca509400000000
	.quad	0xbe675349e1651fc0
	.quad	0xbfca35f700000000
	.quad	0xbe71c8acc30679dd
	.quad	0xbfca1b5f00000000
	.quad	0xbe72ec1682bf9837
	.quad	0xbfca00ca00000000
	.quad	0xbe77d09336233c90
	.quad	0xbfc9e63a00000000
	.quad	0xbe7852e40017e39c
	.quad	0xbfc9cbad00000000
	.quad	0xbe7d1fd8802fb817
	.quad	0xbfc9b12400000000
	.quad	0xbe59d13fae79743c
	.quad	0xbfc9969d00000000
	.quad	0xbe748d385e0277cf
	.quad	0xbfc97c1b00000000
	.quad	0xbe7f678fa8388a68
	.quad	0xbfc9619f00000000
	.quad	0xbe5d6188e89480ec
	.quad	0xbfc9472500000000
	.quad	0xbe74e4cb139c1e95
	.quad	0xbfc92caf00000000
	.quad	0xbe6093e9a4239741
	.quad	0xbfc9123c00000000
	.quad	0xbe3c518d850f7ba8
	.quad	0xbfc8f7cd00000000
	.quad	0xbe797b7fc86f1c0c
	.quad	0xbfc8dd6200000000
	.quad	0xbe77d280a0117cfd
	.quad	0xbfc8c2fa00000000
	.quad	0xbe7d078174c6928f
	.quad	0xbfc8a89800000000
	.quad	0xbe357f7a64ccd537
	.quad	0xbfc88e3800000000
	.quad	0xbe6a22cd1f2e8f29
	.quad	0xbfc873dc00000000
	.quad	0xbe1c582d297ff644
	.quad	0xbfc8598400000000
	.quad	0xbe73cd87ce24f758
	.quad	0xbfc83f3000000000
	.quad	0xbe6eb716bac42623
	.quad	0xbfc824df00000000
	.quad	0xbe73592a0f410400
	.quad	0xbfc80a9300000000
	.quad	0xbe78343174876ba5
	.quad	0xbfc7f04900000000
	.quad	0xbe6ba4f9b930430e
	.quad	0xbfc7d60400000000
	.quad	0xbe5367dd3b0b6b0b
	.quad	0xbfc7bbc200000000
	.quad	0xbe556265a1dc7a8e
	.quad	0xbfc7a18500000000
	.quad	0xbe5f71aca38241c4
	.quad	0xbfc7874b00000000
	.quad	0xbe746381f987646b
	.quad	0xbfc76d1500000000
	.quad	0xbe665804bc056069
	.quad	0xbfc752e200000000
	.quad	0xbe68e83e5955bbc6
	.quad	0xbfc738b200000000
	.quad	0xbe787a19887d1e81
	.quad	0xbfc71e8800000000
	.quad	0xbe5fd1054d6e1895
	.quad	0xbfc7045f00000000
	.quad	0xbe6471e7650be845
	.quad	0xbfc6ea3b00000000
	.quad	0xbe707e9d9296377f
	.quad	0xbfc6d01c00000000
	.quad	0xbe7b1bb94e9cc3b2
	.quad	0xbfc6b5ff00000000
	.quad	0xbe7936ceca9afdc8
	.quad	0xbfc69be600000000
	.quad	0xbe4cb3a881abfdf7
	.quad	0xbfc681d100000000
	.quad	0xbe732151a8286c6f
	.quad	0xbfc667c000000000
	.quad	0xbe6efc2e3e9ced23
	.quad	0xbfc64db200000000
	.quad	0xbe78eb86ac9ef252
	.quad	0xbfc633a800000000
	.quad	0xbe6f50df1abe0fc9
	.quad	0xbfc619a100000000
	.quad	0xbe73f3aefe930c8f
	.quad	0xbfc5ff9f00000000
	.quad	0xbe7edc30c01b141d
	.quad	0xbfc5e59f00000000
	.quad	0xbe7f08ed31fe1628
	.quad	0xbfc5cba500000000
	.quad	0xbe5983b170e6c68f
	.quad	0xbfc5b1ad00000000
	.quad	0xbe7c5342ddbb7371
	.quad	0xbfc597ba00000000
	.quad	0xbe31f13b9ecb2da6
	.quad	0xbfc57dc900000000
	.quad	0xbe75038fc82fbc24
	.quad	0xbfc563dc00000000
	.quad	0xbe783ff5ad081783
	.quad	0xbfc549f300000000
	.quad	0xbe662723a6715875
	.quad	0xbfc5300d00000000
	.quad	0xbe6b7b7cc9af768a
	.quad	0xbfc5162b00000000
	.quad	0xbe1f78d1162b410d
	.quad	0xbfc4fc4d00000000
	.quad	0xbe7cb37679326801
	.quad	0xbfc4e27200000000
	.quad	0xbe7065fa9470590b
	.quad	0xbfc4c89c00000000
	.quad	0xbe6c3a0233eda037
	.quad	0xbfc4aec800000000
	.quad	0xbe4e014055897901
	.quad	0xbfc494f900000000
	.quad	0xbe4fb8e003c2f3b1
	.quad	0xbfc47b2b00000000
	.quad	0xbe7c8996199d6eea
	.quad	0xbfc4616400000000
	.quad	0xbe0faf0bc81e4b94
	.quad	0xbfc4479d00000000
	.quad	0xbe7cc047f1f25c83
	.quad	0xbfc42ddd00000000
	.quad	0xbe53d0da516b147f
	.quad	0xbfc4141f00000000
	.quad	0xbe7fcb190acb1c29
	.quad	0xbfc3fa6400000000
	.quad	0xbe7414ec0c60bad1
	.quad	0xbfc3e0ae00000000
	.quad	0xbe74e9ba984a9a60
	.quad	0xbfc3c6fc00000000
	.quad	0xbe624337ccc1362d
	.quad	0xbfc3ad4b00000000
	.quad	0xbe7774b4cc0ec2a8
	.quad	0xbfc393a000000000
	.quad	0xbe732b380b7efc7c
	.quad	0xbfc379f700000000
	.quad	0xbe62dac931c2e190
	.quad	0xbfc3605300000000
	.quad	0xbe6b470fa43dc529
	.quad	0xbfc346b100000000
	.quad	0xbe69abf6162bfc32
	.quad	0xbfc32d1300000000
	.quad	0xbe2ba4b334a02879
	.quad	0xbfc3137a00000000
	.quad	0xbe4d8be297e30d03
	.quad	0xbfc2f9e300000000
	.quad	0xbe415bfda1644c22
	.quad	0xbfc2e04f00000000
	.quad	0xbe763bbe948b1ac0
	.quad	0xbfc2c6c000000000
	.quad	0xbe016a3f42b0e0f2
	.quad	0xbfc2ad3400000000
	.quad	0xbe00b500d8b4466e
	.quad	0xbfc293ab00000000
	.quad	0xbe767834aad3c38f
	.quad	0xbfc27a2700000000
	.quad	0xbe4b3fb7ded60421
	.quad	0xbfc260a600000000
	.quad	0xbe5cc6018f3bcd49
	.quad	0xbfc2472700000000
	.quad	0xbe603b59bc184860
	.quad	0xbfc22dad00000000
	.quad	0xbe7a556695fca0d7
	.quad	0xbfc2143600000000
	.quad	0xbe64434576d52cb7
	.quad	0xbfc1fac400000000
	.quad	0xbe6796ca377ea74e
	.quad	0xbfc1e15400000000
	.quad	0xbe66f7798c85559d
	.quad	0xbfc1c7e800000000
	.quad	0xbe4bde34965f6984
	.quad	0xbfc1ae7d00000000
	.quad	0xbe79e4ab7003a0e6
	.quad	0xbfc1951900000000
	.quad	0xbe49fd11e39abaac
	.quad	0xbfc17bb800000000
	.quad	0xbe56b7b48b95c15b
	.quad	0xbfc1625900000000
	.quad	0xbe5cc36d3e3cca65
	.quad	0xbfc148fe00000000
	.quad	0xbe41ce485761f69c
	.quad	0xbfc12fa600000000
	.quad	0xbe770a1f05316811
	.quad	0xbfc1165300000000
	.quad	0xbe578d49dc1afe94
	.quad	0xbfc0fd0300000000
	.quad	0xbe6e0dca31cd9e54
	.quad	0xbfc0e3b500000000
	.quad	0xbe784e650e0a2fd5
	.quad	0xbfc0ca6b00000000
	.quad	0xbe7c536d57d9dab9
	.quad	0xbfc0b12500000000
	.quad	0xbe7b57a5578d01fd
	.quad	0xbfc097e300000000
	.quad	0xbe759cc0cf3da52a
	.quad	0xbfc07ea300000000
	.quad	0xbe70dc7f7c36aab7
	.quad	0xbfc0656900000000
	.quad	0xbe43057726eea6f9
	.quad	0xbfc04c3000000000
	.quad	0xbe75532713b0b555
	.quad	0xbfc032fc00000000
	.quad	0xbe51f736f8234297
	.quad	0xbfc019c900000000
	.quad	0xbe757a9427127e28
	.quad	0xbfc0009c00000000
	.quad	0xbe7dd37909d634e1
	.quad	0xbfbfcee400000000
	.quad	0xbe60e50b92227f37
	.quad	0xbfbf9c9700000000
	.quad	0xbe10744b2bbd5c34
	.quad	0xbfbf6a4d00000000
	.quad	0xbe6576fb1ab66ad7
	.quad	0xbfbf380f00000000
	.quad	0xbe6b5374d31a91ee
	.quad	0xbfbf05d600000000
	.quad	0xbe4db610eee1b81b
	.quad	0xbfbed3a000000000
	.quad	0xbe6a19b7978e8bb8
	.quad	0xbfbea17600000000
	.quad	0xbe6f4cb6bf56f18e
	.quad	0xbfbe6f5100000000
	.quad	0xbe57f67e0bd3b63f
	.quad	0xbfbe3d3300000000
	.quad	0xbe666a27d6a83d6c
	.quad	0xbfbe0b1a00000000
	.quad	0xbe523cbf0c85fa27
	.quad	0xbfbdd90800000000
	.quad	0xbe6a7ced811f7da6
	.quad	0xbfbda6ff00000000
	.quad	0xbe5615e1bd550182
	.quad	0xbfbd74fd00000000
	.quad	0xbe6b4da043725d03
	.quad	0xbfbd430000000000
	.quad	0xbe658a49aa2dca64
	.quad	0xbfbd110b00000000
	.quad	0xbe6066543ad84ef1
	.quad	0xbfbcdf1a00000000
	.quad	0xbe66073d700e9f19
	.quad	0xbfbcad3500000000
	.quad	0xbe63a29cd758d759
	.quad	0xbfbc7b5100000000
	.quad	0xbe49b8777d6bbc9d
	.quad	0xbfbc497800000000
	.quad	0xbe623f87f4487fe4
	.quad	0xbfbc17a400000000
	.quad	0xbe55196cb4c66620
	.quad	0xbfbbe5d800000000
	.quad	0xbe496e785a0317a3
	.quad	0xbfbbb41000000000
	.quad	0xbe5ee49501957b40
	.quad	0xbfbb825000000000
	.quad	0xbe6cf6df4849748b
	.quad	0xbfbb509500000000
	.quad	0xbe688f964bd70c8f
	.quad	0xbfbb1ee600000000
	.quad	0xbe6072c317519bb4
	.quad	0xbfbaed3800000000
	.quad	0xbe05b3290a662bd0
	.quad	0xbfbabb9500000000
	.quad	0xbe5b246ad0582c09
	.quad	0xbfba89f700000000
	.quad	0xbe55372721811f66
	.quad	0xbfba585d00000000
	.quad	0xbe67c995fe88bce3
	.quad	0xbfba26cc00000000
	.quad	0xbe596605e161e768
	.quad	0xbfb9f54300000000
	.quad	0xbe53bd6ea8cdcabf
	.quad	0xbfb9c3be00000000
	.quad	0xbe6873a6488f239e
	.quad	0xbfb9924200000000
	.quad	0xbe6038db2539e54e
	.quad	0xbfb960ca00000000
	.quad	0xbe6a3576f0eb47ea
	.quad	0xbfb92f5b00000000
	.quad	0xbe5ca16578e782d8
	.quad	0xbfb8fdf000000000
	.quad	0xbe6571dd058c9404
	.quad	0xbfb8cc8e00000000
	.quad	0xbe4e8172926b3912
	.quad	0xbfb89b3400000000
	.quad	0xbe458eb8a49a1ed9
	.quad	0xbfb869de00000000
	.quad	0xbe67736434037b3e
	.quad	0xbfb8388d00000000
	.quad	0xbe6e2728b7069e85
	.quad	0xbfb8074500000000
	.quad	0xbe61c6bcd5b504de
	.quad	0xbfb7d60500000000
	.quad	0xbe62d9f791fd12f7
	.quad	0xbfb7a4ca00000000
	.quad	0xbe53b18b476f88bf
	.quad	0xbfb7739300000000
	.quad	0xbe671b2ad71bba2e
	.quad	0xbfb7426500000000
	.quad	0xbe6329422bbd68e8
	.quad	0xbfb7113f00000000
	.quad	0xbe6e8b3c2fe4ecae
	.quad	0xbfb6e01f00000000
	.quad	0xbe2795edd5ed58e9
	.quad	0xbfb6af0200000000
	.quad	0xbe6c4c07447a13fa
	.quad	0xbfb67def00000000
	.quad	0xbe4f2ea58340e81e
	.quad	0xbfb64ce400000000
	.quad	0xbe4203398a8ffda4
	.quad	0xbfb61bda00000000
	.quad	0xbe2d4147ad124eaa
	.quad	0xbfb5eadc00000000
	.quad	0xbe539c66835b9867
	.quad	0xbfb5b9df00000000
	.quad	0xbe6317f3d15a9860
	.quad	0xbfb588ef00000000
	.quad	0xbe503474104b244e
	.quad	0xbfb557ff00000000
	.quad	0xbe6f1dfae0bd2e94
	.quad	0xbfb5271900000000
	.quad	0xbe541889ef09d7c8
	.quad	0xbfb4f63b00000000
	.quad	0xbe52dc76d475d4d1
	.quad	0xbfb4c56200000000
	.quad	0xbe433458770a1735
	.quad	0xbfb4948d00000000
	.quad	0xbe6c8223b5c8b49b
	.quad	0xbfb463c200000000
	.quad	0xbe540d91e2302042
	.quad	0xbfb432fb00000000
	.quad	0xbe64b47f064d986f
	.quad	0xbfb4023900000000
	.quad	0xbe6ce4d526c81e43
	.quad	0xbfb3d18000000000
	.quad	0xbe6c41714a091d46
	.quad	0xbfb3a0d000000000
	.quad	0xbe63540db8c80703
	.quad	0xbfb3702100000000
	.quad	0xbe5f8cf1a845a25c
	.quad	0xbfb33f7b00000000
	.quad	0xbe430a65c7a2686f
	.quad	0xbfb30edd00000000
	.quad	0xbe62d26a7215665c
	.quad	0xbfb2de4500000000
	.quad	0xbe1bff57e3bab991
	.quad	0xbfb2adb100000000
	.quad	0xbe5e8adfc156e82d
	.quad	0xbfb27d2200000000
	.quad	0xbe6e5d041c5f1a05
	.quad	0xbfb24c9d00000000
	.quad	0xbe50a21095df344c
	.quad	0xbfb21c2000000000
	.quad	0xbe5b57c218054e22
	.quad	0xbfb1eba400000000
	.quad	0xbe6b1806f4988888
	.quad	0xbfb1bb3200000000
	.quad	0xbe430029dc60a716
	.quad	0xbfb18ac400000000
	.quad	0xbe611e8ed29c4bea
	.quad	0xbfb15a5f00000000
	.quad	0xbe6aae4e1e1cd7e9
	.quad	0xbfb12a0000000000
	.quad	0xbe4f2855166a96d5
	.quad	0xbfb0f9a500000000
	.quad	0xbe68ccc743692647
	.quad	0xbfb0c95400000000
	.quad	0xbe50c2b8ff93eea0
	.quad	0xbfb0990400000000
	.quad	0xbe329700306849f4
	.quad	0xbfb068c000000000
	.quad	0xbe661c7597dfa0cf
	.quad	0xbfb0387e00000000
	.quad	0xbe64f950c199fdd6
	.quad	0xbfb0084500000000
	.quad	0xbe6434bda55a11e5
	.quad	0xbfafb02300000000
	.quad	0xbe537435dba745c1
	.quad	0xbfaf4fc600000000
	.quad	0xbe4793720209c664
	.quad	0xbfaeef7b00000000
	.quad	0xbe3e845c9d0173b4
	.quad	0xbfae8f3a00000000
	.quad	0xbe527188bd53b8bf
	.quad	0xbfae2f0400000000
	.quad	0xbe49e4e1f2d00cb9
	.quad	0xbfadced800000000
	.quad	0xbe57db5b6132809a
	.quad	0xbfad6ebf00000000
	.quad	0xbe43c7fbabdf571f
	.quad	0xbfad0eb000000000
	.quad	0xbe4c086873f1531f
	.quad	0xbfacaeac00000000
	.quad	0xbe33d01264312288
	.quad	0xbfac4eb200000000
	.quad	0xbe4ed73a1b11c287
	.quad	0xbfabeecb00000000
	.quad	0xbe328d5761ea48d2
	.quad	0xbfab8eee00000000
	.quad	0xbe4e2759579ac08a
	.quad	0xbfab2f1c00000000
	.quad	0xbe4eea927b8de26e
	.quad	0xbfaacf5500000000
	.quad	0xbe3a03ec4341a4ac
	.quad	0xbfaa6f9800000000
	.quad	0xbe54efb9656181bf
	.quad	0xbfaa0fee00000000
	.quad	0xbe529aa680456564
	.quad	0xbfa9b04f00000000
	.quad	0xbe42b60fbbf05015
	.quad	0xbfa950ba00000000
	.quad	0xbe59ea4d388956ac
	.quad	0xbfa8f13800000000
	.quad	0xbe5c820f8ddadcd6
	.quad	0xbfa891ba00000000
	.quad	0xbe27e05a334c58f7
	.quad	0xbfa8324d00000000
	.quad	0xbe5d3229b2ba0376
	.quad	0xbfa7d2ec00000000
	.quad	0xbe545e77c08ed94c
	.quad	0xbfa7739600000000
	.quad	0xbe427656b6f95551
	.quad	0xbfa7144a00000000
	.quad	0xbe5c82a193d30405
	.quad	0xbfa6b50a00000000
	.quad	0xbe4ddebd1f3c284a
	.quad	0xbfa655dc00000000
	.quad	0xbe599c108199cfd8
	.quad	0xbfa5f6ba00000000
	.quad	0xbe348e1f3828f0d8
	.quad	0xbfa597a200000000
	.quad	0xbe5240beb8df56ca
	.quad	0xbfa5389600000000
	.quad	0xbe1aed65370b9099
	.quad	0xbfa4d99400000000
	.quad	0xbe5429166d091c5d
	.quad	0xbfa47a9e00000000
	.quad	0xbe44d5db06b75692
	.quad	0xbfa41bba00000000
	.quad	0xbe5e4ff2e670387a
	.quad	0xbfa3bcda00000000
	.quad	0xbe5e73df6e675ed2
	.quad	0xbfa35e0d00000000
	.quad	0xbe5df2994af6bbf0
	.quad	0xbfa2ff4c00000000
	.quad	0xbe31a09f65bfdef1
	.quad	0xbfa2a09500000000
	.quad	0xbe5290bafe6a7061
	.quad	0xbfa241ea00000000
	.quad	0xbe425151c43b4181
	.quad	0xbfa1e34a00000000
	.quad	0xbe41d8dbc0646431
	.quad	0xbfa184b500000000
	.quad	0xbe5298ac777c8c9d
	.quad	0xbfa1263400000000
	.quad	0xbe10a2f9d7e8035a
	.quad	0xbfa0c7b600000000
	.quad	0xbe0bbc4c660fd088
	.quad	0xbfa0694b00000000
	.quad	0xbe3cc374b7950d13
	.quad	0xbfa00aeb00000000
	.quad	0xbe5aa058acdc0265
	.quad	0xbf9f592000000000
	.quad	0xbe149b4d7e5df2c0
	.quad	0xbf9e9c8f00000000
	.quad	0xbe10a7a7e78bdba3
	.quad	0xbf9de01500000000
	.quad	0xbde02a1d978db2f1
	.quad	0xbf9d23b100000000
	.quad	0xbe4e9227a287068e
	.quad	0xbf9c676500000000
	.quad	0xbe4e8561096793f8
	.quad	0xbf9bab3100000000
	.quad	0xbe0968e122179f22
	.quad	0xbf9aef1300000000
	.quad	0xbe328465c0dba24f
	.quad	0xbf9a330c00000000
	.quad	0xbe47051e31e0d70b
	.quad	0xbf99771d00000000
	.quad	0xbe38b8d275ff3a9a
	.quad	0xbf98bb5500000000
	.quad	0xbe122bdb89883925
	.quad	0xbf97ff9400000000
	.quad	0xbe36fbf85d50fecb
	.quad	0xbf9743eb00000000
	.quad	0xbdf87cba8eccac44
	.quad	0xbf96886800000000
	.quad	0xbe4bd57d800c1470
	.quad	0xbf95ccee00000000
	.quad	0xbe3be2933856d62e
	.quad	0xbf95118b00000000
	.quad	0xbe409620e0f1be7b
	.quad	0xbf94564f00000000
	.quad	0xbe4e4325cf62b811
	.quad	0xbf939b1c00000000
	.quad	0xbe2adee9af6a25c0
	.quad	0xbf92e00000000000
	.quad	0xbe20ce46d28f63c9
	.quad	0xbf92250b00000000
	.quad	0xbe41f6aa9fb6fe0b
	.quad	0xbf916a1e00000000
	.quad	0xbe4e41409957601b
	.quad	0xbf90af5900000000
	.quad	0xbe4e53e5a63658ad
	.quad	0xbf8fe93900000000
	.quad	0xbe3eded24d629d7d
	.quad	0xbf8e73ef00000000
	.quad	0xbe3a29d2ea7d362b
	.quad	0xbf8cfef500000000
	.quad	0xbe1e2e79fe4aa765
	.quad	0xbf8b8a0a00000000
	.quad	0xbe3e8785027a216b
	.quad	0xbf8a155000000000
	.quad	0xbe37a174d5a8bded
	.quad	0xbf88a0c600000000
	.quad	0xbe35dde88f39d7ce
	.quad	0xbf872c6c00000000
	.quad	0xbe3c41ea3f44a785
	.quad	0xbf85b86300000000
	.quad	0xbe194c69ffd7f42d
	.quad	0xbf84446a00000000
	.quad	0xbe1a5e4e0d24af39
	.quad	0xbf82d0a100000000
	.quad	0xbe381611eb6c3818
	.quad	0xbf815d0900000000
	.quad	0xbe3dd5da9cc5f987
	.quad	0xbf7fd34500000000
	.quad	0xbe25bd80e0b0590e
	.quad	0xbf7cec9900000000
	.quad	0xbe1ce47bb0eea510
	.quad	0xbf7a068e00000000
	.quad	0xbe26dbe100877575
	.quad	0xbf7720e600000000
	.quad	0xbd9aa4f614b9e1ac
	.quad	0xbf743b5f00000000
	.quad	0xbe271a96b1eb7842
	.quad	0xbf71567b00000000
	.quad	0xbe2318f60005710d
	.quad	0xbf6ce37400000000
	.quad	0xbe0c7a4e122b1762
	.quad	0xbf671b3600000000
	.quad	0xbe1c85d1e3d214d1
	.quad	0xbf61533f00000000
	.quad	0xbe0e793b61aa1f54
	.quad	0xbf57181c00000000
	.quad	0xbe01296a4555af78
	.quad	0xbf47168e00000000
	.quad	0xbdf30d6f34ebfa1c
	.rept	2
	.quad	0x0000000000000000
	.endr
	.rept	48
	.byte	0
	.endr

/* Exp(2) lookup table for exp part (non HSW) */
.if .-__svml_dpow_data != _exp2_tbl
.err
.endif
	.quad	0x3ff0000000000000
	.quad	0x0000000000000000
	.quad	0x3ff0163da9fb3335
	.quad	0x3c9b61299ab8cdb7
	.quad	0x3ff02c9a3e778061
	.quad	0xbc719083535b085d
	.quad	0x3ff04315e86e7f85
	.quad	0xbc90a31c1977c96e
	.quad	0x3ff059b0d3158574
	.quad	0x3c8d73e2a475b465
	.quad	0x3ff0706b29ddf6de
	.quad	0xbc8c91dfe2b13c26
	.quad	0x3ff0874518759bc8
	.quad	0x3c6186be4bb284ff
	.quad	0x3ff09e3ecac6f383
	.quad	0x3c91487818316135
	.quad	0x3ff0b5586cf9890f
	.quad	0x3c98a62e4adc610a
	.quad	0x3ff0cc922b7247f7
	.quad	0x3c901edc16e24f71
	.quad	0x3ff0e3ec32d3d1a2
	.quad	0x3c403a1727c57b52
	.quad	0x3ff0fb66affed31b
	.quad	0xbc6b9bedc44ebd7b
	.quad	0x3ff11301d0125b51
	.quad	0xbc96c51039449b39
	.quad	0x3ff12abdc06c31cc
	.quad	0xbc51b514b36ca5c7
	.quad	0x3ff1429aaea92de0
	.quad	0xbc932fbf9af1369e
	.quad	0x3ff15a98c8a58e51
	.quad	0x3c82406ab9eeab09
	.quad	0x3ff172b83c7d517b
	.quad	0xbc819041b9d78a75
	.quad	0x3ff18af9388c8dea
	.quad	0xbc911023d1970f6b
	.quad	0x3ff1a35beb6fcb75
	.quad	0x3c8e5b4c7b4968e4
	.quad	0x3ff1bbe084045cd4
	.quad	0xbc995386352ef607
	.quad	0x3ff1d4873168b9aa
	.quad	0x3c9e016e00a2643c
	.quad	0x3ff1ed5022fcd91d
	.quad	0xbc91df98027bb78b
	.quad	0x3ff2063b88628cd6
	.quad	0x3c8dc775814a8494
	.quad	0x3ff21f49917ddc96
	.quad	0x3c82a97e9494a5ed
	.quad	0x3ff2387a6e756238
	.quad	0x3c99b07eb6c70572
	.quad	0x3ff251ce4fb2a63f
	.quad	0x3c8ac155bef4f4a4
	.quad	0x3ff26b4565e27cdd
	.quad	0x3c82bd339940e9d9
	.quad	0x3ff284dfe1f56381
	.quad	0xbc9a4c3a8c3f0d7d
	.quad	0x3ff29e9df51fdee1
	.quad	0x3c8612e8afad1255
	.quad	0x3ff2b87fd0dad990
	.quad	0xbc410adcd6381aa3
	.quad	0x3ff2d285a6e4030b
	.quad	0x3c90024754db41d4
	.quad	0x3ff2ecafa93e2f56
	.quad	0x3c71ca0f45d52383
	.quad	0x3ff306fe0a31b715
	.quad	0x3c86f46ad23182e4
	.quad	0x3ff32170fc4cd831
	.quad	0x3c8a9ce78e18047c
	.quad	0x3ff33c08b26416ff
	.quad	0x3c932721843659a5
	.quad	0x3ff356c55f929ff1
	.quad	0xbc8b5cee5c4e4628
	.quad	0x3ff371a7373aa9cb
	.quad	0xbc963aeabf42eae1
	.quad	0x3ff38cae6d05d866
	.quad	0xbc9e958d3c9904bc
	.quad	0x3ff3a7db34e59ff7
	.quad	0xbc75e436d661f5e2
	.quad	0x3ff3c32dc313a8e5
	.quad	0xbc9efff8375d29c3
	.quad	0x3ff3dea64c123422
	.quad	0x3c8ada0911f09ebb
	.quad	0x3ff3fa4504ac801c
	.quad	0xbc97d023f956f9f3
	.quad	0x3ff4160a21f72e2a
	.quad	0xbc5ef3691c309278
	.quad	0x3ff431f5d950a897
	.quad	0xbc81c7dde35f7998
	.quad	0x3ff44e086061892d
	.quad	0x3c489b7a04ef80cf
	.quad	0x3ff46a41ed1d0057
	.quad	0x3c9c944bd1648a76
	.quad	0x3ff486a2b5c13cd0
	.quad	0x3c73c1a3b69062f0
	.quad	0x3ff4a32af0d7d3de
	.quad	0x3c99cb62f3d1be56
	.quad	0x3ff4bfdad5362a27
	.quad	0x3c7d4397afec42e2
	.quad	0x3ff4dcb299fddd0d
	.quad	0x3c98ecdbbc6a7833
	.quad	0x3ff4f9b2769d2ca7
	.quad	0xbc94b309d25957e3
	.quad	0x3ff516daa2cf6642
	.quad	0xbc8f768569bd93ee
	.quad	0x3ff5342b569d4f82
	.quad	0xbc807abe1db13cac
	.quad	0x3ff551a4ca5d920f
	.quad	0xbc8d689cefede59a
	.quad	0x3ff56f4736b527da
	.quad	0x3c99bb2c011d93ac
	.quad	0x3ff58d12d497c7fd
	.quad	0x3c8295e15b9a1de7
	.quad	0x3ff5ab07dd485429
	.quad	0x3c96324c054647ac
	.quad	0x3ff5c9268a5946b7
	.quad	0x3c3c4b1b816986a2
	.quad	0x3ff5e76f15ad2148
	.quad	0x3c9ba6f93080e65d
	.quad	0x3ff605e1b976dc09
	.quad	0xbc93e2429b56de47
	.quad	0x3ff6247eb03a5585
	.quad	0xbc9383c17e40b496
	.quad	0x3ff6434634ccc320
	.quad	0xbc8c483c759d8932
	.quad	0x3ff6623882552225
	.quad	0xbc9bb60987591c33
	.quad	0x3ff68155d44ca973
	.quad	0x3c6038ae44f73e64
	.quad	0x3ff6a09e667f3bcd
	.quad	0xbc9bdd3413b26455
	.quad	0x3ff6c012750bdabf
	.quad	0xbc72895667ff0b0c
	.quad	0x3ff6dfb23c651a2f
	.quad	0xbc6bbe3a683c88aa
	.quad	0x3ff6ff7df9519484
	.quad	0xbc883c0f25860ef6
	.quad	0x3ff71f75e8ec5f74
	.quad	0xbc816e4786887a99
	.quad	0x3ff73f9a48a58174
	.quad	0xbc90a8d96c65d53b
	.quad	0x3ff75feb564267c9
	.quad	0xbc90245957316dd3
	.quad	0x3ff780694fde5d3f
	.quad	0x3c9866b80a02162c
	.quad	0x3ff7a11473eb0187
	.quad	0xbc841577ee04992f
	.quad	0x3ff7c1ed0130c132
	.quad	0x3c9f124cd1164dd5
	.quad	0x3ff7e2f336cf4e62
	.quad	0x3c705d02ba15797e
	.quad	0x3ff80427543e1a12
	.quad	0xbc927c86626d972a
	.quad	0x3ff82589994cce13
	.quad	0xbc9d4c1dd41532d7
	.quad	0x3ff8471a4623c7ad
	.quad	0xbc88d684a341cdfb
	.quad	0x3ff868d99b4492ed
	.quad	0xbc9fc6f89bd4f6ba
	.quad	0x3ff88ac7d98a6699
	.quad	0x3c9994c2f37cb53a
	.quad	0x3ff8ace5422aa0db
	.quad	0x3c96e9f156864b26
	.quad	0x3ff8cf3216b5448c
	.quad	0xbc70d55e32e9e3aa
	.quad	0x3ff8f1ae99157736
	.quad	0x3c85cc13a2e3976c
	.quad	0x3ff9145b0b91ffc6
	.quad	0xbc9dd6792e582523
	.quad	0x3ff93737b0cdc5e5
	.quad	0xbc675fc781b57ebb
	.quad	0x3ff95a44cbc8520f
	.quad	0xbc764b7c96a5f039
	.quad	0x3ff97d829fde4e50
	.quad	0xbc9d185b7c1b85d0
	.quad	0x3ff9a0f170ca07ba
	.quad	0xbc9173bd91cee632
	.quad	0x3ff9c49182a3f090
	.quad	0x3c7c7c46b071f2be
	.quad	0x3ff9e86319e32323
	.quad	0x3c7824ca78e64c6e
	.quad	0x3ffa0c667b5de565
	.quad	0xbc9359495d1cd532
	.quad	0x3ffa309bec4a2d33
	.quad	0x3c96305c7ddc36ab
	.quad	0x3ffa5503b23e255d
	.quad	0xbc9d2f6edb8d41e1
	.quad	0x3ffa799e1330b358
	.quad	0x3c9bcb7ecac563c6
	.quad	0x3ffa9e6b5579fdbf
	.quad	0x3c90fac90ef7fd31
	.quad	0x3ffac36bbfd3f37a
	.quad	0xbc8f9234cae76cd0
	.quad	0x3ffae89f995ad3ad
	.quad	0x3c97a1cd345dcc81
	.quad	0x3ffb0e07298db666
	.quad	0xbc9bdef54c80e424
	.quad	0x3ffb33a2b84f15fb
	.quad	0xbc62805e3084d707
	.quad	0x3ffb59728de5593a
	.quad	0xbc9c71dfbbba6de3
	.quad	0x3ffb7f76f2fb5e47
	.quad	0xbc75584f7e54ac3a
	.quad	0x3ffba5b030a1064a
	.quad	0xbc9efcd30e54292e
	.quad	0x3ffbcc1e904bc1d2
	.quad	0x3c823dd07a2d9e84
	.quad	0x3ffbf2c25bd71e09
	.quad	0xbc9efdca3f6b9c72
	.quad	0x3ffc199bdd85529c
	.quad	0x3c811065895048dd
	.quad	0x3ffc40ab5fffd07a
	.quad	0x3c9b4537e083c60a
	.quad	0x3ffc67f12e57d14b
	.quad	0x3c92884dff483cac
	.quad	0x3ffc8f6d9406e7b5
	.quad	0x3c71acbc48805c44
	.quad	0x3ffcb720dcef9069
	.quad	0x3c7503cbd1e949db
	.quad	0x3ffcdf0b555dc3fa
	.quad	0xbc8dd83b53829d72
	.quad	0x3ffd072d4a07897c
	.quad	0xbc9cbc3743797a9c
	.quad	0x3ffd2f87080d89f2
	.quad	0xbc9d487b719d8577
	.quad	0x3ffd5818dcfba487
	.quad	0x3c82ed02d75b3706
	.quad	0x3ffd80e316c98398
	.quad	0xbc911ec18beddfe8
	.quad	0x3ffda9e603db3285
	.quad	0x3c9c2300696db532
	.quad	0x3ffdd321f301b460
	.quad	0x3c92da5778f018c2
	.quad	0x3ffdfc97337b9b5f
	.quad	0xbc91a5cd4f184b5b
	.quad	0x3ffe264614f5a129
	.quad	0xbc97b627817a1496
	.quad	0x3ffe502ee78b3ff6
	.quad	0x3c839e8980a9cc8f
	.quad	0x3ffe7a51fbc74c83
	.quad	0x3c92d522ca0c8de1
	.quad	0x3ffea4afa2a490da
	.quad	0xbc9e9c23179c2893
	.quad	0x3ffecf482d8e67f1
	.quad	0xbc9c93f3b411ad8c
	.quad	0x3ffefa1bee615a27
	.quad	0x3c9dc7f486a4b6b0
	.quad	0x3fff252b376bba97
	.quad	0x3c93a1a5bf0d8e43
	.quad	0x3fff50765b6e4540
	.quad	0x3c99d3e12dd8a18a
	.quad	0x3fff7bfdad9cbe14
	.quad	0xbc9dbb12d0063509
	.quad	0x3fffa7c1819e90d8
	.quad	0x3c874853f3a5931e
	.quad	0x3fffd3c22b8f71f1
	.quad	0x3c62eb74966579e7

/* log2 polynomial coefficients:
 * clv7 */
double_vector _clv_1 0x3f903950cf599c56

/* clv6 */
double_vector _clv_2 0xbf9b4ea0e9419f52

/* clv5 */
double_vector _clv_3 0x3fa7a334ddfc9f86

/* clv4 */
double_vector _clv_4 0xbfb550472a8bb463

/* clv3 */
double_vector _clv_5 0x3fc47fd462b3b816

/* clv2 */
double_vector _clv_6 0xbfd62e4346694107

/* clv1 */
double_vector _clv_7 0x3e79c3a6966457ee

/* exponential polynomial coefficients:
 * cev5 */
double_vector _cev_1 0x3f55d87fe78a6731

/* cev4 */
double_vector _cev_2 0x3f83b2ab6fba4e77

/* cev3 */
double_vector _cev_3 0x3fac6b08d704a0bf

/* cev2 */
double_vector _cev_4 0x3fcebfbdff82c58e

/* cev1 */
double_vector _cev_5 0x3fe62e42fefa39ef

/* General purpose constants:
 * iMantissaMask */
double_vector _iMantissaMask 0x000fffffffffffff

/* i3fe7fe0000000000 */
double_vector _i3fe7fe0000000000 0x3fe7fe0000000000

/* dbOne */
double_vector _dbOne 0x3ff0000000000000

/* iffffffff00000000 */
double_vector _iffffffff00000000 0xffffffff00000000

/* db2p20_2p19 = 2^20+2^19 */
double_vector _db2p20_2p19 0x4138000000000000

/* iHighMask */
double_vector _iHighMask 0xfffffffff8000000

/* LHN = -log2(e) truncated to 22 bits */
double_vector _LHN 0xbff7154740000000

/* ifff0000000000000 */
double_vector _ifff0000000000000 0xfff0000000000000

/* db2p45_2p44 */
double_vector _db2p45_2p44 0x42c8000000000000

/* NEG_INF */
double_vector _NEG_INF 0xfff0000000000000

/* NEG_ZERO */
double_vector _NEG_ZERO 0x8000000000000000

/* 2pow52 */
double_vector _d2pow52 0x4330000000000000

/* 1div2pow111 */
double_vector _d1div2pow111 0x3900000000000000

/* HIDELTA */
float_vector _HIDELTA 0x00100000

/* LORANGE */
float_vector _LORANGE 0x00200000

/* ABSMASK */
float_vector _ABSMASK 0x7fffffff

/* INF */
float_vector _INF 0x7f800000

/* DOMAINRANGE */
float_vector _DOMAINRANGE 0x408f3fff

/* iIndexMask */
float_vector _iIndexMask 0x000ffe00

/* iIndexAdd */
float_vector _iIndexAdd 0x00000200

/* i3fe7fe00 */
float_vector _i3fe7fe00 0x3fe7fe00

/* i2p20_2p19 */
float_vector _i2p20_2p19 0x41380000

/* iOne */
float_vector _iOne 0x3ff00000

/* jIndexMask */
float_vector _jIndexMask 0x0000007f
	.type	__svml_dpow_data,@object
	.size __svml_dpow_data,.-__svml_dpow_data
